﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chCtrl;
using NT2chView;
using NT2chView.NtFile;
using NT2chView.NtNet;
using NT2chObject;

namespace NT2chHistory
{
    class NTOpenedThreadTable
    {
        public static List<IThreadDescription> retrieveThreadHistoryList()
        {
            string[] list = NTFileAccess.retrieveThreadHistoryList();
            if (list == null)
                return null;

            List<IThreadDescription> threadList = new List<IThreadDescription>();
            foreach (string s in list)
            {
                IThreadDescription threadDecl = NTThreadCashData.parse(s);
                if(threadDecl != null)
                    threadList.Add(threadDecl);
            }
            return threadList;
        }

        public static void saveThreadHistoryList(List<IThreadDescription> threadList)
        {
            List<string> list = new List<string>();
            foreach (IThreadDescription threadDecl in threadList)
            {
                string s = NTThreadCashData.getDescription(threadDecl);
                if (s != null)
                    list.Add(s);
            }
            if (NTUserPreference.NTCloudIsEnabled)
            {
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    string uid = NTUserPreference.NTCloudID;
                    string hashed = NTUserPreference.NTUserCloudGetHashedPasswd();
                    NTHttpAccess.UserCloudUploadThreadHistoryList(uid, hashed, list);
                }
                else
                {
                    string uid = NTUserPreference.NTCloudID;
                    string passwd = NTUserPreference.NTCloudPSS;
                    NTHttpAccess.ntUploadThreadHistoryList(uid, passwd, list);
                }
            }

            NTFileAccess.writeThreadHistoryList(list.ToArray());
        }
#if false
	    const int MAX_SAVE_LINE_COUNT = 50;
	
	    static bool mDirty = false;
	    static bool mDirty2 = false;

	    static List<NTThreadCashData> mList = new List<NTThreadCashData>();
	
	    public static bool getDirty(){return mDirty2;}
	    public static void ClearDirty(){mDirty2 = false;}
	
	
	    public static void add(NTThreadCashData data){
		    remove(data.getBoardName(), data.getDatName());
		    mList.Insert(0, data);
		    mDirty = true;
		    mDirty2 = true;
	    }
	    public static int ListCount(){
		    return mList.Count;
	    }
	    public static bool remove(String boardName, String datName){
		    NTThreadCashData data = getData( boardName, datName);
		    if(data == null)
			    return false;
		    mDirty = true;
		    mDirty2 = true;
		    return mList.Remove(data);
		
	    }
	
	    public static bool remove(NTThreadCashData data){
		    mDirty = true;
		    mDirty2 = true;
		    return mList.Remove(data);
	    }
	
	    public static void removeAll(){
		    mDirty = true;
		    mDirty2 = true;
		    mList.Clear();
	    }

	    public static NTThreadCashData getData(int index){
		    if(index < 0 || index >= mList.Count)
			    return null;
		    return mList[index];
	    }

	    private static NTThreadCashData getData(String boardName, String datName){
		    foreach(NTThreadCashData data in mList){
			    if(data.getBoardName().Equals(boardName) &&
					    data.getDatName().Equals(datName))
				    return data;
		    }
		    return null;
	    }

	    public static void OnNotifyBoardUpdate(Context ctx, BoardTable btbl){
		    foreach(NTThreadCashData data in mList){
			    if(data.isTitleSet())
				    continue;
			    NTThreadTitleTable ttt = btbl.getThreadTitleTableByName(data.mBoardName);
			    if(ttt == null){
				    continue;
			    }
			
			    if(ttt.getCount() == 0){
				    String category = CategoryTable.findCategoryByBoardName(data.mBoardName);
				    if(category == null)
					    continue;
				
				    if(!FileUtil.readThreadTable(ctx, category, data.mBoardName))
					    continue;
				
				    ttt = btbl.getThreadTitleTableByName(data.mBoardName);
				    if(ttt == null)
					    continue;
				
			    }
			
			    int idx = ttt.getIndexByFileName(data.mDatName);
			    if(idx < 0)
				    continue;
			    data.setTitle(ttt.getTitleText(idx));
		    }
		
		    /*DebugUtil.log2("*** ThreadCashData logging... ***");
		    for(ThreadCashData data : mList){
			    DebugUtil.log2("------------------------------");
			    DebugUtil.log2("Board: "+data.mBoardName);
			    DebugUtil.log2("Title: "+data.mTitle);
			    DebugUtil.log2("Dat: "+data.mDatName);
		    }
		    DebugUtil.log2("*** Done... ***");*/
	    }
	
	    public static boolean store(Context ctx){
		    if(!mDirty)
			    return true;
		    mDirty = false;
		    int numLine = mList.size();
		    if(numLine > MAX_SAVE_LINE_COUNT)
			    numLine = MAX_SAVE_LINE_COUNT;
		    ArrayList<String> lines = new ArrayList<String>(numLine);
		    for(int i = 0; i < numLine; i++){
			    String line = mList.get(i).getDescription();
			    lines.add(HttpUtil.encodeBase64URL(line));
		    }
		    return FileUtil.storeReadHistoryToFile(ctx, lines);
	    }
	
	    public static ArrayList<String> getCurrentList(){
		    int numLine = mList.size();
		    if(numLine > MAX_SAVE_LINE_COUNT)
			    numLine = MAX_SAVE_LINE_COUNT;
		    ArrayList<String> lines = new ArrayList<String>(numLine);
		    for(int i = 0; i < numLine; i++){
			    String line = mList.get(i).getDescription();
			    lines.add(line);
		    }
		    return lines;
	    }
	    public static void retrieve(){

            string [] list = NTFileAccess.retrieveThreadHistoryList();

            foreach(string s in list)
            {
                IThreadDescription threadDecl = NTThreadCashData.parse(s);

            }


		    try {
			    ArrayList<String> lines = FileUtil.retrieveReadhistoryFromFile(ctx);
			    mList.clear();
			    int lineCnt = lines.size();
			    if(lineCnt > MAX_SAVE_LINE_COUNT)
				    lineCnt = MAX_SAVE_LINE_COUNT;
			    HashSet<String> boardSet = new HashSet<String>(lineCnt);
			
			    for(int i = 0; i < lineCnt; i++){
				    String line = lines.get(i);
				    String decoded = HttpUtil.decodeBase64URL(line);
				    ThreadCashData data = 
						    ThreadCashData.parse(decoded);
				    if(data != null){
					    mList.add(data);
					    boardSet.add(data.mBoardName);
				    }
			    }
			    for(String boardName : boardSet){
				    BoardTable bTbl = CategoryTable.getBoardByBoardNameAAA(boardName);
				    if(bTbl == null)
					    continue;				
				    OnNotifyBoardUpdate(ctx, bTbl);
			    }
		    } catch (UnsupportedEncodingException e) {
			    e.printStackTrace();
		    }
	    }
#endif
    }
}
