﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using NT2chView.NtNet;

namespace NT2chView
{
    static class NTMaru
    {
        const string SESSION_ID_KEY = "SESSION-ID=";
        static string mSessionId;
        static object mLockThis;

        public static void init()
        {
            mSessionId = string.Empty;
            mLockThis = new object();

        }

        public static string getSessionId()
        {
            string id = string.Empty;
            lock (mLockThis)
            {
                if (mSessionId.Length == 0)
                    login();
                id = mSessionId;
            }
            return id;
        }

        public static bool login()
        {
            if (!NTUserPreference.MaruIsEnabled)
                return false;

            string uid = NTUserPreference.MaruID;
            string passwd = NTUserPreference.MaruPSS;
            if (uid == null || passwd == null)
                return false;
            if (uid.Length == 0 || passwd.Length == 0)
                return false;
            lock (mLockThis)
            {

                string result = NTHttpAccess.loginMaru(uid, passwd);

                if (result == null || result.Length == 0)
                    return false;

                int idx = result.IndexOf(SESSION_ID_KEY);
                if (idx < 0)
                    return false;
                idx += SESSION_ID_KEY.Length;
                int idx2 = result.IndexOf(':', idx);
                if (idx2 < 0)
                    return false;

                string agent = result.Substring(idx, idx2-idx).Trim();
                //string sessionKey = result.Substring(idx2 + 1).Trim();
                string sessionKey = result.Substring(idx).Trim();
                if (agent.Length == 0 || sessionKey.Length == 0)
                    return false;

                if (0 <= agent.IndexOf("ERROR", StringComparison.CurrentCultureIgnoreCase))
                {
                    return false;
                }
                if (!NTHttpAccess.HTTP_HEADER_USER_AGENT.Equals(agent))
                {
                    NTDebug.l("UserAgent Unmatched.");
                }


                mSessionId = NTTextUtiles.percentEncode(sessionKey);
                //mSessionId = sessionKey;
            }


            return (mSessionId.Length > 0) ? true : false;
        }

        public static void loginAsync()
        {
            Thread t = new Thread(loginAsync_DoWord);
            t.Start();
        }

        static void loginAsync_DoWord()
        {
            login();
        }


    }
}
