﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    public abstract class JsVariant
    {
        public virtual JsBooleanValue getBooleanValue()
        {
            return JsBooleanValue.getFalseValue();
        }
        public virtual JsStringValue getStringValue() { return null; }
        public virtual JsNumberValue getNumberValue() { return null; }
    }

    public class JsUndefValue : JsVariant
    {
        static JsUndefValue gThis = new JsUndefValue();

        public static JsUndefValue getConstant(){return gThis;}

        public override JsBooleanValue getBooleanValue()
        {
            return JsBooleanValue.getFalseValue();
        } 
    }

    public class JsNullValue : JsVariant
    {
        static JsNullValue gThis = new JsNullValue();

        public static JsNullValue getConstant() { return gThis; }

        public override JsBooleanValue getBooleanValue()
        {
            return JsBooleanValue.getFalseValue();
        }
    }
}
