﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.css
{
    public class Selector
    {
        List<Select> mSelector = new List<Select>();
        List<Property> mProperties ;//= new List<Property>();

        public List<Select> getList() { return mSelector; }
        public List<Property> getProperties() { return mProperties; }

        public void addSelect(Select select)
        {
            mSelector.Add(select);
        }

        public int getSpecificity()
        {
            int specificity= 0;
            foreach (Select s in mSelector)
            {
                specificity += s.getSpecificity();
            }
            return specificity;
        }

        public Property getProperty(string key)
        {
            foreach (Property p in mProperties)
            {
                if(key.Equals(p.getName()))
                    return p;
            }
            return null;
        }


        public static bool Parse(DebugContext ctx, string selector, List<Selector>  cssList)
        {

            int length = selector.Length;

            int idx = 0;

            int endIdx;
            do
            {
                List<Selector> list = new List<Selector>();
                endIdx = Select.Parse(ctx, selector, idx, list);
                if (endIdx < 0)
                {
                    ctx.setErrorMessage("セレクターの書式が不正です");
                    return false;
                }
                if (endIdx == length)
                    break;
                List<Property> pList = new List<Property>();
                idx = Property.Parse(ctx, selector, endIdx, pList);
                //idx = selector.IndexOf('}', endIdx);
                if (idx < 0)
                {
                    ctx.setErrorMessage("CSSプロパティの書式が不正です");
                    return false;
                }

                foreach (Selector s in list)
                {
                    s.mProperties = pList;
                }
                idx++;
                cssList.AddRange(list);
            } while (idx < length);

            return true;
        }


    }
}
