﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl
{
    class ThreadDescriptionImple : IThreadDescription
    {
        IBoard mBoard;
        string mDatName;
        string mTitle;

        public string getTitle() { return mTitle; }
        public string getDatName() { return mDatName; }
        public IBoard getBoard() { return mBoard; }
        
        public void setTitle(string title)
        {
            mTitle = title;
        }

        public bool Equals(IThreadDescription threadDecl)
        {
            return (mDatName.Equals(threadDecl.getDatName()) && 
                mBoard.getName().Equals(threadDecl.getBoard().getName()));
        }

        public static ThreadDescriptionImple
            createThreadDescription(IThread thread)
        {
            ThreadDescriptionImple threadImpl = new ThreadDescriptionImple(
                thread.getBoard(), thread.getDatName());
            string title = thread.getTitle();
            if(title != null && title.Length > 0)
                threadImpl.setTitle(title);
            return threadImpl;
        }

        public static ThreadDescriptionImple
            createThreadDescription(IBoard board, string datName)
        {
            ThreadDescriptionImple thread = new ThreadDescriptionImple(
                board, datName);
            return thread;
        }


        private ThreadDescriptionImple(IBoard board, string datName)
        {
            mBoard = board;
            mDatName = datName;
        }

    }
}
