﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Documents;
using NT2chObject;

namespace NT2chCtrl
{
    partial class ResListAdapter : UIElementListPanel.IUIElementListAdapter
    {
        class ResCashData
        {
            public UIElement element = null;
            public Section section = null;
            public bool hasMatchText = false;
        }

        List<ResCashData> mResCashDataList;
        void initCashData(int size)
        {
            mResCashDataList = new List<ResCashData>(size);
            for (int i = 0; i < size; i++)
            {
                mResCashDataList.Add(new ResCashData());
            }
        }
        int mSearchResIndex = -1;
        string mStrSearch = string.Empty;
        IAmbiguousSearch mAmbisuousSearch = null;
        //指定された検索文字列を選択状態にして下さい。

        public void SetSearchWord(string searchWord, int startPostion)
        {
            if (mStrSearch.Equals(searchWord))
                return;

            
            ResViewCtrlState state = ResViewCtrlState.getInstance();
            bool htmlLayout = state.EnableHtmlLayout;

            mSearchResIndex = startPostion;
            //mSearchedRes.Clear();
            mStrSearch = searchWord;

            mAmbisuousSearch = mUtil.CreateAmbiguousSearchInstance(mStrSearch);

            //foreach (IRes ires in rList)
            //{
            int num = getCount();
            for (int i = 0; i < num; i++)
            {
                ResCashData cashData = mResCashDataList[i];
                if (htmlLayout)
                {
                    cashData.element = null;
                    cashData.section = null;
                }
                IRes ires = mResList[i];
                string msg = ires.getMsg();
                int firstIndex, length;
                if (mAmbisuousSearch.match(ires.getMsg(), 0, out firstIndex, out length))
                {
                    cashData.hasMatchText = true;
                    if (cashData.element == null)
                    {
                        getElement(i, null);
                    }
                    if (htmlLayout)
                        continue;

                    Section sec = cashData.section;
                    if (sec == null)
                        continue;

                    if (sec.Blocks.Count != 2)
                        continue;

                    if (!sec.Blocks.Remove(sec.Blocks.LastBlock))
                        continue;

                    Paragraph para = new Paragraph();
                    parseResMsg(para, mCurrentThread, ires, firstIndex, length, true);
                    sec.Blocks.Add(para);
                    //mSearchedRes.Add(ires);
                }
                else
                {
                    cashData.hasMatchText = false;
                }
                //}

            }
            //if (mResUI == null)
            //    return;
            //mResUI.SetSearchWord(mCurrentThread, searchWord);
            if (htmlLayout)
            {
                mMainPanel.InvalidateItems();
            }
        }
        //指定された検索文字列の後方にマッチする文字列を選択して下さい。
        public int SearchNext()
        {
            int num = getCount();
            mSearchResIndex++;
            for (int i = mSearchResIndex; i < num; i++)
            {
                ResCashData cashData = mResCashDataList[i];
                if (cashData.hasMatchText)
                {
                    mSearchResIndex = i;
                    return i;
                }
            }
            for (int i = 0; i < mSearchResIndex; i++)
            {
                ResCashData cashData = mResCashDataList[i];
                if (cashData.hasMatchText)
                {
                    mSearchResIndex = i;
                    return i;
                }
            }
            return mSearchResIndex = -1;
        }
        //指定された検索文字列の前方にマッチする文字列を選択して下さい。
        public int SearchPrev()
        {
            int num = getCount();
            mSearchResIndex--;
            if (mSearchResIndex < 0)
                mSearchResIndex = num - 1;
            for (int i = mSearchResIndex; i >= 0; i--)
            {
                ResCashData cashData = mResCashDataList[i];
                if (cashData.hasMatchText)
                {
                    mSearchResIndex = i;
                    return i;
                }
            }
            for (int i = num - 1; i > mSearchResIndex; i--)
            {
                ResCashData cashData = mResCashDataList[i];
                if (cashData.hasMatchText)
                {
                    mSearchResIndex = i;
                    return i;
                }
            }
            return mSearchResIndex = -1;
        }


        public int NextBookmark(int currentPosition)
        {
            currentPosition++;
            int num = getCount();
            if (currentPosition < 0
                || currentPosition >= num)
                currentPosition = 0;

            for (int i = currentPosition; i < num; i++)
            {
                if (mResList[i].getAttribute(RES_ATTRIBUTE.BOOKMARK))
                    return i;
            }
            for (int i = 0; i < currentPosition; i++)
            {
                if (mResList[i].getAttribute(RES_ATTRIBUTE.BOOKMARK))
                    return i;
            }
            return -1;
        }

        public void ZoomIn()
        {
            mZoomValue += 5;
            if (mZoomValue > 500)
                mZoomValue = 500;
            setZoomValue(mZoomValue);
            mMainPanel.InvalidateItems();

        }
        public void ZoomOut()
        {
            mZoomValue -= 5;
            if (mZoomValue < 50)
                mZoomValue = 50;
            setZoomValue(mZoomValue);
            mMainPanel.InvalidateItems();
        }
    }
}
