﻿using NT2chCtrl2;
using NT2chObject;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows.Controls;

namespace NT2chCtrl2
{
    public partial class NTSubjectViewPanel : UserControl, ISubjectView
    {
        private IUtil mUtil;
        private ICommand2 mCommand;
        private Dictionary<PREF_PARAM, object> mDict;
        private ObservableCollection<NTBoardData> mBoardList = new ObservableCollection<NTBoardData>();
        private IBoard mCurrentBoard;


        public IBoard GetCurrentBoard()
        {
            return mCurrentBoard;
        }
        //フレームワークから呼ばれます。先頭のレスにジャンプしてください。
        public void JumpToTop()
        {
            if (mLstThreadTitle.Items == null ||
                mLstThreadTitle.Items.Count == 0)
                return;

            mLstThreadTitle.ScrollIntoView(mLstThreadTitle.Items[0]);
        }
        //フレームワークから呼ばれます。最後のレスにジャンプしてください。
        public void JumpToBottom()
        {
            if (mLstThreadTitle.Items == null ||
                mLstThreadTitle.Items.Count == 0)
                return;
            int cnt = mLstThreadTitle.Items.Count;
            mLstThreadTitle.ScrollIntoView(mLstThreadTitle.Items[cnt - 1]);
        }

        public List<IBoard> QueryOpenedBoardList()
        {
            if (mBoardList == null)
                return null;

            saveData();


            List<IBoard> boardList = new List<IBoard>();
            foreach (NTBoardData data in mBoardList)
            {
                boardList.Add(data.mBoard);
            }
            return boardList;
        }

        public bool OpenBoard(IBoard iboard)
        {
            if (iboard == null)
                return false;
            NTBoardData data = findBoardData(iboard);
            if (data == null)
                return false;

            mLstMenu.SelectedItem = data;

            initFontSize();

            List<IThread> threadList = iboard.getThreadList();

            ObservableCollection<NTThread> list =
                new ObservableCollection<NTThread>();
            foreach (IThread2 ithread in threadList)
            {
                NTThread thread = ithread.getDependencyObject();
                if (thread == null)
                    continue;
                list.Add(thread);
            }
            mLstThreadTitle.ItemsSource = list;

            
            mCurrentBoard = iboard;

            JumpToTop();

            return true;
        }

        public bool InitBoardList(List<IBoard> boardList)
        {
            foreach (IBoard iboard in boardList)
            {
                NTBoardData data = new NTBoardData(iboard);
                mBoardList.Add(data);
            }

            mLstMenu.ItemsSource = mBoardList;
            return true;
        }

        private NTBoardData findBoardData(IBoard iboard)
        {
            foreach (NTBoardData data in mBoardList)
            {
                if (data.BoardName.Equals(iboard.getName()))
                    return data;
            }
            NTBoardData data1 = new NTBoardData(iboard);
            mBoardList.Add(data1);
            if(mBoardList.Count == 1)
                mLstMenu.ItemsSource = mBoardList;

            return data1;
        }
        private ThreadDescrption getThreadDescription(NTThread thread)
        {
            string title = thread.Title;
            string datName = thread.getDatName();
            if (title == null || datName == null ||
                mCurrentBoard == null)
                return null;

            return new ThreadDescrption(title, datName, mCurrentBoard);
        }
        
        public void OnInitApplicationInterface(ICommand2 command, IUtil util)
        {
            mCommand = command;
            mUtil = util;

            mDict = mCommand.GetPreference();
            initFontSize();

            if(command != null)
                loadData(command.GetDataPath());

        }

        private void initFontSize()
        {
            if (null == mDict)
                return;
            object o;
            if (mDict.TryGetValue(
              PREF_PARAM.THREADTITLE_LIST_FONT_SIZE, out o))
            {
                double d = (double)o;
                if(d != mLstThreadTitle.FontSize)
                    mLstThreadTitle.FontSize = d;
            }
        }
    }
}
