/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.util.logging.Logger;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.error.HttpException;
import nor.http.error.NotFoundException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.rest.DirResource;

public class RESTRequestHandler
implements HttpRequestHandler {
    private final RootResource root = new RootResource();
    private static final Logger LOGGER = Logger.getLogger(RESTRequestHandler.class.getName());

    public DirResource getRoot() {
        LOGGER.entering(RESTRequestHandler.class.getName(), "getRoot");
        RootResource ret = this.root;
        LOGGER.exiting(RESTRequestHandler.class.getName(), "getRoot", ret);
        return ret;
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering(RESTRequestHandler.class.getName(), "doRequest", request);
        HttpResponse ret = null;
        try {
            String path = request.getPath();
            if (path.startsWith("/")) {
                switch (Method.valueOf(request.getMethod())) {
                    case GET: {
                        ret = this.root.toGet(path, request);
                        break;
                    }
                    case POST: {
                        ret = this.root.toPost(path, request);
                        break;
                    }
                    case PUT: {
                        ret = this.root.toPut(path, request);
                        break;
                    }
                    case DELETE: {
                        ret = this.root.toDelete(path, request);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (HttpException e) {
            ret = e.createResponse(request);
        }
        LOGGER.exiting(RESTRequestHandler.class.getName(), "doRequest", ret);
        return ret;
    }

    private class RootResource
    extends DirResource {
        public RootResource() {
            super("");
            LOGGER.entering(RootResource.class.getName(), "<init>");
            LOGGER.exiting(RootResource.class.getName(), "<init>");
        }

        @Override
        public HttpResponse toDelete(String path, HttpRequest request) throws HttpException {
            LOGGER.entering(RootResource.class.getName(), "toDelete");
            HttpResponse ret = super.toDelete(path, request);
            if (ret == null) {
                throw new NotFoundException();
            }
            LOGGER.exiting(RootResource.class.getName(), "toDelete", ret);
            return ret;
        }

        @Override
        public HttpResponse toGet(String path, HttpRequest request) throws HttpException {
            LOGGER.entering(RootResource.class.getName(), "toGet");
            HttpResponse ret = super.toGet(path, request);
            if (ret == null) {
                throw new NotFoundException();
            }
            LOGGER.exiting(RootResource.class.getName(), "toGet", ret);
            return ret;
        }

        @Override
        public HttpResponse toPost(String path, HttpRequest request) throws HttpException {
            LOGGER.entering(RootResource.class.getName(), "toPost");
            HttpResponse ret = super.toPost(path, request);
            if (ret == null) {
                throw new NotFoundException();
            }
            LOGGER.exiting(RootResource.class.getName(), "toPost", ret);
            return ret;
        }

        @Override
        public HttpResponse toPut(String path, HttpRequest request) throws HttpException {
            LOGGER.entering(RootResource.class.getName(), "toPut");
            HttpResponse ret = super.toPut(path, request);
            if (ret == null) {
                throw new NotFoundException();
            }
            LOGGER.exiting(RootResource.class.getName(), "toPut", ret);
            return ret;
        }
    }
}

