/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.util.Codec;

public class Query
implements Map<String, String> {
    private final Map<String, String> _entry = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(Query.class.getName());
    private static final Pattern QPAT = Pattern.compile("([^=^&]+)=([^&]+)");
    private static final String NONE = "";

    public Query() {
        LOGGER.entering(Query.class.getName(), "<init>");
        LOGGER.exiting(Query.class.getName(), "<init>");
    }

    public Query(String query) {
        LOGGER.entering(Query.class.getName(), "<init>", query);
        assert (query != null);
        Matcher m = QPAT.matcher(query);
        while (m.find()) {
            String key = m.group(1);
            String value = Codec.urlDecode(m.group(2));
            LOGGER.fine(String.format("Query\u30a8\u30f3\u30c8\u30ea\u3092\u8ffd\u52a0[%s : %s]", key, value));
            this.put(key, value);
        }
        if (this._entry.size() == 0) {
            this.put(query, NONE);
        }
        LOGGER.exiting(Query.class.getName(), "<init>");
    }

    public String toString() {
        LOGGER.entering(Query.class.getName(), "toString");
        StringBuilder builder = new StringBuilder();
        for (String key : this.keySet()) {
            String value = this.get(key);
            if (NONE.equals(value)) {
                builder.append(key);
                continue;
            }
            value = Codec.urlEncode(value);
            builder.append(key);
            builder.append("=");
            builder.append(value);
            builder.append('&');
        }
        int last = builder.length() - 1;
        if (last >= 0 && builder.charAt(last) == '&') {
            builder.deleteCharAt(last);
        }
        String ret = builder.toString();
        LOGGER.exiting(Query.class.getName(), "toString", ret);
        return ret;
    }

    @Override
    public void clear() {
        LOGGER.entering(Query.class.getName(), "clear");
        this._entry.clear();
        LOGGER.exiting(Query.class.getName(), "clear");
    }

    @Override
    public boolean containsKey(Object key) {
        LOGGER.entering(Query.class.getName(), "containsKey", key);
        assert (key != null);
        boolean ret = this._entry.containsKey(key);
        LOGGER.exiting(Query.class.getName(), "containsKey", ret);
        return ret;
    }

    @Override
    public boolean containsValue(Object value) {
        LOGGER.entering(Query.class.getName(), "containsValue", value);
        boolean ret = this._entry.containsValue(value);
        LOGGER.exiting(Query.class.getName(), "containsValue", ret);
        return ret;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        LOGGER.entering(Query.class.getName(), "entrySet");
        Set<Map.Entry<String, String>> ret = this._entry.entrySet();
        LOGGER.exiting(Query.class.getName(), "entrySet", ret);
        return ret;
    }

    @Override
    public final String get(Object key) {
        LOGGER.entering(Query.class.getName(), "get", key);
        String ret = this._entry.get(key);
        LOGGER.exiting(Query.class.getName(), "get", ret);
        return ret;
    }

    @Override
    public boolean isEmpty() {
        LOGGER.entering(Query.class.getName(), "isEmpty");
        boolean ret = this._entry.isEmpty();
        LOGGER.exiting(Query.class.getName(), "<init>");
        return ret;
    }

    @Override
    public Set<String> keySet() {
        LOGGER.entering(Query.class.getName(), "keySet");
        Set<String> ret = this._entry.keySet();
        LOGGER.exiting(Query.class.getName(), "keySet", ret);
        return ret;
    }

    @Override
    public String remove(Object key) {
        LOGGER.entering(Query.class.getName(), "remove", key);
        String ret = this._entry.remove(key);
        LOGGER.exiting(Query.class.getName(), "remove", ret);
        return ret;
    }

    @Override
    public Collection<String> values() {
        LOGGER.entering(Query.class.getName(), "values");
        Collection<String> ret = this._entry.values();
        LOGGER.exiting(Query.class.getName(), "values", ret);
        return ret;
    }

    @Override
    public String put(String key, String value) {
        LOGGER.entering(Query.class.getName(), "put", new Object[]{key, value});
        String ret = this._entry.put(key, value);
        LOGGER.exiting(Query.class.getName(), "put", ret);
        return ret;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        LOGGER.entering(Query.class.getName(), "putAll", m);
        this._entry.putAll(m);
        LOGGER.exiting(Query.class.getName(), "putAll");
    }

    @Override
    public int size() {
        LOGGER.entering(Query.class.getName(), "size");
        int ret = this._entry.size();
        LOGGER.exiting(Query.class.getName(), "size", ret);
        return ret;
    }
}

