/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import nor.http.HeaderName;
import nor.http.Http;
import nor.http.HttpBody;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.InternalServerErrorException;
import nor.http.io.HeaderInputStream;
import nor.util.log.EasyLogger;

public class HttpRequest
extends HttpMessage {
    private String method;
    private String path;
    private String version;
    private final HttpHeader header;
    private final HttpBody body;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(HttpRequest.class);

    private HttpRequest(InputStream input, String prefix) throws IOException {
        String buf;
        LOGGER.entering("<init>", input, prefix);
        assert (input != null);
        BufferedReader in = new BufferedReader(new InputStreamReader(new HeaderInputStream(input)));
        while ((buf = in.readLine()) != null) {
            Matcher m = Http.REQUEST_LINE_PATTERN.matcher(buf);
            if (!m.matches()) continue;
            this.method = m.group(1);
            this.path = String.valueOf(prefix) + m.group(2);
            this.version = m.group(3);
            break;
        }
        this.header = new HttpHeader(in);
        this.body = new HttpBody(input, this.header);
        LOGGER.exiting("<init>");
    }

    public String getMethod() {
        LOGGER.entering("getMethod", new Object[0]);
        String ret = this.method;
        LOGGER.exiting("getMethod", ret);
        return ret;
    }

    public void setPath(String path) {
        LOGGER.entering("setPath", path);
        this.path = path;
        LOGGER.exiting("setPath");
    }

    public HttpResponse createResponse(InputStream input) throws HttpException {
        LOGGER.entering("createResponse", input);
        assert (input != null);
        HttpResponse ret = new HttpResponse(this, input);
        LOGGER.exiting("createResponse", ret);
        return ret;
    }

    public HttpResponse createResponse(HttpURLConnection con) throws HttpException {
        HttpResponse ret;
        LOGGER.entering("createResponse", con);
        assert (con != null);
        HttpHeader header = this.getHeader();
        for (String key : header.keySet()) {
            con.addRequestProperty(key, header.get(key));
        }
        con.setConnectTimeout(60000);
        try {
            if (header.containsKey(HeaderName.ContentLength)) {
                int length = Integer.parseInt(header.get(HeaderName.ContentLength));
                con.setFixedLengthStreamingMode(length);
                con.setDoOutput(true);
                con.connect();
                this.getBody().output(con.getOutputStream(), this.header);
            } else if (header.containsKey(HeaderName.TransferEncoding)) {
                con.setDoOutput(true);
                con.connect();
                this.getBody().output(con.getOutputStream(), this.header);
            } else {
                con.connect();
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        try {
            int code = con.getResponseCode();
            InputStream resStream = null;
            if (code == -1) {
                throw new InternalServerErrorException("Recieve an invalid message.");
            }
            if (code < 400) {
                resStream = con.getInputStream();
                String encode = con.getHeaderField(HeaderName.ContentEncoding.toString());
                if (encode != null) {
                    if ("gzip".equalsIgnoreCase(encode)) {
                        resStream = new GZIPInputStream(resStream);
                    } else if ("deflate".equalsIgnoreCase(encode)) {
                        resStream = new DeflaterInputStream(resStream);
                    }
                }
            } else {
                resStream = con.getErrorStream();
            }
            ret = new HttpResponse(this, Status.valueOf(code), resStream);
            HttpHeader resHeader = ret.getHeader();
            Map<String, List<String>> fields = con.getHeaderFields();
            for (String key : fields.keySet()) {
                if (key == null) continue;
                for (String value : fields.get(key)) {
                    resHeader.add(key, value);
                }
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        LOGGER.exiting("createResponse", ret);
        return ret;
    }

    public HttpResponse createResponse(Status status, InputStream body) {
        HttpResponse ret = new HttpResponse(this, status, body);
        return ret;
    }

    public HttpResponse createResponse(Status status) {
        return this.createResponse(status, "");
    }

    public HttpResponse createResponse(Status status, String body) {
        byte[] b = body.getBytes();
        HttpResponse ret = this.createResponse(status, new ByteArrayInputStream(b));
        HttpHeader header = ret.getHeader();
        header.set(HeaderName.ContentLength, Integer.toString(b.length));
        return ret;
    }

    @Override
    public String getVersion() {
        LOGGER.entering("getVersion", new Object[0]);
        String ret = this.version;
        LOGGER.exiting("getVersion", ret);
        return ret;
    }

    @Override
    public String getPath() {
        LOGGER.entering("getPath", new Object[0]);
        String ret = this.path;
        LOGGER.exiting("getPath", ret);
        return ret;
    }

    @Override
    public String getHeadLine() {
        LOGGER.entering("getHeadLine", new Object[0]);
        String ret = String.format("%s %s HTTP/%s", this.method, this.path, this.version);
        LOGGER.exiting("getHeadLine", ret);
        return ret;
    }

    @Override
    public HttpHeader getHeader() {
        return this.header;
    }

    @Override
    public HttpBody getBody() {
        return this.body;
    }

    public static HttpRequest create(InputStream input, String prefix) {
        HttpRequest ret;
        block3: {
            try {
                ret = new HttpRequest(input, prefix);
                if (ret.getMethod() != null) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ret;
    }
}

