/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType {
    private String _type = "unknown";
    private String _subtype = "unknown";
    private String _charset = "unknown";
    public static final String UNKNOWN = "unknown";
    private static final Logger LOGGER = Logger.getLogger(ContentType.class.getName());
    private static final Pattern CONTENT_TYPE = Pattern.compile("([^/]+)/([^\\s^;]+)\\s*;?(\\s*charset\\s*=\\s*\"+([^\"]+)\"+)?");

    public ContentType() {
        LOGGER.entering(ContentType.class.getName(), "<init>");
        LOGGER.exiting(ContentType.class.getName(), "<init>");
    }

    public ContentType(String str) {
        LOGGER.entering(ContentType.class.getName(), "<init>", str);
        this.setContentType(str);
        LOGGER.exiting(ContentType.class.getName(), "<init>");
    }

    public String getMIMEType() {
        LOGGER.entering(ContentType.class.getName(), "getMIMEType");
        String ret = this._type;
        LOGGER.exiting(ContentType.class.getName(), "getMIMEType", ret);
        return ret;
    }

    public String getMIMESubtype() {
        LOGGER.entering(ContentType.class.getName(), "getMIMESubtype");
        String ret = this._subtype;
        LOGGER.exiting(ContentType.class.getName(), "getMIMESubtype", ret);
        return ret;
    }

    public String getCharset() {
        LOGGER.entering(ContentType.class.getName(), "getCharset");
        String ret = this._charset;
        LOGGER.exiting(ContentType.class.getName(), "getCharset", ret);
        return ret;
    }

    public boolean isAvailable() {
        LOGGER.entering(ContentType.class.getName(), "isUnknown");
        boolean ret = !UNKNOWN.equals(this.getMIMEType());
        LOGGER.exiting(ContentType.class.getName(), "isUnknown", ret);
        return ret;
    }

    public String toString() {
        LOGGER.entering(ContentType.class.getName(), "toString");
        String ret = "";
        if (!UNKNOWN.equals(this.getMIMEType()) && !UNKNOWN.equals(this.getMIMESubtype())) {
            ret = UNKNOWN.equals(this.getCharset()) ? String.format("%s/%s;", this.getMIMEType(), this.getMIMESubtype()) : String.format("%s/%s; charset=%s", this.getMIMEType(), this.getMIMESubtype(), this.getCharset());
        }
        LOGGER.exiting(ContentType.class.getName(), "toString", ret);
        return ret;
    }

    void setContentType(String str) {
        LOGGER.entering(ContentType.class.getName(), "setContentType", str);
        assert (str != null);
        Matcher m = CONTENT_TYPE.matcher(str);
        if (m.find()) {
            this._type = m.group(1);
            this._subtype = m.group(2);
            String charset = m.group(4);
            if (charset != null) {
                this._charset = charset.toLowerCase();
            }
        }
        LOGGER.exiting(ContentType.class.getName(), "setContentType");
    }

    void setMIMEType(String type) {
        LOGGER.entering(ContentType.class.getName(), "setMIMETypr", type);
        assert (type != null);
        this._type = type;
        LOGGER.exiting(ContentType.class.getName(), "setMIMEType");
    }

    void setMIMESubtype(String subtype) {
        LOGGER.entering(ContentType.class.getName(), "setMIMESubtype", subtype);
        assert (subtype != null);
        this._subtype = subtype;
        LOGGER.exiting(ContentType.class.getName(), "setMIMESubtype");
    }

    public void setCharset(String charset) {
        LOGGER.entering(ContentType.class.getName(), "setCharset", charset);
        assert (charset != null);
        this._charset = charset.toLowerCase();
        LOGGER.exiting(ContentType.class.getName(), "setCharset");
    }

    void clear() {
        LOGGER.entering(ContentType.class.getName(), "clear");
        this._type = UNKNOWN;
        this._subtype = UNKNOWN;
        this._charset = UNKNOWN;
        LOGGER.exiting(ContentType.class.getName(), "clear");
    }

    public final class MIMESubType {
        public static final String HTML = "html";
    }

    public final class MIMEType {
        public static final String TEXT = "text";
        public static final String MESSAGE = "message";
        public static final String APPLICATION = "application";
        public static final String IMAGE = "image";
        public static final String AUDIO = "audio";
        public static final String VIDEO = "video";
        public static final String MODEL = "model";
        public static final String MULTIPART = "multipart";
    }
}

