
// ### 注意 ###
// ### prescription.js, usageEditor.jp, groupEditor.js でメソッド名が重複しないこと
// ###########

var _groupName; // Global 変数
var _effect; // Global 変数

var _groupTableArray; // Global 変数
function setGroupTableArray(ln){
	// 文字列形式でもらった ln を基に薬剤テーブルを生成
	_groupTableArray = new Array();
	var records = eval('(' + ln + ')');
    for (i in records){
		var obj = records[i];
        if (obj.code * 1 == 120){ // 約束処方のみに絞る
            var recObj = new GroupRecordObj(obj);
            if (recObj) _groupTableArray.push(recObj);
        }
	}
}
function groupTableArray(){
	return _groupTableArray;
}
function groupNameArray(){
	// 約束処方名の配列を返す
	var array = new Array();
	var i, count = _groupTableArray.length;
	for (i=0; i < count; i++){
		var obj = _groupTableArray[i];
		array[i] = obj.name;
	}
	return array;
}
function groupObjectForName(key){
	// 約束処方名:key に一致する薬剤オブジェクトを返す
	var array = new Array();
	var i, num, count = _groupTableArray.length;
	for (i=0; i < count; i++){
		var obj = _groupTableArray[i];
		if (isSame(obj.name, key))
			return obj;
	}
	return null;
}
function GroupRecordObj(obj){ // Record Object のコンストラクタ
	var newObj = new Object();
	newObj.code = obj.code; // 21,22,23
	newObj.alias = obj.alias;
	newObj.name = obj.name;
	newObj.generic = obj.generic;
	newObj.dose = obj.dose; // "6"
	if (obj.standard) newObj.dose = obj.standard;
	newObj.unit = obj.unit; // obj.unit = "Tab 日分"
	newObj.handan = obj.handan;
	newObj.min = obj.min;
	newObj.standard = obj.standard;
	newObj.max = obj.max;
	newObj.width = obj.width;
	newObj.effect = obj.effect;
	newObj.memo = obj.memo;
	return newObj;
}

var _selectedName;
function setSelectedGroupName(name){
	_selectedName = name;
}
function selectedGroupName(){
	return _selectedName;
}

///////////////////////////
/// Ajax による処理

function groupRemoved(answer){
	// サーバから約束処方を削除したレスポンスを表示
    showGroupList(); // 約束処方リストを表示
}
function removeGroup(){
	// 約束処方の削除
	var groupName = document.getElementById("groupName").value;
	if (confirm("約束処方( "+groupName+" )を削除していいですか")){
        var args = new Object();
        args['groupName'] = groupName;
        
        _callServer("REMOVE_GROUP", "priceListServer.php", args, groupRemoved);
	}
}

function savedGroup(answer){
	// 約束処方の本格登録依頼に対するサーバからのレスポンスを処理
    showGroupList(); // 約束処方リストを表示
}
function saveGroup(){
	// 約束処方の本格登録依頼
    // saveData() がセットされる時点で groupName, effect などはまだ入力されて
    // いないので、saveData() が呼ばれてからここで生成する必要がある。
    if (trim(_groupName).length == 0){
        alert("処方名がないので登録できません");
        return;
    }
    
    var obj = prescriptionObject();
    if (! obj){
        alert("処方内容がないので登録できません");
        return;
    }
    
    var args = new Object();
    args['groupName'] = _groupName;
    args['effect'] = _effect;
    args['records'] = object2json(obj);
    
    _callServer("PUT_GROUP", "priceListServer.php", args, savedGroup);
}

function editAsGroup(){
	// 約束処方の名称や薬効を訂正
    // saveData() がセットされる時点で groupName, effect などはまだ入力されて
    // いないので、saveData() が呼ばれてからここで生成する必要がある。
    var args = new Object();
    _groupName = document.getElementById("groupName").value;
    _effect = document.getElementById("effect").value;
    var sourceObj = groupObjectForName();
    if (sourceObj){ // 登録済みの約束処方を編集
        args['groupName'] = _groupName;
        args['effect'] = _effect;
        args['records'] = contentsOfShohou(_groupName);
        
        _initDebug(true); //##
        _debug("editAsGroup PUT_GROUP->"+encodeObject(args)); //##
        _debug("selectedGroupName->"+selectedGroupName()); //##
        
        _callServer("PUT_GROUP", "priceListServer.php", args, savedGroup);
    } else { // 新規に約束処方を登録
        putAsGroup();
    }

	
	function contentsOfShohou(){
		// 選択された約束処方の内容を JSON 文字列として返す
		// memo の " が '&quot;' に encode されているので decode する
		var ary = sourceObj.memo.split("&quot;");
		var memo = ary.join("\"");
		var buff = '{';
		var yakusokuObj = eval('(' + memo + ')');
		for (groupId in yakusokuObj){
			var youhouObj = yakusokuObj[groupId]; // 同じ用法セット
			buff += '"'+groupId+'":{'; // グループID
			var num = 0;
			for (cId in youhouObj){
				var obj = youhouObj[cId]; // 薬剤または用法オブジェクト
				var cd = (obj.code > 120) ? obj.code : num++;
				buff += '"'+cId+'":{'; // 薬剤・用法ID
				buff += '"code":"' + cd + '",';
				buff += '"name":"' + obj.name + '",';
				buff += '"dose":"' + obj.dose + '",';
				buff += '"unit":"' + obj.unit + '"},';
			}
			if (buff.charAt(buff.length - 1) == ",")
				buff = buff.substr(0, buff.length-1);
			buff += '},';
		}
		if (buff.charAt(buff.length - 1) == ",")
			buff = buff.substr(0, buff.length-1);
		buff += '}';
		return buff;
	}
}

function registerdAsGroup(answer){
	// 約束処方の登録依頼に対するサーバからのレスポンスを処理
    var st = trim(answer);
    if (st.length > 0){
        if (! confirm("この約束処方名は登録済みです。上書きしますか？"))
            return;
    }
    saveGroup(); // ここで登録動作を行う
}
function putAsGroup(){
	// 約束処方の登録を依頼
    // putAsGroup() がセットされる時点で groupName, effect などは
    // まだ入力されていないので、putAsGroup() が呼ばれてから
    // ここで Global 変数に記憶保持しておく必要がある
    _groupName = document.getElementById("groupName").value;
    _effect = document.getElementById("effect").value;
    
    var args = new Object();
    args['groupName'] = _groupName;
    
    _callServer("HAS_GROUP", "priceListServer.php", args, registerdAsGroup);
}

function loadedGroupList(answer){
    //alert("loadedGroupList ---\n"+answer);
    setGroupTableArray(answer);
    document.getElementById("groupList").innerHTML = groupList();

	function groupList(){
		// 用法リストを HTML 形式にして返す
		var array = groupNameArray();
		var results = new Array();
		var i, j, count = array.length;
		for (i=j=0; i < count; i++){
			var name = array[i];
			results[j++] = "<A HREF=# onclick=\"clickedGroup('"+name+"')\">"+name+"</A>";
		}
		return results.join("<BR/>");
	}
}
function showGroupList(){
    // 約束処方リストを表示
    setAsEdotorMode();
    
    var args = new Object();
    args['code'] = "120"; // code:120 は約束処方
    
    _callServer("GET_LIST", "priceListServer.php", args, loadedGroupList);
}
function loadGroupList(){
	// 約束処方すべてをリクエスト
	if (document.getElementById("groupList").innerHTML.length){
		// 約束処方リストを toggle 式に表示・非表示
		setAsRegisterMode();
	} else {
        showGroupList(); // 約束処方リストを表示
	}
}

/// Ajax による処理
///////////////////////////


function setAsRegisterMode(){
	// 約束処方の登録モード
	
	// タイトル表示
	document.getElementById("editorLabel").innerHTML = "上の処方を登録";
	
	// 編集モードでの処方内容表示
	document.getElementById("displayArea").innerHTML = "";
	
	// 約束処方名・薬効
	document.getElementById("groupName").value = "";
	document.getElementById("effect").value = "";

	// コントロール・エリア
	var td = document.getElementById("editorControlArea");
	td.innerHTML = "この約束処方を ";
    var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "登録";
	bt.setAttribute("onclick", "putAsGroup()");
	
	// 約束処方リスト表示エリア
	document.getElementById("groupList").innerHTML = "";
}
function setAsEdotorMode(){
	// 約束処方の編集モード
	
	// タイトル表示
	document.getElementById("editorLabel").innerHTML = "約束処方の編集";
	
	// 編集モードでの処方内容表示
	var st = "処方内容の編集はここではできません<br>";
    st += "上の領域で作成し登録してください。<br/>";
	st += "＊ 処方を以下のリストから選択してください";
	document.getElementById("displayArea").innerHTML = st;
    
	// 約束処方名・薬効
	document.getElementById("groupName").value = "";
	document.getElementById("effect").value = "";
	
	// コントロール・エリア
	var td = document.getElementById("editorControlArea");
	td.innerHTML = "この約束処方を ";
    var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "削除";
	bt.setAttribute("onclick", "removeGroup()");
    var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "確定";
	bt.setAttribute("onclick", "editAsGroup()");
}

function clickedGroup(item){
	// 約束処方内容を確認
	var obj = groupObjectForName(item);
	document.getElementById("groupName").value = item;
	document.getElementById("effect").value = obj.effect;
	setSelectedGroupName(item); // 編集用に選択された約束処方名を記憶
	// memo の " が '&quot;' に encode されているので decode する
	var ary = obj.memo.split("&quot;");
	var memo = ary.join("\"");
	//alert(memo); //##
	var recs = new Array();
	var yakusokuObj = eval('(' + memo + ')');
	for (groupId in yakusokuObj){
		var subObj = yakusokuObj[groupId];
		//alert("== groupId"+groupId); //##
		for (cId in subObj){
			var recObj = subObj[cId];
			if (recObj.code > 120)
				var ln = "--- "+recObj.name+" ("+recObj.dose+" "+recObj.unit+")";
			else
				var ln = recObj.name+" ("+recObj.dose+" "+recObj.unit+")";
			recs.push(ln);
		}
	}
	document.getElementById("displayArea").innerHTML = recs.join("</BR>");
}

function closeGroupEditor(){
	document.getElementById("editorArea").innerHTML = "";
}

function showGroupEditor(){
	// 約束処方編集ペーンを開く
	var elm = document.getElementById("editorArea");
	if (elm.innerHTML.length > 0){
		elm.innerHTML = "";
		return;
	}
    
    var frame = newDIV(elm, "templateFrame");

    // HEADER
    var div = newDIV(frame, "/clearfix");
    div.style.paddingBottom = "5px";
	var im = newIMAGE(div,"icon","./close.png","close");
    im.style.height = "14px";
	im.setAttribute("onclick", "closeGroupEditor()");
    var dv = newSPAN(div, "editorLabel");
    
	// 約束処方名入力
    var div = newDIV(frame, "");
	var fd = newFIELD(div, "groupName", "約束処方名", 15, "");
	var fd = newFIELD(div, "effect", "薬効", 15, "");
    
	// controls
    var div = newDIV(frame, "editorControlArea");
    
	// アンカー・エリア
    var div = newDIV(frame, "");
	var a = newA(div, "約束処方の編集", "#", "");
	a.setAttribute("onclick", "loadGroupList()");
	a.style.fontSize = "10pt";
	
	// 編集モードにおける約束処方表示エリア
    var div = newDIV(frame, "displayArea");
    
	// 用法表示エリア
    var div = newDIV(frame, "groupList");

	setAsRegisterMode();
}
