
////////////////////////////////////////////////////
/// Ajax による処理 //////////////////////////////////

function reveredtLayout(answer){
    // 設定した属性を再読み込みするためブラウザーをリロード
    //alert("reveredtLayout->"+answer); //##
    
    window.location.reload(true);
}
function revertLayout(){
    // レコードを工場出荷状態に戻す
    var args = new Object();
    args["owner"] = currentUser();
    
    _callServer("REMOVE_LAYOUT_PARTS", "frontServer.php", args, reveredtLayout);
}

function gotArchives(answer){
    //alert("gotArchives->"+answer); //##
    
    var obj = JSON.parse(answer);
    // FRONT レイアウトのバックアップファイルのリストを生成
    var array = new Array();
    var files = obj.files;
    if (files){
        for (num in files){
            var filename = files[num];
            
            // 201202201212FRONT.txt 型式の旧 FRONT ファイルはスキップ
            if (filename.indexOf("FRONT") > 0) continue; 
            
            array.push(filename);
        }
    }
    
    // バックアップ編集ペーンを開く
    showBackUp(array);
}
function getBackup(){
    // バックアップファイルの履歴をサーバへリクエスト
    var args = new Object();
    args["owner"] = currentUser();
    
    _callServer("GET_ARCHIVE_FILES", "frontServer.php", args, gotArchives);
}

function gotArchiveFile(answer){
    // まずテンプレートを元に属性を設定
    //alert("gotArchiveFile--\n"+answer); //##
    //_initDebug(true); //##

    // まずテンプレートを obj に設定
    var obj = new Object();
    obj.checkBox = layoutChecksTemplate();
    obj.firstItem = "予定表";
    obj.timeZone = "0900-1200";
    obj.plan = planTemplate();
    obj.day = dayTemplate();
    obj.month = monthTemplate();
    
    // 読み込んだバックアップを obj に上書き
    var rec = decodeObject(answer);
    
    _debug("rec--\n"+encodeObject(rec)); //##
    
    if (rec.checkBox) obj.checkBox = rec.checkBox;
    if (rec.firstItem) obj.firstItem = rec.firstItem;
    if (rec.timeZone) obj.timeZone = rec.timeZone;
    if (rec.plan) obj.plan = rec.plan;
    if (rec.day) obj.day = rec.day;
    if (rec.month) obj.month = rec.month;
    setLayout(obj);
    showPreference(); // ### この途中でコケる #######
    
    _debug("========"); //
    _debug(encodeObject(obj)); //##
    
    if (confirm("この設定でよければ「保存」します")){
        // 読み込んだこのレイアウトを保存
        savePreference();
    }
}
function getArchiveFile(){
    // 指定されたバックアップファイルからレイアウトを復元
    var args = new Object();
    args["owner"] = currentUser();
    args["filename"] = document.getElementById("fileNamePop").value;
    
    _callServer("GET_ARCHIVE_FILE", "frontServer.php", args, gotArchiveFile);
}

function removedArchiveFile(answer){
    // バックアップ・ペーンを一旦閉じる
    alert(answer);
    
    getBackup();
}
function removeArchiveFile(){
    // 指定されたバックアップファイルを削除
    var filename = document.getElementById("fileNamePop").value;
    if (!confirm(filename + " を削除していいですか")) return;

    var args = new Object();
    args["owner"] = currentUser();
    args["filename"] = filename;
    
    _callServer("REMOVE_ARCHIVE_FILE", "frontServer.php", args, removedArchiveFile);
}

/// Ajax による処理 //////////////////////////////////
////////////////////////////////////////////////////


function showBackUp(fileNames){
    // バックアップ・ペーンを開く
    var elm = document.getElementById("backupPane");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.paddingTop = "20px";
    div.style.paddingLeft = "10px";
    // レイアウトを復元
    var sp = newSPAN(div, "");
    sp.innerHTML = "レイアウトを";
    sp.style.paddingRight = "5px";
    // バックアップファイルのポップアップ・メニューを生成
    var sp = newSPAN(div, "");
    var pm = newPopupMenu(sp, "fileNamePop", fileNames, "");
    var bt = newBUTTON(div, "", "から復元");
    bt.setAttribute("onclick", "getArchiveFile()");
    var sp = newSPAN(div, "");
    sp.style.marginRight = "5px";
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeArchiveFile()");

    // 工場出荷状態に戻す
    var sp = newSPAN(div, "");
    sp.innerHTML = "レイアウトを";
    sp.style.paddingLeft = "20px";
    sp.style.paddingRight = "5px";
    var bt = newBUTTON(div, "", "工場出荷状態に戻す");
    bt.setAttribute("onclick", "revertLayout()");
}