
function calendarDateClicked(yymmdd){
    // newDatePopUp() のレシーバで、そのオブジェクトが生成された段階で呼ばれる
    if (!yymmdd)
        yymmdd = document.getElementById("birthDayPop").value;
    var array = yymmdd.split("-");
	var yy = array[0];
	var mm = array[1];
	var dd = array[2];
	
	// 年齢計算
	var elm = document.getElementById("result");
    if (elm){
        var array = age(yy, mm, dd, true);
        var y = array[0];
        var m = array[1];
        var d = array[2];
        elm.innerHTML = y + "才 " + m + "ケ月 "+ d + "日";
    }
}

function makeAgeContents(){
    // 年齢計算のペーンを生成
	var elm = document.getElementById("contents");
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    
    // 生年月日
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "誕生");
    td.style.width = "40px";
	var td1 = newTD(tr, "datePopupArea", "");
    
	// 年齡
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "年齡");
    
    // newDatePopUp() が生成された段階で calendarDateClicked が呼ばれるので
    // calendarDateClicked が答えを表示するのに必要な td2 は先に作成しておく
	var td2 = newTD(tr, "result", "");
    td2.style.padding = "0px 5px";

    if (parent() && parent().patientId()){ // dataCenter.js
        // parent() はこのウインドーの親すなわち NOA
        // NOA から起動され、カルテが開いていれば NOA の生年月日を使う
        var obj = parent().valueForTag("PatientTable.birthDate"); // 1942-03-23 型式
        var date = obj.value;
        
        array = date.split("-");
        var yy = array[0];
        var mm = array[1];
        var dd = array[2];
    } else {
        var date = new Date();
        var yy = date.getYear();
        var mm = date.getMonth() + 1;
        var dd = date.getDate();
        if (yy < 2000) { yy += 1900; }
        yy -= 30; // 30歳を default とする
    }
    td1.innerHTML = "";
    newDatePopUp(td1, "birthDayPop", "", yy, mm, dd, false, calendarDateClicked);
}

///////////////////////////////////////////////////////////////
///// 日数計算 /////////////////////////////////////////////////

function calcInterval(){
    // 日付と日付との週数・日数を計算
    var date1 = elmFor("day1pop").value;
    var date2 = elmFor("day2pop").value;
    if ((date1.length < 10) || (date2.length < 10)){
        elmFor("resultArea").innerHTML = "";
        return;
    }
    
    
    var diff = new Date((+new Date(date2)) - (+new Date(date1)));
    var year = diff.getUTCFullYear() - 1970;
    var month = diff.getUTCMonth();
    var day = diff.getUTCDate() - 1;
    var st = "経過日数 " +　year + "年 " + month + "月 " + day + "日";
    
    var interval = daysBetween(date1, date2);
    var weeks = parseInt(interval / 7);
    var days = parseInt(interval % 7);
    st += " (" + interval + "日：" + weeks + "週 " + days + "日）";
    
    var elm = elmFor("resultArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.paddingTop = "1px";
    div.innerHTML = st;
}

function setNow(id){
    // tag の年月日ポップアップに本日の年月日を設定
    var dv = elmFor(id + "Area");
    dv.innerHTML = "";
    
    // 日付ポップアップを表示
    var dateArray = arrayWithDateTime(todayAndTime());
    var yy = dateArray[0];
    var mm = dateArray[1];
    var dd = dateArray[2];
    newDatePopUp(dv, id, "平成", yy, mm, dd, false);
}

function makeDaysContents(){
    // 日数計算のペーンを生成
	var elm = document.getElementById("daysContents");
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    
    // 第1年月日
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "./timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "setNow('day1pop')");
    img.style.position = "relative";
    img.style.top = "5px";
    img.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "day1popArea");
    newDatePopUp(sp, "day1pop", "", 0, 0, 0, false);
    var sp = newSPAN(td, "");
    sp.innerHTML = "から";
    
    // 第2年月日
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "./timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "setNow('day2pop')");
    img.style.position = "relative";
    img.style.top = "5px";
    img.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "day2popArea");
    newDatePopUp(sp, "day2pop", "", 0, 0, 0, false);
    var sp = newSPAN(td, "");
    sp.innerHTML = "までを";
    var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "計算";
    bt.setAttribute("onclick", "calcInterval()");
    
    // 結果表示行
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "resultArea", "");
}

///// 日数計算 /////////////////////////////////////////////////
///////////////////////////////////////////////////////////////

function initAge(){
	// obj で得られたレイアウトを表示
    //_initDebug(true); //##
    
	var elm = document.getElementById("base");
    var pframe = new PictureFrame(elm, "100%", "100%");
    
    // 年齢計算 =======================================
    // HEADER
    pframe.headerLeft.innerHTML = "年齢計算";

    // CONTENTS
    pframe.body.setAttribute("id", "contents");

    // FOOTER を表示しない
    pframe.footer.style.display = "none"; //###
    
    makeAgeContents();

    // 日数計算 =======================================
    var div = newDIV(elm, "");
    var pframe = new PictureFrame(div, "50%", "50%");
    
    // HEADER
    // LEFT-SIDE
    pframe.headerLeft.innerHTML = "日数計算";
    
    // CONTENTS
    var div = pframe.body;
    div.setAttribute("id", "daysContents");
    div.style.padding = "10px";

    makeDaysContents();

    // FOOTER
    pframe.footerLeft.innerHTML = version();
    
    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "年齡計算ツール";
}

function version(){
	return "Ver.150728";
}

