#ifndef A2BBROWSERPARSER_H
#define A2BBROWSERPARSER_H
#include <QString>
#include <QVector>
#include "a2BC_AbstractOtherBrowserParser.h"
#include "bbsTableParser.h"
#include "a2BCdatFileChecker.h"
#include "a2BCfavoriteParser.h"
#include "a2BCindexParser.h"

/*
 *  a2B̃f[^̓NX...
 * 
 */
class a2BbrowserParser : public a2BC_AbstractOtherBrowserParser
{

public:
    a2BbrowserParser();
    virtual ~a2BbrowserParser();

public:
    virtual QString getBrowserName(void);          // uEU
    virtual void setPath(QString &arPath);         // Oi[fBNg(̃[gfBNg)ݒ
    virtual void setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable); // BBSTABLE.HTML(Ƃꗗt@C)̊Ǘt@Cw
    virtual bool prepare(void);                   // Of[^̏BBB
    virtual int  datFileCount(void);              // Of[^
    virtual int     checkUnmanagedDatFile(void);                 // ǗOdatt@C`FbN
    virtual QString getUnmanagedDatFileName(int aIndex);       // ǗOdatt@C擾
    virtual QString getUnmanagedDatNickName(int aIndex);       // ǗOdatjbNl[擾
    virtual QString getFullPathDatFileName(QString &arNick, QString &arFileName);  // datt@C𐶐
    virtual QString getReceiveDatFileName(QString &arNick, QString &arFileName);   // Mpdatt@C𐶐
    virtual QString getDatFileName(int aIndex);                // datt@C擾
    virtual QString getBoardNick(int aIndex);                  // datt@C݂̑nick擾
    virtual bool isSameLogFormat(void) {return (true); };   // OtH[}bga2BƓH
    virtual int  getReadPoint(int aIndex);                    // ǂ񂾏ꏊ
    virtual qint64 getLastUpdate(int aIndex);                  // ŏIXVԂ擾

    virtual QString getSubjectTxtFilePath(QString &arNick);     // subject.txt̃t@C(full path)擾
    virtual bool receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate);  // datt@CM
    virtual bool copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate);  // datt@CM
    virtual bool finalize(void);                             // nBBB

private:
    bool checkDirectory(QString &arPath);
    void checkUnmanagedFiles(QString &arPath);
    void parseIndexFile(QString &arFileName);
    bool insertData(QString &arNick, QString &arFile, int aReadPoint, qint64 aLastUpdate);

private:
    bbsTableParser      *mpBbsTableParser;
    a2BCdatFileChecker  mDatFileChecker;
    int                 mCount;
    int                 mUnmanagedCount;
    QString              mBaseDirectory;

    QVector<QString>     mUnmanagedDatFilePath;
    QVector<QString>     mUnmanagedDatFileName;

    a2BCfavoriteParser   mFavoriteParser;
    a2BCindexParser      mIndexParser;
};

#endif // #ifndef #ifndef A2BBROWSERPARSER_H
/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
