/*!
 *  ONX
 * 
 */
#include <QSet>
#include <QFile>
#include <QMessageBox>
#include "syncLog.h"
#include "screenData.h"
#include "a2BcConstants.h"

/*!
 *  RXgN^
 * 
 */
syncLog::syncLog(QWidget *parent)
 : QWidget(parent), mpBrowserParser(0), mpA2BbrowserParser(0), mIsReady(false)
{
    // ł͉Ȃ..
}

/*!
 *   fXgN^
 * 
 */
syncLog::~syncLog()
{
    mOtherBrowserFactory.deleteOtherBrowserFactory(mpA2BbrowserParser);
    mOtherBrowserFactory.deleteOtherBrowserFactory(mpBrowserParser);
}


/*!
 *  s̏
 * 
 */
bool syncLog::prepare(screenData &arDB)
{
    QString message;

    // ꗗf[^̓ǂݍݏ
    QString fileName = arDB.getBbsTableFileName();
    bool readyBbs = mBbsTableParser.prepare(fileName);
    if (readyBbs == false)
    {
        // ꗗ͎̉s...I
        return (false);
    }
    message = tr("read :") + " " + fileName;
    emit updateMessage(message);

    // a2Bp̃O̓NX擾As
    mpA2BbrowserParser = mOtherBrowserFactory.createOtherBrowserFactory(OTHERBROWSER_A2B);
    if (mpA2BbrowserParser == 0)
    {
        return (false);
    }
    QString baseDirectory = fileName;
    baseDirectory.replace(QRegExp("bbstable.html$"), "");
    mpA2BbrowserParser->setPath(baseDirectory);
    mpA2BbrowserParser->setBbsTable(&mBbsTableParser, fileName);
    if (mpA2BbrowserParser->prepare() == false)
    {
        mOtherBrowserFactory.deleteOtherBrowserFactory(mpA2BbrowserParser);
        return (false);
    }
    
    // ͌(datt@C)\
    message.setNum(mpA2BbrowserParser->datFileCount());
    message = tr("parsed ") + mpA2BbrowserParser->getBrowserName() + " : " + message;
    emit updateMessage(message);

    // p̃O̓NX擾As
    mpBrowserParser = mOtherBrowserFactory.createOtherBrowserFactory(arDB.getOtherBrowserType());
    if (mpBrowserParser == 0)
    {
        mOtherBrowserFactory.deleteOtherBrowserFactory(mpA2BbrowserParser);
        return (false);
    }
    QString logPath = arDB.getOtherBrowserDirectory();
    mpBrowserParser->setPath(logPath);
    mpBrowserParser->setBbsTable(&mBbsTableParser, fileName);
    if (mpBrowserParser->prepare() == false)
    {
        mOtherBrowserFactory.deleteOtherBrowserFactory(mpA2BbrowserParser);
        mOtherBrowserFactory.deleteOtherBrowserFactory(mpBrowserParser);
        return (false);
    }

    // ͌(datt@C)\
    message.setNum(mpBrowserParser->datFileCount());
    message = tr("parsed ") + mpBrowserParser->getBrowserName() + " : " + message;
    emit updateMessage(message);

    mIsReady = true;
    return (mIsReady);
}

/*!
 *   (a2B)̃uEU擾
 * 
 */
QString syncLog::getSourceBrowserName()
{
    if (mIsReady == false)
    {
        return ("(not ready)");
    }
    QString message;
    message = mpA2BbrowserParser->getBrowserName();
    return (message);
}

/*!
 *   ̃uEU擾
 * 
 */
QString syncLog::getDestinationBrowserName()
{
    if (mIsReady == false)
    {
        return ("(not ready)");
    }
    QString message;
    message = mpBrowserParser->getBrowserName();
    return (message);
}

/*!
 *   a2BŊǗĂȂdatt@C𑼃uEUɈړ
 * 
 */
void syncLog::moveToUnmanagedLogFile(int aSyncType)
{
    bool force = false;
    if (aSyncType == SYNC_FROM_a2B)
    {
        // a2B㏑ꍇ...
        force = true;
    }

    // a2BŊǗĂȂdatt@C̐߂
    int count = mpA2BbrowserParser->checkUnmanagedDatFile();
    for (int loop = 0; loop < count; loop++)
    {
        QString nickName = mpA2BbrowserParser->getUnmanagedDatNickName(loop);
        QString fileName = mpA2BbrowserParser->getUnmanagedDatFileName(loop);
        QString srcName  = mpA2BbrowserParser->getFullPathDatFileName(nickName, fileName);
        QString dstName  = mpBrowserParser->getReceiveDatFileName(nickName, fileName);
        QString message = "\n  " + srcName + " ==> " + dstName + "\n";
        emit updateMessage(message);
        
        // Rs[t@C݂ĂƂ...
        if (QFile::exists(dstName) == true)
        {
            // overwrite邩ǂ̊mFs...
            int ans = QMessageBox::No;
            if (force != true)
            {
                message = nickName + "/" + dstName + " " + tr("is already exists, overwrite it?");
                ans = QMessageBox::question(0, tr("confirmation"), message, QMessageBox::Yes, QMessageBox::No, QMessageBox::YesAll);
                if (ans == QMessageBox::YesAll)
                {
                    force = true;
                }
            }
            if ((force == true)||(ans == QMessageBox::Yes))
            {
                // ㏑mFYesI񂾏ꍇA邢́AYesAllI񂾏ꍇɂ́At@CăRs[
                QFile::remove(dstName);
            }
        }
        // t@Cړ
        mpBrowserParser->receiveDatFile(nickName, fileName, dstName, srcName, mpA2BbrowserParser->isSameLogFormat(), 1, 0);
    }
    return;
}

/*!
 *   ̎s
 * 
 */
bool syncLog::doSync(int aSyncType, Qt::CheckState aBackupErrorLog, Qt::CheckState aCopySubjectTxt)
{
    bool ret = false;
    
    // a2B̃G[O𑼃uEUֈړ邩ǂ...
    if (aBackupErrorLog == Qt::Checked)
    {
        // a2BŊǗĂȂdatt@C𑼃uEUɈړꍇ...
        moveToUnmanagedLogFile(aSyncType);        
    }

    QString message;
    switch (aSyncType)
    {
      case SYNC_TO_a2B:
        // uEU  a2B
        message = tr("Sync ") + getDestinationBrowserName() + " ==> " + getSourceBrowserName();
        emit updateMessage(message);
        ret = logCopyMain(mpA2BbrowserParser, mpBrowserParser, aBackupErrorLog, aCopySubjectTxt);
        break;

      case SYNC_FROM_a2B:
        // a2B  uEU
        message = tr("Sync ") + getSourceBrowserName() + " ==> " + getDestinationBrowserName();
        emit updateMessage(message);
        ret = logCopyMain(mpBrowserParser, mpA2BbrowserParser, aBackupErrorLog, aCopySubjectTxt);
        break;

      case SYNC_ALL:
      default:
        // O𓯊ꍇ...
        message = tr("Sync ") + getSourceBrowserName() + " <==> " + getDestinationBrowserName();
        emit updateMessage(message);
        ret = synchronizeMain(mpBrowserParser, mpA2BbrowserParser, aBackupErrorLog, aCopySubjectTxt);
        break;
    }

    // Ƃ܂
    mpA2BbrowserParser->finalize();
    mpBrowserParser->finalize();

    message = tr("synchronize end...");
    emit completedSynchronize(message);
    return (ret);
}

/*!
 *   O̎s...
 * 
 */
bool syncLog::synchronizeMain(a2BC_AbstractOtherBrowserParser *apDst, a2BC_AbstractOtherBrowserParser *apSrc, Qt::CheckState aBackupErrorLog, Qt::CheckState aCopySubjectTxt)
{
    bool ret = false;

    return (ret);
}

/*!
 *   ORs[̎s...
 * 
 */
bool syncLog::logCopyMain(a2BC_AbstractOtherBrowserParser *apDst, a2BC_AbstractOtherBrowserParser *apSrc, Qt::CheckState aRemoveErrorLog, Qt::CheckState aCopySubjectTxt)
{
    QSet<QString>  nickSet;
    bool force = false;
    bool ret = false;

    // ϐNA
    nickSet.clear();

    // vOXo[̍őlݒ
    emit setMaximum(apSrc->datFileCount() - 2);

    // apSrc  apDst̃O㏑Rs[...
    int count = apSrc->datFileCount();
    for (int loop = 0; loop < count; loop++)
    {
        QString srcNick    = apSrc->getBoardNick(loop);
        QString srcFile    = apSrc->getDatFileName(loop);
        int    readPoint  = apSrc->getReadPoint(loop);
        qint64  lastUpdate = apSrc->getLastUpdate (loop);
        QString srcName    = apSrc->getFullPathDatFileName(srcNick, srcFile);
        QString dstName    = apDst->getReceiveDatFileName(srcNick, srcFile);

        if ((aCopySubjectTxt == Qt::Checked)&&(nickSet.contains(srcNick) != true))
        {
            // jbNl[L^ĂȂ...
            nickSet.insert(srcNick);
        }

        // Rs[t@C𐶐...
        int ans = QMessageBox::Yes;
        if (QFile::exists(dstName) == true)
        {
            // overwrite邩ǂ̊mFs...
            if (force != true)
            {
                QFile srcFileInfo(srcName);
                QFile dstFileInfo(dstName);
                qint64 srcSize, dstSize;
                QString srcNum, dstNum;
                srcSize = srcFileInfo.size();
                dstSize = dstFileInfo.size();
                srcNum.setNum(srcSize);
                dstNum.setNum(dstSize);
                QString message = dstName + " " + tr("is already exists, overwrite it?") +"\n\n\t";
                message = message +  tr("src File") + " : " + srcNum + " bytes\n\t" +  tr("dst File") + " : " + dstNum + " bytes";
                if (srcSize == dstSize)
                {
                    message = message + "\n\n" + tr("file size is same.");
                }
                if (srcSize < dstSize)
                {
                    message = message + "\n\n" + tr("the destination file is bigger.");
                }
                ans = QMessageBox::question(0, tr("confirmation"), message, QMessageBox::Yes, QMessageBox::No, QMessageBox::YesAll);
                if (ans == QMessageBox::YesAll)
                {
                    force = true;
                    ans = QMessageBox::Yes;
                }
            }
            if ((force == true)||(ans == QMessageBox::Yes))
            {
                // ㏑mFYesI񂾏ꍇA邢́AYesAllI񂾏ꍇɂ́At@CăRs[
                QFile::remove(dstName);
            }
        }
        if (ans == QMessageBox::Yes)
        {
            // t@CRs[
            apDst->copyDatFile(srcNick, srcFile, dstName, srcName, apSrc->isSameLogFormat(), readPoint, lastUpdate);
            QString message = "\n  " + srcName + " --> " + dstName;
            emit updateMessage(message);
        }
        
        // vOXo[̍XV...
        emit updateValue(loop);
    }

    // subject.txtRs[w肪ꍇBBB
    if (aCopySubjectTxt == Qt::Checked)
    {
        QSet<QString>::const_iterator item = nickSet.begin();
        while (item != nickSet.end())
        {
            QString nick     = *item;
            QString srcFile  = apSrc->getSubjectTxtFilePath(nick);
            QString dstFile  = apDst->getSubjectTxtFilePath(nick);
            if (QFile::exists(dstFile) == true)
            {
                // t@C݂ꍇɂ͍폜ĂRs[...
                QFile::remove(dstFile);
            }
            QFile::copy(srcFile, dstFile);
            QString message = "\n  " + srcFile + " -> " + dstFile;
            emit updateMessage(message);

            item++;
        }
    }
    return (ret);
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
