/*!
 *   p[^ǂݏoEL
 *
 */
#include <Qt>
#include <QMessageBox>
#include <QFile>
#include <QTextStream>
#include <QXmlSimpleReader>
#include "a2BCparam.h"

/*!
 *  RXgN^
 * 
 */
a2BCparam::a2BCparam(QWidget *parent)
  : QWidget(parent), mLoaded(false), mItemParam(false), mPath(0), mpDB(0)
{

}

/*!
 *   fXgN^
 * 
 */
a2BCparam::~a2BCparam()
{

}

/*!
 *  t@Cǂݏo
 * 
 */
bool a2BCparam::loadFromFile(QString &execPath, screenData *arDB)
{
    bool ret = false;
    mpDB  = arDB;
    mPath = execPath;

    QFile file(mPath + "/a2BC-conf.xml");
    if (!file.open(QFile::ReadOnly | QFile::Text))
    {
        // t@CI[vs...
        return (false);
    }
    QString     itemName  = "";
    QString     itemType  = "";
    QString     itemValue = "";
    QTextStream in(&file);
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<NNsi:item", Qt::CaseInsensitive) == true)
        {
            mItemParam = true;
            itemName = line.section("\"", 1, 1);
            itemType = line.section("\"", 3, 3);
        }
        if ((mItemParam == true)&&(line.contains("<NNsi:val>", Qt::CaseInsensitive) == true))
        {
            itemValue  = line.section("\"", 1, 1);
            bool result = setParameter(itemName, itemType, itemValue);
            if (result == true)
            {
                ret = true;
            }
            itemName   = "";
            itemType   = "";
            itemValue  = "";
            mItemParam = false;
        }
    }
    file.close();
    return (ret);
}

/*!
 *   t@C֋L^
 * 
 */
bool a2BCparam::saveToFile(void)
{
    if (mpDB == 0)
    {
        return (false);
    }

    QFile file(mPath + "/a2BC-conf.xml");
    if (!file.open(QFile::WriteOnly | QFile::Text))
    {
        // t@CI[vs
        QMessageBox::warning(this, tr("a2BC preference"),
                             tr("Cannot write file %1:\n%2.")
                             .arg("a2BC-conf.xml")
                             .arg(file.errorString()));
        return (false);
    }
    QTextStream out;
    out.setDevice(&file);
    out.setCodec("UTF-8");
    out << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
        << "<!DOCTYPE NNsi:NNsiXML SYSTEM \"http://nnsi.sourceforge.jp/NNsiXML/NNsiXML100.dtd\">\n"
        << "<NNsi:NNsiXML xmlns:NNsi=\"http:nnsi.sourceforge.jp/NNsiXML\">\n"
        << "  <NNsi:NNsiSet ver=\"100\">\n";
 
    //////////  bbstable.html 擾URL  //////////
    out << "    <NNsi:item name=\"bbsTableUrl\" type=\"QString\">\n"
        << "      <NNsi:val> \"" << mpDB->getBbsTableUrl() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    //////////  bbstable.html [Ji[t@C  //////////
    out << "    <NNsi:item name=\"bbsTableFileName\" type=\"QString\">\n"
        << "      <NNsi:val> \"" << mpDB->getBbsTableFileName() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    //////////  擾Ԋu (PʁFms)  //////////
    out << "    <NNsi:item name=\"getReceiveInterval\" type=\"int\">\n"
        << "      <NNsi:val> \"" << mpDB->getReceiveInterval() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    //////////  Xꗗ𓯎ɍXV (true: XV, false: XVȂ)  //////////
    out << "    <NNsi:item name=\"updateSubjectTxt\" type=\"bool\">\n";
    if (mpDB->getUpdateSubjectTxt() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  datXǂ߂悤ɂ (true:ǂ߂悤ɂ, false:Ȃ) //////////
    out << "    <NNsi:item name=\"enableDownThread\" type=\"bool\">\n";
    if (mpDB->getEnableDownThread() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  (gpAqXǗΏۂɂ)  //////////
    out << "    <NNsi:item name=\"addThreadToIndex\" type=\"bool\">\n";
    if (mpDB->getAddThreadToIndex() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  G[X𑼃uEUɈړ  //////////
    out << "    <NNsi:item name=\"backupErrorLog\" type=\"bool\">\n";
    if (mpDB->getBackupErrorLog() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  bbstable.htmla2BJeSǉ (true:ǉ, false:ǉȂ)  //////////
    out << "    <NNsi:item name=\"addToBbsTable\" type=\"bool\">\n";
    if (mpDB->getAddToBbsTable() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  XSčĎ擾 (true:Ď擾, false:Ď擾Ȃ)  //////////
    out << "    <NNsi:item name=\"disableGetPart\" type=\"bool\">\n";
    if (mpDB->getDisableGetPart() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  G[XǗΏۂ͂ (true:O, false:OȂ)  //////////
    out << "    <NNsi:item name=\"removeErrorThreadMessage\" type=\"bool\">\n";
    if (mpDB->getRemoveErrorMessage() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  1000XǗΏۂ͂ (true:O, false:OȂ)  //////////
    out << "    <NNsi:item name=\"removeOverThreadMessage\" type=\"bool\">\n";
    if (mpDB->getRemoveOverMessage() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  Xꗗ𓯎ɃRs[ (true: Rs[, false: Rs[Ȃ)  //////////
    out << "    <NNsi:item name=\"copySubjectTxt\" type=\"bool\">\n";
    if (mpDB->getCopySubjectTxt() == Qt::Checked)
    {
        out << "      <NNsi:val> \"true\" </NNsi:val>\n";
    }
    else
    {
        out << "      <NNsi:val> \"false\" </NNsi:val>\n";
    }
    out << "    </NNsi:item>\n";

    //////////  QuEŮǗfBNg  //////////
    out << "    <NNsi:item name=\"otherBrowserDirectory\" type=\"QString\">\n"
        << "      <NNsi:val> \"" << mpDB->getOtherBrowserDirectory() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    //////////  QuEŨ^Cv  //////////
    out << "    <NNsi:item name=\"otherBrowserType\" type=\"int\">\n"
        << "      <NNsi:val> \"" << mpDB->getOtherBrowserType() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    //////////  QuEUƂ̓  //////////
    out << "    <NNsi:item name=\"synchronizeType\" type=\"int\">\n"
        << "      <NNsi:val> \"" << mpDB->getSynchronizeType() << "\" </NNsi:val>\n"
        << "    </NNsi:item>\n";

    out << "  </NNsi:NNsiSet>\n"
        << "</NNsi:NNsiXML>\n";
    file.flush();
    file.close();
    return (true);
}

/*!
 *   p[^ݒ肷
 * 
 */
bool a2BCparam::setParameter(QString name, QString type, QString value)
{
    bool ret = false;
    
    //////////  bbstable.html 擾URL  //////////
    if (name.contains("bbsTableUrl", Qt::CaseInsensitive) == true)
    {
        mpDB->setBbsTableUrl(value);
    }

    //////////  bbstable.html [Ji[t@C  //////////
    if (name.contains("bbsTableFileName", Qt::CaseInsensitive) == true)
    {
        mpDB->setBbsTableFileName(value);
        if (value.contains("bbstable.html") == true)
        {
            ret = true;
        }
    }

    //////////  擾Ԋu (PʁFms)  //////////
    if (name.contains("getReceiveInterval", Qt::CaseInsensitive) == true)
    {
        mpDB->setReceiveInterval(value.toInt());
    }

    //////////  Xꗗ𓯎ɍXV (true: XV, false: XVȂ)  //////////
    if (name.contains("updateSubjectTxt", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setUpdateSubjectTxt(yesNo);
    }

    //////////  datXǂ߂悤ɂ (true:ǂ߂悤ɂ, false:Ȃ) //////////
    if (name.contains("enableDownThread", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setEnableDownThread(yesNo);
    }

    //////////  (gpAqXǗΏۂɂ)  //////////
    if (name.contains("addThreadToIndex", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setAddThreadToIndex(yesNo);
    }

    //////////  G[X𑼃uEUɈړ (true:ړ, false:ړȂ)  //////////
    if (name.contains("backupErrorLog", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setBackupErrorLog(yesNo);
    }

    //////////  bbstable.htmla2BJeSǉ (true:ǉ, false:ǉȂ)  //////////
    if (name.contains("addToBbsTable", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setAddToBbsTable(yesNo);
    }

    //////////  XSčĎ擾 (true:Ď擾, false:Ď擾Ȃ)  //////////
    if (name.contains("disableGetPart", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setDisableGetPart(yesNo);
    }

    //////////  G[XǗΏۂ͂ (true:O, false:OȂ)  //////////
    if (name.contains("removeErrorThreadMessage", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setRemoveErrorMessage(yesNo);
    }

    //////////  1000XǗΏۂ͂ (true:O, false:OȂ)  //////////
    if (name.contains("removeOverThreadMessage", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setRemoveOverMessage(yesNo);
    }

    //////////  Xꗗ𓯎ɍXV (true: XV, false: XVȂ)  //////////
    if (name.contains("copySubjectTxt", Qt::CaseInsensitive) == true)
    {
        Qt::CheckState yesNo = Qt::Unchecked;
        if (value.contains("true", Qt::CaseInsensitive) == true)
        {
            yesNo = Qt::Checked;
        }
        mpDB->setCopySubjectTxt(yesNo);
    }

    //////////  QuEŮǗfBNg  //////////
    if (name.contains("otherBrowserDirectory", Qt::CaseInsensitive) == true)
    {
        mpDB->setOtherBrowserDirectory(value);
    }

    //////////  QuEŨ^Cv  //////////
    if (name.contains("otherBrowserType", Qt::CaseInsensitive) == true)
    {
        mpDB->setOtherBrowserType(value.toInt());
    }

    //////////  QuEŨ^Cv  //////////
    if (name.contains("synchronizeType", Qt::CaseInsensitive) == true)
    {
        mpDB->setSynchronizeType(value.toInt());
    }

    return (ret);
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
