/*!
 *   ..
 *
 */
#include <QCoreApplication>
#include <QUrl>
#include <QDir>
#include <QFileDialog>
#include <QStringList>
#include <QMessageBox>
#include "a2BCmodel.h"
#include "a2BCbbsTableTrim.h"

/*!
 *   RXgN^
 *
 */
a2BCmodel::a2BCmodel(screenData *apDB, a2BChttpConnection *apHttp, a2BCindexParser *apParser, QWidget *parent)
 : QWidget(parent), mpDB(apDB), mpHttp(apHttp), mpIndexParser(apParser), mStartedGetting(-1),
   mGetUpdated(0), mGetFailure(0), mNotModified(0)
{
    initializeSelf();
}

/*!
 *    fXgN^
 *
 */
a2BCmodel::~a2BCmodel()
{
    // ȂɂȂ
}

/*!
 *  NX̏
 *
 */
void a2BCmodel::initializeSelf(void)
{
    // jbNl[NA
    mNick.clear();
    
    // XgNA
    for (QVector<a2BCgettingFile *>::ConstIterator it = mGettingFileList.begin(); it != mGettingFileList.end(); it++)
    {
        delete (*it);
    }
    mGettingFileList.clear();
    mGettingFileIndex.clear();
    resetTrimBbsTable();
    mFavoriteParser.clear();
    mDatFileChecker.resetData();
    return;
}

/*!
 *    bbstable.htmlt@CI
 *
 */
bool a2BCmodel::selection_bbsTableFile(QString &arFileName)
{
    QString s = QFileDialog::getOpenFileName(this, "bbstable.html", arFileName, "bbstable.html");
    if (s == 0)
    {
        return (false);
    }
    arFileName = s;
    return (true);
}

/*!
 *    bbstable.htmlt@CURL擾
 *
 */
void a2BCmodel::update_bbsTableFile(QString &arFileName, QString &arUrl)
{
    QUrl url(arUrl);
    if (!url.isValid())
    {
        QMessageBox mb("a2BC", tr("Invalid URL : ") + arUrl,
                       QMessageBox::Information,
                       QMessageBox::Ok | QMessageBox::Default,
                       QMessageBox::NoButton,
                       QMessageBox::NoButton);
        mb.exec();
        return;
    }

    // 擾C...
    mpHttp->getFileFromUrl(arFileName, arUrl, false);
    return;
}

/*!
 *    bbstable.htmlt@C̎擾LZ
 *
 */
void a2BCmodel::cancelGetBbsTable()
{
    return;
}



/*!
 *  ݂ fBNg`FbN
 * 
 * 
 */
void a2BCmodel::checkDirectoryList(QDir &arBaseDirectory)
{
    QFileInfoList list = arBaseDirectory.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
        QFileInfo fileInfo = list.at(i);
        if (fileInfo.isDir() == true)
        {
            QString dirName = fileInfo.fileName();
            if (dirName.startsWith(".") != true)
            {
                // XVfBNgAAA
                mNick.append(dirName);
            }
        }
    }
    return;
}


/*!
 *   a2B̃OfBNgF
 * 
 * 
 */
bool a2BCmodel::prepareA2BLogDirectory(bbsTableParser &arBbsTable, QString &arBaseDirectory)
{
    QString message, fileName;

    // f[^
    initializeSelf();

    // ꗗf[^̓ǂݍݏ
    fileName = mpDB->getBbsTableFileName();
    bool readyBbs = arBbsTable.prepare(fileName);
    if (readyBbs == false)
    {
        // ꗗ͎̉s...I
        message = tr("bbs table read failure..."); 
        emit updateMessage(message);
        return (false);
    }
    int count = arBbsTable.numberOfBoards();
    message.setNum(count);
    message = tr("parsed board : ") + message;
    emit updateMessage(message);

    // pfBNgm肷
    arBaseDirectory = fileName;
    arBaseDirectory.replace(QRegExp("bbstable.html$"), "");

    // Oi[fBNg̈ꗗ擾
    QDir baseDir(arBaseDirectory);
    checkDirectoryList(baseDir);
    message = tr("Base directory : ") + arBaseDirectory; 
    emit updateMessage(message);

    /// Cɓf[^ǂݍ...
    int favorCount = mFavoriteParser.parseIndexFile(arBaseDirectory + "favorite.idx");
    message.setNum(favorCount);
    message = tr(" favorite count : ") + message; 
    emit updateMessage(message);
    
    return (true);
}

/*
 *   a2b.idx̃f[^Ǘ
 * 
 * 
 */
int a2BCmodel::parseA2Bindex(bbsTableParser &arBbsTable, QString &arBaseDirectory, QString &arBoardNick, int aOffset)
{
    ////// a2b.idxǂŁA擾t@C̈ꗗ쐬 /////
    QString boardUrl    = arBbsTable.getUrl(arBoardNick);
    if (boardUrl.isEmpty() == true)
    {
        // URL̎擾ɎsƂ...
        return (0);
    }
    QString targetIndex = arBaseDirectory + arBoardNick + "/a2b.idx";
    int count = mpIndexParser->parseIndexFile(targetIndex);

    ///// Cɓf[^ɓo^ĂBBSURLbbstable.html ƐƂ...
    ///// (Ԃ邾[ȁ[[)
    mFavoriteParser.updateUrl(arBoardNick + "/", boardUrl);

    // uOt@CĎ擾ṽ`FbN
    Qt::CheckState getAll = mpDB->getDisableGetPart();

    for (int index = 0; index < count; index++)
    {
        bool append = true;
        a2BCgettingFile *datItem = new a2BCgettingFile();
        QString dataIndexFile    = mpIndexParser->getFileName(index + aOffset);
        QString datFileName      = arBaseDirectory + arBoardNick + "/" + dataIndexFile;
        datItem->setFileName(datFileName);
        int datStatus = mpIndexParser->getFileStatus(index + aOffset);
        if ((getAll == Qt::Checked)||((getAll == Qt::Unchecked)&&((datStatus == A2BCSTATUS_NOTYET)||(datStatus == A2BCSTATUS_RESERVE)||(datStatus == A2BCSTATUS_GETERROR))))
        {
            // Xe[^X擾A܂́A擾\AG[ꍇɂ͑S擾
            datItem->setPartGet(false);
        }
        else
        {
            // 擾{
            datItem->setPartGet(true);
        }

        int dataNofMsg = mpIndexParser->getNofMessage(index + aOffset);
        if (dataNofMsg > 1000)
        {
            // X1000𒴂ĂX͎擾Ȃ
            append = false;
        }

        QString datFileUrl = boardUrl + "dat/" + mpIndexParser->getFileName(index + aOffset);            
        datItem->setUrl(datFileUrl);
        if (append == true)
        {
            mGettingFileList.append(datItem);
            mGettingFileIndex.append((index + aOffset));
        }
    }

    // a2b.idxǂݏoʂ\B
    QString message = "";
    message.setNum(count);
    message = "  " + targetIndex + " (" + message + ")";
//  emit updateMessage(message);

    return (count);
}

/*!
 *   udatXǂ߂悤ɂvɃ`FbNꂽƂ̏
 * 
 */
void a2BCmodel::parseOldThreadFile(QString &arBaseDirectory, QString &arBoardNick)
{
    // "datXǂ߂悤ɂ" ŁAdatT@\ǉ...
    QDir targetDir(arBaseDirectory + arBoardNick);
    QStringList filter;
    filter << "*.dat";
    QStringList nameList = targetDir.entryList(filter);
    QString temp;
    int ct = 0;
    for (QStringList::const_iterator ite = nameList.constBegin(); ite != nameList.constEnd(); ite++)
    {
        // indext@CɂȂ datt@C𔭌!!
        if (mpIndexParser->exists(*ite) < 0)
        {
            // t@C`FbJɊi[
            if (mDatFileChecker.appendDataFile((arBaseDirectory + arBoardNick), (*ite)) == true)
            {
                temp = temp + (*ite) + " ";
                ct++;
            }
        }
    }

    if (ct != 0)
    {
        // a2b.idxɒǉt@CΕ\
        QString message;
        message.setNum(ct);
        temp = arBoardNick + " (" + message + ") : " + temp;
        emit updateMessage(temp);
    }
    return;
}

/*!
 *  subject.txtɍXV邩ǂ̃`FbN
 * 
 */
void a2BCmodel::parseSubjectTxtIndex(bbsTableParser &arBbsTable, QString &arBaseDirectory, QString &arBoardNick)
{
    // subject.txtɍXV邩H
    Qt::CheckState checkState = mpDB->getUpdateSubjectTxt();
    if (checkState == Qt::Unchecked)
    {
        return;
    }
    QString subjectTxt = arBaseDirectory + arBoardNick + "/subject.txt";
    QString subjectUrl = arBbsTable.getUrl(arBoardNick) + "subject.txt";
    a2BCgettingFile *subjData = new a2BCgettingFile();
    subjData->setFileName(subjectTxt);
    subjData->setPartGet(false);
    subjData->setUrl(subjectUrl);
    mGettingFileList.append(subjData);
    mGettingFileIndex.append(-1);

    return;
}


/*!
 *  XVs邩mF
 * 
 */
bool a2BCmodel::confirmStartUpdate(void)
{
    QString message;
    message.setNum(mGettingFileList.size());
    message = tr(" start ") + tr("get threads: ") + message;
    QMessageBox mb(tr("get threads"), message,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
                   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    
    // _CAOA{bNX̊mF
    if (mb.exec() != QMessageBox::Ok)
    {
        return (false);
    }
    return (true);
}

/*!
 *  a2B̃f[^XVC...
 *
 */
void a2BCmodel::update_a2B_datas(void)
{
    bbsTableParser bbsTable;
    QString        a2BDirectory;

    // a2B̃OfBNg֘Ȁ...
    if (prepareA2BLogDirectory(bbsTable, a2BDirectory) == false)
    {
        return;
    }

    // ׂĂɂĎs...
    int offset = 0;
    for (QVector<QString>::ConstIterator it = mNick.begin(); it != mNick.end(); it++)
    {
        QString boardNick = (*it);
        
        // "a2b.idx"ɂẲ͏
        offset = offset + parseA2Bindex(bbsTable, a2BDirectory, boardNick, offset);

        // "subject.txt"XV邩ǂ...
        parseSubjectTxtIndex(bbsTable, a2BDirectory, boardNick);

        // udatXǂ߂悤ɂvɃ`FbN邩ǂ...
        // (udatXǂ߂悤ɂvɃ`FbNĂȂƂɂ͂ȂɂȂ)
        if (mpDB->getEnableDownThread() != Qt::Unchecked)
        {
            parseOldThreadFile(a2BDirectory, boardNick);
        }
    }

    // O擾̊Jnʒm
    emit startedUpdate();

    // 擾Jn邩ǂmF
    if (confirmStartUpdate() == false)
    {
        // ɏI
        mpIndexParser->clearIndexFile();

        // Iʒm
        emit completedUpdate();
        return;
    }

    // 擾ʂ̏
    mGetUpdated  = 0;
    mGetFailure  = 0;
    mNotModified = 0;

    // bbstable.htmlɃX擾邩ǂ
    if (mpDB->getAddToBbsTable() == Qt::Checked)
    {
        // bbstable.htmlɎ擾ς݃Xǉꍇ...
        trimBbsTable(bbsTable);
    }

    // ̃^CAEg҂
    unsigned long interval = mpDB->getReceiveInterval();
    mStartedGetting = 0;
    emit setTimer(0, interval);

    // vOXo[̍őlݒ
    emit setMaximum(mGettingFileList.size() - 2);

    return;
}

/*!
 * 
 * 
 */
void a2BCmodel::resetTrimBbsTable(void)
{
    mBbsTableTrim.reset();
}

/*!
 * 
 * 
 * 
 */
void a2BCmodel::trimBbsTable(bbsTableParser &arBbsTable)
{
    QString bbsTableFile = mpDB->getBbsTableFileName();
    QString message;

    message = tr("---");
    emit updateMessage(message);

    bool ret = mBbsTableTrim.prepare(bbsTableFile);
    if (ret != true)
    {
        message = tr("modify bbstable.html failure");
        emit updateMessage(message);
        return;
    }

    for (QVector<QString>::ConstIterator it = mNick.begin(); it != mNick.end(); it++)
    {
        QString boardNick = (*it);
        QByteArray data = arBbsTable.getData(boardNick);
        if (data.isEmpty() == false)
        {
            // o^f[^i[
            mBbsTableTrim.append(data);
        }
    }
    
    ret = mBbsTableTrim.output();
    if (ret != true)
    {
        message = tr("modify bbstable.html failure");
        emit updateMessage(message);
        return;
    }
    message = tr("updated bbstable.html");
    emit updateMessage(message);
    return;
}

/*!
 *    bbstable.htmlt@C̎擾I
 *
 */
void a2BCmodel::finishGetBbsTable(void)
{
    return;
}

/*!
 *   ^CAEg̎M (subject.txt , X̎擾{)
 * 
 */
void a2BCmodel::receiveTimeout(int id)
{
    QString message = "";
  
    if (id >= mGettingFileList.size())
    {
        // G[Ƃɂ́AǗΏۂ͂H
        bool removeError = false;
        if (mpDB->getRemoveErrorMessage() == Qt::Checked)
        {
            removeError = true;
        }

        // 1000Ƃɂ́AǗΏۂ͂H
        bool removeOver = false;
        if (mpDB->getRemoveOverMessage() == Qt::Checked)
        {
            removeOver = true;
        }

        bool outputSubjectTxt = false;
        if (mpDB->getEnableDownThread() == Qt::Checked)
        {
            outputSubjectTxt = true;
        }
        mpIndexParser->outputIndexFile(removeError, removeOver, outputSubjectTxt, &mDatFileChecker);

        // Cɓf[^ꍇɂ́AXV
        if (mFavoriteParser.count() > 0)
        {
            mFavoriteParser.outputIndexFile(removeError, removeOver);
            message = "\n---\n" + tr("updated favorite file");
            emit updateMessage(message);
        }

        // O擾̏IBB
        message.setNum(mStartedGetting);

        mStartedGetting = -1;
        message = "\n------\n" + tr("complete to get log :") + message + "\n------\n";
        emit updateMessage(message);

        // Iʒm        
        emit completedUpdate();

        // _CAO{bNXŃO擾̏Iʒm
        QString numTemp = "";
        numTemp.setNum(mGetUpdated);
        message = tr("completed to get log") + "\n   ";
        message = message + tr("updated : ") + numTemp  + "\n   ";
        numTemp = "";
        numTemp.setNum(mNotModified);
        message = message + tr("not modified : ") + numTemp  + "\n   ";
        numTemp = "";
        numTemp.setNum(mGetFailure);
        message = message + tr("error : ") + numTemp;
        QMessageBox::information(0, tr("a2BC"), message, QMessageBox::Ok);

        // NX̃f[^NA
        initializeSelf();
        return;
    }

    // Ɏ擾郍Of[^ƂĂ
    a2BCgettingFile *itemData = mGettingFileList[id];

    // ؂
    message = "---";
    emit updateMessage(message);
 
    emit updateValue(id);
    
    // O擾ƂĂ...
    QString fileName = itemData->getFileName();
    QString url      = itemData->getUrl();
    bool   partGet  = itemData->getPartGet();

    // 擾@̊mF
    if (partGet == true)
    {
        // 擾
        message = tr("update file: ");
    }
    else
    {
        // S擾
        message = tr("get file: ");
    }

    // \
    message = message + itemData->getFileName();
    emit updateMessage(message);
    
    // O擾Ăяo
    mpHttp->getFileFromUrl(fileName, url, partGet);
 
    return;
}

/*!
 *   ʐM̏I
 * 
 */
void a2BCmodel::completedCommunication(int error)
{
    // VmF{Ă邩`FbN
    if (mStartedGetting < 0)
    {
        // VmF{...Ȃ̂ŏI
        return;
    }
    
    int status = A2BCSTATUS_UNKNOWN;
    int index = mGettingFileIndex[mStartedGetting];
    if (index >= 0)
    {
        // ʐMʂ𔽉f
        if (error > 0)
        {
            // ʐM
            status = A2BCSTATUS_UPDATE;
            mGetUpdated++;
        }
        else if (error == 0)
        {
            // XVȂAAԂ͕ύXȂ
            status = A2BCSTATUS_UNKNOWN;
            mNotModified++;
        }
        else
        {
            // ʐMsAG[ԂɍXV
            status = A2BCSTATUS_GETERROR;
            mGetFailure++;
        }

        quint64 bbsTime = mpIndexParser->getLastUpdate(index);  // XVO̎擾...
        mpIndexParser->setFileStatus(index, status);
        
        int dataNofMsg = mpIndexParser->getNofMessage(index);
        QString dataIndexFile = mpIndexParser->getFileName(index);
        QString boardNick = mpIndexParser->getNickName(index);

        /// Cɓo^Xǂ`FbNAf[^𓯊
        int favorIndex = mFavoriteParser.exists(boardNick, dataIndexFile);
        if (favorIndex >= 0)
        {
            // CɓȂ̂ŁA}[N
            mFavoriteParser.markIt(favorIndex);

            // t@CԂXV
            mFavoriteParser.setFileStatus(favorIndex, status);

            // Cɓ`FbN
            QString message = tr("---");
            emit updateMessage(message);

            // Cɓɓo^ĂX...
            quint64 favorTime = mFavoriteParser.getLastUpdate(favorIndex);
            int nofMsg       = mFavoriteParser.getNofMessage(favorIndex);
            if (favorTime > bbsTime)
            {
                // Cɓ -> ʏɃf[^f
                int curMsg = mFavoriteParser.getCurrentMessage(favorIndex);
                mpIndexParser->setNofMessage(index, nofMsg);
                mpIndexParser->setCurrentMessage(index, curMsg);
                mpIndexParser->setFileStatus(index, status);
        
                message = tr("modify favorite -> board");
                emit updateMessage(message);
            }
            else
            {
                // ʏ -> CɓɃf[^f
                int curMsg = mpIndexParser->getCurrentMessage(index);
                mFavoriteParser.setNofMessage(favorIndex, dataNofMsg);
                mFavoriteParser.setCurrentMessage(favorIndex, curMsg);

                message = tr("modify board -> favorite");
                emit updateMessage(message);
            }
        }
    }

    // ̃O擾̂߂ɃCxg𔭍s
    QEvent *event = new QEvent(QEvent::User);
    QCoreApplication::postEvent(this, event);
    return;
}

/*!
 *    ̒ʐMJn...
 * 
 */
void a2BCmodel::nextCommunication()
{
    if (mStartedGetting < 0)
    {
        return;
    }

    unsigned long interval = mpDB->getReceiveInterval();
    mStartedGetting++;
    emit setTimer(mStartedGetting, interval);

    return;
}

/*!
 *  Cxg̎M
 * 
 */
void a2BCmodel::customEvent(QEvent *event)
{
    // null Ȃ牽Ȃ
    if (event == 0)
    {
        return;
    }
    
    // [U`CxgA̒ʐMs
    if (event->type() == QEvent::User)
    {
        nextCommunication();
    }
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
