/*!
 *   ..
 *
 */
#include <QCoreApplication>
#include <QUrl>
#include <QDir>
#include <QFileDialog>
#include <QMessageBox>
#include "a2BCmodel.h"
#include "a2BCbbsTableTrim.h"

/*!
 *   RXgN^
 *
 */
a2BCmodel::a2BCmodel(screenData *apDB, a2BChttpConnection *apHttp, a2BCindexParser *apParser, QWidget *parent)
 : QWidget(parent), mpDB(apDB), mpHttp(apHttp), mpBbsTableParser(0), mpIndexParser(apParser), mStartedGetting(-1),
   mGetUpdated(0), mGetFailure(0), mNotModified(0)
{
	initializeSelf();
}

/*!
 *    fXgN^
 *
 */
a2BCmodel::~a2BCmodel()
{
    if (mpBbsTableParser != 0)
    {
        delete mpBbsTableParser;
        mpBbsTableParser = 0;
    }
}

/*!
 *  NX̏
 *
 */
void a2BCmodel::initializeSelf(void)
{
    // jbNl[NA
    mNick.clear();
    
    // XgNA
    for (QVector<a2BCgettingFile *>::ConstIterator it = mGettingFileList.begin(); it != mGettingFileList.end(); it++)
    {
        delete (*it);
    }
    mGettingFileList.clear();
    mGettingFileIndex.clear();
    resetTrimBbsTable();
    mFavoriteParser.clear();
	return;
}

/*!
 *    bbstable.htmlt@CI
 *
 */
bool a2BCmodel::selection_bbsTableFile(QString &arFileName)
{

	QString s = QFileDialog::getOpenFileName(this, "bbstable.html", arFileName, "bbstable.html");
	if (s == 0)
	{
		return (false);
	}
	arFileName = s;
	return (true);
}

/*!
 *    bbstable.htmlt@CURL擾
 *
 */
void a2BCmodel::update_bbsTableFile(QString &arFileName, QString &arUrl)
{
	QUrl url(arUrl);
	if (!url.isValid())
	{
		QMessageBox mb("a2BC", tr("Invalid URL : ") + arUrl,
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
        return;
	}

	// 擾C...
	mpHttp->getFileFromUrl(arFileName, arUrl, false);

	return;
}

/*!
 *    bbstable.htmlt@C̎擾LZ
 *
 */
void a2BCmodel::cancelGetBbsTable()
{
	return;
}

/*!
 *  a2B̃f[^XVC...
 *
 */
void a2BCmodel::update_a2B_datas(void)
{
	QString        message, fileName;
	bbsTableParser bbsTable;

    // f[^
    initializeSelf();

	fileName = mpDB->getBbsTableFileName();
	bool readyBbs = bbsTable.prepare(fileName);
	if (readyBbs == false)
	{
		// ꗗ͎̉s...I
		message = tr("bbs table read failure..."); 
		emit updateMessage(message);

		return;
	}

    // ݃fBNǧ
	int count = bbsTable.numberOfBoards();
	message.setNum(count);
	message = tr("parsed board : ") + message;
	emit updateMessage(message);

    QString searchingDirectory = fileName;
    searchingDirectory.replace(QRegExp("bbstable.html$"), "");

	QDir baseDir(searchingDirectory);
    QFileInfoList list = baseDir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
	{
        QFileInfo fileInfo = list.at(i);
        if (fileInfo.isDir() == true)
        {
            QString dirName = fileInfo.fileName();
            if (dirName.startsWith(".") != true)
            {
                // XVfBNgAAA
                mNick.append(dirName);
            }
        }
    }

    ///// ɂf[^ǂݍ...
    QString favoriteFile = searchingDirectory + "favorite.idx";
    int favorCount = mFavoriteParser.parseIndexFile(favoriteFile);
    message.setNum(favorCount);
    message = tr(" favorite count : ") + message; 
    emit updateMessage(message);



    Qt::CheckState getAll = mpDB->getDisableGetPart();
    int offset = 0;
    for (QVector<QString>::ConstIterator it = mNick.begin(); it != mNick.end(); it++)
    {
        ////// a2b.idxǂŁA擾t@C̈ꗗ쐬 /////
        QString boardNick = (*it);
        QString targetIndex   = searchingDirectory + boardNick + "/a2b.idx";

        int count = mpIndexParser->parseIndexFile(targetIndex);
        QString boardUrl = bbsTable.getUrl(boardNick);

        if (boardUrl.isEmpty() == true)
        {
            // URL̎擾ɎsƂ...
            count = 0;
        }
        else
        {
            ///// Cɓf[^ɓo^ĂBBSURLbbstable.html ƐƂ...
            ///// (Ԃ邾[ȁ[[)
            mFavoriteParser.updateUrl(boardNick + "/", boardUrl);
        }
        for (int index = 0; index < count; index++)
        {
            bool append = true;
            a2BCgettingFile *datItem = new a2BCgettingFile();
            QString dataIndexFile = mpIndexParser->getFileName(index + offset);
            QString datFileName = searchingDirectory + boardNick + "/" + dataIndexFile;
            datItem->setFileName(datFileName);
            int datStatus = mpIndexParser->getFileStatus(index + offset);
            if ((getAll == Qt::Checked)||((getAll == Qt::Unchecked)&&((datStatus == A2BCSTATUS_NOTYET)||(datStatus == A2BCSTATUS_RESERVE)||(datStatus == A2BCSTATUS_GETERROR))))
            {
                // Xe[^X擾A܂́A擾\AG[ꍇɂ͑S擾
                datItem->setPartGet(false);
            }
            else
            {
                // 擾{
                datItem->setPartGet(true);
            }
            int dataNofMsg = mpIndexParser->getNofMessage(index + offset);
            if (dataNofMsg > 1000)
            {
                // X1000𒴂ĂX͎擾Ȃ
                append = false;
            }

            QString datFileUrl = boardUrl + "dat/" + mpIndexParser->getFileName(index + offset);            
            datItem->setUrl(datFileUrl);
            if (append == true)
            {
                mGettingFileList.append(datItem);
                mGettingFileIndex.append((index + offset));
            }
        }
        offset = offset + count;


        // a2b.idxǂݏoʂ\B
        message = "";
        message.setNum(count);
        message = "  " + targetIndex + " (" + message + ")";
//        emit updateMessage(message);

        // subject.txtɍXV邩H
        Qt::CheckState checkState = mpDB->getUpdateSubjectTxt();
        if (checkState != Qt::Unchecked)
        {
            QString subjectTxt = searchingDirectory + boardNick + "/subject.txt";
            QString subjectUrl = bbsTable.getUrl(boardNick) + "subject.txt";

            a2BCgettingFile *subjData = new a2BCgettingFile();
            subjData->setFileName(subjectTxt);
            subjData->setPartGet(false);
            subjData->setUrl(subjectUrl);
            mGettingFileList.append(subjData);
            mGettingFileIndex.append(-1);

            message = "  " + subjectTxt;
//            emit updateMessage(message);
        }        
    }

    // O擾̊Jnʒm
    emit startedUpdate();

    message.setNum(mGettingFileList.size());
    message = tr(" start ") + tr("get threads: ") + message;
    QMessageBox mb(tr("get threads"), message,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
                   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    
    // _CAOA{bNX̊mF
    if (mb.exec() != QMessageBox::Ok)
    {
        // ɏI
        mpIndexParser->clearIndexFile();

        // Iʒm        
        emit completedUpdate();
        return;
    }

    // 擾ʂ̏
    mGetUpdated  = 0;
    mGetFailure  = 0;
    mNotModified = 0;

    // 
    if (mpDB->getAddToBbsTable() == Qt::Checked)
    {
        // bbstable.htmlɎ擾ς݃Xǉꍇ...
        trimBbsTable(bbsTable);
    }

    // ̃^CAEg҂
    unsigned long interval = mpDB->getReceiveInterval();
    mStartedGetting = 0;
    emit setTimer(0, interval);

	return;
}


/*!
 * 
 * 
 */
void a2BCmodel::resetTrimBbsTable(void)
{
    mBbsTableTrim.reset();
}

/*!
 * 
 * 
 * 
 */
void a2BCmodel::trimBbsTable(bbsTableParser &arBbsTable)
{
    QString bbsTableFile = mpDB->getBbsTableFileName();
    QString message;

    message = tr("---");
    emit updateMessage(message);

    bool ret = mBbsTableTrim.prepare(bbsTableFile);
    if (ret != true)
    {
        message = tr("modify bbstable.html failure");
        emit updateMessage(message);
        return;
    }

    for (QVector<QString>::ConstIterator it = mNick.begin(); it != mNick.end(); it++)
    {
        QString boardNick = (*it);
        QByteArray data = arBbsTable.getData(boardNick);
        if (data.isEmpty() == false)
        {
            // o^f[^i[
            mBbsTableTrim.append(data);
        }
    }
    
    ret = mBbsTableTrim.output();
    if (ret != true)
    {
        message = tr("modify bbstable.html failure");
        emit updateMessage(message);
        return;
    }
    message = tr("updated bbstable.html");
    emit updateMessage(message);
    return;
}

/*!
 *    bbstable.htmlt@C̎擾I
 *
 */
void a2BCmodel::finishGetBbsTable(void)
{
	return;
}

/*!
 *   ^CAEg̎M (subject.txt , X̎擾{)
 * 
 */
void a2BCmodel::receiveTimeout(int id)
{
    QString message = "";
  
    if (id >= mGettingFileList.size())
    {
        // G[Ƃɂ́AǗΏۂ͂H
        bool removeError = false;
        if (mpDB->getRemoveErrorMessage() == Qt::Checked)
        {
            removeError = true;
        }

        bool outputSubjectTxt = false;
        if (mpDB->getEnableDownThread() == Qt::Checked)
        {
            outputSubjectTxt = true;
        }
        mpIndexParser->outputIndexFile(removeError, outputSubjectTxt);

        // Cɓf[^ꍇɂ́AXV
        if (mFavoriteParser.count() > 0)
        {
            mFavoriteParser.outputIndexFile(removeError);
            message = "\n---\n" + tr("updated favorite file");
            emit updateMessage(message);
        }

        // O擾̏IBB
        message.setNum(mStartedGetting);

        mStartedGetting = -1;
        message = "\n------\n" + tr("complete to get log :") + message + "\n------\n";
        emit updateMessage(message);

        // Iʒm        
        emit completedUpdate();

        // _CAO{bNXŃO擾̏Iʒm
        QString numTemp = "";
        numTemp.setNum(mGetUpdated);
        message = tr("completed to get log") + "\n   ";
        message = message + tr("updated : ") + numTemp  + "\n   ";
        numTemp = "";
        numTemp.setNum(mNotModified);
        message = message + tr("not modified : ") + numTemp  + "\n   ";
        numTemp = "";
        numTemp.setNum(mGetFailure);
        message = message + tr("error : ") + numTemp;
        QMessageBox::information(0, tr("a2BC"), message, QMessageBox::Ok);

        // NX̃f[^NA
        initializeSelf();
        return;
    }

    // Ɏ擾郍Of[^ƂĂ
    a2BCgettingFile *itemData = mGettingFileList[id];

    // ؂
    message = "---";
    emit updateMessage(message);
    
    // O擾ƂĂ...
    QString fileName = itemData->getFileName();
    QString url      = itemData->getUrl();
    bool   partGet  = itemData->getPartGet();

    // 擾@̊mF
    if (partGet == true)
    {
        // 擾
        message = tr("update file: ");
    }
    else
    {
        // S擾
        message = tr("get file: ");
    }

    // \
    message = message + itemData->getFileName();
    emit updateMessage(message);
    
    // O擾Ăяo
    mpHttp->getFileFromUrl(fileName, url, partGet);
 
    return;
}

/*!
 *   ʐM̏I
 * 
 */
void a2BCmodel::completedCommunication(int error)
{
    // VmF{Ă邩`FbN
    if (mStartedGetting < 0)
    {
        // VmF{...Ȃ̂ŏI
        return;
    }
    
    int status = A2BCSTATUS_UNKNOWN;
    int index = mGettingFileIndex[mStartedGetting];
    if (index >= 0)
    {
        // ʐMʂ𔽉f
        if (error > 0)
        {
            // ʐM
            status = A2BCSTATUS_UPDATE;
            mGetUpdated++;
        }
        else if (error == 0)
        {
            // XVȂAAԂ͕ύXȂ
            status = A2BCSTATUS_UNKNOWN;
            mNotModified++;
        }
        else
        {
            // ʐMsAG[ԂɍXV
            status = A2BCSTATUS_GETERROR;
            mGetFailure++;
        }

        quint64 bbsTime = mpIndexParser->getLastUpdate(index);  // XVO̎擾...
        mpIndexParser->setFileStatus(index, status);
        
        int dataNofMsg = mpIndexParser->getNofMessage(index);
        QString dataIndexFile = mpIndexParser->getFileName(index);
        QString boardNick = mpIndexParser->getNickName(index);

        /// Cɓo^Xǂ`FbNAf[^𓯊
        int favorIndex = mFavoriteParser.exists(boardNick, dataIndexFile);
        if (favorIndex >= 0)
        {
            // CɓȂ̂ŁA}[N
            mFavoriteParser.markIt(favorIndex);

            // t@CԂXV
            mFavoriteParser.setFileStatus(favorIndex, status);

            // Cɓ`FbN
            QString message = tr("---");
            emit updateMessage(message);

            // Cɓɓo^ĂX...
            quint64 favorTime = mFavoriteParser.getLastUpdate(favorIndex);
            int nofMsg       = mFavoriteParser.getNofMessage(favorIndex);
            if (favorTime > bbsTime)
            {
                // Cɓ -> ʏɃf[^f
                int curMsg = mFavoriteParser.getCurrentMessage(favorIndex);
                mpIndexParser->setNofMessage(index, nofMsg);
                mpIndexParser->setCurrentMessage(index, curMsg);
                mpIndexParser->setFileStatus(index, status);
        
                message = tr("modify favorite -> board");
                emit updateMessage(message);
            }
            else
            {
                // ʏ -> CɓɃf[^f
                int curMsg = mpIndexParser->getCurrentMessage(index);
                mFavoriteParser.setNofMessage(favorIndex, dataNofMsg);
                mFavoriteParser.setCurrentMessage(favorIndex, curMsg);

                message = tr("modify board -> favorite");
                emit updateMessage(message);
            }
        }
    }

    // ̃O擾̂߂ɃCxg𔭍s
    QEvent *event = new QEvent(QEvent::User);
    QCoreApplication::postEvent(this, event);
    return;
}

/*!
 *    ̒ʐMJn...
 * 
 */
void a2BCmodel::nextCommunication()
{
    if (mStartedGetting < 0)
    {
        return;
    }

    unsigned long interval = mpDB->getReceiveInterval();
    mStartedGetting++;
    emit setTimer(mStartedGetting, interval);

    return;
}


/*!
 *  Cxg̎M
 * 
 */
void a2BCmodel::customEvent(QEvent *event)
{
    // null Ȃ牽Ȃ
    if (event == 0)
    {
        return;
    }
    
    // [U`CxgA̒ʐMs
    if (event->type() == QEvent::User)
    {
        nextCommunication();
    }
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
