/*============================================================================*
 *  FILE: 
 *     getlog.c
 *
 *  Description: 
 *     QƃÕO擾
 *===========================================================================*/
#define GETLOG_C
#include "local.h"

#ifdef USE_LOGCHARGE

/*--------------------------------------------------------------------------*/
/*   launch_viewJPEG() : JPEGt@C̉{(DAN̗\...)            */
/*                                      fileLoc  : t@Ĉ肩         */
/*                                          FILEMGR_STATE_OPENED_STREAM     */
/*                                          FILEMGR_STATE_OPENED_VFS        */
/*                                      fileName : t@C(full-path)    */
/*--------------------------------------------------------------------------*/
static void launch_viewJPEG(UInt16 fileLoc, Char *fileName)
{
    Char   fileType, *cmdMsg;

    NNsh_DebugMessage(ALTID_INFO, "OPEN JPEG : ", fileName, fileLoc);

    // nnDACXg[Ă邩mF
    if (CheckInstalledResource_NNsh('DAcc','nnDA') == false)
    {
        // nnDACXg[AI
        return;
    }

    if (fileLoc == FILEMGR_STATE_OPENED_VFS)
    {
        // "VFS̓RpNgtbVgp"ݒ̏ꍇAAA
        switch ((NNshGlobal->NNsiParam)->vfsUseCompactFlash)
        {
          case NNSH_VFS_USEMEDIA_CF:             
            fileType = 'c';
            break;

          case NNSH_VFS_USEMEDIA_MS: 
            fileType = 'm';
            break;

          case NNSH_VFS_USEMEDIA_SD:
            fileType = 's';             
            break;

          case NNSH_VFS_USEMEDIA_SM:
            fileType = 't';
            break;
                
          case NNSH_VFS_USEMEDIA_RD:             
            fileType = 'r';
            break;

          case NNSH_VFS_USEMEDIA_DoC:
            fileType = 'd';
            break;

          default:
            // w肵Ȃ
            fileType = 'v';
            break;
        }
    }
    else
    {
        fileType = 'f';
    }

    // Nbv{[hp̗̈mۂ
    cmdMsg = MEMALLOC_PTR(BIGBUF + MARGIN);
    if (cmdMsg == NULL)
    {
        return;
    }
    MemSet(cmdMsg, BIGBUF + MARGIN, 0x00);

    StrCopy(cmdMsg, nnDA_NNSIEXT_VIEWSTART);
    StrCat (cmdMsg, nnDA_NNSIEXT_INFONAME);
    StrCat (cmdMsg, nnDA_NNSIEXT_SHOWJPEG);
    cmdMsg[StrLen(cmdMsg)] = fileType;
    StrCat (cmdMsg, "NNsi:");
    StrCat (cmdMsg, fileName);
    StrCat (cmdMsg, nnDA_NNSIEXT_ENDINFONAME);
    StrCat (cmdMsg, nnDA_NNSIEXT_ENDVIEW);
    ClipboardAddItem(clipboardText, cmdMsg, StrLen(cmdMsg) + 1); 

    MEMFREE_PTR(cmdMsg);

    // nnDAN
    (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
    return;
}


/*--------------------------------------------------------------------------*/
/*  getLogFileList() : Ot@C擾ׂURL̈ꗗ擾        */
/*                              vt@N^OII (Phase 2)    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
static Err getLogFileList(Char *fileName, Char *baseURL, UInt32 tokenId, NNshGetLogTempURLDatabase *tempURL)
{
    NNshFileRef                 fileRef;
    NNshLogTokenDatabase       *logToken;
    Char                       *buffer,  *ptr, *ptr2, *chkPtr;
    Char                       *tempPtr, *tempBuf;
    DmOpenRef                   dbRef;
    UInt32                      offset, readSize;
    UInt16                      count,  status, bufCnt;
    Err                         ret;

    // e|̃m
    tempBuf = MEMALLOC_PTR(MAX_GETLOG_URL + MARGIN);
    if (tempBuf == NULL)
    {
        return (~errNone - 9);
    }
    MemSet(tempBuf, (MAX_GETLOG_URL + MARGIN), 0x00);

    // e|f[^x[X폜
    DeleteDB_wCreator(DBNAME_TEMPURL, DBVERSION_TEMPURL, SOFT_CREATOR_ID, SOFT_DBTYPE_ID);

    // e|DBI[v(VKI[v)
    OpenDatabase_NNsh(DBNAME_TEMPURL, DBVERSION_TEMPURL, &dbRef);
    if (dbRef == 0)
    {
        // DBI[vs(肦Ȃ͂...)
        MEMFREE_PTR(tempBuf);
        return (~errNone - 10);
    }
    count = 0;
    GetDBCount_NNsh(dbRef, &count);
    if (count != 0)
    {
        // cãR[h(S)폜 (łȂ͂)
        for (; count != 0; count--)
        {
            DeleteRecordIDX_NNsh(dbRef, (count - 1));
        }
    }

    // t@Cǂݍݗ̈mۂ
    buffer = MEMALLOC_PTR((NNshGlobal->NNsiParam)->bufferSize + MARGIN);
    if (buffer == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (buffer) ", " size:", 
                          (NNshGlobal->NNsiParam)->bufferSize);
        CloseDatabase_NNsh(dbRef);
        MEMFREE_PTR(tempBuf);
        return (~errNone);
    }
    MemSet(buffer, ((NNshGlobal->NNsiParam)->bufferSize + MARGIN), 0x00);

    // g[Nf[^̗̈mۂ
    logToken = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (logToken == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (logToken) ", "", 0);
        MEMFREE_PTR(buffer);
        CloseDatabase_NNsh(dbRef);
        MEMFREE_PTR(tempBuf);
        return (~errNone);
    }
    MemSet(logToken, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);

    // g[Nf[^̎擾
    if (GetLogToken(tokenId, logToken) != errNone)
    {
        // g[Nf[^̎擾Ɏsꍇ...
        MemSet(logToken, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, " startToken : %s ", logToken->startToken);
    HostTraceOutputTL(appErrorClass, " endToken : %s ",   logToken->endToken);
#endif // #ifdef USE_REPORTER

    // t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_READONLY, &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", fileName, ret);
        MEMFREE_PTR(logToken);
        MEMFREE_PTR(buffer);
        CloseDatabase_NNsh(dbRef);
        MEMFREE_PTR(tempBuf);
        return (ret);
    }

    // t@Cf[^ubNƂɎ擾
    status = NNSH_MSGTOKENSTATE_NONE;
    offset = 0;
    while ((ret == errNone)&&(status != NNSH_MSGTOKENSTATE_END))
    {
        readSize = 0;
        MemSet(buffer, ((NNshGlobal->NNsiParam)->bufferSize + MARGIN), 0x00);

        ret  = ReadFile_NNsh(&fileRef, offset, (NNshGlobal->NNsiParam)->bufferSize, buffer, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            // t@Cǂ݂݃G[AI
            NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh() :", fileName, ret);
            break;
        }

        chkPtr = buffer;
        if ((status == NNSH_MSGTOKENSTATE_NONE)&&(logToken->startToken[0] != '\0'))
        {
            //  擪̋؂蕶T
            ptr = StrStr(buffer, logToken->startToken);
            if (ptr == NULL)
            {
                // f[^擪̋؂肪ȂAobt@ǂݍ
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " CANNOT FIND DATA HEADER... ");
#endif // #ifdef USE_REPORTER
                // ǂݍސ擪肷
                offset = offset + readSize - StrLen(logToken->startToken);
                continue;
            }
            chkPtr = ptr + StrLen(logToken->startToken);
        }
        status = NNSH_MSGTOKENSTATE_MESSAGE;

        // ǂݍ񂾃obt@ɁA̋؂蕶Ă邩ׂ
        if (logToken->endToken[0] != '\0')
        {
            ptr = StrStr(buffer, logToken->endToken);
            if (ptr != NULL)
            {
                // f[^𔭌I f[^͂܂łƂ
                // (f[^̃|C^ʒuvZ܂łȂ߁A
                //  ςȌvZ@iobt@̐擪΁[ƃCNgj
                //  ɂ...)
                readSize = 0;
                while (ptr > buffer)
                {
                    ptr--;
                    readSize++;
                }
                status = NNSH_MSGTOKENSTATE_END;
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " DETECT END SEPARATOR ");
#endif // #ifdef USE_REPORTER
            }
        }

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " FILE readSize : %lu, buffer : %p ", readSize, buffer);
#endif // #ifdef USE_REPORTER

        //  AnchorT... (chkPtrɌJn̐擪Aǂݍ݃TCYreadSize)
        while (chkPtr < (buffer + readSize))
        {
            MemSet (tempURL,  (sizeof(NNshGetLogTempURLDatabase)), 0x00);
            ptr = StrStr(chkPtr, "<link>");
            if (ptr != NULL)
            {
                // <link> o...NtempURLɐ؂o
                ptr = StrStr(ptr, "http://");
                if (ptr != NULL)
                {
                    // URL̖肷...
                    ptr2 = StrStr(ptr, "<");
                    while (ptr < ptr2)
                    {
                        ptr2--;
                        if (*ptr2 > ' ')
                        {
                            break;
                        }
                    }

                    // ؂oURLo͗p̈ɃRs[
                    MemMove(tempURL->dataURL, ptr, ((ptr2 - ptr) + 1));

                    // ؂oURLÓǂ`FbN郍WbN...
                    goto VALIDATE_URL;
                }
            }

            // 啶AJ[ƏAJ[̂ǂ炩܂܂邩`FbN
            ptr = StrStr (chkPtr, "<a");
            ptr2 = StrStr(chkPtr, "<A");
            if ((ptr == NULL)&&(ptr2 == NULL))
            {
                // AJ[ȂAƂ肠AƂ߂Ă݂B
                if (readSize > MARGIN)
                {
                    readSize = readSize - MARGIN;
                }
                // t@C̎̃ubNֈړ
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " not found anchor : readSize :%d", readSize);
#endif // #ifdef USE_REPORTER
                break;
            }
            if ((ptr == NULL)||((ptr2 != NULL)&&(ptr > ptr2)))
            {
                // 啶AJ[̕AJ[Oɂꍇɂ́Aptr
                // 啶AJ[̂̂ɓւ
                ptr = ptr2;
            }
            ptr = ptr + 2;            // "<a"ɂ߂
            ptr2 = StrStr(ptr, ">");  // AJ[̖擾ł邩mF
            if (ptr2 == NULL)
            {
                // AJ[̖mFłȂAt@C̎ubNֈړ
                if (ptr != buffer)
                {
                    readSize = (ptr - buffer);
                }
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " NOT FOUND TAIL OF ANCHOR readSize: %d ", readSize);
#endif // #ifdef USE_REPORTER
                break;
            }

            // URL ptr ` ptr2 ̊Ԃ(m)B
            while ((ptr < ptr2)&&(*ptr != '\0'))
            {
                if (((*ptr == 'h')||(*ptr == 'H'))&&
                    ((*(ptr + 1) == 'r')||(*(ptr + 1) == 'R'))&&
                    ((*(ptr + 2) == 'e')||(*(ptr + 2) == 'E'))&&
                    ((*(ptr + 3) == 'f')||(*(ptr + 3) == 'F')))
                {
                    // URL̐擪肷...
                    ptr = ptr + 4;
                    while ((*ptr != '"')&&(*ptr != '\'')&&
                            (*ptr != '.')&&(*ptr != '/')&&
                            (ptr < ptr2)&&(*ptr != '\0'))
                    {
                        // (alnum)ꍇ́A[v𔲂
                        if (((*ptr >= '0')&&(*ptr <= '9'))||
                            ((*ptr >= 'A')&&(*ptr <= 'Z'))||
                            ((*ptr >= 'a')&&(*ptr <= 'z')))
                        {
                            break;
                        }
                        ptr++;
                    }
                    break;
                }
                ptr++;
            }
            if ((ptr >= ptr2)||(*ptr == '\0'))
            {
                // f[^ُÃAJ[͂
                chkPtr = ptr2 + 1;
                continue;
            }
            if ((*ptr == '"')||(*ptr == '\''))
            {
                // 擪 " ܂ ' ΂ɂ͂P߂
                ptr++;
            }
            // tempURLփAJ[؂o
            bufCnt = 0;
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                    (*ptr != '>')&&(*ptr != 0x00)&&(ptr < ptr2))
            {
                if (bufCnt < MAX_GETLOG_URL)
                {
                    // URLURLi[obt@Ɏ܂Ƃ͕Rs[
                    tempURL->dataURL[bufCnt] = *ptr;
                    bufCnt++;
                }
                ptr++;
            }

#ifdef USE_REPORTER
            if (bufCnt == MAX_GETLOG_URL)
            {
                HostTraceOutputTL(appErrorClass, " ...DATA OVERFLOW... %d(%s)", bufCnt, tempURL->dataURL);
            }
#endif // #ifdef USE_REPORTER

            /////  Ń^Cg؂o  /////
            /////   tempPtr  : ؂oobt@
            /////   tempPtr2 : ؂oobt@
            // ^Cg̐擪ݒ肷
            tempPtr = ptr2 + 1;

            ////////////// ^Cg𔲂o... ///////////
            /// (^Cg̐擪tempTitle, tempPtr2͎̐擪i[̈)
            bufCnt = 0;
            while (((*tempPtr != '<')||(*(tempPtr + 1) != '/'))&&
                    ((UInt8) *tempPtr >= (UInt8) ' ')&&(bufCnt < MAX_THREADNAME))
            {
                if (*tempPtr == '<')
                {
                    // AJ[(^Cgɑgݍ܂)ǂݔ΂...
                    while ((*tempPtr != '\0')&&(*tempPtr != '>'))
                    {
                        tempPtr++;
                    }
                    tempPtr++;
                }
                tempURL->titleName[bufCnt] = *tempPtr;
                tempPtr++;
                bufCnt++;
            }
#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, " xx tempTitle: %s", tempTitle);
#endif // #ifdef USE_REPORTER
            
            // tempURLɐ؂oURLAꂪ(擾̂)ÓURL`FbN
            // (L͈̔͊O肵ȂmF)
            if (ptr >= buffer + readSize)
            {
                // L͈̔͊OAURLo^͂Ȃ
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " RANGE OVER : %s ", tempURL);
#endif // #ifdef USE_REPORTER
                // breakÃobt@̈ǂݍ...
                break;
            }

            // xURLꍇ...
            ptr = StrStr(tempURL->dataURL, "#");
            if (ptr != NULL)
            {
                // #tĂAÓURLł͂Ȃ
                // (̃AJ[͂)
                chkPtr = ptr2 + 1;
                continue;
            }

VALIDATE_URL:
            ptr = tempURL->dataURL;
            if (((*ptr == 'h')||(*ptr == 'H'))&&
                ((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
                ((*(ptr + 3) == 'p')||(*(ptr + 3) == 'P')))
            {
                //////////////////////////////////////////////////////////////
                // httpvgR(URL)tAÓURLAURLXgɓo^
                // (ő僊Nȉ̏ꍇ)
                //////////////////////////////////////////////////////////////
                EntryRecord_NNsh(dbRef, sizeof(NNshGetLogTempURLDatabase), (void *) tempURL);
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " ENTRY URL:%s ", tempURL->dataURL);
#endif // #ifdef USE_REPORTER
                chkPtr = ptr2 + 1;
                continue;  // ̃AJ[Tɂ
            }

            ///////////////////////////////////////////////////////////////////
            // x[XURLʂ̂ƂŎw肳Ăꍇ
            // iΈʒuŃAJ[w肳Ăꍇ...j
            // x[XURL炩߃Rs[
            ///////////////////////////////////////////////////////////////////
            MemSet (tempBuf, (MAX_GETLOG_URL + MARGIN), 0x00);
            MemMove(tempBuf, tempURL->dataURL, MAX_GETLOG_URL);
            StrCopy(tempURL->dataURL, baseURL);
            if (tempBuf[0] == '/')
            {
                // ΃AhXpXw
                // (ŏ '/' ܂ł𒊏o)
                ptr = StrStr(tempURL->dataURL, "//");
                if (ptr != NULL)
                {
                	ptr = ptr + 2;
                    ptr = StrStr(ptr, "/");
                    if (ptr == NULL)
                    {
                        // Ō / t
                        StrCat(tempURL->dataURL, "/");
                        ptr = tempURL->dataURL+ StrLen(tempURL->dataURL) - 1;
                    }
                }
                else
                {
					ptr = tempURL->dataURL + StrLen(tempURL->dataURL) - 1;
                }
            }
            else
            {
                // '/'T
                ptr = tempURL->dataURL + StrLen(tempURL->dataURL) - 1;
                while ((ptr > tempURL->dataURL)&&(*ptr != '/'))
                {
                    ptr--;
                }
            }
            ptr++;

            // 擪̕mFRs[
            MemSet(ptr, (StrLen(tempBuf) + 1), 0x00);
            if ((tempBuf[0] == '.')&&(tempBuf[1] == '/'))
            {
                // ΃AhXpXH
                StrCopy(ptr, &tempBuf[2]);
            }
            else if (tempBuf[0] == '/')
            {
                // ΃AhXpXH
                StrCopy(ptr, &tempBuf[1]);
            }
            else
            {
                // ȊO͂̂܂܃Rs[
                StrCopy(ptr, tempBuf);
            }

            // URL\
            NNsh_DebugMessage(ALTID_INFO, "tempURL > ", tempBuf, 0);

            // URL\
            NNsh_DebugMessage(ALTID_INFO, "URL > ", tempURL->dataURL, 0);

            // DBɓo^
            EntryRecord_NNsh(dbRef, sizeof(NNshGetLogTempURLDatabase), (void *) tempURL);
#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, " entry URL:%s ", tempURL->dataURL);
#endif // #ifdef USE_REPORTER

            chkPtr = ptr2 + 1;
        }             // while (chkPtr < buffer + readSize)
        offset = offset + readSize;   // ǂݍސ擪肷
    }                 // while ((ret == errNone)&&(status != NNSH_MSGTOKENSTATE_END))
    ret = errNone;

    // Ƃ܂
    CloseFile_NNsh(&fileRef);
    CloseDatabase_NNsh(dbRef);
    MEMFREE_PTR(logToken);
    MEMFREE_PTR(buffer);
    MEMFREE_PTR(tempBuf);

    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  ReadOnlyLogDataPickup() : QƃÕO擾                      */
/*                                                                          */
/*                                                                          */
/*                    ̊֐̈ŁAXVf[^ : url, fileName  */
/*--------------------------------------------------------------------------*/
Err ReadOnlyLogDataPickup(Boolean isImage, NNshGetLogDatabase *dbData,
                          Char *url, Char *fileName, UInt16 recNum,
                          UInt32 recId, UInt16 depth, UInt16 number, 
                          Char *dateTime)
{
    Err                       ret;
    Boolean                   workAround, updateRecord;
    UInt16                    index, bufSize, kanjiCode, redirectCnt, titleSize, subIndex;
    UInt32                    readSize, offset, dummy, offsetW, currentTime;
    DmOpenRef                 subjRef;
    Char                      *ptr, *file, *realBuf, *chk, *dateBuf, *titlePrefix;
    NNshSubjectDatabase       *subjDb;
    NNshFileRef                fileRefR, fileRefW;
    NNshGetLogSubFileDatabase *subDbData;

    // X^Cg(Ăяo)Ŏw肳Ă邩H
    if ((depth != 0)&&(dateTime != NULL))
    {
        // X^CǵAQKwȉŎw肳Ă
        // (Kwł̕ϐdateTiméAIf-Modified-Since ̈ŗpĂ)
        // ȕϐ̗pȂ̂Œӂ邱ƁAAB
        titlePrefix = dateTime;
    }
    else
    {
        titlePrefix = NULL;
    }

    // ̈mۂ
    subIndex = NNSH_DATABASE_BLANK;
    bufSize = sizeof(NNshSubjectDatabase) + MARGIN;
    subjDb = MEMALLOC_PTR(bufSize);
    if (subjDb == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        return (~errNone);
    }
    MemSet(subjDb, sizeof(NNshSubjectDatabase) + MARGIN, 0x00);
  
    dateBuf = MEMALLOC_PTR(sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN);
    if (dateBuf == NULL)
    {
        // ꎞ̈̊mۂɎs...
        MEMFREE_PTR(subjDb);
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN));
        return (~errNone);
    } 
    MemSet(dateBuf, (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN), 0x00);
  
    subDbData = MEMALLOC_PTR(sizeof(NNshGetLogSubFileDatabase) + MARGIN);
    if (subDbData == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (subDbData) ", "", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(dateBuf);
        return (~errNone);
    }
    MemSet(subDbData, (sizeof(NNshGetLogSubFileDatabase) + MARGIN), 0x00);
  
    // w肳ꂽURL\
    NNsh_DebugMessage(ALTID_INFO, "url:", url, 0);

    // R[h
    kanjiCode = dbData->kanjiCode;

    // ꎞobt@̈m
    bufSize = (NNshGlobal->NNsiParam)->bufferSize + MARGIN;
    realBuf = MEMALLOC_PTR(bufSize);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(subDbData);
        MEMFREE_PTR(subjDb);
        return (~errNone);
    }
    MemSet(realBuf, bufSize, 0x00);
    bufSize = bufSize - MARGIN;

    // Xf[^x[X̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &subjRef);
    if (subjRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(subDbData);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(realBuf);
        return (~errNone);
    }

    // ot@C̓ƁAXcaɏރf[^
    if (StrLen(fileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇɂ́Ãt@Cgp
        //                                      (t@CXDBɊi[)
        StrNCopy(subjDb->threadFileName, fileName, MAX_THREADFILENAME);
    }
    MemSet(fileName, sizeof(fileName), 0x00);

    // OFFLINEXVFSɊi[ꍇɂ́AfBNgtB
    workAround = false;
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) != 0)
    {
        // Ox[XfBNgt
        if ((NNshGlobal->logPrefixH == 0)||
            ((ptr = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
        {
            StrCopy(fileName, LOGDATAFILE_PREFIX);
        }
        else
        {
            StrCopy(fileName, ptr);
            MemHandleUnlock(NNshGlobal->logPrefixH);
        }
        subjDb->msgState = FILEMGR_STATE_OPENED_VFS; 

        // CLIE4pstOĂ邩`FbN
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND) != 0)
        {
            workAround = true;
        }       
    }
    else
    {
        subjDb->msgState = FILEMGR_STATE_OPENED_STREAM;        
    }
    if (StrStr(dbData->dataTitlePrefix, "%t") == NULL)
    {
        StrCopy(subjDb->threadTitle, dbData->dataTitlePrefix);
    }
    else
    {
        //  Ƃ肠APł͂ȂꍇA"%t"X^Cwb_
        // ܂܂ĂƂ́ȂO܂ł̕wb_ɓ
        chk = dbData->dataTitlePrefix;
        ptr = subjDb->threadTitle;
        while ((*chk != '\0')&&
                ((*chk != '%')||(*(chk + 1) != 't')))
        {
            *ptr = *chk;
            ptr++;
            chk++;
        }
        *ptr = '\0';
    }
    StrCopy(subjDb->boardNick, OFFLINE_THREAD_NICK);
    subjDb->state = NNSH_SUBJSTATUS_UNKNOWN;

    // ݎ擾
    currentTime = TimGetSeconds();

    // Ot@C̍\z
    file = &fileName[StrLen(fileName)];
    if (StrLen(subjDb->threadFileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇ(̃t@C𗘗p)
        StrCat(fileName, subjDb->threadFileName);
    }
    else
    {
        // Ƀt@Cw肳ĂȂꍇ(IɃt@C𐶐)
        StrCat (fileName, FILE_LOGCHARGE_PREFIX);
        NUMCATI(fileName, recNum);
        StrCat (fileName, "-");
        NUMCATI(fileName, depth);
        StrCat (fileName, "-");
        NUMCATI(fileName, number);
        if ((depth != 0)&&(dbData->getAfterHours != 0))
        {
            //  depthw肳ĂꍇłAnԌĎ擾̎w肪Ă
            // ꍇAt@Cɓ16iŕt
            // (2005N11̌oߕbt)
            StrCat (fileName, "-");
            NUMCATH(fileName, (currentTime 
                           - TIME_CONVERT_1904_1970 - TIME_CONVERT_1970_2005));
        }
        StrCat (fileName, FILE_LOGCHARGE_SUFFIX);    
        StrNCopy(subjDb->threadFileName, file, MAX_THREADFILENAME);
    }

    redirectCnt = 0;

    // 擾ς݃O݂邩ǂ̃`FbN
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (IsExistRecordRR_NNsh(subjRef, subjDb->threadFileName, NNSH_KEYTYPE_CHAR, 0, &index) == errNone)
    {
        // f[^ɂAf[^̍XV`FbNɐ؂ւ
        if (dbData->getDateTime[0] != '\0')
        {
            StrCopy(dateBuf, "If-Modified-Since: ");
            StrCat (dateBuf, dbData->getDateTime);
        }
        updateRecord = true;   // 擾ς݃O݂
    }
    else
    {
        // 擾ς݃O݂Ȃ
        updateRecord = false;

        // Kwł͂ȂAXVĂꍇ...
        if ((depth == 0)&&(dbData->lastUpdate != 0))
        {
            // ݎ擾
            currentTime = TimGetSeconds();
            currentTime = currentTime - dbData->lastUpdate;
            dummy       = ((UInt32) dbData->getAfterHours) * 60 * 60;
            if ((dbData->getAfterHours == MAX_GETLOG_REGETHOUR)||
                 (currentTime < dummy))
            {
                // Ď擾ԂɓBĂȂ̂ŁAXV`FbNɐ؂ւ
                if (dbData->getDateTime[0] != '\0')
                {
                    StrCopy(dateBuf, "If-Modified-Since: ");
                    StrCat (dateBuf, dbData->getDateTime);
                }
            }
        }
    }

    // uP擾vŁAuԍXVmFvw肳ĂƂ...
    if ((depth != 0)&&(dbData->getAfterHours != 0))
    {
        // w肳ꂽtqk擾ς݂ǂmF
        subIndex = GetSubFileDatabase(NNSH_GETLOGDB_CHECKURL, 0, url, subDbData);
        if (subIndex != NNSH_DATABASE_BLANK)
        {
            // w肳ꂽURL͎擾ς...
            if (subDbData->lastUpdate != 0)
            {
                currentTime = TimGetSeconds();
                currentTime = currentTime - dbData->lastUpdate;
                dummy       = ((UInt32) dbData->getAfterHours) * 60 * 60;
                if ((dbData->getAfterHours == MAX_GETLOG_REGETHOUR)||
                     (currentTime < dummy))
                {
                    // Ď擾ԂɓBĂȂAAAO擾͍sȂ
                    ret = NNSH_DATABASE_PENDING;
                    goto FUNC_END;
                }
            }
            // (Â)Ot@C...
            if (subDbData->logDbId != 0)
            {
                DeleteThreadMessage_RecordID(subDbData->logDbId);
            }
            subDbData->logDbId = 0;
        }
    }

////////  _CNgwꍇɂ́Aɖ߂ĂƂȂ  ////////
GET_URL_DATA:

    // f[^̎擾
    // zXgXꗗf[^擾
    if (dbData->wwwcMode != 0)
    {
        // ꕔ(wb_̂)擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_GETLOG_START, HTTP_GETLOG_LEN, NULL);
    }
    else
    {
        // ʏ擾[h
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    }

    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[logCharge]", ret);
            goto FUNC_END;
        }

        // ʐM^CAEg
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[logCharge]", ret);
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "logGET URL:%s [DONE]", url);
#endif // #ifdef USE_REPORTER

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        goto FUNC_END;
    }

    // BUSYEBhE\
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    // f[^̓ǂݏo
    readSize = 0;
    MemSet(realBuf, bufSize, 0x00);
    ret  = ReadFile_NNsh(&fileRefR, 0, bufSize, realBuf, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read Failure :", FILE_RECVMSG, ret);
        goto CLOSE_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "++++++++++HTTP MESSAGE++++++++++");
    HostTraceOutputTL(appErrorClass, "%s", realBuf);
    HostTraceOutputTL(appErrorClass, "++++++++++++++++++++++++++++++++");
#endif // #ifdef USE_REPORTER
    
    // if ((StrNCompare(realBuf,"HTTP/1.1 3", 10) == 0)||
    //     (StrNCompare(realBuf,  "HTTP/1.0 3", 10) == 0))
    if ((redirectCnt < MAX_REDIRECT_COUNT)&&(((realBuf[0] == 'H')&&
        (realBuf[1] == 'T')&&(realBuf[2] == 'T')&&
        (realBuf[3] == 'P')&&(realBuf[9] == '3'))))
    {
        // R[h(304, Not Modified)̂Ƃ...
        if ((realBuf[10] == '0')&&(realBuf[11] == '4'))
        {
            // f[^̍XV͍s킸IB
            NNsh_DebugMessage(ALTID_INFO, "HTTP/1.x 304 Not Modified :", url, 0);
            goto CLOSE_END;
        }

        // {ȂA"Location:" TׂA
        ptr = StrStr(realBuf, "http://");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
        
            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_GETLOG_URL - 1)))
            {
                chk++;
            }
            *chk = 0x00;

            // VURLRs[
            MemSet(url, MAX_GETLOG_URL, 0x00);
            StrNCopy(url, ptr, MAX_GETLOG_URL);

            redirectCnt++;

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "REDIRECT(%d) TO URL:%s ", redirectCnt, url);
#endif // #ifdef USE_REPORTER

            // f[^̍ēx蒼
            goto GET_URL_DATA;
        }
        
        // "Location:" TAAA
        ptr = StrStr(realBuf, "Location");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
            
            // f[^ǂݔ΂...
            ptr = ptr + sizeof("Location") - 1;
            while ((*ptr == ':')||(*ptr == ' '))
            {
                ptr++;   
            }

            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_GETLOG_URL - 1)))
            {
                chk++;
            }
            *chk = 0x00;

            // VURLRs[...AURLΎw肳ĂBB
            //   (؂ ( http://host.name/ )c悤ɂ)
            chk = StrStr(url, "://");
            if (chk != NULL)
            {
                chk = chk + sizeof("://") - 1;
                while ((*chk != '/')&&(*chk != '\0'))
                {
                    chk++;
                }
                *chk = 0x00;
                dummy = MAX_GETLOG_URL - StrLen(url);
            }
            else
            {
                chk = url;
                dummy = MAX_GETLOG_URL;
            }
            StrNCopy(chk, ptr, dummy);

            redirectCnt++;

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "REDIRECT(%d) TO URL:%s ", redirectCnt, url);
#endif // #ifdef USE_REPORTER

            // f[^̍ēx蒼
            goto GET_URL_DATA;        
        } 
    }

    // T[o̍XV擾i[
    chk = "Last-modified";
    ptr = StrStr(realBuf, chk);
    if (ptr == NULL)
    {
        chk = "Last-Modified";
        ptr = StrStr(realBuf, chk);
        if (ptr == NULL)
        {
            // T[ȏM擾i[
            chk = "Date";
            ptr = StrStr(realBuf, chk);
        }
    }
    if ((depth == 0)&&((dateTime != NULL)&&(ptr != NULL)))
    {
        ptr = ptr + StrLen(chk);
        while ((*ptr != '\x0d')&&((*ptr == ':')||(*ptr <= ' ')))
        {
            ptr++;
        }
        dummy = 0;
        while ((dummy < MAX_GETLOG_DATETIME)&&
                (*(ptr + dummy) != '\x0d')&&
                (*(ptr + dummy) != '\x0a')&&
                (*(ptr + dummy) != '\0'))
        {
            dummy++;
        }
        MemSet(dateTime, MAX_GETLOG_DATETIME, 0x00);
        StrNCopy(dateTime, ptr, dummy);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "DateTime>>>%s", dateTime);
#endif // #ifdef USE_REPORTER
    }

    if (dbData->wwwcMode != 0)
    {
        // XV`FbNIAŐ܂Ԃ...
        // (subjDBȂ...̂AŁH)
        NNsh_DebugMessage(ALTID_INFO, "SITE UPDATE :", url, 0);
        if (updateRecord == true)
        {
            // ɃOꍇAxbZ[Woɂ
            NNsh_DebugMessage(ALTID_WARN, "LOG DATA EXIST, but... ", "", 0);
        }
        goto CLOSE_END;
    }

    // GR[h̃`FbN(JPEGM\ɂ邩H)
    // ptr = StrStr(realBuf, "image/jpeg");
    ptr = StrStr(realBuf, "image/");
    if (ptr != NULL)
    {
        file = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
        if ((file != NULL)&&(ptr < file))
        {
            // JPEGt@CMI
            file       = file + 4;  // g[Nǂݔ΂...
            offset     = (UInt32) (file - realBuf);
            kanjiCode  = NNSH_KANJICODE_NOT_TEXT;

            // t@CH ("/Palm/Images"fBNgɕۑ)
            ptr = fileName + StrLen(fileName);
            while ((ptr > fileName)&&(*ptr != '/'))
            {
                ptr--;
            }
            dummy = StrLen(ptr) + 1;  // +1 ́A'\0'킹Ĉړ邽

            // C[Wۑp̃fBNg(ꉞARs[ł悤)쐬
            if (subjDb->msgState == FILEMGR_STATE_OPENED_VFS)
            {
                // VFSɃRs[Ƃ̃fBNgw...
                MemMove(&fileName[12], ptr, dummy); // 12"/Palm/Images"̒
                StrCopy(fileName, "/Palm/Image");
                fileName[11] = 's';   // StrCopy̎dlYꂽ̂ŁAAAS
                CreateDir_NNsh("/Palm/Images");
            }
            else
            {
                // file streamɎMƂ́At@CɂĂ܂
                MemMove(fileName, ptr, dummy);

                // t@C̃TCYꍇɂ͐؂B
                fileName[MAX_DBNAMELEN - 1] = '\0';
            }
            redirectCnt = subjDb->msgState;

            // t@Co̓WbN...
            goto OUTPUT_DATAFILE;
        }
    }

    // zipt@CMA܂͋IɃC[WMw...
    ptr = StrStr(realBuf, "application/zip");
    if ((ptr != NULL)||(isImage == true))
    {
        file = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
        if ((file != NULL)&&(ptr < file))
        {
            file        = file + 4;  // g[Nǂݔ΂...
            offset      = (UInt32) (file - realBuf);
            redirectCnt = FILEMGR_STATE_DISABLED;
            kanjiCode   = NNSH_KANJICODE_NOT_TEXT;

            // t@Co̓WbN...
            goto OUTPUT_DATAFILE;
        }
    }

    // R[h̃`FbN
    ptr = StrStr(realBuf, "charset=");
    dummy = StrLen("charset=");
    if (ptr == NULL)
    {
        // charsetȂꍇɂ́Aencodinggp
        ptr   = StrStr(realBuf, "encoding=");
        dummy = StrLen("encoding=");
    }
    if (ptr != NULL)
    {
        // ǂݔ΂
        ptr = ptr + dummy;
        
        // 󔒕ǂݔ΂
        while ((*ptr == ' ')||(*ptr == '\t')||(*ptr == '"'))
        {
            ptr++;
        }

        if (StrNCaselessCompare(ptr, "iso-2022-jp", StrLen("iso-2022-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_JIS;
        }
        else if (StrNCaselessCompare(ptr, "euc-jp", StrLen("euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "x-euc-jp", StrLen("x-euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "shift_jis", StrLen("shift_jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "x-sjis", StrLen("x-sjis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "shift-jis", StrLen("shift-jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "utf-8", StrLen("utf-8")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_UTF8;
        }
    }

    // RSSɃ`FbNĂꍇɂ́A(I)UTF-8Ƃ
    // (Aŏʂ̊Kw...)
    if ((dbData->rssData != 0)&&(depth == 0))
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "kanji :%d, utf-8:%d", 
                                               kanjiCode, NNSH_KANJICODE_UTF8);
#endif // #ifdef USE_REPORTER
        kanjiCode = NNSH_KANJICODE_UTF8;
    }

    // f[^̐擪T
    ptr = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // 擪Ȃ΁Af[^ubN̍ŏ͂
        NNsh_DebugMessage(ALTID_ERROR, "Data Failure :", FILE_RECVMSG, ret);
        ptr = realBuf;
    }

    // Rs[f[^̕␳
    //     ptrf[^{fB̐擪ɎĂB
    //     offsetǂݏot@C̐擪̃ItZbgĂB
    //     (offset́At@C̏o̐擪߂Ƃɗp)
    ptr = ptr + 4;   // 4́AStrLen(NNSH_HTTP_HEADER_ENDTOKEN) ƓB
    offset = (UInt32) (ptr - realBuf);

    // ʂ^Cgw肳Ă邩H
    if (titlePrefix != NULL)
    {
        // ^Cĝw肳Ăꍇɂ́A𗘗p
        file = titlePrefix;
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "##### Title : %s", file);
#endif // #ifdef USE_REPORTER
        goto SET_TITLE_STRING;
    }

    // ^Cg̎擾
    file = StrStr(ptr, "<title");
    if (file == NULL)
    {
        // ^Cg^OłȂꍇ...
        file = StrStr(ptr, "<TITLE");
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "<TITLE(kanji:%d)>", kanjiCode);
#endif // #ifdef USE_REPORTER

    if (file != NULL)
    {
        // ^O̖T...
        file = file + StrLen("<TITLE");
        while (*file != '>')
        {
            file++;
        }
        file++;

        // ^Cgf[^̖T
        chk = StrStr(file, "</TITLE");
        if (chk == NULL)
        {
            chk = StrStr(file, "</title");
        }
        if (chk == NULL)
        {
            chk = file;
            *chk = ' ';
            chk++;
        }
        *chk = '\0';

SET_TITLE_STRING:
        // X^Ci[̈Ƀf[^i[(R[h̕ϊYȂI)
        dummy = StrLen(subjDb->threadTitle);
        titleSize = StrLen(file);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "</TITLE(len:%lu, size:%d)>", dummy, titleSize);
#endif // #ifdef USE_REPORTER

        switch (kanjiCode)
        {
          case NNSH_KANJICODE_EUC:
            // EUC -> SJϊĊi[
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopySJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            break;

          case NNSH_KANJICODE_JIS:
            // JIS -> SJϊĊi[(JIS...)
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopyJIStoSJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
             break;

          case NNSH_KANJICODE_UTF8:
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrNCopyUTF8toSJ(chk, file, (titleSize * 2));
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            else
            {
                // UTF8̕ϊłȂꍇ...
                StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            }
            break;                

          case NNSH_KANJICODE_SHIFTJIS:
          default:
            // ̂܂܊i[
            StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            break;
        }
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "TITLE : %s ", subjDb->threadTitle);
#endif // #ifdef USE_REPORTER

OUTPUT_DATAFILE:
    // ݃t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Write File Open :", fileName, ret);
        goto CLOSE_END;
    }

    // ɓǂݍ߂Ƃ́Af[^̃{fBt@CɃRs[
    ret = errNone;
    offsetW = 0;
    while (ret == errNone)
    {
        readSize = 0;
        MemSet(realBuf, bufSize, 0x00);
        ret  = ReadFile_NNsh(&fileRefR, offset, bufSize, realBuf, &readSize);

        offset  = offset + readSize;
        if ((readSize % 2) != 0)
        {
            // ݃TCYɕ␳(CLIE4p̕ی)
            if (workAround == true)
            {
                realBuf[readSize] = ' ';
                readSize++;
            }
        }
        (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
        offsetW = offsetW + readSize;
    }

    // urlL^(eLXgt@ĈƂ̂)
    if (kanjiCode != NNSH_KANJICODE_NOT_TEXT)
    {
        MemSet (realBuf, bufSize, 0x00);
        StrCopy(realBuf, "<br><hr><a href=\"");
        StrCat (realBuf, url);
        StrCat (realBuf, "\">");
        StrCat (realBuf, url);
        StrCat (realBuf, "</a>");
    }

    readSize = StrLen(realBuf);
    if ((readSize % 2) != 0)
    {
        // ݃TCYɕ␳(CLIE4p̕ی)
        if (workAround == true)
        {
            realBuf[readSize] = ' ';
            readSize++;
        }
    }
    (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
    offsetW = offsetW + readSize;

    CloseFile_NNsh(&fileRefW);

    // C[Wt@CMɂ́At@CN[Y
    // (DB̍XV{Ȃ...)
    if (kanjiCode == NNSH_KANJICODE_NOT_TEXT)
    {
        goto CLOSE_END;
    }

    // Ot@CTCYL^
    subjDb->fileSize = offsetW;
    
    // BBS^CvɊR[hǉ
    subjDb->bbsType = NNSH_BBSTYPE_HTML | (kanjiCode << NNSH_BBSTYPE_CHAR_SHIFT);

    // VXƂčXV
    subjDb->state = NNSH_SUBJSTATUS_NEW;

    // Xf[^o^ς݂̏ꍇAxf[^폜
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (updateRecord == true)
    {
        // f[^ɂAf[^XV
        ret = UpdateRecord_NNsh(subjRef, index, sizeof(NNshSubjectDatabase), subjDb);
    }
    else
    {
        // f[^ȂAf[^o^
        ret = EntryRecord_NNsh(subjRef, sizeof(NNshSubjectDatabase), subjDb);
        index = 0;
    }

    // uP擾vŁAuԍXVmFvw肳ĂƂ...
    if ((depth != 0)&&(dbData->getAfterHours != 0))
    {
        // TuDBo^
        // URLLqĂ邩H (f[^o^ς݂ǂmF)
        if (subIndex == NNSH_DATABASE_BLANK)
        {
            // VKo^Kv...
            StrNCopy(subDbData->dataURL, url, MAX_GETLOG_URL);
            StrNCopy(subDbData->dataFileName, subjDb->threadFileName, MAX_THREADFILENAME);
            subDbData->lastUpdate = TimGetSeconds();
            subDbData->parentDbId = recId;

            // Of[^̃R[hID擾
            if (GetRecordID_NNsh(subjRef, index, &(subDbData->logDbId)) != errNone)
            {
                subDbData->logDbId = 0;
                NNsh_DebugMessage(ALTID_ERROR, "Cannot get record id ", " ", 0);
            }
            EntryLogSubFileDatabase(subDbData);
        }
        else
        {
            // (Â)Ot@C...
            if (subDbData->logDbId != 0)
            {
                DeleteThreadMessage_RecordID(subDbData->logDbId);
            }
            // Of[^̃R[hID擾
            if (GetRecordID_NNsh(subjRef, index, &(subDbData->logDbId)) != errNone)
            {
                subDbData->logDbId = 0;
                NNsh_DebugMessage(ALTID_ERROR, "cannot get record id ", " ", 0);
            }

            // R[hXVKv(XV)
            subDbData->lastUpdate = TimGetSeconds();
            subDbData->parentDbId = recId;
            UpdateSubFileDatabase(subIndex, subDbData);
            
        }
    }

CLOSE_END:
    // t@C̃N[Y
    Hide_BusyForm(false);
    CloseFile_NNsh(&fileRefR);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "CLOSE END>>ReadOnlyLogDataPickup()");
#endif // #ifdef USE_REPORTER

FUNC_END:
    // f[^x[X̃N[Y
    CloseDatabase_NNsh(subjRef);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FUNC END>>ReadOnlyLogDataPickup"
                      "(subjDB:%x, dateBuf:%x, realBuf:%x)",
                      &subjDb, &dateBuf, &realBuf);
#endif // #ifdef USE_REPORTER

    // J...
    MEMFREE_PTR(realBuf);
    MEMFREE_PTR(subDbData);
    MEMFREE_PTR(dateBuf);
    MEMFREE_PTR(subjDb);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "GET URL:%s DONE.", url);
#endif // #ifdef USE_REPORTER

    // C[Wt@CMɂ́ADANs...
    if (kanjiCode == NNSH_KANJICODE_NOT_TEXT)
    {
        if (redirectCnt != FILEMGR_STATE_DISABLED)
        {
            // JPEGt@CMꍇADANsB
            launch_viewJPEG(redirectCnt, fileName);
        }
        else
        {
            // t@CM񍐂s
            NNsh_WarningMessage(ALTID_WARN, fileName, MSG_RECEIVE_IMAGEFILE, 0);
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  GetReadOnlyLogData_NNsh() : QƃÕO擾                          */
/*                                                                          */
/*==========================================================================*/
Err GetReadOnlyLogData_NNsh(void)
{
    Char                      *fileName, *titlePtr, dateTime[MAX_GETLOG_DATETIME];
    Boolean                    penState;
    UInt16                     dbCount, loop, x, y, number, urlCnt;
    UInt32                     recordId;
    DmOpenRef                  dbRef, tempDbRef;
    NNshGetLogDatabase        *dbData;
    NNshGetLogTempURLDatabase *tempDbURL;

    // e|f[^x[XI[v
    OpenDatabase_NNsh(DBNAME_TEMPORARYLOG, DBVERSION_TEMPORARYLOG, &dbRef);
    if (dbRef != 0)
    {
        // 擾ăN[Y
        GetDBCount_NNsh(dbRef, &dbCount);
        CloseDatabase_NNsh(dbRef);
        
        if (dbCount > NNSH_GETLOGDBMAX_SUBDATA)
        {
            // p[W{
            Show_BusyForm(MSG_EXECUTE_PURGE);
            PurgeSubFileDatabase(NNSH_GETLOGDB_CHECKPARENT,
                                 recordId, 
                                 (dbCount - NNSH_GETLOGDBMAX_SUBDATA));
            Hide_BusyForm(false);
        }

        // gpf[^NA
        dbRef   = 0;
        dbCount = 0;
    }

    // e|GÅm
    tempDbURL = MEMALLOC_PTR(sizeof(NNshGetLogTempURLDatabase) + MARGIN); 
    if (tempDbURL == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (tempDbURL) ", "", 0);
        return (~errNone);
    }
    MemSet(tempDbURL, (sizeof(NNshGetLogTempURLDatabase) + MARGIN), 0x00);

    // t@Cmۃobt@̎擾
    fileName = MEMALLOC_PTR(MAXLENGTH_FILENAME + MARGIN);
    if (fileName == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (fileName) ", "", 0);
        MEMFREE_PTR(tempDbURL);
        return (~errNone);
    }
    MemSet(fileName, (MAXLENGTH_FILENAME + MARGIN), 0x00);

    // DBi[̈m
    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (logDatabase) ", "", 0);
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(tempDbURL);
        return (~errNone);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        NNsh_DebugMessage(ALTID_ERROR, "DB open(permanentlog) ", "", 0);
        MEMFREE_PTR(dbData);
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(tempDbURL);
        return (~errNone);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &dbCount);

    // p[}lgQƃOf[^ǂݏo
    for (loop = 0; loop < dbCount; loop++)
    {
        // R[h̓ǂݏo
        GetRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);

        // DB̃xA擾xƓꍇAAA
        // (x[̎͑SĂ擾)
        if (((NNshGlobal->NNsiParam)->getROLogLevel == 0)||
            (dbData->usable == (NNshGlobal->NNsiParam)->getROLogLevel))
        {
            // Of[^̒o
            MemSet(tempDbURL->dataURL, (MAX_GETLOG_URL), 0x00);
            StrNCopy(tempDbURL->dataURL, dbData->dataURL, (MAX_GETLOG_URL));
            MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
            MemSet(dateTime, MAX_GETLOG_DATETIME, 0x00);
            (void) ReadOnlyLogDataPickup(false, dbData, tempDbURL->dataURL, fileName, loop, 0, 0, 0, dateTime);
            if (dbData->getDepth != 0)
            {
                // PKw̃Of[^擾ꍇ...

                if (GetRecordID_NNsh(dbRef, loop, &(recordId)) != errNone)
                {
                    recordId = 0;
                }

                // BUSYEBhE\
                Show_BusyForm(MSG_EXECUTE_PURGE);

                if (dbData->getSubData > NNSH_GETLOGDBMAX_SITEDATA)
                {
                    // p[Ws...
                    PurgeSubFileDatabase(NNSH_GETLOGDB_CHECKPARENT,
                                         recordId, 
                                         (dbData->getSubData - NNSH_GETLOGDBMAX_SITEDATA));
                    dbData->getSubData = NNSH_GETLOGDBMAX_SITEDATA;
                }

                // BUSYEBhE\
                SetMsg_BusyForm(MSG_CHECK_URLLIST);

                // Ot@CURLꗗDBɓWJ
                (void) getLogFileList(fileName, dbData->dataURL, dbData->tokenId, tempDbURL);

                Hide_BusyForm(false);

                // e|DBI[v
                urlCnt    = 0;
                tempDbRef = 0;
                OpenDatabase_NNsh(DBNAME_TEMPURL, DBVERSION_TEMPURL, &tempDbRef);
                if (tempDbRef == 0)
                {
                    // cat@C̃I[vɎsA...
                    continue;
                }

                // R[h擾
                GetDBCount_NNsh(tempDbRef, &urlCnt);

                for (number = urlCnt; number != 0; number--)
                {
                    // x Ɏ擾郌R[hԍݒ肷
                    // (stackߖŕϐ𗬗p...)
                    x = number - 1;

                    MemSet(tempDbURL, sizeof(NNshGetLogTempURLDatabase) + MARGIN, 0x00);
                    GetRecord_NNsh(tempDbRef, (x), sizeof(NNshGetLogTempURLDatabase), tempDbURL);

                    // O擾(̈URL͉̊֐Ŕj󂳂邽)
                    MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
#ifdef USE_REPORTER
                    HostTraceOutputTL(appErrorClass, "SUB get URL(%d):%s ", (x), tempDbURL->dataURL);
#endif // #ifdef USE_REPORTER

                    // fobOURL\
                    NNsh_DebugMessage(ALTID_INFO, "SUB URL : ", tempDbURL->dataURL, (x));

                    // X^Cgwb_ʂ̂𗘗p邩H
                    if (StrStr(dbData->dataTitlePrefix, "%t") != NULL)
                    {
                        // URLmF̂Ƃɒo^Cg
                        titlePtr = tempDbURL->titleName;
                    }
                    else
                    {
                        titlePtr = NULL;
                    }
                    if (ReadOnlyLogDataPickup(false, dbData, tempDbURL->dataURL,
                                              fileName, loop, recordId, 1, (x), 
                                              titlePtr) == errNone)
                    {
                        // Tuf[^̃JEgXV
                        (dbData->getSubData)++;
                    }

                    // y̏ԂE(ʃ^bvĂ邩mF)
                    EvtGetPen(&x, &y, &penState);
                    if (penState == true)
                    {
                        // y_EĂAʑw擾𒆎~邩mF
                        if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                              MSG_CONFIRM_ABORT_SUBLAYER, 
                                              MSG_NOTCHECK_RECORDS, 
                                              urlCnt - number) == 0)
                        {
                            // OKꂽAbreak
                            break;
                        }
                    }
                }

                // f[^x[X
                CloseDatabase_NNsh(tempDbRef);
           }
            // 擾ςĂꍇɂ́AXV
            if (dateTime[0] != '\0')
            {
                if (StrCompare(dbData->getDateTime, dateTime) != 0)
                {
                    MemMove(dbData->getDateTime, dateTime, MAX_GETLOG_DATETIME);
                    dbData->lastUpdate = TimGetSeconds();     // XVi[
                    dbData->state      = NNSH_SUBJSTATUS_NEW; // XV}[N
#ifdef USE_REPORTER
                    HostTraceOutputTL(appErrorClass, "Update DateTime:%s(%lu)", dbData->getDateTime, dbData->lastUpdate);
#endif // #ifdef USE_REPORTER
                    UpdateRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);
                }
#if 0
                else
                {
                    // 擾ςĂȂꍇɂ́AXV}[N
                    dbData->state      = NNSH_SUBJSTATUS_NOT_YET;
                    UpdateRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);
                }
#endif
            }
        }

        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GETLOG, 
                                  MSG_NOTCHECK_RECORDS, dbCount - loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);
 
    // e|f[^x[X폜
    DeleteDB_wCreator(DBNAME_TEMPURL, DBVERSION_TEMPURL, 0, 0);

    // DBR[ḧJ
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    MEMFREE_PTR(tempDbURL);

    return (errNone); 
}


/*-------------------------------------------------------------------------*/
/*   Function :   Handler_LogGetURL                                        */
/*                                      QƃO̎擾ݒCxgnh */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
Boolean Handler_LogGetURL(EventType *event)
{
    UInt16              keyCode;
    NNshGetLogDatabase  dbData;
    DmOpenRef           dbRef;
    FormType           *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        // ҏWCxgs
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        frm = FrmGetActiveForm();

        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrTapWaveSpecificKeyRDown:
          case vchrThumbWheelDown:
          case vchrRockerDown:
          case vchrRockerRight:
          case vchrJogRight:
          case vchrTapWaveSpecificKeyRRight:
          case chrUnitSeparator:  // J[\L[()̏
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrTapWaveSpecificKeyRUp:
          case vchrThumbWheelUp:
          case vchrRockerUp:
          case vchrRockerLeft:
          case vchrJogLeft:
          case vchrTapWaveSpecificKeyRLeft:
          case chrRecordSeparator:   // J[\L[()̏
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case chrRightArrow:     // J[\L[E(5wayE)
          case chrLeftArrow:         // J[\L[(5way)
          case vchrRockerCenter:
          case vchrHardRockerCenter:
          case vchrThumbWheelPush:
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case chrEscape:
          default:
            return (false);
            break;
        }
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshGetLogDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayLogDataInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      case ctlSelectEvent:
        frm = FrmGetActiveForm();
        switch (event->data.ctlSelect.controlID)
        {
          case BTNID_GETLOG_PREV:
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_GETLOG_NEXT:
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }

            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_GETLOG_NEW:
            // VK擾쐬(f[^𖖔Ɉړ)
            // f[^XV
            effectLogGetURL(frm);

            // f[^ʂɔf
            MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
            dbData.usable = 1;
            displayLogDataInfo(frm, &dbData);
            NNshGlobal->jumpSelection = 1;
            NNshGlobal->work2 = 0;
            return (true);
            break;

          case BTNID_GETLOG_DELETE:
            // R[h폜
            if ((NNshGlobal->work1 != 0)&&(NNshGlobal->jumpSelection == 0))
            {
                // f[^{ɍ폜Ă悢mF
                if (NNsh_ConfirmMessage(ALTID_CONFIRM, "",
                                        MSG_CONFIRM_DELETE_DATA, 0) == 0)
                {
                    // QƃO`[WpDB̎擾
                    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
                    if (dbRef == 0)
                    {
                        // ODB̃I[vsAI
                        return (false);
                    }
                    // R[h폜
                    DeleteRecordIDX_NNsh(dbRef, NNshGlobal->work2);
                    (NNshGlobal->work1)--;

                    if (NNshGlobal->work1 == NNshGlobal->work2)
                    {
                        // R[h폜ꍇ...
                        (NNshGlobal->work2)--;
                    }

                    // DBN[Y
                    CloseDatabase_NNsh(dbRef);
                }
            }            
            break;

          default:
            // Ȃ
            return (false);
            break;
        }
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshGetLogDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayLogDataInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      default: 
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectLogGetURL                                          */
/*                                              \f[^̃R[h𔽉f */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean effectLogGetURL(FormType *frm)
{
    DmOpenRef           dbRef;
    UInt16              data;
    Char               *ptr;
    NNshGetLogDatabase  dbData;
    FieldType          *fldP;
    MemHandle           txtH;
    
    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }
    
    MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
    
    // OURL̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_URLSET));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataURL, MAX_GETLOG_URL, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataURL, ptr, MAX_GETLOG_URL);
            MemHandleUnlock(txtH);
        }
        else
        {
            // URLw肳ȂAI
            MemHandleUnlock(txtH);
            CloseDatabase_NNsh(dbRef);
            return (false);
        }
    }

    // 񃌃x̐ݒ
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_GETLOG_USE)));
    dbData.usable = (UInt8) data;

    // RSS[hǂ
    data = 0;
    UpdateParameter(frm, CHKID_GETLOG_RSSDATA, &(data));
    dbData.rssData = (UInt8) data;

    // O擾Ȃǂ(O擾Ȃꍇɂ͂PKw擾Ȃ)
    data = 0;
    UpdateParameter(frm, CHKID_NOTGETLOG, &(data));
    dbData.wwwcMode = (UInt8) data;

    // PKw擾
    UpdateParameter(frm, CHKID_GETLOG_DEPTH, &(data));
    if ((dbData.wwwcMode == 0)&&(data != 0))
    {
        dbData.getDepth = 1;
    }
    else
    {
        dbData.getDepth = 0;
    }

    // Owb_̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_HEADER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataTitlePrefix, MAX_DATAPREFIX, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataTitlePrefix, ptr, MAX_DATAPREFIX);
        }
        MemHandleUnlock(txtH);
    }

    // 擾於̂̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_TITLE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataTitle, MAX_TITLE_LABEL, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataTitle, ptr, MAX_TITLE_LABEL);
        }
        MemHandleUnlock(txtH);
    }

    // nԌĎ擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_REGET_HOUR));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            data = (UInt16) StrAToI(ptr);
            if (data > MAX_GETLOG_REGETHOUR)
            {
                data = MAX_GETLOG_REGETHOUR;
            }
            dbData.getAfterHours = data;
        }
        MemHandleUnlock(txtH);
    }

    // ؂蕶ID̎擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_NORMTOKEN)));
    if (NNshGlobal->work4 != NULL)
    {
        dbData.tokenId = NNshGlobal->work4[data];
    }

    // Tu؂蕶ID擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_SUBTOKEN)));
    if (NNshGlobal->work4 != NULL)
    {
        dbData.subTokenId = NNshGlobal->work4[data];
    }

    // R[h̎擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_KANJICODE)));
    dbData.kanjiCode = (UInt8) data;

    if (NNshGlobal->jumpSelection == 0)
    {
        // R[hXV
        UpdateRecord_NNsh(dbRef, NNshGlobal->work2,
                          sizeof(NNshGetLogDatabase), &dbData);
    }
    else
    {
        // R[ho^
        EntryRecord_NNsh(dbRef, sizeof(NNshGetLogDatabase), &dbData);
        (NNshGlobal->work1)++;
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // QƃOf[^x[XXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_LOGCHARGE));

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   displayLogDataInfo                                       */
/*                                                      QƃO擾̐ݒ */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean displayLogDataInfo(FormType *frm, NNshGetLogDatabase *dbData)
{
    UInt16 data;
    Char   numBuf[TINYBUF];

    // `FbN{bNX̔f(PKw擾)
    data = dbData->getDepth;

    SetControlValue(frm, CHKID_GETLOG_DEPTH, &data);

    // RSSf[^ǂ
    data = dbData->rssData;
    SetControlValue(frm, CHKID_GETLOG_RSSDATA, &data);

    // O擾Ȃǂ
    data = dbData->wwwcMode;
    SetControlValue(frm, CHKID_NOTGETLOG, &data);

    // ^CgvtBbNX
    NNshWinSetFieldText(frm, FLDID_GETLOG_HEADER, false,
                        dbData->dataTitlePrefix, MAX_DATAPREFIX);

    // 擾URL
    NNshWinSetFieldText(frm, FLDID_GETLOG_URLSET, false, 
                        dbData->dataURL, MAX_GETLOG_URL);

    // nԌĎ擾
    MemSet (numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, dbData->getAfterHours);
    NNshWinSetFieldText(frm,FLDID_REGET_HOUR, false, numBuf, TINYBUF);

    // 擾̖
    NNshWinSetFieldText(frm, FLDID_GETLOG_TITLE, true, 
                        dbData->dataTitle, MAX_TITLE_LABEL);

    // 񃌃xݒ
    data = dbData->usable;
    NNshWinSetPopItems(frm, POPTRID_GETLOG_USE, LSTID_GETLOG_USE, data);

    // R[hݒ
    data = dbData->kanjiCode;
    NNshWinSetPopItems(frm, POPTRID_KANJICODE, LSTID_KANJICODE, data);

    // |bvAbvgK̐ݒ

    // (؂p^[1)
    data = ConvertTokenListNum(dbData->tokenId);
    NNshWinSetPopItems(frm, POPTRID_NORMTOKEN, LSTID_NORMTOKEN, data);

    // (؂p^[2)
    data = ConvertTokenListNum(dbData->subTokenId);
    NNshWinSetPopItems(frm, POPTRID_SUBTOKEN,  LSTID_SUBTOKEN, data);

   return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   SetLogGetURL                                             */
/*                                                      QƃO擾̐ݒ */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
Boolean SetLogGetURL(UInt16 recNum)
{
    Boolean              ret = false;
    FormType            *frm, *prevFrm;
    DmOpenRef            dbRef;
    NNshGetLogDatabase  *dbData;
    UInt16               labelCnt;
    UInt32              *idList;
    NNshWordList         separatorChoice;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }

    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        return (false);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // R[h擾
    GetDBCount_NNsh(dbRef, &(NNshGlobal->work1));

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " SetLogGetURL(%d) : recNum:%d", 
                          recNum, NNshGlobal->work1);
#endif // #ifdef USE_REPORTER

    // x擾
    labelCnt = GetLogTokenLabelList(&separatorChoice, &idList);
    NNshGlobal->work4 = idList;

    // f[^̏
    //  work1 F R[h
    //  work2 F \R[h
    //  jumpSelection F VKR[htO(PȂVK)
    //  work4 F ؂f[^XgIDXg|C^
    if ((recNum != NNSH_ITEM_LASTITEM)&&(recNum < NNshGlobal->work1))
    {
        // 郌R[h|CgĊJꍇ
        NNshGlobal->work2 = recNum;
        NNshGlobal->jumpSelection = 0;
    }
    else
    {
        // VKR[hǉ̏ꍇ...
        NNshGlobal->work2 = 0;
        NNshGlobal->jumpSelection = 1;        
    }

    // _CAO\
    prevFrm = FrmGetActiveForm();
    PrepareDialog_NNsh(FRMID_GETLOG_INPUT, &frm, true);
    if (frm == NULL)
    {
        // f[^x[X
        CloseDatabase_NNsh(dbRef);
        ReleaseWordList(&separatorChoice);
        MEMFREE_PTR(idList);
        MEMFREE_PTR(dbData);
        return (false);
    }

    // |bvAbvgK̐ݒ
    if (labelCnt != 0)
    {
        NNshWinSetPopItemsWithList(frm, POPTRID_NORMTOKEN, LSTID_NORMTOKEN, &separatorChoice, 0);
        NNshWinSetPopItemsWithList(frm, POPTRID_SUBTOKEN,  LSTID_SUBTOKEN,  &separatorChoice, 0);
    }

    // R[hPȂꍇA͐VKR[hǉ̏ꍇ
    if ((NNshGlobal->work1 == 0)||(NNshGlobal->jumpSelection == 1))
    {
        // ̃R[hf[^ʂɕ\
        dbData->usable = (NNshGlobal->NNsiParam)->getROLogLevel;
    }
    else
    {
        // Ō̃R[hf[^ʂɕ\ꍇ...
        if (NNshGlobal->work2 == NNSH_ITEM_BOTTOMITEM)
        {
            NNshGlobal->work2 = NNshGlobal->work1 - 1;
        }
        GetRecord_NNsh(dbRef, NNshGlobal->work2,
                       sizeof(NNshGetLogDatabase), dbData);
        NNshGlobal->jumpSelection = 0;
    }

    displayLogDataInfo(frm, dbData);

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // Cxgnh̐ݒ
    FrmSetEventHandler(frm, Handler_LogGetURL);

    // QƃO擾̐ݒ_CAO\
    if (FrmDoDialog(frm) == BTNID_GETLOG_OK)
    {
        // \f[^̃R[h𔽉f
        ret = effectLogGetURL(frm);
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, frm, true);

    // ẍJ
    ReleaseWordList(&separatorChoice);
    MEMFREE_PTR(idList);
    MEMFREE_PTR(dbData);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :  effectLogToken                                            */
/*                                    Ő؂ݒf[^x[Xɔf */
/*-------------------------------------------------------------------------*/
static Boolean effectLogToken(FormType *frm)
{
    NNshLogTokenDatabase *dbData;
    DmOpenRef             dbRef;
    Char                 *ptr;
    FieldType            *fldP;
    MemHandle             txtH;
    UInt16                cnt;
    
    dbData = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (dbData == NULL)
    {
        // ̈mێsAI
        return (false);
    }

    // f[^̏
    MemSet(dbData, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        MEMFREE_PTR(dbData);
        return (false);
    }

    // f[^VKo^mF
    if ((NNshGlobal->work3 == 0)&&(cnt != 0))
    {
        // R[hhc擾AR[hIDɊi[
        GetRecordID_NNsh(dbRef, (NNshGlobal->work2), &(dbData->id));
    }

    // Owb_̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_HEADER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->tokenPatternName, ptr, MAX_DATAPREFIX);
        }
        MemHandleUnlock(txtH);
    }

    // Jn̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_START));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->startToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }

    // I̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_END));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->endToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }
    
    // g[N̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_INDEX));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->dataToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &(cnt));

    // f[^VKo^mF
    if ((NNshGlobal->work3 != 0)||(cnt == 0))
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " CREATE NEW RECORD : %d ", cnt);
#endif // #ifdef USE_REPORTER

        // R[ho^
        EntryRecord_NNsh(dbRef, sizeof(NNshLogTokenDatabase), dbData);

        // R[hhc擾AR[hIDɊi[
        GetRecordID_NNsh(dbRef, 0, &(dbData->id));

        NNshGlobal->work2 = 0;
        (NNshGlobal->work1)++;
    }

    // R[hXV
    UpdateRecord_NNsh(dbRef, NNshGlobal->work2,
                      sizeof(NNshLogTokenDatabase), dbData);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    // QƃOg[Nf[^x[XXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_LOGTOKEN));

    MEMFREE_PTR(dbData);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :  displayLogToken                                           */
/*                                                  Ő؂ݒ𔽉f */
/*-------------------------------------------------------------------------*/
static Boolean displayLogToken(FormType *frm, UInt16 recNum)
{
    NNshLogTokenDatabase *dbData;
    DmOpenRef            dbRef;


    dbData = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (dbData == NULL)
    {
        // ̈mێsAI
        return (false);
    }

    // f[^̏
    MemSet(dbData, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
    
    // recNum  0xffff ̎́A󕶎\(DBf[^͎擾Ȃ)
    if (recNum != NNSH_DATABASE_BLANK)
    {
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            MEMFREE_PTR(dbData);
            return (false);
        }

        // f[^ǂݏo
        GetRecord_NNsh(dbRef, recNum, sizeof(NNshLogTokenDatabase), dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
    }

    // 擾f[^ʂɔf

    // ؂p^[
    NNshWinSetFieldText(frm, FLDID_GETLOG_HEADER, false,
                        dbData->tokenPatternName, MAX_DATAPREFIX);

    // Jn
    NNshWinSetFieldText(frm, FLDID_GETLOG_START, false, 
                        dbData->startToken, MAX_DATATOKEN);

    // I
    NNshWinSetFieldText(frm, FLDID_GETLOG_END, false, 
                        dbData->endToken, MAX_DATATOKEN);

    // ؂蕶
    NNshWinSetFieldText(frm, FLDID_GETLOG_INDEX, true, 
                        dbData->dataToken, MAX_DATATOKEN);

    MEMFREE_PTR(dbData);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Handler_setLogToken                                      */
/*                              QƃŐ؂ݒʗpCxgnh */
/*-------------------------------------------------------------------------*/
Boolean Handler_setLogToken(EventType *event)
{
    UInt16              keyCode;
    DmOpenRef           dbRef;
    FormType           *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        // ҏWCxgs
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        frm = FrmGetActiveForm();

        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrTapWaveSpecificKeyRUp:
          case vchrThumbWheelUp:
          case vchrRockerUp:
          case vchrRockerLeft:
          case vchrJogLeft:
          case vchrTapWaveSpecificKeyRLeft:
          case chrRecordSeparator:   // J[\L[()̏
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->work3 = 0;
            break;

          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrTapWaveSpecificKeyRDown:
          case vchrThumbWheelDown:
          case vchrRockerDown:
          case vchrRockerRight:
          case vchrJogRight:
          case vchrTapWaveSpecificKeyRRight:
          case chrUnitSeparator:  // J[\L[()̏
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->work3 = 0;
            break;

          case chrLeftArrow:         // J[\L[(5way)
          case chrRightArrow:     // J[\L[E(5wayE)
          case vchrRockerCenter:
          case vchrHardRockerCenter:
          case vchrThumbWheelPush:
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case chrEscape:
          default:
            return (false);
            break;
        }

        // ǂݏof[^ʂɔf
        displayLogToken(frm, NNshGlobal->work2);
        return (true);
        break;

      case ctlSelectEvent:
        frm = FrmGetActiveForm();
        switch (event->data.ctlSelect.controlID)
        {
          case BTNID_GETLOG_NEXT:
            // OR[hɈړ(ǎ{^Ƃ...)
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->work3 = 0;
            break;

          case BTNID_GETLOG_PREV:
            // R[hɈړ(ǑO{^Ƃ...)
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }

            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->work3 = 0;
            break;

          case BTNID_GETLOG_NEW:
            // VK擾쐬(f[^𖖔Ɉړ)
            // f[^XV
            effectLogToken(frm);

            // f[^ʂɔf
            NNshGlobal->work3 = 1;
            NNshGlobal->work2 = 0;
            displayLogToken(frm, NNSH_DATABASE_BLANK);
            return (true);
            break;

          case BTNID_GETLOG_DELETE:
            // R[h폜
            if ((NNshGlobal->work1 != 0)&&(NNshGlobal->work3 == 0))
            {
                // f[^{ɍ폜Ă悢mF
                if (NNsh_ConfirmMessage(ALTID_CONFIRM, "",
                                        MSG_CONFIRM_DELETE_DATA, 0) == 0)
                {
                    // QƃO`[WpDB̎擾
                    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
                    if (dbRef == 0)
                    {
                        // ODB̃I[vsAI
                        return (false);
                    }
                    // R[h폜
                    DeleteRecordIDX_NNsh(dbRef, NNshGlobal->work2);
                    (NNshGlobal->work1)--;

                    if (NNshGlobal->work1 == NNshGlobal->work2)
                    {
                        // R[h폜ꍇ...
                        (NNshGlobal->work2)--;
                    }

                    // DBN[Y
                    CloseDatabase_NNsh(dbRef);
                }
            }            
            break;

          default:
            // Ȃ
            return (false);
            break;
        }

        // ǂݏof[^ʂɔf
        displayLogToken(frm, NNshGlobal->work2);

        return (true);
        break;

      default: 
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   SetLogCharge_LogToken                                    */
/*                                                    ؂p^[̓o^ */
/*=========================================================================*/
Boolean SetLogCharge_LogToken(UInt16 recNum)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    UInt16        btnId;
    DmOpenRef     dbRef;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // QƃO؂DB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "LOGTOKEN DB Open Failure.");
#endif // #ifdef USE_REPORTER
        return (false);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &(NNshGlobal->work1));

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "TOKEN DB count : %d", NNshGlobal->work1);
#endif // #ifdef USE_REPORTER

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // \nf[^̔fi[N̈̎gp@j
    //   work1F݂̃R[h
    //   work2F\̃R[hԍ
    //   work3FVKR[hǉiPȂǉj
    NNshGlobal->work2 = recNum;
    NNshGlobal->work3 = (NNshGlobal->work1 == 0) ? 1 : 0;

    // _CAO\
    PrepareDialog_NNsh(FRMID_GETLOG_TOKENSET, &diagFrm, true);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // f[^̔f
    displayLogToken(diagFrm, NNshGlobal->work2);

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_setLogToken);

    // EBhE̕\
    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_GETLOG_OK)
    {
         // \f[^R[hɔf
         effectLogToken(diagFrm);
         ret = true;
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, true);

    // f[^x[X̃\[gsĂ
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    QsortRecord_NNsh(dbRef, NNSH_KEYTYPE_UINT32, 0);
    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :   GetLogToken                                              */
/*                                                    ؂p^[̎擾 */
/*=========================================================================*/
Err GetLogToken(UInt32 key, NNshLogTokenDatabase *record)
{
   Err       ret;
   DmOpenRef dbRef;
   UInt16    index;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }

    // idkeyɂČ
    ret = SearchRecord_NNsh(dbRef, &key, NNSH_KEYTYPE_UINT32, 0,
                            sizeof(NNshLogTokenDatabase), record, &index);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :  ConvertTokenListNum                                       */
/*                                      ؂p^[IDXgԍɕϊ */
/*=========================================================================*/
UInt16 ConvertTokenListNum(UInt32 key)
{
   Err       ret;
   DmOpenRef dbRef;
   UInt16    index;
   NNshLogTokenDatabase record;

    // keyw̏ꍇɂ́A0
    if (key == 0)
    {
        return (0);
    }

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (0);
    }

    // idkeyɂČ
    index = 0;
    ret = SearchRecord_NNsh(dbRef, &key, NNSH_KEYTYPE_UINT32, 0,
                            sizeof(NNshLogTokenDatabase), &record, &index);
    if (ret != errNone)
    {
        index = 0;
    }

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (index);
}

/*=========================================================================*/
/*   Function :   GetLogTokenLabelList                                     */
/*                                                ؂p^[̈ꗗ擾 */
/*=========================================================================*/
UInt16 GetLogTokenLabelList(NNshWordList *wordList, UInt32 **idList)
{
    Err                   ret;
    Char                 *nameP, *strBuf;
    UInt32               *idP;
    DmOpenRef             dbRef;
    UInt16                index, count, recCount;
    MemHandle             dataH;
    NNshLogTokenDatabase *data;

    // ϐ̏
    MemSet(wordList, sizeof(NNshWordList), 0x00);
    *idList = NULL;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (0);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &count);
    if (count == 0)
    {
        return (0);
    }

    // IDi[̈m
    *idList = MEMALLOC_PTR(sizeof(UInt32) * count + MARGIN);
    if (*idList == NULL)
    {
        return (0);
    }
    MemSet(*idList, (sizeof(UInt32) * count + MARGIN), 0x00);
    idP = *idList;

    // xi[̈m
    strBuf = MEMALLOC_PTR((sizeof(Char) * (MAX_STRLEN)) * count + MARGIN);
    if (strBuf == NULL)
    {
        MEMFREE_PTR(*idList);
        return (0);
    }
    MemSet(strBuf, ((sizeof(Char) * (MAX_STRLEN)) * count + MARGIN), 0x00);
    nameP = strBuf;

    recCount = 0;
    for (index = 0; index < count; index++)
    {
        // R[hf[^̎擾
        ret = GetRecordReadOnly_NNsh(dbRef, index, &dataH, (void **) &data);
        if (ret == errNone)
        {
            if (recCount != 0)
            {
                StrCat(nameP, ",");
            }

            // ǂݏof[^mۂ̈ɔf
            *idP = data->id;
            idP++;
            if (data->tokenPatternName[0] != '\0')
            {
                // 擾
                StrCat(nameP, data->tokenPatternName);
            }
            else
            {
                StrCat(nameP, "???");
            }

            // R[hf[^̕\
            nameP = nameP + StrLen(nameP);

            recCount++;
        }
        // R[hAւ
        ReleaseRecordReadOnly_NNsh(dbRef, dataH);
    }

    // xꗗXgɕ\\֕ϊ...
    SeparateWordList(strBuf, wordList);
    MEMFREE_PTR(strBuf);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (recCount);
}

/*=========================================================================*/
/*   Function :   SelectLogToken                                           */
/*                                                    ؂p^[̑I */
/*=========================================================================*/
UInt16 SelectLogToken(UInt32 *selection)
{
    Char         *ptr;
    FormType     *prevFrm, *diagFrm;
    UInt32       *idList;
    UInt16        btnId, nofItems;
    MemHandle     listH;
    ListType     *lstP;
    NNshWordList  wordList;
    
    // 
    listH     = 0;
    *selection = 0;
    btnId     = BTNID_JUMPCANCEL;
    prevFrm   = FrmGetActiveForm();
    MemSet(&wordList, sizeof(NNshWordList), 0x00);

    // Og[NƂ肾
    nofItems = GetLogTokenLabelList(&wordList, &idList);

    // ACe̊mF([A߂)
    if (nofItems == 0)
    {
        // ؂p^[Ȃ
        return (BTNID_JUMPCANCEL);
    }

    // _CAO\
    PrepareDialog_NNsh(FRMID_DIRSELECTION, &diagFrm, false);
    if (diagFrm == NULL)
    {
        return (BTNID_JUMPCANCEL);
    }

    // Xg̐ݒ
    lstP  = FrmGetObjectPtr(diagFrm,
                                FrmGetObjectIndex(diagFrm, LSTID_JUMPLIST));

    ptr = MemHandleLock(wordList.wordmemH);
    LstSetListChoices(lstP, (Char **) ptr, wordList.nofWord);
    LstSetSelection  (lstP, 0);
    LstSetTopItem    (lstP, 0);

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_JumpSelection);

    // WvNA
    NNshGlobal->jumpSelection = 0;

    // _CAÕI[vA̓͂҂
    btnId = FrmDoDialog(diagFrm);

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, false);

    // nhAbN
    MemHandleUnlock(wordList.wordmemH);

    if (btnId == BTNID_JUMPEXEC)
    {
        // Iꂽ
        *selection = idList[NNshGlobal->jumpSelection];        
    }

    // Ƃ܂
    MEMFREE_PTR(idList);
    ReleaseWordList(&wordList);

    return (btnId);
}


/*=========================================================================*/
/*   Function :   GetImageFile                                             */
/*                                             C[Wt@C擾  */
/*=========================================================================*/
Boolean GetImageFile(Char *url)
{
    Err                  ret;
    Char                *fileName, *ptr;
    NNshGetLogDatabase  *dbData;

    // t@C擾̊mF...
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, url, MSG_COMFIRM_GETFILE, 0) != 0)
    {
        // f[^̎擾mFLZꂽꍇ
        return (false);
    }

    // t@Ci[̈m
    fileName = MEMALLOC_PTR(MAXLENGTH_FILENAME + MARGIN);
    if (fileName == NULL)
    {
        return (false);
    }
    MemSet(fileName, MAXLENGTH_FILENAME + MARGIN, 0x00);

    // DB̃_~[̈m
    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        MEMFREE_PTR(fileName);
        return (false);
    }
    MemSet(dbData, sizeof(NNshGetLogDatabase) + MARGIN, 0x00);

    // f[^ۑXt@C̓
    ptr = url + StrLen(url) - 1;
    while ((*ptr != '/')&&(*ptr != '?')&&(*ptr != '*'))
    {
        ptr--;
    }

    // f[^̍ŌɃXbVꍇɂ̓t@CRs[Ȃ
    if (ptr < url + StrLen(url) - 1)
    {
        StrNCopy(fileName, (ptr + 1), (MAXLENGTH_FILENAME - 1));
    }

    // tqkf[^̎擾...
    ret = ReadOnlyLogDataPickup(true, dbData, url, fileName, NNSH_MSGNUM_UNKNOWN, 0, 0, 0, NULL);

    // mۗ̈J
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    if (ret != errNone)
    {
        return (false);
    }
    return (true);
}

/*=========================================================================*/
/*   Function :   EntryLogSubFileDatabase                                  */
/*                           uP擾v̎擾Ƀf[^o^  */
/*=========================================================================*/
Err EntryLogSubFileDatabase(NNshGetLogSubFileDatabase *subDb)
{
    Err       ret;
    DmOpenRef dbRef;

    OpenDatabase_NNsh(DBNAME_TEMPORARYLOG, DBVERSION_TEMPORARYLOG, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", DBNAME_TEMPORARYLOG, 0);
        return (~errNone);
    }

    // Xf[^XV
    ret = EntryRecord_NNsh(dbRef, sizeof(NNshGetLogSubFileDatabase), subDb);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "EntryRecord_NNsh() ", DBNAME_TEMPORARYLOG, ret);
    }
    else
    {
        // TuOf[^x[XXVƂɂ
        NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_LOGSUBDB));
    }
    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :   GetSubFileDatabase                                       */
/*                   uP擾v̎擾񂪓o^ς݂ǂmF  */
/*                             (΁AsubDbɃf[^Rs[ĉ) */
/*                          sɂ́ANNSH_DATABASE_BLANK    */
/*=========================================================================*/
UInt16 GetSubFileDatabase(UInt16 command, UInt32 recId, 
                             Char *dataURL, NNshGetLogSubFileDatabase *subDb)
{
    Err                        ret;
    UInt16                     dbCount, loop, len, matched;
    MemHandle                  dataH;
    DmOpenRef                  dbRef;
    NNshGetLogSubFileDatabase *subDbRec;

    len = StrLen(dataURL);
    OpenDatabase_NNsh(DBNAME_TEMPORARYLOG, DBVERSION_TEMPORARYLOG, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", DBNAME_TEMPORARYLOG, 0);
        return (NNSH_DATABASE_BLANK);
    }
    // R[h擾
    GetDBCount_NNsh(dbRef, &dbCount);
    for (loop = dbCount; loop != 0; loop--)
    {
        ret = GetRecordReadOnly_NNsh(dbRef, (loop - 1), &dataH, (void **)&subDbRec);
        if (ret == errNone)
        {
            matched = NNSH_DATABASE_BLANK;
            switch (command)
            {
              case NNSH_GETLOGDB_CHECKPARENT:
                // eR[hw肳ꂽ...
                if (recId == subDbRec->parentDbId)
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_CHECKTOKEN:
                // ؂̃R[hw肳ꂽ...
                if (recId == subDbRec->tokenId)
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_CHECKURL:
                // URLw肳ꂽ...
                matched = StrNCompare(subDbRec->dataURL, dataURL, len);
                break;
              
              default:
                // LȊO...
                break;
            }
            if (matched == 0)
            {
                // R[hBB
                if (subDb != NULL)
                {
                    // R[h̃f[^Rs[
                    MemMove(subDb, subDbRec, sizeof(NNshGetLogSubFileDatabase));
                }
                // R[h̃bNJ
                ReleaseRecordReadOnly_NNsh(dbRef, dataH);

                // DBN[Y
                CloseDatabase_NNsh(dbRef);
                return (loop - 1);
            }
            // R[h̃bNJ
            ReleaseRecordReadOnly_NNsh(dbRef, dataH);
        }
    }
    // DBN[Yĉ
    CloseDatabase_NNsh(dbRef);
    return (NNSH_DATABASE_BLANK);
}

/*=========================================================================*/
/*   Function :   UpdateSubFileDatabase                                    */
/*                                   uP擾v̎擾XV  */
/*=========================================================================*/
Err UpdateSubFileDatabase(UInt16 index, NNshGetLogSubFileDatabase *subDb)
{
    Err       ret;
    DmOpenRef dbRef;

    OpenDatabase_NNsh(DBNAME_TEMPORARYLOG, DBVERSION_TEMPORARYLOG, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", DBNAME_TEMPORARYLOG, 0);
        return (~errNone);
    }

    // Xf[^XV
    ret = UpdateRecord_NNsh(dbRef,index,sizeof(NNshGetLogSubFileDatabase), subDb);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", DBNAME_TEMPORARYLOG, ret);
    }
    CloseDatabase_NNsh(dbRef);

    // TuOf[^x[XXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_LOGSUBDB));

    return (ret);
}

/*=========================================================================*/
/*   Function :   PurgeSubFileDatabase                                     */
/*                                 uP擾v̎擾p[W  */
/*=========================================================================*/
Err PurgeSubFileDatabase(UInt16 command, UInt32 recId, UInt16 purgeCount)
{
    Err                        ret;
    UInt32                     diffTime;
    UInt16                     dbCount, loop, matched, count;
    MemHandle                  dataH;
    DmOpenRef                  dbRef;
    NNshGetLogSubFileDatabase *subDbRec;

    OpenDatabase_NNsh(DBNAME_TEMPORARYLOG, DBVERSION_TEMPORARYLOG, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", DBNAME_TEMPORARYLOG, 0);
        return (~errNone);
    }

    count = 0;
    // R[h擾
    GetDBCount_NNsh(dbRef, &dbCount);
    for (loop = dbCount; ((loop != 0)&&(count < purgeCount)); loop--)
    {
        ret = GetRecordReadOnly_NNsh(dbRef, (loop - 1), &dataH, (void **)&subDbRec);
        if (ret == errNone)
        {
            matched = NNSH_DATABASE_BLANK;
            switch (command)
            {
              case NNSH_GETLOGDB_CHECKPARENT:
                // eR[hԍv...
                if (recId == subDbRec->parentDbId)
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_CHECKTOKEN:
                // g[Nԍv...
                if (recId == subDbRec->tokenId)
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_CHECKDATE:
                // nbÂTuO͏...
                diffTime = TimGetSeconds() - subDbRec->lastUpdate;
                if (diffTime > recId)
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_CHECK_PARENT_DATE:
                // eR[hԍvAnbÂTuO͏...
                diffTime = TimGetSeconds() - subDbRec->lastUpdate;
                if ((diffTime > recId)&&(recId == subDbRec->parentDbId))
                {
                    matched = 0;
                }
                break;

              case NNSH_GETLOGDB_FORCE_DELETE:
                // K...
                matched = 0;
                break;

              case NNSH_GETLOGDB_CHECKURL:
              default:
                // p[WȂ...
                break;
            }
            // R[h̃bNJ
            ReleaseRecordReadOnly_NNsh(dbRef, dataH);

            // purgeɊY郌R[hꍇ...
            if (matched == 0)
            {
                // DB폜...
                DeleteRecordIDX_NNsh(dbRef, (loop - 1));
                
                // Ot@C...
                if (subDbRec->logDbId != 0)
                {
                    DeleteThreadMessage_RecordID(subDbRec->logDbId);
                }
                count++;
            }
        }
    }
    // DBN[Yĉ (purge)
    CloseDatabase_NNsh(dbRef);
    return (errNone);
}
#endif  // #ifdef USE_LOGCHARGE
