/*============================================================================*
 *  FILE: 
 *     nnshset.c
 *
 *  Description: 
 *     NNsh parameter setting functions for NNsh.
 *
 *===========================================================================*/
#define NNSHSET_C
#define GLOBAL_REAL
#include "local.h"

extern Err setOfflineLogDir(Char *fileName);

/*=========================================================================*/
/*   Function :   SetControlValue                                          */
/*                                       p[^ʂɔf鏈  */
/*=========================================================================*/
void SetControlValue(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    CtlSetValue(chkObj, (UInt16) *value);

    return;
}

/*=========================================================================*/
/*   Function :   UpdateParameter                                          */
/*                                       ʂp[^ɔf鏈  */
/*=========================================================================*/
void UpdateParameter(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    *value = CtlGetValue(chkObj);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting7                                       */
/*                              NNsiݒ-7(foCX֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting7(FormType *frm)
{
    ControlType *chkObj, *chkObjSub;
    UInt16       butID;

#ifdef USE_TSPATCH
    Err        ret;
    UInt32     fontVer;

    // TsPatch@\gpȂ
    ret = FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT_SUPPORT, &fontVer);
    if (ret == errNone)
    {    
        UpdateParameter(frm, CHKID_NOTUSE_TSPATCH, &(butID));
        if (butID != 0)
        {
            (NNshGlobal->NNsiParam)->notUseTsPatch = 1;
        }
        else
        {
            (NNshGlobal->NNsiParam)->notUseTsPatch = 0;
        }
    }
    else
#endif
    {
        (NNshGlobal->NNsiParam)->notUseTsPatch = 0;
    }


    // ARMletgp
    UpdateParameter(frm, CHKID_USE_ARMLET, &((NNshGlobal->NNsiParam)->useARMlet));
    if ((NNshGlobal->NNsiParam)->useARMlet != 0)
    {
        // ArmLetPalmOS5p̋@\Ȃ߁A{Ɏ{邩mF\)
        butID = NNsh_WarningMessage(ALTID_CONFIRM, MSG_WARNING_OS5, "", 0);
        if (butID != 0)
        {
            (NNshGlobal->NNsiParam)->useARMlet = 0;
        }
    }

#ifdef USE_CLIE
    // SONYnC]@\gȂ
    UpdateParameter(frm, CHKID_NOTUSE_SONYHIRES, &((NNshGlobal->NNsiParam)->disableSonyHR));
    if (NNshGlobal->notUseHR != (NNshGlobal->NNsiParam)->disableSonyHR)
    {
        // SONYnC]@\̎gpېݒ́ANLƂȂ
        NNsh_WarningMessage(ALTID_WARN, MSG_HR_NEXT_LAUNCH, "", 0);
    }

    // SilksȂ
    UpdateParameter(frm, CHKID_NOTUSE_SILK, &NNshGlobal->notUseSilk);
    if (NNshGlobal->notUseSilk != (NNshGlobal->NNsiParam)->notUseSilk)
    {
        // SILK͍sȂƂ́Ax\
        NNsh_WarningMessage(ALTID_WARN, MSG_SILK_NEXT_LAUNCH, "", 0);
    }
#endif

    // gpVFSw
    butID  = LstGetSelection(FrmGetObjectPtr(frm, 
                                  FrmGetObjectIndex(frm, LSTID_VFS_LOCATION)));
    (NNshGlobal->NNsiParam)->vfsUseCompactFlash = (UInt8) butID;

    // VFS p\ɎIVFS ON
    butID = 0;
    UpdateParameter(frm, CHKID_VFSON_AUTOMATIC, &butID);
    (NNshGlobal->NNsiParam)->vfsOnAutomatic = (UInt8) butID;

    // VFS ONłDB`FbNȂ
    UpdateParameter(frm, CHKID_VFSON_NOTDBCHK, &((NNshGlobal->NNsiParam)->vfsOnNotDBCheck));

    // VFS̎gpƉtOAOFFLINEOgptO̐ݒ
    if ((NNshGlobal->NNsiParam)->useVFS != NNSH_NOTSUPPORT_VFS)
    {
        chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
        (NNshGlobal->NNsiParam)->useVFS = CtlGetValue(chkObj);

        chkObjSub = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
        if (CtlGetValue(chkObjSub) != 0)
        {
            (NNshGlobal->NNsiParam)->useVFS = (NNshGlobal->NNsiParam)->useVFS | NNSH_VFS_WORKAROUND;
        }

        chkObjSub = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
        if (CtlGetValue(chkObjSub) != 0)
        {
            (NNshGlobal->NNsiParam)->useVFS = (NNshGlobal->NNsiParam)->useVFS | NNSH_VFS_USEOFFLINE;
        }

        chkObjSub =
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
        if (CtlGetValue(chkObjSub) != 0)
        {
            (NNshGlobal->NNsiParam)->useVFS = (NNshGlobal->NNsiParam)->useVFS | NNSH_VFS_DBBACKUP;
        }

        chkObjSub =
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
        if (CtlGetValue(chkObjSub) != 0)
        {
            (NNshGlobal->NNsiParam)->useVFS = (NNshGlobal->NNsiParam)->useVFS | NNSH_VFS_DBIMPORT;
        }
        
        chkObjSub =
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DIRMODE));
        if (CtlGetValue(chkObjSub) != 0)
        {
            (NNshGlobal->NNsiParam)->useVFS = (NNshGlobal->NNsiParam)->useVFS | NNSH_VFS_DIROFFLINE;
        }

        if ((NNshGlobal->NNsiParam)->useVFS != 0)
        {
            //  VFS֘Ap[^̐ݒ肪ĂƂAN
            // LƂȂ邱Ƃ\B
            NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_VFSWARN, "", 0);
        }

        // logdir.txtǂ݁AOFFLINEOx[XfBNg擾
        (void) setOfflineLogDir(LOGDIR_FILE);
    }

    // DBXV邵
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting8                                       */
/*                                  NNsiݒ-8(ʐM֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting8(FormType *frm)
{
    FieldType   *fldP;
    UInt32       bufSize;
    UInt16       timeout;
    Char        *logBuf, *numP;
    MemHandle    txtH;


    // GZIPgpݒ...
    timeout = 0;
    UpdateParameter(frm, CHKID_USE_GZIP, &(timeout));
    (NNshGlobal->NNsiParam)->useGZIP = timeout;

    // ʐM^CAEgl̕ύX
    timeout = SysTicksPerSecond();
    timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_COMM_TIMEOUT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        // ő厞Ԃ傫ꍇ...
        if (bufSize >= MAX_TIMEOUT_VALUE)
        {
            // 厞ԑ҂悤ɂ
            (NNshGlobal->NNsiParam)->netTimeout = -1;
        }
        else 
        {
            if ((NNshGlobal->NNsiParam)->netTimeout != timeout * bufSize)
            {
                (NNshGlobal->NNsiParam)->netTimeout = timeout * bufSize;

                // TIMEOUT̍XV\
                NNsh_DebugMessage(ALTID_INFO, MSG_TIMEOUT_UPDATED, 
                                  "", (NNshGlobal->NNsiParam)->netTimeout);
            }
        }
    }

    // obt@TCY̕ύX
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_BUFFER_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);
        if ((bufSize < NNSH_WORKBUF_MIN)||(bufSize > NNSH_WORKBUF_MAX))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MEMALLOC_PTR(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE1);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE2);
                NUMCATI(logBuf, NNSH_WORKBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WORKBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WORKBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MEMFREE_PTR(logBuf);
            }
            return (~errNone);
        }
        else
        {
            if (bufSize == (NNshGlobal->NNsiParam)->bufferSize)
            {
                // obt@TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "buffer size:", (NNshGlobal->NNsiParam)->bufferSize);
            }
            else
            {
                // obt@TCYύXďI
                (NNshGlobal->NNsiParam)->bufferSize = bufSize;
                NNsh_DebugMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                  "buffer size:", (NNshGlobal->NNsiParam)->bufferSize);
            }
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "0", 0);
    }

    // _E[hw擾
    UpdateParameter(frm, CHKID_DL_PART, &((NNshGlobal->NNsiParam)->enablePartGet));

    // BBSꗗ㏑
    UpdateParameter(frm, CHKID_BBS_OVERWRITE, &((NNshGlobal->NNsiParam)->bbsOverwrite));

    // _E[h̃TCY擾
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_DL_PARTSIZE));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        if (bufSize < NNSH_DOWNLOADSIZE_MIN)
        {
            // _E[hTCÝAobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_UNDER,
                              "", NNSH_DOWNLOADSIZE_MIN);
            return (~errNone);
        }
        if (bufSize > (NNshGlobal->NNsiParam)->bufferSize)
        {
            // _E[hTCÝA[Nobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_OVER, "", 0);
            return (~errNone);
        }
        if (bufSize != (NNshGlobal->NNsiParam)->partGetSize)
        {
            (NNshGlobal->NNsiParam)->partGetSize = bufSize;

            // _E[hTCY̍XV\
            NNsh_DebugMessage(ALTID_INFO, MSG_DOWNLOADSIZE_UPDATE, "",
                              (NNshGlobal->NNsiParam)->partGetSize);
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "1", 0);
    }

    // BBSꗗ擾̐ݒ
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_URL_BBS));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[hURL擾
        numP = MemHandleLock(txtH);
        MemSet  ((NNshGlobal->NNsiParam)->bbs_URL, MAX_URL, 0x00);
        StrNCopy((NNshGlobal->NNsiParam)->bbs_URL, numP, (MAX_URL - 1));
        MemHandleUnlock(txtH);
    }

    // ProxyoRł̃ANZX
    UpdateParameter(frm, CHKID_USE_PROXY, &((NNshGlobal->NNsiParam)->useProxy));

    // Proxy URL
    fldP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, FLDID_USE_PROXY));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP = MemHandleLock(txtH);
        MemSet((NNshGlobal->NNsiParam)->proxyURL, MAX_URL, 0x00);
        if (*numP != '\0')
        {
            StrNCopy((NNshGlobal->NNsiParam)->proxyURL, numP, (MAX_URL - 1));
        }
        MemHandleUnlock(txtH);
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY URL", 0);
    }

    // Proxy Port #
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_PROXY_PORT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        (NNshGlobal->NNsiParam)->proxyPort = bufSize;
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY PORT", 0);
    }

    // ʐM^CAEg̃gC
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_TIMEOUT_RETRY));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP     = MemHandleLock(txtH);
        timeout  = StrAToI(numP);
        MemHandleUnlock(txtH);

        // gC񐔂K傫΁AKlŊۂ߂
        timeout = (timeout > NNSH_LIMIT_RETRY)? NNSH_LIMIT_RETRY : timeout;
        (NNshGlobal->NNsiParam)->nofRetry = timeout;
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "RETRY COUNT", 0);
    }

    // ZLIB̃T|[gۊmFs
    SetZLIBsupport_NNsh();

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting5                                       */
/*                              NNsiݒ-5(݊֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting5(FormType *frm)
{
    UInt16       item;
    UInt32       bufSize;
    FieldType   *fldP;
    Char        *nameP, *logBuf;
    MemHandle    txtH;

    // ݎobt@TCY̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_WRITEBUF_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[h珑݃obt@TCY擾
        nameP = MemHandleLock(txtH);
        if (nameP != NULL)
        {
            bufSize = StrAToI(nameP);
            MemHandleUnlock(txtH);
        }
        else
        {
            bufSize = NNSH_WRITEBUF_DEFAULT;
        }
        if ((bufSize > NNSH_WRITEBUF_MAX)||(bufSize < NNSH_WRITEBUF_MIN))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MEMALLOC_PTR(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL2);
                NUMCATI(logBuf, NNSH_WRITEBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WRITEBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WRITEBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MEMFREE_PTR(logBuf);
            }
            return (~errNone);
        }
        else
        {
            // TCYmF
            if (bufSize == (NNshGlobal->NNsiParam)->writeBufferSize)
            {
                // TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "writeBufferSize:", (NNshGlobal->NNsiParam)->writeBufferSize);
            }
            else
            {
                (NNshGlobal->NNsiParam)->writeBufferSize = bufSize;
                NNsh_DebugMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                  "writeBufferSize:", (NNshGlobal->NNsiParam)->writeBufferSize);
            }
        }
    }

    // ݎPUSH{^𖳌
    UpdateParameter(frm, CHKID_WRITE_AUTOSAVE,
                                       &((NNshGlobal->NNsiParam)->writeMessageAutoSave));

    // ݎPUSH{^𖳌
    item = 0;
    UpdateParameter(frm, CHKID_WRITEPUSH_DISABLE, &(item));
    (NNshGlobal->NNsiParam)->writeJogPushDisable = item;

    // sage
    UpdateParameter(frm, CHKID_WRITE_SAGE,  &((NNshGlobal->NNsiParam)->writeAlwaysSage));

    // Ren@\gpݒ
    UpdateParameter(frm, CHKID_FIXED_HANDLE, &((NNshGlobal->NNsiParam)->useFixedHandle));

    // nh̐ݒ(nhݒłȂĂ퉞)
    MemSet((NNshGlobal->NNsiParam)->handleName, BUFSIZE, 0x00);
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_HANDLENAME));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        nameP = MemHandleLock(txtH);
        MemSet((NNshGlobal->NNsiParam)->handleName, BUFSIZE, 0x00);
        if (*nameP != '\0')
        {
            StrNCopy((NNshGlobal->NNsiParam)->handleName, nameP, (BUFSIZE - 1));
        }
        MemHandleUnlock(txtH);
    }

    // MCookiegpď
    UpdateParameter(frm, CHKID_WRITE_USE_COOKIE, &((NNshGlobal->NNsiParam)->useCookieWrite));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    item = 0;
    UpdateParameter(frm, CHKID_NOT_AUTOFOCUSSET, &(item));
    (NNshGlobal->NNsiParam)->notAutoFocus = item;

    // ݎAVNg債Ȃ
    item = 0;
    UpdateParameter(frm, CHKID_NOTSILK_WRITE, &(item));
    (NNshGlobal->NNsiParam)->notOpenSilkWrite = item;

    // ݎAA_[COFFɂ
    UpdateParameter(frm, CHKID_UNDERLINE_WRITE, &((NNshGlobal->NNsiParam)->disableUnderlineWrite));

    // ݎQƃXԍ}
    UpdateParameter(frm, CHKID_INSERT_REPLYNUM, &((NNshGlobal->NNsiParam)->insertReplyNum));

    // ݃V[PXPART2
    UpdateParameter(frm, CHKID_WRITE_SEQUENCE2, &((NNshGlobal->NNsiParam)->writeSequence2));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting6                                       */
/*                                NNsiݒ-6(WO֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting6(FormType *frm)
{
    UInt16 item;

    // QƎJumpListɁuꗗցv
    UpdateParameter(frm, CHKID_ADD_RTNTOLIST, &((NNshGlobal->NNsiParam)->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    UpdateParameter(frm, CHKID_ADD_BACKMESSAGE, &((NNshGlobal->NNsiParam)->addMenuBackRtnMsg));

    // QƎJumpListɃj[
    UpdateParameter(frm, CHKID_ADD_OPENMENU, &((NNshGlobal->NNsiParam)->addMenuMsg));

    // QƎJumpListɁu擾v
    UpdateParameter(frm, CHKID_ADD_GETPART, &((NNshGlobal->NNsiParam)->addLineGetPart));

    // QƎJumpListɁuؒfv
    UpdateParameter(frm, CHKID_ADD_LINEDISCONN, &((NNshGlobal->NNsiParam)->addLineDisconn));

    // QƎJumpListɐ擪
    UpdateParameter(frm, CHKID_ADD_JUMPTOP, &((NNshGlobal->NNsiParam)->addJumpTopMsg));

    // QƎJumpListɖ
    UpdateParameter(frm, CHKID_ADD_JUMPBOTTOM, &((NNshGlobal->NNsiParam)->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    UpdateParameter(frm, CHKID_ADD_OPENWEB, &((NNshGlobal->NNsiParam)->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    UpdateParameter(frm, CHKID_ADD_GRAPHVIEW, &((NNshGlobal->NNsiParam)->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    UpdateParameter(frm, CHKID_ADD_FAVORITE, &((NNshGlobal->NNsiParam)->addMenuFavorite));

    // QƎJumpListɃo
    UpdateParameter(frm, CHKID_ADD_OUTPUTMEMO, &((NNshGlobal->NNsiParam)->addMenuOutputMemo));

    // ꗗMenuɃj[\
    UpdateParameter(frm, CHKID_ADD_MENUOPEN, &item);
    (NNshGlobal->NNsiParam)->addMenuTitle = item;

    // ꗗMenuɎQCOPY
    UpdateParameter(frm, CHKID_ADD_MENUCOPY, &(NNshGlobal->NNsiParam)->addMenuCopyMsg);

    // ꗗMenuMSG폜
    UpdateParameter(frm, CHKID_ADD_MENUDELETE, &(NNshGlobal->NNsiParam)->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    UpdateParameter(frm, CHKID_ADD_MENUGRAPHMODE, &(NNshGlobal->NNsiParam)->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW1, &(NNshGlobal->NNsiParam)->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW2, &(NNshGlobal->NNsiParam)->addMenuMultiSW2);

    // ꗗMenuNNsiI
    UpdateParameter(frm, CHKID_ADD_NNSIEND, &(NNshGlobal->NNsiParam)->addMenuNNsiEnd);

    // ꗗMenuɃfoCX
    UpdateParameter(frm, CHKID_ADD_MENUDEVICEINFO, &(NNshGlobal->NNsiParam)->addMenuDeviceInfo);

    // QƎMenuɃfoCX
    UpdateParameter(frm, CHKID_ADD_DEVICEINFO, &(NNshGlobal->NNsiParam)->addDeviceInfo);

    // ꗗMenuDirI
    UpdateParameter(frm, CHKID_ADD_MENUDIRSELECT, &(NNshGlobal->NNsiParam)->addMenuDirSelect);

    // MenuBt On/Off\
    UpdateParameter(frm, CHKID_ADD_BT_ONOFF, &item);
    (NNshGlobal->NNsiParam)->addBtOnOff = item;

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effect_NNshSetting                                       */
/*                   NNsiݒ(NNsi)p[^lɔf鏈  */
/*-------------------------------------------------------------------------*/
static Err effect_NNshSetting(FormType *frm)
{
    ListType *lstP;
    UInt16   item;

    /***  NNshݒ(O[oϐ)f  ***/

    // URL擾AL`FbNȂ
    UpdateParameter(frm, CHKID_NOTCHECK_BBSURL,&((NNshGlobal->NNsiParam)->notCheckBBSURL));

    // ړɖ擾X폜
    UpdateParameter(frm, CHKID_AUTODEL_NOT_YET,&((NNshGlobal->NNsiParam)->autoDeleteNotYet));

    // Ji𔼊pSpϊ
    UpdateParameter(frm,CHKID_CONVERT_HANZEN, &((NNshGlobal->NNsiParam)->convertHanZen));

    // OfflineXɃX{Ȃ
    UpdateParameter(frm, CHKID_NOT_DELOFFLINE, &item);
    (NNshGlobal->NNsiParam)->notDelOffline = item;

    // Cɓ\ŒXx̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    item  = LstGetSelection(lstP);
    switch (item)
    {
      case 1:
        (NNshGlobal->NNsiParam)->displayFavorLevel = NNSH_MSGATTR_FAVOR_L2;
        break;

      case 2:
        (NNshGlobal->NNsiParam)->displayFavorLevel = NNSH_MSGATTR_FAVOR_L3;
        break;

      case 3:
        (NNshGlobal->NNsiParam)->displayFavorLevel = NNSH_MSGATTR_FAVOR_L4;
        break;

      case 4:
        (NNshGlobal->NNsiParam)->displayFavorLevel = NNSH_MSGATTR_FAVOR;
        break;

      case 0:
      default:
        (NNshGlobal->NNsiParam)->displayFavorLevel = NNSH_MSGATTR_FAVOR_L1;
        break;
    }

    // mFbZ[Wȗ
    item = 0;
    UpdateParameter(frm, CHKID_OMIT_DIALOG, &item);
    if (item == 0)
    {
        // mFbZ[WȗݒNA
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
    }
    if ((item != 0)&&((NNshGlobal->NNsiParam)->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }

    // ɁA啶ʂȂ
    UpdateParameter(frm, CHKID_SEARCH_CASELESS, &((NNshGlobal->NNsiParam)->searchCaseless));

    // NOfflineX
    UpdateParameter(frm, CHKID_OFFCHK_LAUNCH,   &((NNshGlobal->NNsiParam)->offChkLaunch));

    // QƃOփRs[ƂAɃX폜{
    UpdateParameter(frm, CHKID_COPYDEL_READONLY,
                    &((NNshGlobal->NNsiParam)->copyDelReadOnly));

    // i-modepURLgp
    UpdateParameter(frm, CHKID_USE_IMODEURL, &((NNshGlobal->NNsiParam)->useImodeURL));


    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting2                                       */
/*                                   NNsiݒ2(ꗗ)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting2(FormType *frm)
{
    UInt16 item;

    // Xꗗ(subject.txt)S擾
    UpdateParameter(frm, CHKID_SUBJECT_ALL, &((NNshGlobal->NNsiParam)->getAllThread));

    // Xꗗʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TITLE,
                                     &((NNshGlobal->NNsiParam)->useSonyTinyFontTitle));

    // dmF
    UpdateParameter(frm, CHKID_CHECK_DUPLICATE,
                    &((NNshGlobal->NNsiParam)->checkDuplicateThread));

    // Xꗗɕ\MSG͖ǐ
    item = 0;
    UpdateParameter(frm, CHKID_PRINT_NOFNOTREAD,&(item));
    (NNshGlobal->NNsiParam)->listMesNumIsNotReadNum = item;

    // XꗗMSG
    UpdateParameter(frm, CHKID_PRINT_NOFMSG,&((NNshGlobal->NNsiParam)->printNofMessage));

    // 擾ςݑSĂ͎QƃOɕ\Ȃ
    item = 0;
    UpdateParameter(frm, CHKID_NOT_READONLY_NEW, &(item));
    (NNshGlobal->NNsiParam)->notListReadOnlyNew = item;

    // 擾ςݑSĂɂ͎QƃOɕ\Ȃ
    item = 0;
    UpdateParameter(frm, CHKID_NOT_READONLY, &(item));
    (NNshGlobal->NNsiParam)->notListReadOnly = item;

    // 擾ɃXQ
    UpdateParameter(frm, CHKID_OPEN_AUTO,   &((NNshGlobal->NNsiParam)->openAutomatic));

#ifdef USE_COLOR
    // ꗗ\ɃJ[
    UpdateParameter(frm, CHKID_USE_COLORMODE, &((NNshGlobal->NNsiParam)->useColor));
#endif

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting3                                       */
/*                                NNsiݒ-3(ꗗ{^)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting3(FormType *frm)
{
    Char      *txtP;
    FieldType *fldP;
    ListType  *lstP;
    UInt16     item;
    MemHandle  txtH;

    // ړIXCb`ݒP̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW1));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch1 = item | NNSH_SWITCHUSAGE_TITLE;

    // ړIXCb`ݒQ̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW2));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2 = item | NNSH_SWITCHUSAGE_TITLE;

    if ((NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch1 ==
        (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2)
    {
        // ړIXCb`PƂQ̐ݒlꍇXCb`QgpȂ
        (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2 = NNSH_SWITCHUSAGE_TITLE;
    }

    // ړI{^P̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN1));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn1Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN1));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn1Feature = item | MULTIBTN_FEATURE;

    // ړI{^Q̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN2));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn2Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN2));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn2Feature = item | MULTIBTN_FEATURE;

    // ړI{^R̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN3));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn3Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN3));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn3Feature = item | MULTIBTN_FEATURE;

    // ړI{^S̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN4));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn4Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN4));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn4Feature = item | MULTIBTN_FEATURE;

    // ړI{^T̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN5));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn5Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN5));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn5Feature = item | MULTIBTN_FEATURE;

    // ړI{^U̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN6));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy ((NNshGlobal->NNsiParam)->multiBtn6Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN6));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->multiBtn6Feature = item | MULTIBTN_FEATURE;

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting9                                       */
/*                             NNsiݒ-9(V/֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting9(FormType *frm)
{
    ListType  *lstP;
    UInt16     item;

    // NNsiIɉؒf
    UpdateParameter(frm, CHKID_END_OFFLINE, &((NNshGlobal->NNsiParam)->disconnectNNsiEnd));

    // uVmFvIɉؒf
    UpdateParameter(frm, CHKID_DISCONN_ARRIVAL, &((NNshGlobal->NNsiParam)->disconnArrivalEnd));

    // uVmFvODAN
    item = 0;
    UpdateParameter(frm, CHKID_PREPARE_DA, &(item));
    (NNshGlobal->NNsiParam)->preOnDAnewArrival = item;

    // uVmFvIɖǈꗗ\
    item = 0;
    UpdateParameter(frm, CHKID_ARRIVAL_NOTREAD, &(item));
    (NNshGlobal->NNsiParam)->autoOpenNotRead = item;

    // uVmFvIɃr[v
    item = 0;
    UpdateParameter(frm, CHKID_DONE_BEEP, &(item));
    (NNshGlobal->NNsiParam)->autoBeep = item;

    //  NNsiNɃ}Ns
    item = 0;
    UpdateParameter(frm, CHKID_AUTOSTARTMACRO, &(item));
    (NNshGlobal->NNsiParam)->autostartMacro = item;
    if ((NNshGlobal->NNsiParam)->autostartMacro != 0)
    {
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_MACROENABLE, "", 0);
    }

    // ڑ͎擾\
    UpdateParameter(frm,CHKID_GETRESERVEFEATURE,&(NNshGlobal->NNsiParam)->getReserveFeature);

    // ڑʂĕ`
    UpdateParameter(frm,CHKID_REDRAW_CONNECT,&((NNshGlobal->NNsiParam)->redrawAfterConnect));

    // ܂BBS/@JBBSVmF
    item = 0;
    UpdateParameter(frm, CHKID_HTMLBBS_ENABLE, &(item));
    (NNshGlobal->NNsiParam)->enableNewArrivalHtml = item;
    if ((NNshGlobal->NNsiParam)->enableNewArrivalHtml != 0)
    {
        //  ܂BBS/@JBBSŐVmFꍇ́A擾ł͂Ȃ
        // Ď擾{邱Ƃx
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNMACHINEW, "", 0);
    }

    // BBSꗗ̃XgԂ𔽉f
    lstP  = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,LSTID_CHECK_NEWARRIVAL));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->newArrivalNotRead = item;

#ifdef USE_LOGCHARGE
    // QƃO擾xp[^ɔf
    lstP  = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_CHECK_READONLY));
    item  = LstGetSelection(lstP);
    (NNshGlobal->NNsiParam)->getROLogLevel = item;
#endif

    // VG[ɂȂ΍Ď擾
    UpdateParameter(frm, CHKID_ALLUPDATE_ABORT, &((NNshGlobal->NNsiParam)->autoUpdateGetError));

    // WebBrowserJƂŐV50
    UpdateParameter(frm, CHKID_WEBBROWSE_LAST50, &item);
    if (item != 0)
    {
        (NNshGlobal->NNsiParam)->browseMesNum = 50;
    }
    else
    {
        (NNshGlobal->NNsiParam)->browseMesNum = 0;
    }

    // ꗗ擾ɐVmF
    UpdateParameter(frm, CHKID_UPDATEMSG_LIST, &((NNshGlobal->NNsiParam)->listAndUpdate));
    if ((NNshGlobal->NNsiParam)->listAndUpdate != 0)
    {
        // ꗗ擾ɐVmFꍇ́uꗗ㏑vɎŃ`FbN
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNLISTUPDATE, "", 0);
        (NNshGlobal->NNsiParam)->checkDuplicateThread = 1;
    }

    // VmFɃ[`FbN
    UpdateParameter(frm, CHKID_cMDA_EXECUTE, &((NNshGlobal->NNsiParam)->use_DAplugin));
    if ((NNshGlobal->NNsiParam)->use_DAplugin != 0)
    {
        // VmFɃ[`FbNꍇ̒ӎ\
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNcMDA, MSG_NNSISET_WARNcMDA2, 0);
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting4                                       */
/*                                  NNsiݒ-4(QƉ)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting4(FormType *frm)
{
    FieldType *fldP;
    MemHandle txtH;
    Char      *numP;
    UInt16     resNum;

    // X̍őTCY
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_RESNUM_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[h烌X̍őTCY擾
        numP = MemHandleLock(txtH);
        if (numP != NULL)
        {
            resNum = StrAToI(numP);
            MemHandleUnlock(txtH);
        }
        else
        {
            resNum = NNSH_MESSAGE_MAXNUMBER;
        }

        // X̍őTCYw肪ُ킾ꍇɂ́Alɖ߂
        if ((resNum < NNSH_MESSAGE_MAXNUMBER)||(resNum > NNSH_MESSAGE_MAXLIMIT))
        {
            resNum = NNSH_MESSAGE_MAXNUMBER;
        }
        (NNshGlobal->NNsiParam)->msgNumLimit = resNum;
    }

    // RAW\[h
    UpdateParameter(frm, CHKID_USE_RAWDISPLAY, &resNum);
    (NNshGlobal->NNsiParam)->rawDisplayMode = resNum;

    // Bookmark(ݒ)
    UpdateParameter(frm, CHKID_USE_BOOKMARK,&((NNshGlobal->NNsiParam)->useBookmark));

    // Xԍyzɂ
    UpdateParameter(frm, CHKID_BOLD_MSGNUM, &((NNshGlobal->NNsiParam)->boldMessageNum));

    // XQƉʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TINYFONT,
                                      &((NNshGlobal->NNsiParam)->useSonyTinyFont));

    // QƎA_[COFF
    UpdateParameter(frm, CHKID_MSG_LINEOFF, &((NNshGlobal->NNsiParam)->disableUnderline));

    // PUSH ON_CŁ}P
    UpdateParameter(frm, CHKID_NOT_CURSOR, &((NNshGlobal->NNsiParam)->notCursor));

    // XQƉʂŃJ[\\Ȃ
    UpdateParameter(frm,CHKID_NOT_FOCUSSET_NUM, &((NNshGlobal->NNsiParam)->notFocusNumField));

    // QƎOɈړőOX
    UpdateParameter(frm, CHKID_DISPLAY_BOTTOMMES, &((NNshGlobal->NNsiParam)->dispBottom));

    // QƎXA\
    UpdateParameter(frm,CHKID_BLOCK_DISP_MODE, &((NNshGlobal->NNsiParam)->blockDispMode));
    if ((NNshGlobal->NNsiParam)->blockDispMode != 0)
    {
        // XA\Ƃ́AOɈړőOXnmɂ
        (NNshGlobal->NNsiParam)->blockDispMode = NNSH_BLOCKDISP_NOFMSG;
        (NNshGlobal->NNsiParam)->dispBottom    = 1;
    }

    // NGmF
    (NNshGlobal->NNsiParam)->hideMessage = 0;    
    UpdateParameter(frm, CHKID_HIDE_MESSAGE, &resNum);
    if (resNum != 0)
    {
        // NGmF-3{
        (NNshGlobal->NNsiParam)->hideMessage = NNSH_USE_NGWORD1AND2;
    }

    // NGmF(NG-3)
    UpdateParameter(frm, CHKID_HIDE3_MESSAGE, &resNum);
    if (resNum != 0)
    {
        // NGmF-3{
        (NNshGlobal->NNsiParam)->hideMessage = (NNshGlobal->NNsiParam)->hideMessage | NNSH_USE_NGWORD3;
    }

    // NG[hݒŐK\gp
    UpdateParameter(frm, CHKID_USE_REGEXPRESS,
                                        &((NNshGlobal->NNsiParam)->useRegularExpression));
    if ((NNshGlobal->NNsiParam)->useRegularExpression != 0)
    {
        //  K\gpꍇɂ́AptH[}Xۏ؂łȂƂ
        // x
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNREGEXP, "", 0);
    }

    // gꍇ̐ݒ
    if ((NNshGlobal->NNsiParam)->useBookmark == 0)
    {
        // gȂꍇAݒ̃NA
        (NNshGlobal->NNsiParam)->lastFrmID     = NNSH_FRMID_THREAD;
        (NNshGlobal->NNsiParam)->bookMsgNumber = 0;
        (NNshGlobal->NNsiParam)->bookMsgIndex  = 0;
        MEMFREE_PTR(NNshGlobal->bookmarkFileName);
        MEMFREE_PTR(NNshGlobal->bookmarkNick);
    }
    else
    {
        if (NNshGlobal->bookmarkFileName == NULL)
        {
            // ݒL̈mۂ
            NNshGlobal->bookmarkFileName = MEMALLOC_PTR(MAX_THREADFILENAME);
            if (NNshGlobal->bookmarkFileName != NULL)
            {
                NNshGlobal->bookmarkNick = MEMALLOC_PTR(MAX_NICKNAME);
                if (NNshGlobal->bookmarkNick == NULL)
                {
                    MEMFREE_PTR(NNshGlobal->bookmarkFileName);
                }
            }
        }
    }

    // NGݒ12̕`FbN
    SeparateWordList((NNshGlobal->NNsiParam)->hideWord1, &(NNshGlobal->hide1));
    SeparateWordList((NNshGlobal->NNsiParam)->hideWord2, &(NNshGlobal->hide2));

    // Xx̃ZN^gKɊ蓖Ă
    (NNshGlobal->NNsiParam)->viewMultiBtnFeature = 
          LstGetSelection(FrmGetObjectPtr(frm,
                                     FrmGetObjectIndex(frm, LSTID_LVLSELTRIG)));

    // X^Cg̃ZN^gKɊ蓖Ă
    (NNshGlobal->NNsiParam)->viewTitleSelFeature = 
          LstGetSelection(FrmGetObjectPtr(frm,
                                     FrmGetObjectIndex(frm, LSTID_TTLSELTRIG)));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSettingA                                       */
/*                                        NNsiݒ(T)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSettingA(FormType *frm)
{
    UInt16   item;

    // DEBUG[h̐ݒ
    UpdateParameter(frm, CHKID_DEBUG_DIALOG,&((NNshGlobal->NNsiParam)->debugMessageON));

    // Xꗗ(subject.txt)S擾
    UpdateParameter(frm, CHKID_SUBJECT_ALL, &((NNshGlobal->NNsiParam)->getAllThread));

#ifdef USE_COLOR
    // ꗗ\ɃJ[
    UpdateParameter(frm, CHKID_USE_TITLE_COLOR, &((NNshGlobal->NNsiParam)->useColor));
#endif

    // gpVFSw
    item  = LstGetSelection(FrmGetObjectPtr(frm, 
                                  FrmGetObjectIndex(frm, LSTID_VFS_LOCATION)));
    (NNshGlobal->NNsiParam)->vfsUseCompactFlash = (UInt8) item;

    // VFS p\ɎIVFS ON
    item = 0;
    UpdateParameter(frm, CHKID_VFSON_AUTOMATIC, &item);
    if (item != 0)
    {
        // VFS ONNNsiݒ(T)Őݒ肵ꍇɂ́ADB`FbNOFFɂ
        if (((NNshGlobal->NNsiParam)->vfsOnAutomatic == 0)&&((NNshGlobal->NNsiParam)->vfsOnNotDBCheck == 0))
        {
            (NNshGlobal->NNsiParam)->vfsOnNotDBCheck = 1;
        }
    }
    (NNshGlobal->NNsiParam)->vfsOnAutomatic = (UInt8) item;

    // QƎXA\
    UpdateParameter(frm,CHKID_BLOCK_DISP_MODE, &((NNshGlobal->NNsiParam)->blockDispMode));
    if ((NNshGlobal->NNsiParam)->blockDispMode != 0)
    {
        // XA\Ƃ́AOɈړőOXnmɂ
        (NNshGlobal->NNsiParam)->blockDispMode = NNSH_BLOCKDISP_NOFMSG;
        (NNshGlobal->NNsiParam)->dispBottom    = 1;
    }

    // ڑ͎擾\
    UpdateParameter(frm,CHKID_GETRESERVEFEATURE,&(NNshGlobal->NNsiParam)->getReserveFeature);

    // ܂BBS/@JBBSVmF
    item = 0;
    UpdateParameter(frm, CHKID_HTMLBBS_ENABLE, &(item));
    (NNshGlobal->NNsiParam)->enableNewArrivalHtml = item;
    if ((NNshGlobal->NNsiParam)->enableNewArrivalHtml != 0)
    {
        //  ܂BBS/@JBBSŐVmFꍇ́A擾ł͂Ȃ
        // Ď擾{邱Ƃx
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNMACHINEW, "", 0);

    }

    // mFbZ[Wȗ
    item = 0;
    UpdateParameter(frm, CHKID_OMIT_DIALOG, &item);
    if (item == 0)
    {
        // mFbZ[WȗݒNA
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
    }
    if ((item != 0)&&((NNshGlobal->NNsiParam)->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}


/*-------------------------------------------------------------------------*/
/*   Function :   clearFeatureList                                         */
/*                                            Xg̈NA */
/*-------------------------------------------------------------------------*/
static void clearFeatureList(void)
{
    if (NNshGlobal->featureList != NULL)
    {
        // ẍ̗惍bN͂B
        while (NNshGlobal->featureLockCnt != 0)
        {
            MemHandleUnlock((NNshGlobal->featureList)->wordmemH);
            (NNshGlobal->featureLockCnt)--;
        }

        // @\ݒ胊Xg`Ăꍇ͗̈
        ReleaseWordList(NNshGlobal->featureList);
        MEMFREE_PTR(NNshGlobal->featureList);
        NNshGlobal->featureList = NULL;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   closeForm_NNsiSettings                                   */
/*                                        NNsiݒnʂ̃tH[ */
/*-------------------------------------------------------------------------*/
static void closeForm_NNsiSettings(UInt16 nextFormID)
{
    // Xg̈NA
    clearFeatureList();

    // ʑJڂ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm (nextFormID);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   createFeatureListStrings                                 */
/*                              XgO\[XꗗXg𐶐 */
/*-------------------------------------------------------------------------*/
static Err createFeatureListStrings(NNshWordList **lst, UInt16 strRscId)
{
    Err        ret;
    MemHandle  memH;
    Char      *ptr;

    // @\ꗗXg쐬ς݂Ȃ瑦
    if (*lst != NULL)
    {
        return (errNone);
    }

    // @\ꗗXg̊Ǘ̈mۂ
    *lst = MEMALLOC_PTR(sizeof(NNshWordList));
    if (*lst == NULL)
    {
        // ̈mۂɎs
        return (errNone);
    }
    MemSet(*lst, sizeof(NNshWordList), 0x00);

    // ꗗ@\Xg̎擾iXgO\[X擾j
    memH = DmGetResource('tSTR', strRscId);
    if (memH == 0)
    {
        return (~errNone);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        return (~errNone);
    }

    // XgO\[XXg`ɕ
    ret = SeparateWordList(ptr, *lst);
    if (ret != errNone)
    {
        // ̕ɎsAǗ̈JB
        MEMFREE_PTR(*lst);
    }
    MemHandleUnlock(memH);
    DmReleaseResource(memH);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   keyDownEvt_NNshSetting                                   */
/*                                                        L[͎̏ */
/*-------------------------------------------------------------------------*/
static Boolean keyDownEvt_NNshSetting(EventType *event)
{
    FormType *frm;
    UInt16    formID;
    Int16     move;

    // ݂̃tH[ID擾
    formID = FrmGetActiveFormID();
    move   = 0;

    // 5way navigatorpL[R[hRo[gAL[R[h𔻒肷
    switch (KeyConvertFiveWayToJogChara(event))
    {
      // n[hL[̏
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrThumbWheelDown:
      case chrDownArrow:
        move = 1;
        break;

      // n[hL[̏
      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrThumbWheelUp:
      case chrUpArrow:
        move = -1;
        break;

      // obN{^/ESCL[/BSL[Ƃ̏
      // case chrBackspace:
      case vchrJogBack:
      case chrEscape:
      case vchrThumbWheelBack:
      case vchrGarminEscape:
        if (formID != FRMID_NNSI_SETTING_ABSTRACT)
        {
            // NNsiݒʂ֑Jڂ
            closeForm_NNsiSettings(FRMID_NNSI_SETTING_ABSTRACT);
        }
        return (false);
        break;

      case chrCapital_D:    // DL[̓
      case chrSmall_D:
      case chrDigitZero:    // [L[̓
        if (formID != FRMID_NNSI_SETTING_ABSTRACT)
        {
            // NNsiݒ(TvȊO)͉I
            return (false);
        }
        break;

      default: 
        return (false);
        break;
    }

    // ݊JĂtH[hcAɊJtH[肷
    frm = FrmGetActiveForm();
    switch (formID)
    {
      case FRMID_CONFIG_NNSH:
        effect_NNshSetting(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING2 : FRMID_NNSI_SETTING9;
        break;
      case FRMID_NNSI_SETTING2:
        effectNNsiSetting2(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING3 : FRMID_CONFIG_NNSH;
        break;
      case FRMID_NNSI_SETTING3:
        effectNNsiSetting3(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING4 : FRMID_NNSI_SETTING2;
        break;
      case FRMID_NNSI_SETTING4:
        effectNNsiSetting4(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING5 : FRMID_NNSI_SETTING3;
        break;
      case FRMID_NNSI_SETTING5:
        effectNNsiSetting5(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING6 : FRMID_NNSI_SETTING4;
        break;
      case FRMID_NNSI_SETTING6:
        effectNNsiSetting6(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING7 : FRMID_NNSI_SETTING5;
        break;
      case FRMID_NNSI_SETTING7:
        effectNNsiSetting7(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING8 : FRMID_NNSI_SETTING6;
        break;

      case FRMID_NNSI_SETTING8:
        effectNNsiSetting8(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING9 : FRMID_NNSI_SETTING7;
        break;

      case FRMID_NNSI_SETTING9:
        effectNNsiSetting9(frm);
        formID = (move > 0) ? FRMID_CONFIG_NNSH   : FRMID_NNSI_SETTING8;
        break;

      case FRMID_NNSI_SETTING_ABSTRACT:
        effectNNsiSettingA(frm);
        formID = FRMID_CONFIG_NNSH;
        break;

      default:
        return (false);
        break;
    }

    // ʑJڂ
    closeForm_NNsiSettings(formID);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   SetTitleHardKey                                          */
/*                                                        n[hL[̐ݒ */
/*-------------------------------------------------------------------------*/
static Boolean SetTitleHardKey(Char *title, UInt16 data, UInt16 mask, NNshHardkeyControl *info)
{
    Boolean    ret = false;
    FormType  *frm, *prevFrm;
    ListType  *lstP;
    UInt16     items[MINIBUF], *dataP, item;
    Char      *ptr;

    NNshListItem popList[] = {
        { POPTRID_LIST_MULTIUP,   LSTID_MULTIUP   },
        { POPTRID_LIST_MULTIDOWN, LSTID_MULTIDOWN },
        { POPTRID_LIST_HKEY1,     LSTID_HKEY1     },
        { POPTRID_LIST_HKEY2,     LSTID_HKEY2     },
        { POPTRID_LIST_HKEY3,     LSTID_HKEY3     },
        { POPTRID_LIST_HKEY4,     LSTID_HKEY4     },
        { POPTRID_LIST_JOGPUSH,   LSTID_JOGPUSH   },
        { POPTRID_LIST_JOGBACK,   LSTID_JOGBACK   },
        { POPTRID_LIST_CAPTURE,   LSTID_CAPTURE   },
        { POPTRID_LIST_MULTILEFT, LSTID_MULTILEFT   },
        { POPTRID_LIST_MULTIRIGHT, LSTID_MULTIRIGHT },
        { 0, 0 }
    };                 

    // ݂̃tH[擾
    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    frm = FrmInitForm(FRMID_HARDKEY_SETTING);
    FrmSetActiveForm(frm);

    // EBhE^Cg̐ݒ
    FrmCopyTitle(frm, title);

    // ݂̃L[@\ݒe[uɊi[
    MemSet(items, sizeof(items), 0x00);
    dataP = items;
    *dataP = (info->up)&(mask);            // n[hL[̐ݒ
    dataP++;
    *dataP = (info->down)&(mask);          // n[hL[̐ݒ
    dataP++;
    *dataP = (info->key1)&(mask);          // n[hL[P̐ݒ
    dataP++;
    *dataP = (info->key2)&(mask);          // n[hL[Q̐ݒ
    dataP++;
    *dataP = (info->key3)&(mask);          // n[hL[R̐ݒ
    dataP++;
    *dataP = (info->key4)&(mask);          // n[hL[S̐ݒ
    dataP++;
    *dataP = (info->jogPush)&(mask);       // JOG PUSH̐ݒ
    dataP++;
    *dataP = (info->jogBack)&(mask);       // JOG BACK̐ݒ
    dataP++;
    *dataP = (info->clieCapture)&(mask);   // CLIE NXLv`{^̐ݒ
    dataP++;
    *dataP = (info->left)&(mask);          // n[h{^̐ݒ
    dataP++;
    *dataP = (info->right)&(mask);         // n[h{^E̐ݒ
    dataP++;

    // @\ꗗXgbN
    ptr = MemHandleLock((NNshGlobal->featureList)->wordmemH);
    NNshWinSetPopItemsWithListArray(frm, popList, ptr,
                                    (NNshGlobal->featureList)->nofWord, items);

    // _CAO̕\
    if (FrmDoDialog(frm) == BTNID_HARDKEY_OK)
    {
        // n[hL[̐ݒ
        lstP     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIUP));
        item     = LstGetSelection(lstP);
        info->up = item | data;

        // n[hL[̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIDOWN));
        item       = LstGetSelection(lstP);
        info->down = item | data;

        // n[hL[P̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY1));
        item       = LstGetSelection(lstP);
        info->key1 = item | data;

        // n[hL[Q̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY2));
        item       = LstGetSelection(lstP);
        info->key2 = item | data;

        // n[hL[R̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY3));
        item       = LstGetSelection(lstP);
        info->key3 = item | data;

        // n[hL[S̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY4));
        item       = LstGetSelection(lstP);
        info->key4 = item | data;

        // WO_CPush{^
        lstP          = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_JOGPUSH));
        item          = LstGetSelection(lstP);
        info->jogPush = item | data;

        // WO_CBack{^
        lstP          = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_JOGBACK));
        item          = LstGetSelection(lstP);
        info->jogBack = item | data;

        // NX Capture{^
        lstP              = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_CAPTURE));
        item              = LstGetSelection(lstP);
        info->clieCapture = item | data;

        // n[hL[̐ݒ
        lstP     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTILEFT));
        item     = LstGetSelection(lstP);
        info->left = item | data;

        // n[hL[E̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIRIGHT));
        item       = LstGetSelection(lstP);
        info->right = item | data;

        // DBXV邵
        NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

        ret = true;
    }

    // @\ꗗXg̃bN
    MemHandleUnlock((NNshGlobal->featureList)->wordmemH);

    // _CAO
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(frm);
    FrmDrawForm(prevFrm);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Handler_NGwordInput                                      */
/*                                  NG[hݒ̎擾ݒCxgnh */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
Boolean Handler_NGwordInput(EventType *event)
{
    UInt16              keyCode;
    NNshNGwordDatabase  dbData;
    DmOpenRef           dbRef;
    FormType           *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        // ҏWCxgs
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        frm = FrmGetActiveForm();

        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrThumbWheelDown:
          case chrRightArrow:     // J[\L[E(5wayE)
          case vchrJogRight:
          case chrUnitSeparator:  // J[\L[()̏
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }
            // f[^XV
            effectNGwordInput(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrThumbWheelUp:
          case chrLeftArrow:         // J[\L[(5way)
          case vchrJogLeft:
          case chrRecordSeparator:   // J[\L[()̏
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectNGwordInput(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case vchrThumbWheelPush:
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case chrEscape:
          default:
            return (false);
            break;
        }
        // NG[hi[pDB̎擾
        OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
        if (dbRef == 0)
        {
            // NG[hpDB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshNGwordDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshNGwordDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayNGwordInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      case ctlSelectEvent:
        frm = FrmGetActiveForm();
        switch (event->data.ctlSelect.controlID)
        {
          case BTNID_NGWORD_PREV:
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectNGwordInput(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_NGWORD_NEXT:
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }

            // f[^XV
            effectNGwordInput(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_NGWORD_NEW:
            // VK擾쐬(f[^𖖔Ɉړ)
            // f[^XV
            effectNGwordInput(frm);

            // f[^ʂɔf
            MemSet(&dbData, sizeof(NNshNGwordDatabase), 0x00);
            displayNGwordInfo(frm, &dbData);
            NNshGlobal->jumpSelection = 1;
            NNshGlobal->work2 = 0;
            return (true);
            break;

          case BTNID_NGWORD_DELETE:
            // R[h폜
            if ((NNshGlobal->work1 != 0)&&(NNshGlobal->jumpSelection == 0))
            {
                // f[^{ɍ폜Ă悢mF
                if (NNsh_ConfirmMessage(ALTID_CONFIRM, "",
                                        MSG_CONFIRM_DELETE_DATA, 0) == 0)
                {
                    // NG[hi[pDB̎擾
                    OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
                    if (dbRef == 0)
                    {
                        // ODB̃I[vsAI
                        return (false);
                    }
                    // R[h폜
                    DeleteRecordIDX_NNsh(dbRef, NNshGlobal->work2);
                    (NNshGlobal->work1)--;

                    if (NNshGlobal->work1 == NNshGlobal->work2)
                    {
                        // R[h폜ꍇ...
                        (NNshGlobal->work2)--;
                    }

                    // DBN[Y
                    CloseDatabase_NNsh(dbRef);
                }
            }            
            break;

          default:
            // Ȃ
            return (false);
            break;
        }
        // NG[hi[pDB̎擾
        OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshNGwordDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshNGwordDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayNGwordInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      default: 
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNGwordInput                                        */
/*                                              \f[^̃R[h𔽉f */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean effectNGwordInput(FormType *frm)
{
    DmOpenRef           dbRef;
    Char               *ptr;
    NNshNGwordDatabase  dbData;
    FieldType          *fldP;
    MemHandle           txtH;
    
    // NG[hi[pDB̎擾
    OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
    if (dbRef == 0)
    {
        // i[pDB̃I[vsAI
        return (false);
    }
    
    MemSet(&dbData, sizeof(NNshNGwordDatabase), 0x00);
    
    // NG[h̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_NGWORD_INPUT));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.ngWord, NGWORD_LEN, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.ngWord, ptr, NGWORD_LEN - 1);
            MemHandleUnlock(txtH);
        }
        else
        {
            // NG[hw肳ȂAI
            MemHandleUnlock(txtH);
            CloseDatabase_NNsh(dbRef);
            return (false);
        }
    }

    // ԂɂAXV/o^肷
    if (NNshGlobal->jumpSelection == 0)
    {
        // R[hXV
        UpdateRecord_NNsh(dbRef, NNshGlobal->work2,
                          sizeof(NNshNGwordDatabase), &dbData);
    }
    else
    {
        // R[ho^
        EntryRecord_NNsh(dbRef, sizeof(NNshNGwordDatabase), &dbData);
        (NNshGlobal->work1)++;
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   displayNGwordInfo                                        */
/*                                                          NG[h̕\ */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean displayNGwordInfo(FormType *frm, NNshNGwordDatabase *dbData)
{
    Char   data[MINIBUF];
    
    // ݕ\Ă郌R[hԍ̕\ (݌ / S)
    MemSet (data, sizeof(data), 0x00);
    if (NNshGlobal->work1 != 0)
    {
        NUMCATI(data, NNshGlobal->work1 - NNshGlobal->work2);
    }
    else
    {
        StrCopy(data, "1");
    }
    StrCat (data, "/");
    NUMCATI(data, NNshGlobal->work1);
    NNshWinSetFieldText(frm, FLDID_NGWORD_INFO, false, data, MINIBUF);

    // NGL[[h̕\
    NNshWinSetFieldText(frm,FLDID_NGWORD_INPUT,true,dbData->ngWord,NGWORD_LEN);

   return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   SetNGword3                                               */
/*                                                          NGݒ-3C */
/*-------------------------------------------------------------------------*/
Boolean SetNGword3(void)
{
    Boolean              ret = false;
    FormType            *frm, *prevFrm;
    DmOpenRef            dbRef;
    NNshNGwordDatabase   dbData;

    // NG[hpDB̎擾
    OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
    if (dbRef == 0)
    {
        // NG[hpDB̃I[vsAI
        return (false);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &(NNshGlobal->work1));

    // f[^̏
    NNshGlobal->work2 = 0;
    MemSet(&dbData, sizeof(NNshNGwordDatabase), 0x00);

    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    frm = FrmInitForm(FRMID_NGWORD_INPUT);
    FrmSetActiveForm(frm);
   
    // R[hPȂꍇ
    if (NNshGlobal->work1 == 0)
    {
        NNshGlobal->jumpSelection = 1;
    }
    else
    {
        // Ō̃R[hf[^ʂɕ\
        NNshGlobal->work2 = NNshGlobal->work1 - 1;
        GetRecord_NNsh(dbRef, NNshGlobal->work2,
                       sizeof(NNshNGwordDatabase), &dbData);
        NNshGlobal->jumpSelection = 0;
    }
    displayNGwordInfo(frm, &dbData);

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // Cxgnh̐ݒ
    FrmSetEventHandler(frm, Handler_NGwordInput);

    // QƃO擾̐ݒ_CAO\
    if (FrmDoDialog(frm) == BTNID_NGWORD_OK)
    {
        // \f[^̃R[h𔽉f
        ret = effectNGwordInput(frm);
    }

    // _CAO
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(frm);
    FrmDrawForm(prevFrm);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   selectOmitDialog                                         */
/*                                          mF_CAȌȗ(ڍאݒ) */
/*-------------------------------------------------------------------------*/
static Boolean selectOmitDialog(void)
{
    Boolean   ret = false;
    FormType *frm, *prevFrm;
    UInt16    status;

    // ݂̃`FbN{bNXݒƁANNsiݒϐ̊mFs
    UpdateParameter(FrmGetActiveForm(), CHKID_OMIT_DIALOG, &status);
    if ((status != 0)&&((NNshGlobal->NNsiParam)->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }


    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    frm = FrmInitForm(FRMID_OMITDIALOG_DETAIL);
    FrmSetActiveForm(frm);

    // mF_CAOȗ
    if (((NNshGlobal->NNsiParam)->confirmationDisable & (NNSH_OMITDIALOG_CONFIRM)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_CONFIRM, &status);
    }

    // x_CAO\Ȃ
    if (((NNshGlobal->NNsiParam)->confirmationDisable & (NNSH_OMITDIALOG_WARNING)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_WARNING, &status);
    }

    // _CAO\Ȃ
    if (((NNshGlobal->NNsiParam)->confirmationDisable & (NNSH_OMITDIALOG_INFORMATION)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_INFORMATION, &status);
    }

    // ڍ׃_CAO\
    if (FrmDoDialog(frm) == BTNID_OMITDIALOG_OK)
    {
        (NNshGlobal->NNsiParam)->confirmationDisable = 0;

        // mFbZ[Wȗ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_CONFIRM, &status);
        if (status != 0)
        {
            (NNshGlobal->NNsiParam)->confirmationDisable = 
                     (NNshGlobal->NNsiParam)->confirmationDisable | NNSH_OMITDIALOG_CONFIRM;
        }

        // xbZ[W\Ȃ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_WARNING, &status);
        if (status != 0)
        {
            (NNshGlobal->NNsiParam)->confirmationDisable = 
                     (NNshGlobal->NNsiParam)->confirmationDisable | NNSH_OMITDIALOG_WARNING;
        }

        // 񃁃bZ[W\Ȃ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_INFORMATION, &status);
        if (status != 0)
        {
            (NNshGlobal->NNsiParam)->confirmationDisable = 
                 (NNshGlobal->NNsiParam)->confirmationDisable | NNSH_OMITDIALOG_INFORMATION;
        }
        ret = true;
    }

    // _CAO
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(frm);
    FrmDrawForm(prevFrm);

    return (ret);
}

/*=========================================================================*/
/*   Function :   Hander_NNshSetting                                       */
/*                                     NNsiݒn()Cxgnh  */
/*=========================================================================*/
Boolean Handler_NNshSetting(EventType *event)
{
    FormType    *frm;
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3, *chkObjSub4;
    ControlType *chkObjSub5;
#ifdef USE_COLOR
    IndexedColorType color;
#endif
#ifdef USE_XML_OUTPUT
    Char        *locP;
    UInt16       bakVFS, btnId;
    EventType   *dummyEvent;
#endif
    UInt16       formID;
    Err          ret;
    void        *effectFunc;

    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        switch (event->data.menu.itemID)
        {
          case MNUID_SHOW_HELP:
            // wv̕\
            // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
            ClipboardAddItem(clipboardText, 
                             nnDA_NNSIEXT_VIEWSTART
                             nnDA_NNSIEXT_INFONAME
                             nnDA_NNSIEXT_HELPNNSISET
                             nnDA_NNSIEXT_ENDINFONAME
                             nnDA_NNSIEXT_ENDVIEW,
                             sizeof(nnDA_NNSIEXT_VIEWSTART
                                     nnDA_NNSIEXT_INFONAME
                                     nnDA_NNSIEXT_HELPNNSISET
                                     nnDA_NNSIEXT_ENDINFONAME
                                     nnDA_NNSIEXT_ENDVIEW));
            break;

          case MNUID_SHOW_RECVFILE:
            // Mf[^t@C̕\
            // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
            ClipboardAddItem(clipboardText, 
                             nnDA_NNSIEXT_VIEWSTART
                             nnDA_NNSIEXT_INFONAME
                             nnDA_NNSIEXT_FILERECVFILE
                             nnDA_NNSIEXT_ENDINFONAME
                             nnDA_NNSIEXT_ENDVIEW,
                             sizeof(nnDA_NNSIEXT_VIEWSTART
                                     nnDA_NNSIEXT_INFONAME
                                     nnDA_NNSIEXT_FILERECVFILE
                                     nnDA_NNSIEXT_ENDINFONAME
                                     nnDA_NNSIEXT_ENDVIEW));
            break;

          case MNUID_SHOW_SENDFILE:
            // Mf[^t@C̕\
            // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
            ClipboardAddItem(clipboardText, 
                             nnDA_NNSIEXT_VIEWSTART
                             nnDA_NNSIEXT_INFONAME
                             nnDA_NNSIEXT_FILESENDFILE
                             nnDA_NNSIEXT_ENDINFONAME
                             nnDA_NNSIEXT_ENDVIEW,
                             sizeof(nnDA_NNSIEXT_VIEWSTART
                                     nnDA_NNSIEXT_INFONAME
                                     nnDA_NNSIEXT_FILESENDFILE
                                     nnDA_NNSIEXT_ENDINFONAME
                                     nnDA_NNSIEXT_ENDVIEW));
            break;

          default:
            // ҏWj[s
            return (NNsh_MenuEvt_Edit(event));
            break;
        }
        // nnDAN
        (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        break;

      case keyDownEvent:
        // L[͂
        return (keyDownEvt_NNshSetting(event));
        break;

#ifdef USE_PIN_DIA
      case winDisplayChangedEvent:
        // fBXvCTCYύXCxg
        if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
            (NNshGlobal->device == NNSH_DEVICE_GARMIN))
        {
            frm = FrmGetActiveForm();
            if (HandEraResizeForm(frm) == true)
            {
                FrmDrawForm(frm);        
            }
        }
        break;
#endif

      default: 
        return (false);
        break;
    }

    effectFunc = NULL;
    formID     = FRMID_NNSI_SETTING_ABSTRACT;
    frm        = FrmGetActiveForm();

    // ɊJtH[ID̐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // "OK"{^ꂽƂ(NNsiݒʂɖ߂)
      case BTNID_CONFIG_NNSH_OK:
      case BTNID_NNSI_SET_OK:
      case BTNID_NNSISET3_OK:
      case BTNID_NNSISET4_OK:
      case BTNID_NNSISET5_OK:
      case BTNID_NNSISET6_OK:
      case BTNID_NNSISET7_OK:
      case BTNID_NNSISET8_OK:
      case BTNID_NNSISET9_OK:
        formID     = FRMID_NNSI_SETTING_ABSTRACT;
        break;

      // NNsiݒʂŁA"OK"/"Cancel"{^ꂽƂ(ꗗʂɖ߂)
      case BTNID_NNSISETA_OK:
      case BTNID_NNSISETA_CANCEL:
        formID     = NNshGlobal->backFormId;
        break;

      // "1"{^ꂽƂ
      case NNSHSET2_1:
      case NNSHSET3_1:
      case NNSHSET4_1:
      case NNSHSET5_1:
      case NNSHSET6_1:
      case NNSHSET7_1:
      case NNSHSET8_1:
      case NNSHSET9_1:
      case SELTRID_NNSISET_NNSI:
        formID     = FRMID_CONFIG_NNSH;
        break;

      // "2"{^ꂽƂ
      case NNSHSET_2:
      case NNSHSET3_2:
      case NNSHSET4_2:
      case NNSHSET5_2:
      case NNSHSET6_2:
      case NNSHSET7_2:
      case NNSHSET8_2:
      case NNSHSET9_2:
      case SELTRID_NNSISET_THREAD:
        formID     = FRMID_NNSI_SETTING2; 
        break;

      // "3"{^ꂽƂ
      case NNSHSET_3:
      case NNSHSET2_3:
      case NNSHSET4_3:
      case NNSHSET5_3:
      case NNSHSET6_3:
      case NNSHSET7_3:
      case NNSHSET8_3:
      case NNSHSET9_3:
      case SELTRID_NNSISET_BUTTON:
        formID     = FRMID_NNSI_SETTING3; 
        break;

      // "4"{^ꂽƂ
      case NNSHSET_4:
      case NNSHSET2_4:
      case NNSHSET3_4:
      case NNSHSET5_4:
      case NNSHSET6_4:
      case NNSHSET7_4:
      case NNSHSET8_4:
      case NNSHSET9_4:
      case SELTRID_NNSISET_MESSAGE:
        formID     = FRMID_NNSI_SETTING4; 
        break;

      // "5"{^ꂽƂ
      case NNSHSET_5:
      case NNSHSET2_5:
      case NNSHSET3_5:
      case NNSHSET4_5:
      case NNSHSET6_5:
      case NNSHSET7_5:
      case NNSHSET8_5:
      case NNSHSET9_5:
      case SELTRID_NNSISET_WRITE:
        formID     = FRMID_NNSI_SETTING5;
        break;

      // "6"{^ꂽƂ
      case NNSHSET_6:
      case NNSHSET2_6:
      case NNSHSET3_6:
      case NNSHSET4_6:
      case NNSHSET5_6:
      case NNSHSET7_6:
      case NNSHSET8_6:
      case NNSHSET9_6:
      case SELTRID_NNSISET_JOG:
        formID     = FRMID_NNSI_SETTING6;
        break;

      // "7"{^ꂽƂ
      case NNSHSET_7:
      case NNSHSET2_7:
      case NNSHSET3_7:
      case NNSHSET4_7:
      case NNSHSET5_7:
      case NNSHSET6_7:
      case NNSHSET8_7:
      case NNSHSET9_7:
      case SELTRID_NNSISET_DEVICE:
        formID     = FRMID_NNSI_SETTING7;
        break;

      // "8"{^ꂽƂ
      case NNSHSET_8:
      case NNSHSET2_8:
      case NNSHSET3_8:
      case NNSHSET4_8:
      case NNSHSET5_8:
      case NNSHSET6_8:
      case NNSHSET7_8:
      case NNSHSET9_8:
      case SELTRID_NNSISET_LINE:
        formID     = FRMID_NNSI_SETTING8;
        break;

      // "9"{^ꂽƂ
      case NNSHSET_9:
      case NNSHSET2_9:
      case NNSHSET3_9:
      case NNSHSET4_9:
      case NNSHSET5_9:
      case NNSHSET6_9:
      case NNSHSET7_9:
      case NNSHSET8_9:
      case SELTRID_NNSISET_COMM:
        formID     = FRMID_NNSI_SETTING9;
        break;

#ifdef USE_COLOR
      case  SELTRID_COLOR_UNKNOWN:
        color = (NNshGlobal->NNsiParam)->colorUnknown;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorUnknown = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_BACKGROUND:
        color = (NNshGlobal->NNsiParam)->colorBackGround;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorBackGround = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_OVER:
        color = (NNshGlobal->NNsiParam)->colorOver;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorOver = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NEW:
        color = (NNshGlobal->NNsiParam)->colorNew;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorNew = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_UPDATE:
        color = (NNshGlobal->NNsiParam)->colorUpdate;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorUpdate = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_REMAIN:
        color = (NNshGlobal->NNsiParam)->colorRemain;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorRemain = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ALREADY:
        color = (NNshGlobal->NNsiParam)->colorAlready;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorAlready = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NOTYET:
        color = (NNshGlobal->NNsiParam)->colorNotYet;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorNotYet = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ERROR:
        color = (NNshGlobal->NNsiParam)->colorError;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorError = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_UPDOWN:
        color = (NNshGlobal->NNsiParam)->colorButton;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            (NNshGlobal->NNsiParam)->colorButton = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_VIEWCOLOR_DETAIL:
        // QƉʂ̐Fݒ_CAO\
        setViewColorDetail();
        return (false);
        break;
#endif

      // mF_CAOȗ
      case SELTRID_OMIT_DIALOG:
        // ڍאݒ
        if (selectOmitDialog() == true)
        {
            if ((NNshGlobal->NNsiParam)->confirmationDisable != 0)
            {
                formID = 1;
            }
            else
            {
                formID = 0;
            }
            SetControlValue(FrmGetActiveForm(), CHKID_OMIT_DIALOG, &formID);
            FrmDrawForm(FrmGetActiveForm());
        }
        return (false);
        break;

      case SELTRID_HIDE1_WORDSET:
        // NG[hPݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD1,
                        (NNshGlobal->NNsiParam)->hideWord1, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_HIDE2_WORDSET:
        // NG[hQݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD2,
                        (NNshGlobal->NNsiParam)->hideWord2, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_HIDE3_WORDSET:
        // NG[hRݒ
        SetNGword3();
        return (false);
        break;

      case SELTRID_GETLOG_SEPARATOR:
        // QƃO؂ݒ
#ifdef USE_LOGCHARGE
        SetLogCharge_LogToken(0);
        return (false);
#endif // #ifdef USE_LOGCHARGE
        break;

      case SELTRID_GETLOG_DETAIL:
#ifdef USE_LOGCHARGE
        // QƃO擾ݒ
        SetLogGetURL(NNSH_ITEM_BOTTOMITEM);
        return (false);
#endif
        break;

      case SELTRID_SET_LAUNCH_WORD:
        // NpX[hݒ
        DataInputDialog(NNSH_INPUTWIN_SETPASS, (NNshGlobal->NNsiParam)->launchPass, PASSSIZE,
                        NNSH_DIALOG_USE_PASS, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_NNSISET_IMPORT:
#ifdef USE_XML_OUTPUT
        // NNsiݒOXMLt@C(NNsiSet.xml)ǂݏo
        if ((NNshGlobal->NNsiParam)->useVFS == NNSH_NOTSUPPORT_VFS)
        {
            // VFST|[g@̏ꍇA{ɓǂݏoݒs
            if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_IMPORT_XML, "", 0) == 0)
            {
                // 荞݂̎s
                ret = Input_NNsiSet_XML(FILE_XML_NNSISET);
                if (ret == errNone)
                {
                    // 荞ݐI
                    NNsh_InformMessage(ALTID_INFO, MSG_INPUT_XML_DONE, "", 0);

                    // 荞݂ꍇANNsiICxgς
                    dummyEvent = &(NNshGlobal->dummyEvent);
                    MemSet(dummyEvent, sizeof(EventType), 0x00);
                    dummyEvent->eType = appStopEvent;
                    EvtAddEventToQueue(dummyEvent);
                }
                else
                {
                    // f[^ǂݏos
                    NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", ret);
                }
            }
            // ǂݍݏIAʂJȂ
            FrmDrawForm(FrmGetActiveForm());
            break;
        }

        // ȍ~VFST|[g@̏ꍇAAA
        bakVFS = (NNshGlobal->NNsiParam)->useVFS;
        btnId = NNsh_ConfirmMessage(ALTID_CONFIRM_DATALOC, MSG_IMPORT_XML_LOC, "", 0);
        switch (btnId)
        {
          case 0:
            // VFSǂݏo(VFS{^ꂽƂ)
            if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
            {
                // NNsiݒ肪AVFSǂݏoݒɂȂĂȂꍇ
                // (VFSݒɍXV)
                (NNshGlobal->NNsiParam)->useVFS = ((NNSH_VFS_ENABLE)|
                                     (NNSH_VFS_WORKAROUND)|
                                     (NNSH_VFS_USEOFFLINE)|
                                     (NNSH_VFS_DIROFFLINE)|
                                     (NNSH_VFS_DBBACKUP));
                
            }
            locP = " (VFS)";
            break;

          case 1:
            // PalmǂݏoݒɍXV(Palm{^ꂽƂ)
            (NNshGlobal->NNsiParam)->useVFS = 0;
            locP = " (Palm)";
            break;

          default:
            // f[^ǂݏo~A֐𔲂
            NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", 0);
            return (false);
            break;
        }
        // btnIdɎ荞ݏOVFSݒL
        btnId = (NNshGlobal->NNsiParam)->useVFS;

        // 荞݂̎s
        ret = Input_NNsiSet_XML(FILE_XML_NNSISET);
        if (ret == errNone)
        {
            // 荞ݐI
            NNsh_InformMessage(ALTID_INFO, MSG_INPUT_XML_DONE, locP, 0);

            // 荞݂ꍇANNsiICxgς
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType = appStopEvent;
            EvtAddEventToQueue(dummyEvent);
        }
        else
        {
            // f[^ǂݏos
            NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, locP, 0);
        }

        // VFSݒۊǂĂlɖ߂
        // (AXML`̃f[^ǂݍ݂ŒlXVȂꍇ̂)
        if (btnId == (NNshGlobal->NNsiParam)->useVFS)
        {
            (NNshGlobal->NNsiParam)->useVFS = bakVFS;
        }
        FrmDrawForm(FrmGetActiveForm());
#endif
        // ʂJȂ
        break;

      case SELTRID_NNSISET_EXPORT:
#ifdef USE_XML_OUTPUT
        // XMLt@C`NNsiݒt@Co͂
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)
        {
            // o͐VFS
            locP = "VFS";
        }
        else
        {
            // o͐Palm
            locP = "Palm";
        }
        // {ɏo͂邩mFsB
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_EXPORT_XML, locP, 0) == 0)
        {
            // o͂̎s
            ret = Output_NNsiSet_XML(FILE_XML_NNSISET);
            if (ret == errNone)
            {
                // o͏Iʒm
                NNsh_InformMessage(ALTID_INFO, MSG_OUTPUT_XML_DONE, "", 0);
            }
            else
            {
                // G[ʒm
                NNsh_InformMessage(ALTID_ERROR, MSG_OUTPUT_XML_ERROR, " Code:", ret);
            }
        }
        FrmDrawForm(FrmGetActiveForm());
#endif
        return (false);
        break;

      case SELTRID_USE_HARDKEY_VIEW:
        // Xg̃NA
        clearFeatureList();
      
        // ꗗʋ@\Xg̐ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREVIEWMSG_STRINGS);

        // ꗗʃn[hL[ڍאݒ
        (void) SetTitleHardKey(NNSH_TITLE_HARDKEYVIEW_TITLE, MULTIVIEWBTN_FEATURE, 
                                MULTIVIEWBTN_FEATURE_MASK, &((NNshGlobal->NNsiParam)->viewFtr));

        //  ꕔn[hL[̐́ANNsiݒ̃n[hL[ݒ肪Kv
        // ƂxB
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_SETTING_HARDKEY, "", 0);
        return (true);
        break;

      case SELTRID_USE_HARDKEY_DETAIL:
        // Xg̃NA
        clearFeatureList();
      
        // ꗗʋ@\Xg̐ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREMSG_STRINGS);

        // ꗗʃn[hL[ڍאݒ
        (void) SetTitleHardKey(NNSH_TITLE_HARDKEYSET_TITLE, MULTIBTN_FEATURE, 
                                MULTIBTN_FEATURE_MASK, &((NNshGlobal->NNsiParam)->ttlFtr));

        //  ꕔn[hL[̐́ANNsiݒ̃n[hL[ݒ肪Kv
        // ƂxB
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_SETTING_HARDKEY, "", 0);
        return (true);
        break;

      case SELTRID_HARDKEY_CONTROL:
        // Xg̃NA
        clearFeatureList();

        // n[hL[ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), HARDKEY_CONTROL_STRINGS);

        // Sf[^(\) "NNsiŐ" ɂĂB
        (NNshGlobal->NNsiParam)->useKey.up      = 1;
        (NNshGlobal->NNsiParam)->useKey.down    = 1;
        (NNshGlobal->NNsiParam)->useKey.jogPush = 1;
        (NNshGlobal->NNsiParam)->useKey.jogBack = 1;

        (void) SetTitleHardKey(NNSH_HARDKEYCONTROL_TITLE, HARDKEY_FEATURE, 
                               HARDKEY_FEATURE_MASK, &((NNshGlobal->NNsiParam)->useKey));
        if (((NNshGlobal->NNsiParam)->useKey.up      != 1)||
            ((NNshGlobal->NNsiParam)->useKey.down    != 1)||
            ((NNshGlobal->NNsiParam)->useKey.jogPush != 1)||
            ((NNshGlobal->NNsiParam)->useKey.jogBack != 1))
        {
            // ݒs\ȍڂnmɂȂĂ̂ł̓NA
            NNsh_WarningMessage(ALTID_WARN, MSG_NOTSET_KEYITEM, "", 0);
        }

        // Sf[^NA
        (NNshGlobal->NNsiParam)->useKey.up      = 0;
        (NNshGlobal->NNsiParam)->useKey.down    = 0;
        (NNshGlobal->NNsiParam)->useKey.jogPush = 0;
        (NNshGlobal->NNsiParam)->useKey.jogBack = 0;

        // S̓IɃn[hL[̐̂Ȃ̂f
        if (((NNshGlobal->NNsiParam)->useKey.key1 != 0)||((NNshGlobal->NNsiParam)->useKey.key2 != 0)||
            ((NNshGlobal->NNsiParam)->useKey.key3 != 0)||((NNshGlobal->NNsiParam)->useKey.key4 != 0)||
            ((NNshGlobal->NNsiParam)->useKey.clieCapture != 0)||
            ((NNshGlobal->NNsiParam)->useKey.left != 0)||((NNshGlobal->NNsiParam)->useKey.right != 0))
        {
            // n[hL[{ݒɕύX
            (NNshGlobal->NNsiParam)->useHardKeyControl = 1;
        }
        else
        {
            // n[hL[{ȂݒɕύX
            (NNshGlobal->NNsiParam)->useHardKeyControl = 0;
        }
        // DBXVꂽ
        NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
        return (true);
        break;

      // ڍו\[hɐ؂ւꍇ
      case NNSHSET_SHOW_DETAIL:
        formID = FrmGetActiveFormID();
        // NNsiݒ(Tv)ANNsȉڍאݒ֘ÃZN^gK\
        if (formID == FRMID_NNSI_SETTING_ABSTRACT)
        {
            FrmShowObject(frm,  FrmGetObjectIndex(frm, LBL_NNSISET_DETAIL));

            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_NNSI));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_THREAD));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_BUTTON));

            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_MESSAGE));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_WRITE));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_JOG));

            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_DEVICE));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_LINE));
            FrmShowObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_COMM));
        }
        FrmDrawForm(frm);
        return (true);
        break;

      // tH[JڂȂƂ
      default:
        // ȂɂȂ
        break;
    }

    // f֐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // NNsiݒ̊m
      case BTNID_CONFIG_NNSH_OK:
      case NNSHSET_2:
      case NNSHSET_3:
      case NNSHSET_4:
      case NNSHSET_5:
      case NNSHSET_6:
      case NNSHSET_7:
      case NNSHSET_8:
      case NNSHSET_9:
        effectFunc = &effect_NNshSetting;
        break;

      // NNsiݒ-2̊m
      case BTNID_NNSI_SET_OK:
      case NNSHSET2_1:
      case NNSHSET2_3:
      case NNSHSET2_4:
      case NNSHSET2_5:
      case NNSHSET2_6:
      case NNSHSET2_7:
      case NNSHSET2_8:
      case NNSHSET2_9:
        effectFunc = &effectNNsiSetting2;
        break;

      // NNsiݒ-3̊m
      case BTNID_NNSISET3_OK:
      case NNSHSET3_1:
      case NNSHSET3_2:
      case NNSHSET3_4:
      case NNSHSET3_5:
      case NNSHSET3_6:
      case NNSHSET3_7:
      case NNSHSET3_8:
      case NNSHSET3_9:
        effectFunc = &effectNNsiSetting3;
        break;

      // NNsiݒ-4̊m
      case BTNID_NNSISET4_OK:
      case NNSHSET4_1:
      case NNSHSET4_2:
      case NNSHSET4_3:
      case NNSHSET4_5:
      case NNSHSET4_6:
      case NNSHSET4_7:
      case NNSHSET4_8:
      case NNSHSET4_9:
        effectFunc = &effectNNsiSetting4;
        break;

      // NNsiݒ-5̊m
      case BTNID_NNSISET5_OK:
      case NNSHSET5_1:
      case NNSHSET5_2:
      case NNSHSET5_3:
      case NNSHSET5_4:
      case NNSHSET5_6:
      case NNSHSET5_7:
      case NNSHSET5_8:
      case NNSHSET5_9:
        effectFunc = &effectNNsiSetting5;
        break;

      // NNsiݒ-6̊m
      case BTNID_NNSISET6_OK:
      case NNSHSET6_1:
      case NNSHSET6_2:
      case NNSHSET6_3:
      case NNSHSET6_4:
      case NNSHSET6_5:
      case NNSHSET6_7:
      case NNSHSET6_8:
      case NNSHSET6_9:
        effectFunc = &effectNNsiSetting6;
        break;

      // NNsiݒ-7̊m
      case BTNID_NNSISET7_OK:
      case NNSHSET7_1:
      case NNSHSET7_2:
      case NNSHSET7_3:
      case NNSHSET7_4:
      case NNSHSET7_5:
      case NNSHSET7_6:
      case NNSHSET7_8:
      case NNSHSET7_9:
        effectFunc = &effectNNsiSetting7;
        break;

      // NNsiݒ-8̊m
      case BTNID_NNSISET8_OK:
      case NNSHSET8_1:
      case NNSHSET8_2:
      case NNSHSET8_3:
      case NNSHSET8_4:
      case NNSHSET8_5:
      case NNSHSET8_6:
      case NNSHSET8_7:
      case NNSHSET8_9:
        effectFunc = &effectNNsiSetting8;
        break;

      // NNsiݒ-9̊m
      case BTNID_NNSISET9_OK:
      case NNSHSET9_1:
      case NNSHSET9_2:
      case NNSHSET9_3:
      case NNSHSET9_4:
      case NNSHSET9_5:
      case NNSHSET9_6:
      case NNSHSET9_7:
      case NNSHSET9_8:
        effectFunc = &effectNNsiSetting9;
        break;

      // NNsiݒ(T)̊m
      case BTNID_NNSISETA_OK:
      case SELTRID_NNSISET_COMM:
      case SELTRID_NNSISET_LINE:
      case SELTRID_NNSISET_DEVICE:
      case SELTRID_NNSISET_JOG:
      case SELTRID_NNSISET_WRITE:
      case SELTRID_NNSISET_MESSAGE:
      case SELTRID_NNSISET_BUTTON:
      case SELTRID_NNSISET_THREAD:
      case SELTRID_NNSISET_NNSI:
        effectFunc = &effectNNsiSettingA;
        break;

      // "Cancel"{^ꂽƂ
      case BTNID_CONFIG_NNSH_CANCEL:
      case BTNID_NNSI_SET_CANCEL:
      case BTNID_NNSISET3_CANCEL:
      case BTNID_NNSISET4_CANCEL:
      case BTNID_NNSISET5_CANCEL:
      case BTNID_NNSISET6_CANCEL:
      case BTNID_NNSISET7_CANCEL:
      case BTNID_NNSISET8_CANCEL:
      case BTNID_NNSISET9_CANCEL:
      case BTNID_NNSISETA_CANCEL:
        effectFunc = NULL;
        break;

      case CHKID_USE_VFS:
        // VFS؂ւݒ𔽉f
        if ((NNshGlobal->NNsiParam)->useVFS != NNSH_NOTSUPPORT_VFS)
        {
            // VFS  ON/OFF؂ւAʏVFSACeXVB
            chkObj   = FrmGetObjectPtr(frm,
                                       FrmGetObjectIndex(frm, CHKID_USE_VFS));
            chkObjSub1 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
            chkObjSub2 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
            chkObjSub3 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
            chkObjSub4 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
            chkObjSub5 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DIRMODE));
            if (CtlGetValue(chkObj) == 0)
            {
                CtlSetValue  (chkObjSub1, 0);
                CtlSetEnabled(chkObjSub1, false);
                CtlSetUsable (chkObjSub1, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetValue  (chkObjSub2, 0);
                CtlSetEnabled(chkObjSub2, false);
                CtlSetUsable (chkObjSub2, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetValue  (chkObjSub3, 0);
                CtlSetEnabled(chkObjSub3, false);
                CtlSetUsable (chkObjSub3, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));

                CtlSetValue  (chkObjSub4, 0);
                CtlSetEnabled(chkObjSub4, false);
                CtlSetUsable (chkObjSub4, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
                
                CtlSetValue  (chkObjSub5, 0);
                CtlSetEnabled(chkObjSub5, false);
                CtlSetUsable (chkObjSub5, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DIRMODE));

                FrmEraseForm (frm);
            }
            else
            {
                CtlSetEnabled(chkObjSub1, true);
                CtlSetUsable (chkObjSub1, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetEnabled(chkObjSub2, true);
                CtlSetUsable (chkObjSub2, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetEnabled(chkObjSub3, true);
                CtlSetUsable (chkObjSub3, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));

                CtlSetEnabled(chkObjSub4, true);
                CtlSetUsable (chkObjSub4, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));

                CtlSetEnabled(chkObjSub5, true);
                CtlSetUsable (chkObjSub5, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DIRMODE));
            }
            FrmDrawForm(frm);
        }
        return (false);
        break;

      case CHKID_USE_BBS_NEWURL:
        // WURL`FbN{bNXꂽABBSꗗ擾WURLɕύX
        NNshWinSetFieldText(frm, FLDID_URL_BBS, true, URL_BBSTABLE, MAX_URL);
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_NEW, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_NEWURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      case CHKID_USE_BBS_OLDURL:
        // URL`FbN{bNXꂽƂABBSꗗ擾URLɕύX
        NNshWinSetFieldText(frm,FLDID_URL_BBS,true,URL_BBSTABLE_OLD, MAX_URL);
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_OLD, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_OLDURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      default:
        // LȊO(Ȃ)
        return (false);
        break;
    }

    // ݒ肳ꂽf[^𔽉f鏈
    if (effectFunc != NULL)
    {
        ret =  ((Err (*)())effectFunc)(frm);
        if (ret != errNone)
        {
            // ݒG[(ʂ͂̂܂)
            return (false);
        }
    }

    // ʑJڂ
    closeForm_NNsiSettings(formID);
    return (false);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting7                                    */
/*                                NNsiݒ-7(foCX֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting7(FormType  *frm)
{
    ControlType *chkObj, *chkObjSub1, *chkObjSub2;
    ControlType *chkObjSub3, *chkObjSub4, *chkObjSub5;
    UInt16       dum;
#ifdef USE_TSPATCH
    UInt32       fontVer;
    Err          ret;
#endif

#ifdef USE_ARMLET
    UInt32       processorType;

    // PalmOS5p@\gp
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMlet̎gp
        SetControlValue(frm, CHKID_USE_ARMLET, &((NNshGlobal->NNsiParam)->useARMlet));
    }
    else
#endif
    {
        // ARMlet̎gpɂāAݒ荀ڎ̂ʂɕ\Ȃ
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_USE_ARMLET));
        CtlSetUsable(chkObjSub1, false);

        (NNshGlobal->NNsiParam)->useARMlet           = 0;
    }

#ifdef USE_CLIE
    // SilksȂ̕\ۃ`FbN
    if (NNshGlobal->silkVer != 0)
    {
        if (NNshGlobal->notUseSilk != 0)
        {
            dum = 1;
            SetControlValue(frm, CHKID_NOTUSE_SILK, &dum);
        }
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_NOTUSE_SILK));
        CtlSetUsable(chkObjSub1, false);
    }

    // SONYnC]sȂ
#ifdef USE_CLIE
    if ((NNshGlobal->notUseHR != 0)||(NNshGlobal->hrRef != 0))
    {
        if ((NNshGlobal->NNsiParam)->disableSonyHR != 0)
        {
            dum = 1;
        }
        else
        {
            dum = 0;
        }
        SetControlValue(frm, CHKID_NOTUSE_SONYHIRES, &dum);
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, 
                                                  CHKID_NOTUSE_SONYHIRES));
        CtlSetUsable(chkObjSub1, false);
    }

    // TsPatch@\sȂ
#ifdef USE_TSPATCH
    ret = FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT_SUPPORT, &fontVer);
    if (ret == errNone)
    {    
        if ((NNshGlobal->NNsiParam)->notUseTsPatch != 0)
        {
            dum = 1;
        }
        else
        {
            dum = 0;
        }
        SetControlValue(frm, CHKID_NOTUSE_TSPATCH, &dum);
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, 
                                                        CHKID_NOTUSE_TSPATCH));
        CtlSetUsable(chkObjSub1, false);
    }

    // gpVFS̎w
    dum = (UInt16) (NNshGlobal->NNsiParam)->vfsUseCompactFlash;
    NNshWinSetPopItems(frm, POPTRID_VFS_LOCATION, LSTID_VFS_LOCATION, dum);

    // VFS p\ɎIVFS ON
    dum = (UInt16) (NNshGlobal->NNsiParam)->vfsOnAutomatic;
    SetControlValue(frm, CHKID_VFSON_AUTOMATIC, &dum);

    // IVFS ONłDB`FbNȂ
    SetControlValue(frm, CHKID_VFSON_NOTDBCHK,&((NNshGlobal->NNsiParam)->vfsOnNotDBCheck));

    // uVFS̎gpv͂P̃p[^ŕ̈ӖLĂ邽
    chkObj     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
    chkObjSub1 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
    chkObjSub2 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
    chkObjSub3 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
    chkObjSub4 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
    chkObjSub5 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DIRMODE));
    switch ((NNshGlobal->NNsiParam)->useVFS)
    {
      // VFST|[g@̏ꍇAuVFS̎gpvݒ͕\ȂB
      case NNSH_NOTSUPPORT_VFS:
        CtlSetUsable(chkObj,     false);
        CtlSetUsable(chkObjSub1, false);
        CtlSetUsable(chkObjSub2, false);
        CtlSetUsable(chkObjSub3, false);
        CtlSetUsable(chkObjSub4, false);
        CtlSetUsable(chkObjSub5, false);
        break;

      // VFS̃`FbN
      case NNSH_VFS_DISABLE:
        CtlSetValue  (chkObj,     NNSH_VFS_DISABLE);
        CtlSetValue  (chkObjSub1, 0);
        CtlSetUsable (chkObjSub1, false);

        CtlSetValue  (chkObjSub2, 0);
        CtlSetUsable (chkObjSub2, false);

        CtlSetValue  (chkObjSub3, 0);
        CtlSetUsable (chkObjSub3, false);

        CtlSetValue  (chkObjSub4, 0);
        CtlSetUsable (chkObjSub4, false);

        CtlSetValue  (chkObjSub5, 0);
        CtlSetUsable (chkObjSub5, false);
        break;

      case NNSH_VFS_ENABLE:
      default:
        CtlSetValue  (chkObj,     NNSH_VFS_ENABLE);
        CtlSetUsable (chkObjSub1, true);
        CtlSetValue  (chkObjSub1, (NNSH_VFS_WORKAROUND & (NNshGlobal->NNsiParam)->useVFS));

        CtlSetUsable (chkObjSub2, true);
        CtlSetValue  (chkObjSub2, (NNSH_VFS_USEOFFLINE & (NNshGlobal->NNsiParam)->useVFS));

        CtlSetUsable (chkObjSub3, true);
        CtlSetValue  (chkObjSub3, (NNSH_VFS_DBBACKUP & (NNshGlobal->NNsiParam)->useVFS));

        CtlSetUsable (chkObjSub4, true);
        CtlSetValue  (chkObjSub4, (NNSH_VFS_DBIMPORT & (NNshGlobal->NNsiParam)->useVFS));

        CtlSetUsable (chkObjSub5, true);
        CtlSetValue  (chkObjSub5, (NNSH_VFS_DIROFFLINE & (NNshGlobal->NNsiParam)->useVFS));
        break;
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting8                                    */
/*                                    NNsiݒ-8(ʐM֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting8(FormType  *frm)
{
    UInt16       timeout;
    Char         numBuf[TINYBUF];

    // GZIPgpݒ
    timeout = (NNshGlobal->NNsiParam)->useGZIP;
    SetControlValue(frm, CHKID_USE_GZIP, &(timeout));

    // ProxyoRł̃ANZX
    SetControlValue(frm, CHKID_USE_PROXY, &((NNshGlobal->NNsiParam)->useProxy));

    // Proxy URL
    if ((NNshGlobal->NNsiParam)->proxyURL[0] != '\0')
    { 
        NNshWinSetFieldText(frm, FLDID_USE_PROXY, false,
                            (NNshGlobal->NNsiParam)->proxyURL, MAX_URL);
    }

    // Proxy Port #
    if ((NNshGlobal->NNsiParam)->proxyPort != 0)
    {
        MemSet (numBuf, sizeof(numBuf), 0x00);
        StrIToA(numBuf, (NNshGlobal->NNsiParam)->proxyPort);
        NNshWinSetFieldText(frm,FLDID_PROXY_PORT, false, numBuf, TINYBUF);
    }

    // tB[hɌ݂̃^CAEgl𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    if ((NNshGlobal->NNsiParam)->netTimeout == -1)
    {
        // ^CAEgȂ΁Aőlɐݒ肷
        StrIToA(numBuf, MAX_TIMEOUT_VALUE);
    }
    else
    {
        // p[^ɂ Tick܂ł̂ŏZ{ċ߂
        timeout = SysTicksPerSecond();
        timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
        StrIToA(numBuf, ((NNshGlobal->NNsiParam)->netTimeout / timeout));
    }
    NNshWinSetFieldText(frm,FLDID_COMM_TIMEOUT, false, numBuf, TINYBUF);

    // tB[hɌ݂̃obt@TCY𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, (NNshGlobal->NNsiParam)->bufferSize);
    NNshWinSetFieldText(frm,FLDID_BUFFER_SIZE,false,numBuf, TINYBUF);

    // tB[hɌ݂̕擾TCY𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, (NNshGlobal->NNsiParam)->partGetSize);
    NNshWinSetFieldText(frm,FLDID_DL_PARTSIZE,false,numBuf, TINYBUF);


    // tB[hɒʐM^CAEggC񐔂𔽉f
    MemSet (numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, (NNshGlobal->NNsiParam)->nofRetry);
    NNshWinSetFieldText(frm,FLDID_TIMEOUT_RETRY,false,numBuf,sizeof(numBuf));

    // _E[hwʂɔf
    SetControlValue(frm, CHKID_DL_PART, &((NNshGlobal->NNsiParam)->enablePartGet));

    // BBSꗗ㏑
    SetControlValue(frm, CHKID_BBS_OVERWRITE, &((NNshGlobal->NNsiParam)->bbsOverwrite));

    // BBSꗗ擾URL̐ݒ
    NNshWinSetFieldText(frm, FLDID_URL_BBS, true, (NNshGlobal->NNsiParam)->bbs_URL, MAX_URL);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting5                                    */
/*                                NNsiݒ-5(݉)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting5(FormType  *frm)
{
    UInt16       item;
    ControlType  *objP;
    Char         numBuf[TINYBUF];

    // ݉ʏIXŕۑ
    SetControlValue(frm, CHKID_WRITE_AUTOSAVE,
                                       &((NNshGlobal->NNsiParam)->writeMessageAutoSave));

    // ݎPUSH{^𖳌
    item = (NNshGlobal->NNsiParam)->writeJogPushDisable;
    SetControlValue(frm, CHKID_WRITEPUSH_DISABLE, &(item));

    // MCookiegpď
    SetControlValue(frm, CHKID_WRITE_USE_COOKIE, &((NNshGlobal->NNsiParam)->useCookieWrite));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    item = (NNshGlobal->NNsiParam)->notAutoFocus;
    SetControlValue(frm, CHKID_NOT_AUTOFOCUSSET, &item);

#ifdef USE_CLIE
    // SilksȂ̕\ۃ`FbN
    if (NNshGlobal->silkVer != 0)
    {
        // ݎAVNg債Ȃ
        item = (NNshGlobal->NNsiParam)->notOpenSilkWrite;
        SetControlValue(frm, CHKID_NOTSILK_WRITE, &item);
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        objP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_NOTSILK_WRITE));
        CtlSetUsable(objP, false);
    }

    // ݎAA_[COFFɂ
    SetControlValue(frm, CHKID_UNDERLINE_WRITE,
                    &((NNshGlobal->NNsiParam)->disableUnderlineWrite));

    // ݎQƃXԍ}
    SetControlValue(frm, CHKID_INSERT_REPLYNUM, &((NNshGlobal->NNsiParam)->insertReplyNum));

    // ݃V[PXPART2
    SetControlValue(frm, CHKID_WRITE_SEQUENCE2, &((NNshGlobal->NNsiParam)->writeSequence2));

    // sage
    SetControlValue(frm, CHKID_WRITE_SAGE,  &((NNshGlobal->NNsiParam)->writeAlwaysSage));

    // Ren@\gpݒʂɔf
    SetControlValue(frm, CHKID_FIXED_HANDLE, &((NNshGlobal->NNsiParam)->useFixedHandle));

    // nh̐ݒ
    if ((NNshGlobal->NNsiParam)->handleName[0] != '\0')
    { 
      NNshWinSetFieldText(frm, FLDID_HANDLENAME, false,
                            (NNshGlobal->NNsiParam)->handleName, BUFSIZE);
    }

    // tB[hɏ݃obt@TCY
    MemSet (numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, (NNshGlobal->NNsiParam)->writeBufferSize);
    NNshWinSetFieldText(frm,FLDID_WRITEBUF_SIZE, true, numBuf, TINYBUF);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting6                                    */
/*                                  NNsiݒ-6(WO֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting6(FormType  *frm)
{
    UInt16 item;

    // QƎJumpListɁuꗗցv
    SetControlValue(frm, CHKID_ADD_RTNTOLIST, &((NNshGlobal->NNsiParam)->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    SetControlValue(frm,CHKID_ADD_BACKMESSAGE,&((NNshGlobal->NNsiParam)->addMenuBackRtnMsg));

    // QƎJumpListɁuj[v
    SetControlValue(frm, CHKID_ADD_OPENMENU, &((NNshGlobal->NNsiParam)->addMenuMsg));

    // QƎJumpListɁu擾v
    SetControlValue(frm, CHKID_ADD_GETPART, &((NNshGlobal->NNsiParam)->addLineGetPart));

    // QƎJumpListɁuؒfv
    SetControlValue(frm, CHKID_ADD_LINEDISCONN, &((NNshGlobal->NNsiParam)->addLineDisconn));

    // QƎJumpListɐ擪
    SetControlValue(frm, CHKID_ADD_JUMPTOP, &((NNshGlobal->NNsiParam)->addJumpTopMsg));

    // QƎJumpListɖ
    SetControlValue(frm, CHKID_ADD_JUMPBOTTOM, &((NNshGlobal->NNsiParam)->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    SetControlValue(frm, CHKID_ADD_OPENWEB, &((NNshGlobal->NNsiParam)->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    SetControlValue(frm, CHKID_ADD_GRAPHVIEW, &((NNshGlobal->NNsiParam)->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    SetControlValue(frm, CHKID_ADD_FAVORITE, &((NNshGlobal->NNsiParam)->addMenuFavorite));

    // QƎJumpListɃo
    SetControlValue(frm,CHKID_ADD_OUTPUTMEMO,&((NNshGlobal->NNsiParam)->addMenuOutputMemo));

    // ꗗMenuɃj[ǉ
    item = (NNshGlobal->NNsiParam)->addMenuTitle;
    SetControlValue(frm, CHKID_ADD_MENUOPEN, &item);

    // ꗗMenuɎQCOPY
    SetControlValue(frm, CHKID_ADD_MENUCOPY, &(NNshGlobal->NNsiParam)->addMenuCopyMsg);

    // ꗗMenuMSG폜
    SetControlValue(frm, CHKID_ADD_MENUDELETE, &(NNshGlobal->NNsiParam)->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    SetControlValue(frm,CHKID_ADD_MENUGRAPHMODE,&(NNshGlobal->NNsiParam)->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    SetControlValue(frm, CHKID_ADD_MENUMULTISW1, &(NNshGlobal->NNsiParam)->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    SetControlValue(frm, CHKID_ADD_MENUMULTISW2, &(NNshGlobal->NNsiParam)->addMenuMultiSW2);

    // ꗗMenuNNsiI
    SetControlValue(frm, CHKID_ADD_NNSIEND, &(NNshGlobal->NNsiParam)->addMenuNNsiEnd);

    // ꗗMenuɃfoCX
    SetControlValue(frm, CHKID_ADD_MENUDEVICEINFO, &(NNshGlobal->NNsiParam)->addMenuDeviceInfo);

    // QƎMenuɃfoCX
    SetControlValue(frm, CHKID_ADD_DEVICEINFO, &(NNshGlobal->NNsiParam)->addDeviceInfo);

    // ꗗMenuDirI
    SetControlValue(frm, CHKID_ADD_MENUDIRSELECT, &(NNshGlobal->NNsiParam)->addMenuDirSelect);

    // MenuBt On/Off\
    item = (NNshGlobal->NNsiParam)->addBtOnOff;
    SetControlValue(frm, CHKID_ADD_BT_ONOFF, &item);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNshSetting                                     */
/*                                      NNsiݒ(NNsi)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNshSetting(FormType *frm)
{
    ControlType *ctlObj;
    ListType    *lstP;
    UInt16       item;
    Char        *ptr;

    // QƃOփRs[ƂAɃX폜{
    SetControlValue(frm, CHKID_COPYDEL_READONLY,&((NNshGlobal->NNsiParam)->copyDelReadOnly));


    // URL擾AL`FbNȂ
    SetControlValue(frm, CHKID_NOTCHECK_BBSURL,&((NNshGlobal->NNsiParam)->notCheckBBSURL));

    // ړɖ擾X폜
    SetControlValue(frm, CHKID_AUTODEL_NOT_YET,&((NNshGlobal->NNsiParam)->autoDeleteNotYet));

    // Ji𔼊pSpϊ
    SetControlValue(frm,CHKID_CONVERT_HANZEN, &((NNshGlobal->NNsiParam)->convertHanZen));

    // OfflineXɃX{Ȃ
    item = (NNshGlobal->NNsiParam)->notDelOffline;
    SetControlValue(frm, CHKID_NOT_DELOFFLINE, &item);

    // Cɓ\ŒXx̃xݒ(ƃXgACeݒ)
    switch ((NNshGlobal->NNsiParam)->displayFavorLevel)
    {
      case NNSH_MSGATTR_FAVOR_L2:
        item = 1;
        ptr  = NNSH_ATTRLABEL_FAVOR_L2;
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        item = 2;
        ptr  = NNSH_ATTRLABEL_FAVOR_L3;
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        item = 3;
        ptr  = NNSH_ATTRLABEL_FAVOR_L4;
        break;

      case NNSH_MSGATTR_FAVOR:
        item = 4;
        ptr  = NNSH_ATTRLABEL_FAVOR;
        break;

      case NNSH_MSGATTR_FAVOR_L1:
      default:
        item = 0;
        ptr  = NNSH_ATTRLABEL_FAVOR_L1;
        break;
    }

    ctlObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_FAVOR_LEVEL));
    CtlSetLabel(ctlObj, ptr);

    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    LstSetSelection(lstP, item);
    LstSetTopItem  (lstP, item);


    /***  NNshݒ(O[oϐ)f  ***/

    // mFbZ[Wȗ
    SetControlValue(frm, CHKID_OMIT_DIALOG, &((NNshGlobal->NNsiParam)->confirmationDisable));

    // ɁA啶ʂȂ
    SetControlValue(frm, CHKID_SEARCH_CASELESS, &((NNshGlobal->NNsiParam)->searchCaseless));

    // NOfflineX
    SetControlValue(frm, CHKID_OFFCHK_LAUNCH,   &((NNshGlobal->NNsiParam)->offChkLaunch));

    // i-modepURLgp
    SetControlValue(frm, CHKID_USE_IMODEURL, &((NNshGlobal->NNsiParam)->useImodeURL));

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting2                                    */
/*                                    NNsiݒ-2(ꗗ)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting2(FormType  *frm)
{
    UInt16       item;
    ControlType *ctlObj;

    // Xꗗ(subject.txt)S擾
    SetControlValue(frm, CHKID_SUBJECT_ALL, &((NNshGlobal->NNsiParam)->getAllThread));

    // Xꗗʂtiny/smalltHggp
    SetControlValue(frm,CHKID_CLIE_USE_TITLE,
                                     &((NNshGlobal->NNsiParam)->useSonyTinyFontTitle));

    // X^CgdȂ
    SetControlValue(frm, CHKID_CHECK_DUPLICATE,&((NNshGlobal->NNsiParam)->checkDuplicateThread));

    // XꗗMSG
    SetControlValue(frm, CHKID_PRINT_NOFMSG,&((NNshGlobal->NNsiParam)->printNofMessage));

    // Xꗗɕ\MSG͖ǐ
    item = (NNshGlobal->NNsiParam)->listMesNumIsNotReadNum;
    SetControlValue(frm, CHKID_PRINT_NOFNOTREAD,&(item));

    // 擾ςݑSĂɂ͎QƃO\Ȃ
    item = (NNshGlobal->NNsiParam)->notListReadOnly;
    SetControlValue(frm, CHKID_NOT_READONLY, &(item));

    // ǂɂ͎QƃO\Ȃ
    item = (NNshGlobal->NNsiParam)->notListReadOnlyNew;
    SetControlValue(frm, CHKID_NOT_READONLY_NEW, &(item));

    // X擾ɃXQ
    SetControlValue(frm, CHKID_OPEN_AUTO,   &((NNshGlobal->NNsiParam)->openAutomatic));


#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        SetControlValue(frm, CHKID_USE_COLORMODE, &((NNshGlobal->NNsiParam)->useColor));

        // {́AZN^gK̃LvVɐF...
        // i悭킩̂ŏȗj
    }
    else
#endif
    {
        (NNshGlobal->NNsiParam)->useColor = 0;

        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        FrmCopyLabel(frm, LBL_SEL_COLOR, "  ");

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_COLORMODE));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, SELTRID_COLOR_UNKNOWN));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                            FrmGetObjectIndex(frm, SELTRID_COLOR_BACKGROUND));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_OVER));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NEW));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_UPDATE));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_REMAIN));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, SELTRID_COLOR_ALREADY));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NOTYET));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_ERROR));
        CtlSetUsable(ctlObj, false);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting3                                    */
/*                                  NNsiݒ-3(ꗗ{^)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting3(FormType  *frm)
{
    UInt16       selItem;

    // ꗗʋ@\Xg̐ݒ
    createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREMSG_STRINGS);

    // ݂̃tH[ւ̃|C^擾
    frm = FrmGetActiveForm();

    // ړIXCb`P(ꗗ)̃xݒ(ƃXgACeݒ)
    selItem = 
             (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch1 & (NNSH_SWITCHUSAGE_FUNCMASK);
    NNshWinSetPopItems(frm, POPTRID_LIST_FUNCSW1, LSTID_TITLE_FUNCSW1, selItem);

    // ړIXCb`Q(ꗗ)̃xݒ(ƃXgACeݒ)
    selItem = 
             (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2 & (NNSH_SWITCHUSAGE_FUNCMASK);
    NNshWinSetPopItems(frm, POPTRID_LIST_FUNCSW2,LSTID_TITLE_FUNCSW2,selItem);

    // ړI{^P̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn1Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN1, LSTID_MULTIBTN1,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN1, false,
                        (NNshGlobal->NNsiParam)->multiBtn1Caption, MAX_CAPTION);

    // ړI{^Q̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn2Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN2, LSTID_MULTIBTN2,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN2, false,
                        (NNshGlobal->NNsiParam)->multiBtn2Caption, MAX_CAPTION);

    // ړI{^R̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn3Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN3, LSTID_MULTIBTN3,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN3, false,
                        (NNshGlobal->NNsiParam)->multiBtn3Caption, MAX_CAPTION);

    // ړI{^S̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn4Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN4, LSTID_MULTIBTN4,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN4, false,
                        (NNshGlobal->NNsiParam)->multiBtn4Caption, MAX_CAPTION);

    // ړI{^T̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn5Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN5, LSTID_MULTIBTN5,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN5, false,
                        (NNshGlobal->NNsiParam)->multiBtn5Caption, MAX_CAPTION);

    // ړI{^U̐ݒʂɔf
    selItem = ((NNshGlobal->NNsiParam)->multiBtn6Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN6, LSTID_MULTIBTN6,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN6, true,
                        (NNshGlobal->NNsiParam)->multiBtn6Caption, MAX_CAPTION);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting9                                    */
/*                                   NNsiݒ-9(V/)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting9(FormType  *frm)
{
    Err          ret;
    UInt16       lp;
    ControlType *chkObj;

    // NNsiIɉؒf
    SetControlValue(frm, CHKID_END_OFFLINE, &((NNshGlobal->NNsiParam)->disconnectNNsiEnd));

    // uVmFvIɉؒf
    SetControlValue(frm,CHKID_DISCONN_ARRIVAL,&((NNshGlobal->NNsiParam)->disconnArrivalEnd));

    // uVmFvIɖǈꗗ\
    lp = (NNshGlobal->NNsiParam)->autoOpenNotRead;
    SetControlValue(frm, CHKID_ARRIVAL_NOTREAD, &(lp));

    // uVmFvODAN
    lp = (NNshGlobal->NNsiParam)->preOnDAnewArrival;
    SetControlValue(frm, CHKID_PREPARE_DA, &(lp));

    //  NNsiNɃ}Ns
#ifdef USE_MACRO
    lp = (NNshGlobal->NNsiParam)->autostartMacro;
    SetControlValue(frm, CHKID_AUTOSTARTMACRO, &(lp));
#else
    // }N@\LłȂꍇɂ̓ACe
    CtlSetUsable(FrmGetObjectPtr(frm, 
                         FrmGetObjectIndex(frm, CHKID_AUTOSTARTMACRO)), false);
#endif

    // uVmFvIɃr[v炷
    lp = (NNshGlobal->NNsiParam)->autoBeep;
    SetControlValue(frm, CHKID_DONE_BEEP, &(lp));

    // ڑ͎擾\
    SetControlValue(frm,CHKID_GETRESERVEFEATURE,&(NNshGlobal->NNsiParam)->getReserveFeature);

    // ڑʂĕ`
    SetControlValue(frm,CHKID_REDRAW_CONNECT,&((NNshGlobal->NNsiParam)->redrawAfterConnect));

    // ܂BBS/@JBBSVmF
    lp = (NNshGlobal->NNsiParam)->enableNewArrivalHtml;
    SetControlValue(frm, CHKID_HTMLBBS_ENABLE, &(lp));

    // VG[ɂȂ΍Ď擾
    SetControlValue(frm, CHKID_ALLUPDATE_ABORT,
                                             &((NNshGlobal->NNsiParam)->autoUpdateGetError));

    // ꗗ擾ɐVmF
    SetControlValue(frm, CHKID_UPDATEMSG_LIST, &((NNshGlobal->NNsiParam)->listAndUpdate));

    // VmFɃ[`FbN
    if (CheckInstalledResource_NNsh('DAcc', 'cMDA') == false)
    {
        // cMDACXg[ĂȂꍇɂ́Aݒ荀ڂ
        CtlSetUsable(FrmGetObjectPtr(frm, 
                         FrmGetObjectIndex(frm, CHKID_cMDA_EXECUTE)), false);
    }
    else
    {
        // ݒʂɔf
        SetControlValue(frm, CHKID_cMDA_EXECUTE, &((NNshGlobal->NNsiParam)->use_DAplugin));
    }

    // BBSꗗ̍쐬
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret == errNone)
    {
        // BBSꗗ̃XgԂ𔽉fB
        NNshWinSetListItems(frm, LSTID_CHECK_NEWARRIVAL,
                            NNshGlobal->bbsTitles, lp,
                            (NNshGlobal->NNsiParam)->newArrivalNotRead,
                            &(NNshGlobal->bbsTitleH), NULL);

        // |bvAbvgK̃x(XgԂɍ킹)XV
        NNshWinSetPopItems(frm, POPTRID_NEWARRIVAL, LSTID_CHECK_NEWARRIVAL,
                           (NNshGlobal->NNsiParam)->newArrivalNotRead);
    }


    // WebBrowserJƂŐV50
    if (NNshGlobal->browserCreator != 0)
    {
        if ((NNshGlobal->NNsiParam)->browseMesNum != 0)
        {
            lp = 1;
            SetControlValue(frm, CHKID_WEBBROWSE_LAST50, &lp);
        }
    }
    else
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObj = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_WEBBROWSE_LAST50));
        CtlSetUsable(chkObj, false);
    }

#ifdef USE_LOGCHARGE
    // QƃO擾x̐ݒ(|bvAbvgK̃xXV)
    lp = (NNshGlobal->NNsiParam)->getROLogLevel;
    NNshWinSetPopItems(frm, POPTRID_CHECK_READONLY, LSTID_CHECK_READONLY, lp);

#else
    // O`[W@\gpȂꍇ́Aڂ\Ȃ
    chkObj = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, SELTRID_GETLOG_DETAIL));
    CtlSetUsable(chkObj, false);

    chkObj = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, SELTRID_GETLOG_SEPARATOR));
    CtlSetUsable(chkObj, false);

    chkObj = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, POPTRID_CHECK_READONLY));
    CtlSetUsable(chkObj, false);

#endif
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting4                                    */
/*                                    NNsiݒ-4(QƉ)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting4(FormType  *frm)
{
    Char         numBuf[TINYBUF];
    UInt16       item;

    // X
    if ((NNshGlobal->NNsiParam)->msgNumLimit != 0)
    {
        MemSet (numBuf, sizeof(numBuf), 0x00);
        StrIToA(numBuf, (NNshGlobal->NNsiParam)->msgNumLimit);
        NNshWinSetFieldText(frm, FLDID_RESNUM_SIZE, false, numBuf, TINYBUF);
    }

    // RAW\[h
    item = (NNshGlobal->NNsiParam)->rawDisplayMode;
    SetControlValue(frm, CHKID_USE_RAWDISPLAY, &item);

    // ݒ@\gp
    SetControlValue(frm, CHKID_USE_BOOKMARK,&((NNshGlobal->NNsiParam)->useBookmark));

    // Xԍyzɂ
    SetControlValue(frm, CHKID_BOLD_MSGNUM, &((NNshGlobal->NNsiParam)->boldMessageNum));

    // QƎOtBbN`惂[hgp
    SetControlValue(frm,CHKID_CLIE_USE_TINYFONT,&((NNshGlobal->NNsiParam)->useSonyTinyFont));

    // QƎA_[COFF
    SetControlValue(frm, CHKID_MSG_LINEOFF, &((NNshGlobal->NNsiParam)->disableUnderline));

    // PUSH ON_CŁ}P
    SetControlValue(frm, CHKID_NOT_CURSOR, &((NNshGlobal->NNsiParam)->notCursor));

    // XQƉʂŃJ[\\Ȃ
    SetControlValue(frm, CHKID_NOT_FOCUSSET_NUM,
                                               &((NNshGlobal->NNsiParam)->notFocusNumField));

    // QƎX][ŕ\
    SetControlValue(frm,CHKID_BLOCK_DISP_MODE, &((NNshGlobal->NNsiParam)->blockDispMode));

    // QƎOɈړőOX
    SetControlValue(frm, CHKID_DISPLAY_BOTTOMMES, &((NNshGlobal->NNsiParam)->dispBottom));

    // NGmF(NG1, 2)
    if (((NNshGlobal->NNsiParam)->hideMessage & NNSH_USE_NGWORD1AND2) == NNSH_USE_NGWORD1AND2)
    {
        item = 1;
    }
    else
    {
        item = 0;
    }
    SetControlValue(frm, CHKID_HIDE_MESSAGE, &item);

    // NGmF(NG3)
    if (((NNshGlobal->NNsiParam)->hideMessage & NNSH_USE_NGWORD3) == NNSH_USE_NGWORD3)
    {
        item = 1;
    }
    else
    {
        item = 0;
    }
    SetControlValue(frm, CHKID_HIDE3_MESSAGE, &item);

    // NG[hݒŐK\gp
    SetControlValue(frm, CHKID_USE_REGEXPRESS,
                                        &((NNshGlobal->NNsiParam)->useRegularExpression));

#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        // SetControlValue(frm, CHKID_USE_COLORMODE, &((NNshGlobal->NNsiParam)->useColor));

        // {́AZN^gK̃LvVɐF...
        // i悭킩̂ŏȗj
    }
    else
#endif
    {
        (NNshGlobal->NNsiParam)->useColor = 0;
    }

    // Xg̃NA
    clearFeatureList();
      
    // QƉʋ@\Xg̐ݒ
    createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREVIEWMSG_STRINGS);

    // @\ꗗXgbN(x̃ZN^gK)
    NNshWinSetPopItemsWithList(frm, POPTRID_LVLSELTRIG, LSTID_LVLSELTRIG,
                               NNshGlobal->featureList, 
                               (NNshGlobal->NNsiParam)->viewMultiBtnFeature);

    // @\ꗗXgbN(x̃ZN^gK)
    NNshWinSetPopItemsWithList(frm, POPTRID_TTLSELTRIG, LSTID_TTLSELTRIG,
                               NNshGlobal->featureList, 
                               (NNshGlobal->NNsiParam)->viewTitleSelFeature);
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSettingA                                    */
/*                                          NNsiݒ(T)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSettingA(FormType  *frm)
{
    ControlType *ctlObj;
    UInt16       item;

#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        SetControlValue(frm, CHKID_USE_TITLE_COLOR, &((NNshGlobal->NNsiParam)->useColor));
    }
    else
#endif
    {
        // J[̐ݒ͕\Ȃ
        (NNshGlobal->NNsiParam)->useColor = 0;
        ctlObj = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_USE_TITLE_COLOR));
        CtlSetUsable(ctlObj, false);
    }

#ifdef USE_XML_OUTPUT
#else
    // XML`o͂Ȃꍇ́ANNsiݒ Import/Exportw͕\ȂB
    FrmHideObject(frm, FrmGetObjectIndex(frm, LBL_NNSISET_XML));

    ctlObj = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm, SELTRID_NNSISET_IMPORT));
    CtlSetUsable(ctlObj, false);

    ctlObj = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm, SELTRID_NNSISET_EXPORT));
    CtlSetUsable(ctlObj, false);
#endif

    // DEBUG
    SetControlValue(frm, CHKID_DEBUG_DIALOG,&((NNshGlobal->NNsiParam)->debugMessageON));

    // Xꗗ(subject.txt)S擾
    SetControlValue(frm, CHKID_SUBJECT_ALL, &((NNshGlobal->NNsiParam)->getAllThread));

    // VFS p\ɎIVFS ON
    item = (UInt16) (NNshGlobal->NNsiParam)->vfsOnAutomatic;
    SetControlValue(frm, CHKID_VFSON_AUTOMATIC, &item);

    // QƎX][ŕ\
    SetControlValue(frm,CHKID_BLOCK_DISP_MODE, &((NNshGlobal->NNsiParam)->blockDispMode));

    // ڑ͎擾\
    SetControlValue(frm,CHKID_GETRESERVEFEATURE,&(NNshGlobal->NNsiParam)->getReserveFeature);

    // ܂BBS/@JBBSVmF
    item = (NNshGlobal->NNsiParam)->enableNewArrivalHtml;
    SetControlValue(frm, CHKID_HTMLBBS_ENABLE, &(item));

    // mFbZ[Wȗ
    SetControlValue(frm, CHKID_OMIT_DIALOG, &((NNshGlobal->NNsiParam)->confirmationDisable));

    // gpVFS̎w
    item = (UInt16) (NNshGlobal->NNsiParam)->vfsUseCompactFlash;
    NNshWinSetPopItems(frm, POPTRID_VFS_LOCATION, LSTID_VFS_LOCATION, item);

#ifdef USE_USERTAB_DETAIL
         // Ȃ...
#else
    if ((NNshGlobal->NNsiParam)->debugMessageON == 0)
    {
        // NNsȉڍאݒ֘ÃZN^gK\Ȃ
        FrmHideObject(frm,  FrmGetObjectIndex(frm, LBL_NNSISET_DETAIL));

        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_NNSI));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_THREAD));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_BUTTON));

        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_MESSAGE));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_WRITE));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_JOG));

        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_DEVICE));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_LINE));
        FrmHideObject(frm,  FrmGetObjectIndex(frm, SELTRID_NNSISET_COMM));
    }
#endif  // #ifdef USE_USERTAB_DETAIL

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   closeForm_FavorTabSet                                    */
/*                                    Cɓݒ̃tH[ */
/*-------------------------------------------------------------------------*/
static void closeForm_FavorTabSet(UInt16 nextForm)
{
    if (NNshGlobal->listHandle != 0)
    {
        MemHandleUnlock(NNshGlobal->listHandle);
        MemHandleFree  (NNshGlobal->listHandle);
        NNshGlobal->listHandle = 0;
    }
    FrmGotoForm(nextForm);
    return;
}

/*=========================================================================*/
/*   Function :   OpenForm_FavorTabSet                                     */
/*                                      Cɓݒ̃tH[J */
/*=========================================================================*/
Err OpenForm_FavorTabSet(FormType *frm)
{
    Err            ret;
    Char          *ptr;
    UInt16         status, lp, bbsCond, thLevel, thrCond, allCond;
    NNshCustomTab *customTab;

    switch (NNshGlobal->jumpSelection)
    {
      case MULTIBTN_FEATURE_USER1TAB:
        lp        = PBTNID_FAVORSET_TAB1;
        customTab = &((NNshGlobal->NNsiParam)->custom1);
        break;

      case MULTIBTN_FEATURE_USER2TAB:
        lp        = PBTNID_FAVORSET_TAB2;
        customTab = &((NNshGlobal->NNsiParam)->custom2);
        break;

      case MULTIBTN_FEATURE_USER3TAB:
        lp        = PBTNID_FAVORSET_TAB3;
        customTab = &((NNshGlobal->NNsiParam)->custom3);
        break;

      case MULTIBTN_FEATURE_USER4TAB:
        lp        = PBTNID_FAVORSET_TAB4;
        customTab = &((NNshGlobal->NNsiParam)->custom4);
        break;

      case MULTIBTN_FEATURE_USER5TAB:
      default:
        lp        = PBTNID_FAVORSET_TAB5;
        customTab = &((NNshGlobal->NNsiParam)->custom5);
        break;
    }

    // [U^u(vbV{^)ݒ
    status = 1;
    SetControlValue(frm, lp, &status);

    // f[^̒o
    thLevel = customTab->threadLevel & NNSH_THREADLEVEL_MASK;
    thrCond = 
      (customTab->threadLevel & NNSH_THREADCOND_MASK) >> NNSH_THREADCOND_SHIFT;
    allCond = customTab->condition & NNSH_CONDITION_ALL;
    bbsCond = customTab->boardCondition;

    // QƃO͏O
    status  = customTab->condition & NNSH_CONDITION_NOTREADONLY;
    if (status != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_NOT_READONLY, &status);
    }

    // [U^utB[hɔf
    NNshWinSetFieldText(frm, FLDID_FAVORSET_TABTITLE, false,
                        customTab->tabName, StrLen(customTab->tabName));

    // BBSꗗ̍쐬
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret == errNone)
    {
        // BBSꗗ̃XgԂ𔽉fB(VmF{^u)
        NNshWinSetListItems(frm, LSTID_FAVORSET_CHECKNEW,
                            NNshGlobal->bbsTitles, lp,
                            customTab->newArrival, 
                            &(NNshGlobal->listHandle),
                            &ptr);

        NNshWinSetPopItems(frm, POPTRID_FAVORSET_CHECKNEW,
                           LSTID_FAVORSET_CHECKNEW, customTab->newArrival);

        // BBSꗗ̃XgԂ𔽉fB(ꗗ擾^u)
        NNshWinUpdateListItems(frm, LSTID_FAVORSET_GETLIST, ptr, lp,
                               customTab->getList);

        NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETLIST,
                           LSTID_FAVORSET_GETLIST, customTab->getList);


        // BBSꗗ̃XgԂ𔽉fB(ݒ^u)
        NNshWinUpdateListItems(frm, LSTID_FAVORSET_BBSNICK, ptr, lp,
                               customTab->boardNick);

        NNshWinSetPopItems(frm, POPTRID_FAVORSET_BBSNICK,
                           LSTID_FAVORSET_BBSNICK, customTab->boardNick);
    }

    // ݒ̏l𔽉f
    if (bbsCond != 0)
    {
        // ݒ̃`FbN߂
        SetControlValue(frm, CHKID_FAVORSET_BBSNICK, &(bbsCond));
        bbsCond--;
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_BBSNICK_SET,
                           LSTID_FAVORSET_BBSNICK_SET, bbsCond);
    }

    status = 1;
    if (thrCond != 0)
    {
        // Xx̃`FbN{bNXf
        SetControlValue(frm, CHKID_FAVORSET_LEVEL, &(status));

        // Xx̏f
        thrCond--;
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_LVL_SET, 
                           LSTID_FAVORSET_LVL_SET, thrCond);
    }

    // Xx̔f
    switch (thLevel)
    {
      case NNSH_MSGATTR_FAVOR_L1:
        SetControlValue(frm, PBTNID_FAVORSET_LVL1, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L2:
        SetControlValue(frm, PBTNID_FAVORSET_LVL2, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        SetControlValue(frm, PBTNID_FAVORSET_LVL3, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        SetControlValue(frm, PBTNID_FAVORSET_LVL4, &(status));
        break;

      case NNSH_MSGATTR_FAVOR:
        SetControlValue(frm, PBTNID_FAVORSET_LVL5, &(status));
        break;

      case NNSH_MSGATTR_NOTFAVOR:
      default:
        // wȂ
        SetControlValue(frm, PBTNID_FAVORSET_LVL0, &(status));
        break;
    }

    // AND/ORݒ
    NNshWinSetPopItems(frm, POPTRID_FAVORSET_CONDITIONSET,
                       LSTID_FAVORSET_CONDITIONSET, allCond);

    // Oʒu̎w
    status = (customTab->condition & NNSH_CONDITION_LOGLOC_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_LOGLOC_PALM)
        {
            // Palm
            allCond = 0;
        }
        else
        {
            // VFS
            allCond = 1;
        }

        // Oʒũ`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_LOGLOC, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_LOGLOC_SET,
                           LSTID_FAVORSET_LOGLOC_SET, allCond);
    }

    // 擾G[̐ݒ
    status = (customTab->condition & NNSH_CONDITION_GETERR_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_GETERR_NONE)
        {
            // G[Ȃ
            allCond = 0;
        }
        else
        {
            // G[
            allCond = 1;
        }

        // Oʒũ`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETERROR, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETERROR_SET,
                           LSTID_FAVORSET_GETERROR_SET, allCond);
    }

    // 擾ۗ̐ݒ
    status = (customTab->condition & NNSH_CONDITION_GETRSV_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_GETRSV_RSV)
        {
            // 擾ۗX
            allCond = 0;
        }
        else
        {
            // 擾ۗX
            allCond = 1;
        }

        // 擾ۗ̃`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETRESERVE, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETRESERVE_SET,
                           LSTID_FAVORSET_GETRESERVE_SET, allCond);
    }

    // XԂ̃`FbN{bNXݒ
    if ((customTab->threadStatus != 0)||(customTab->threadCreate))
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETSTATUS, &(status));
    }
    // XԂ̃`FbN{bNXݒ
    if ((customTab->stringSet & NNSH_STRING_SELECTION) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_TITLESET, &(status));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   Hander_FavorTabSet                                       */
/*                                     CɓݒCxgnh  */
/*=========================================================================*/
Boolean Handler_FavorTabSet(EventType *event)
{
    UInt16         btnId, status, keyId;
    MemHandle      txtH;
    Char          *ptr, numBuf[TINYBUF];
    FormType      *frm, *diagFrm;
    NNshCustomTab *custom;
    ListType      *lstP;
    FieldType     *fldP;

    // {^`FbNȊÕCxg͑߂
    keyId = 0;
    switch (event->eType)
    { 
      case ctlSelectEvent:
        // {^ꂽ(֐i)
        keyId = event->data.ctlSelect.controlID;
        break;

      case keyDownEvent:
        // L[͂ꂽ(֐i)
        switch (KeyConvertFiveWayToJogChara(event))
        {
          // n[hL[̏
          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrThumbWheelDown:
          case chrRightArrow:
          case vchrJogRight:
            keyId = chrRightArrow;
            break;

          // n[hL[̏
          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrThumbWheelUp:
          case chrLeftArrow:
          case vchrJogLeft:
            keyId = chrLeftArrow;
            break;

          // obN{^/ESCL[/BSL[Ƃ̏
          // case chrBackspace:
          case vchrJogBack:
          case chrEscape:
          case vchrThumbWheelBack:
          case vchrGarminEscape:
            keyId = BTNID_FAVORSET_CANCEL;
            break;

          // HandEra JOG PushI/EnterL[͎̏(XgI)
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case vchrThumbWheelPush:
            keyId = BTNID_FAVORSET_OK;
            break;

#ifdef USE_PIN_DIA
          case winDisplayChangedEvent:
            // fBXvCTCYύXCxg
            if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
                (NNshGlobal->device == NNSH_DEVICE_GARMIN))
            {
                frm = FrmGetActiveForm();
                if (HandEraResizeForm(frm) == true)
                {
                    FrmDrawForm(frm);        
                }
            }
            return (false);
            break;
#endif

          default: 
            return (false);
            break;
        }
        break;

      case menuEvent:
        // j[Jꂽ
        if (event->data.menu.itemID == MNUID_SHOW_HELP)
        {
            // wv̕\
            // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
            ClipboardAddItem(clipboardText, 
                             nnDA_NNSIEXT_VIEWSTART
                             nnDA_NNSIEXT_INFONAME
                             nnDA_NNSIEXT_HELPFAVORTAB
                             nnDA_NNSIEXT_ENDINFONAME
                             nnDA_NNSIEXT_ENDVIEW,
                             sizeof(nnDA_NNSIEXT_VIEWSTART
                                     nnDA_NNSIEXT_INFONAME
                                     nnDA_NNSIEXT_HELPFAVORTAB
                                     nnDA_NNSIEXT_ENDINFONAME
                                     nnDA_NNSIEXT_ENDVIEW));
            // nnDAN
            (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
        }
        return (false);
        break;

      default: 
        return (false);
        break;
    }

    // ݊JĂʂ̐ݒ荀ڂmF
    switch (NNshGlobal->jumpSelection)
    {
      case MULTIBTN_FEATURE_USER1TAB:
        custom = &((NNshGlobal->NNsiParam)->custom1);
        if (keyId == chrLeftArrow)
        {
            keyId = PBTNID_FAVORSET_TAB5;
        }
        else if (keyId == chrRightArrow)
        {
            keyId = PBTNID_FAVORSET_TAB2;
        }
        break;

      case MULTIBTN_FEATURE_USER2TAB:
        custom = &((NNshGlobal->NNsiParam)->custom2);
        if (keyId == chrLeftArrow)
        {
            keyId = PBTNID_FAVORSET_TAB1;
        }
        else if (keyId == chrRightArrow)
        {
            keyId = PBTNID_FAVORSET_TAB3;
        }
        break;

      case MULTIBTN_FEATURE_USER3TAB:
        custom = &((NNshGlobal->NNsiParam)->custom3);
        if (keyId == chrLeftArrow)
        {
            keyId = PBTNID_FAVORSET_TAB2;
        }
        else if (keyId == chrRightArrow)
        {
            keyId = PBTNID_FAVORSET_TAB4;
        }
        break;

      case MULTIBTN_FEATURE_USER4TAB:
        custom = &((NNshGlobal->NNsiParam)->custom4);
        if (keyId == chrLeftArrow)
        {
            keyId = PBTNID_FAVORSET_TAB3;
        }
        else if (keyId == chrRightArrow)
        {
            keyId = PBTNID_FAVORSET_TAB5;
        }
        break;

      case MULTIBTN_FEATURE_USER5TAB:
      default:
        custom = &((NNshGlobal->NNsiParam)->custom5);
        if (keyId == chrLeftArrow)
        {
            keyId = PBTNID_FAVORSET_TAB4;
        }
        else if (keyId == chrRightArrow)
        {
            keyId = PBTNID_FAVORSET_TAB1;
        }
        break;
    }

    frm = FrmGetActiveForm();
    switch (keyId)
    {
      // 擾Ԃ̐ݒ
      case SELTRID_FAVORSET_GETSTATUS:
        diagFrm  = FrmInitForm(FRMID_FAVORSET_THREADSTATE);
        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_NEW) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NEWGET,     &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_UPDATE) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_PARTGET,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_REMAIN) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NOTREAD,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_ALREADY) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ALREADY,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_OVER) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_UPPERLIMIT, &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_NOT_YET) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NOTYET,     &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_GETERROR) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ERROR,      &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_UNKNOWN) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ETC,        &status);

        // Xē n ȍ~̃f[^f
        status = custom->threadCreate;
        SetControlValue(diagFrm, CHKID_THREAD_DATE, &status);
        if (status != 0)
        {
            MemSet (numBuf, TINYBUF, 0x00);
            NUMCATI(numBuf, status);
            NNshWinSetFieldText(diagFrm, 
                                FLDID_THREAD_DATE, false, numBuf, TINYBUF);
        }

        FrmSetActiveForm(diagFrm);
        btnId = FrmDoDialog(diagFrm);
        if (btnId == BTNID_FAVORSET_ST_OK)
        {
            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NEWGET,     &status);
            custom->threadStatus = (status << NNSH_SUBJSTATUS_NEW);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_PARTGET,    &status);
            custom->threadStatus = 
                       custom->threadStatus|(status << NNSH_SUBJSTATUS_UPDATE);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NOTREAD,    &status);
            custom->threadStatus =
                       custom->threadStatus|(status << NNSH_SUBJSTATUS_REMAIN);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ALREADY,    &status);
            custom->threadStatus = 
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_ALREADY);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_UPPERLIMIT, &status);
            custom->threadStatus = 
                         custom->threadStatus|(status << NNSH_SUBJSTATUS_OVER);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NOTYET,     &status);
            custom->threadStatus = 
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_NOT_YET);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ERROR,      &status);
            custom->threadStatus =
                     custom->threadStatus|(status << NNSH_SUBJSTATUS_GETERROR);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ETC,        &status);
            custom->threadStatus =
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_UNKNOWN);

            // Xē̎擾
            custom->threadCreate = 0;
            fldP    = FrmGetObjectPtr(diagFrm, 
                                FrmGetObjectIndex(diagFrm, FLDID_THREAD_DATE));
            txtH = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr    = MemHandleLock(txtH);
                if (StrLen(ptr) != 0)
                {
                    custom->threadCreate = StrAToI(ptr);
                }
                MemHandleUnlock(txtH);
            }
        }
        FrmSetActiveForm(frm);
        FrmDeleteForm(diagFrm);

        // ԐݒXV
        status = ((custom->threadStatus != 0)||(custom->threadCreate)) ? 1 : 0;
        SetControlValue(frm, CHKID_FAVORSET_GETSTATUS, &(status));
        break;

      // ^Cg̏ڍאݒ
      case SELTRID_FAVORSET_TITLESET:
        diagFrm  = FrmInitForm(FRMID_FAVORSET_THREADTITLE);
        FrmSetActiveForm(diagFrm);
        if (custom->string1[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR1, false,
                                custom->string1, sizeof(custom->string1));
        }
        if (custom->string2[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR2, false,
                                custom->string2, sizeof(custom->string2));
        }
        if (custom->string3[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR3, false, 
                                custom->string3, sizeof(custom->string2));
        }

        // ̏ݒ
        status = custom->stringSet & NNSH_STRING_SETMASK;
        NNshWinSetPopItems(diagFrm, 
                           POPTRID_FAVORSET_TTL_CONDSET,
                           LSTID_FAVORSET_TTL_CONDSET, status);

        btnId    = FrmDoDialog(diagFrm);
        if (btnId == BTNID_FAVORSET_TTL_OK)
        {
            // P̎擾
            fldP    = FrmGetObjectPtr(diagFrm, 
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR1));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string1, MINIBUF, 0x00);
                StrNCopy(custom->string1, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }

            // Q̎擾
            fldP    = FrmGetObjectPtr(diagFrm,
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR2));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string2, MINIBUF, 0x00);
                StrNCopy(custom->string2, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }

            // R̎擾
            fldP    =  FrmGetObjectPtr(diagFrm,
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR3));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string3, MINIBUF, 0x00);
                StrNCopy(custom->string3, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }
            lstP  = FrmGetObjectPtr(diagFrm,
                       FrmGetObjectIndex(diagFrm, LSTID_FAVORSET_TTL_CONDSET));
            custom->stringSet = custom->stringSet & NNSH_STRING_SELECTION;
            custom->stringSet = custom->stringSet | LstGetSelection(lstP);
        }
        FrmSetActiveForm(frm);
        FrmDeleteForm(diagFrm);
        break;

      // "Cancel"{^ꂽƂ
      case BTNID_FAVORSET_CANCEL:
        // ljAꗗʂɉʑJڂ
        FrmEraseForm(frm);
        closeForm_FavorTabSet(NNshGlobal->backFormId);
        break;

      // "OK"{^ꂽƂ
      case BTNID_FAVORSET_OK:
        // l𔽉fAꗗʂɉʑJڂ
        effect_FavorTabSet(frm, custom);
        FrmEraseForm(frm);
        closeForm_FavorTabSet(NNshGlobal->backFormId);
        break;

      case PBTNID_FAVORSET_TAB1:
        // ʏ̒lۑAʑJ
        effect_FavorTabSet(frm, custom);
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER1TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      case PBTNID_FAVORSET_TAB2:
        // ʏ̒lۑAʑJ
        effect_FavorTabSet(frm, custom);
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER2TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      case PBTNID_FAVORSET_TAB3:
        // ʏ̒lۑAʑJ
        effect_FavorTabSet(frm, custom);
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER3TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      case PBTNID_FAVORSET_TAB4:
        // ʏ̒lۑAʑJ
        effect_FavorTabSet(frm, custom);
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER4TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      case PBTNID_FAVORSET_TAB5:
        // ʏ̒lۑAʑJ
        effect_FavorTabSet(frm, custom);
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER5TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      default:
        // LȊOiȂj
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effect_FavorTabSet                                       */
/*                         Cɓݒp[^lɔf鏈  */
/*-------------------------------------------------------------------------*/
static Err effect_FavorTabSet(FormType *frm, NNshCustomTab *custom)
{
    UInt16     status;
    ListType  *lstP;
    FieldType *fldP;
    MemHandle  txtH;
    Char      *txtP;

    // ^u^Cg̎擾
    fldP    = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, FLDID_FAVORSET_TABTITLE));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        MemSet(custom->tabName, MAX_BOARDNAME, 0x00);
        StrNCopy(custom->tabName, txtP, (MAX_BOARDNAME - 1));
        MemHandleUnlock(txtH);

        // BBS^CgCfbNXp̗̈
        if (NNshGlobal->boardIdxH != 0)
        {
            MemHandleFree(NNshGlobal->boardIdxH);
            NNshGlobal->boardIdxH = 0;
        }
        MEMFREE_PTR((NNshGlobal->bbsTitles));
    }

    // VmF{^u
    lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_CHECKNEW));
    custom->newArrival = LstGetSelection(lstP);

    // ꗗ擾{^u
    lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_GETLIST));
    custom->getList = LstGetSelection(lstP);

    /////////////////////////////////////////////////////////////////////////

    // `FbN
    lstP   = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_CONDITIONSET));
    status = LstGetSelection(lstP);
    if (status != 0)
    {
        // ǂꂩv
        custom->condition = NNSH_CONDITION_OR;
    }
    else
    {
        // SĈv
        custom->condition = NNSH_CONDITION_AND;
    }

    // QƃO͏O
    UpdateParameter(frm, CHKID_FAVORSET_NOT_READONLY, &status);
    if (status != 0)
    {
        custom->condition = custom->condition | NNSH_CONDITION_NOTREADONLY;
    }

    // Xx̃`FbN
    UpdateParameter(frm, CHKID_FAVORSET_LEVEL, &(status));
    if (status != 0)
    {
        // Xx𔽉f
        lstP = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, LSTID_FAVORSET_LVL_SET));
        custom->threadLevel =
                          (LstGetSelection(lstP) + 1) << NNSH_THREADCOND_SHIFT;
        UpdateParameter(frm, PBTNID_FAVORSET_LVL1, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L1;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL2, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L2;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL3, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L3;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL4, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L4;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL5, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR;
            goto SET_CONDITION;
        }
#if 0
        UpdateParameter(frm, PBTNID_FAVORSET_LVL0, &status);
        if (status != 0)
        {
            status = 0;
            goto SET_CONDITION;
        }
        status = 0;
#endif

SET_CONDITION:
        custom->threadLevel = custom->threadLevel|(status);
    }
    else
    {
        custom->threadLevel = 0;
    }
     
    // ݒ̃`FbN
    UpdateParameter(frm, CHKID_FAVORSET_BBSNICK, &(status));
    if (status != 0)
    {
        // ݒ𔽉f
        lstP = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, LSTID_FAVORSET_BBSNICK));
        custom->boardNick = LstGetSelection(lstP);
        if (custom->boardNick < NNSH_NOF_SPECIAL_BBS)
        {
            // ݒ́Aʏ̔w肳Ă邱
            NNsh_WarningMessage(ALTID_WARN, MSG_WARN_NOTEFFECT_BBS, "", 0);

            // ݒNA
            custom->boardCondition = 0;
            goto FUNC_END;
        }
        lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_BBSNICK_SET));
        custom->boardCondition = LstGetSelection(lstP) + 1;
    }
    else
    {
        custom->boardCondition = 0;
    }

    // Oʒu̎w
    UpdateParameter(frm, CHKID_FAVORSET_LOGLOC, &(status));
    if (status != 0)
    {
        // Oʒuf[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_LOGLOC_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition | NNSH_CONDITION_LOGLOC_PALM;
        }
        else
        {
            custom->condition = custom->condition | NNSH_CONDITION_LOGLOC_VFS;
        }
    }

    // 擾G[̎w
    UpdateParameter(frm, CHKID_FAVORSET_GETERROR, &(status));
    if (status != 0)
    {
        // 擾G[f[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_GETERROR_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition|NNSH_CONDITION_GETERR_NONE;
        }
        else
        {
            custom->condition = custom->condition|NNSH_CONDITION_GETERR_ERROR;
        }
    }

    // 擾ۗ̎w
    UpdateParameter(frm, CHKID_FAVORSET_GETRESERVE, &(status));
    if (status != 0)
    {
        // 擾ۗf[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_GETRESERVE_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition | NNSH_CONDITION_GETRSV_RSV;
        }
        else
        {
            custom->condition = custom->condition | NNSH_CONDITION_GETRSV_NONE;
        }
    }

    // XԂ̊mF 
    UpdateParameter(frm, CHKID_FAVORSET_GETSTATUS, &(status));
    if (status == 0)
    {
        // XԂNA
        custom->threadStatus = 0;    
    }

    // ̐ݒ
    UpdateParameter(frm, CHKID_FAVORSET_TITLESET, &(status));
    if (status != 0)
    {
        custom->stringSet = custom->stringSet | NNSH_STRING_SELECTION;
    }
    else
    {
        custom->stringSet = custom->stringSet & NNSH_STRING_SETMASK;
    }

FUNC_END:
    return (errNone);
}

#ifdef USE_COLOR
/*-------------------------------------------------------------------------*/
/*   Function :   Handler_setViewColorDetail                               */
/*                                      QƉʂ̐FݒpCxgnh */
/*-------------------------------------------------------------------------*/
Boolean Handler_setViewColorDetail(EventType *event)
{
    UInt8            *paramPtr;
    IndexedColorType  color;

    if (event->eType != ctlSelectEvent)
    {
        // Ȃ
        return (false);
    }

    switch (event->data.ctlSelect.controlID)
    {
      case SELTRID_NNSISET_COLOR_LETTER:
        // ̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorViewFG);
        break;

      case SELTRID_NNSISET_COLOR_HEADER:
        // wb_̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgHeader);
        break;

      case SELTRID_NNSISET_COLOR_BOLDHEADER:
        // wb_ij̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgHeaderBold);
        break;

      case SELTRID_NNSISET_COLOR_BACKGROUND:
        // wi̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorViewBG);
        break;

      case SELTRID_NNSISET_COLOR_FOOTER:
        // tb^̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgFooter);
        break;

      case SELTRID_NNSISET_COLOR_BOLDFOOTER:
        //@tb^()̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgFooterBold);
        break;

      case SELTRID_NNSISET_COLOR_MARKING:
        // }[N̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgInform);
        break;

      case SELTRID_NNSISET_COLOR_BOLDMARKING:
        // }[Nij̐F
        paramPtr = &((NNshGlobal->NNsiParam)->colorMsgInformBold);
        break;
        
      default:
        // Ȃ
        return (false);
        break;
    }
    // FI
    color = *paramPtr;
    if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
    {
        // ݒ肵F𔽉f
        *paramPtr = color;
    }
    FrmDrawForm(FrmGetActiveForm());
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   selectOmitDialog                                         */
/*                                          mF_CAȌȗ(ڍאݒ) */
/*-------------------------------------------------------------------------*/
static Boolean setViewColorDetail(void)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    UInt16        btnId;
    FieldType    *fldP;
    MemHandle     txtH;
    Char         *nameP, separator[SEPARATOR_LEN];

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAO\
    PrepareDialog_NNsh(FRMID_NNSISET_VIEWCOLOR, &diagFrm, true);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // f[^̐ݒ
    // wb_/tb^̐F\{
    btnId = (NNshGlobal->NNsiParam)->useColorMessageToken;
    SetControlValue(diagFrm, CHKID_NNSISET_USEVIEWCOLOR, &btnId);

    // nnDAgpAXpop up \
    btnId = (NNshGlobal->NNsiParam)->showResPopup;
    SetControlValue(diagFrm, CHKID_NNSISET_USE_POPUP, &btnId);

    // ݂̃bZ[W؂蕶擾
    MemSet (separator, sizeof(separator), 0x00);
    StrCopy(separator, &((NNshGlobal->NNsiParam)->messageSeparator[1]));
    
    // ̕(sR[hĂ邩)
    nameP = separator;
    while ((*nameP != '\n')&&(*nameP != '\0'))
    {
        nameP++;
    }
    *nameP = '\0';

    // bZ[W̋؂蕶̌ݐݒlEBhEɔf
    NNshWinSetFieldText(diagFrm, FLDID_ZONE_SEPARATOR, true, separator, sizeof(separator));
    FrmSetFocus(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_ZONE_SEPARATOR));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_setViewColorDetail);

    // EBhE̕\
    btnId = FrmDoDialog(diagFrm);

    // f[^̃wb_/tb^̐F\
    UpdateParameter(diagFrm, CHKID_NNSISET_USEVIEWCOLOR, &btnId);
    (NNshGlobal->NNsiParam)->useColorMessageToken = btnId;

    // f[^̃wb_/tb^̋\
    UpdateParameter(diagFrm, CHKID_NNSISET_USE_POPUP, &btnId);
    (NNshGlobal->NNsiParam)->showResPopup = btnId;

    // ؂蕶̎擾
    fldP = FrmGetObjectPtr(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_ZONE_SEPARATOR));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        nameP = MemHandleLock(txtH);
        if (*nameP != '\0')
        {
            (NNshGlobal->NNsiParam)->messageSeparator[0] = '\n';
            StrNCopy(&((NNshGlobal->NNsiParam)->messageSeparator[1]),
                     nameP, (SEPARATOR_LEN - MARGIN));
            StrCat((NNshGlobal->NNsiParam)->messageSeparator, "\n");
        }
        MemHandleUnlock(txtH);        
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, true);

    return (ret);
}
#endif  // #ifdef USE_COLOR

#ifdef USE_LOGCHARGE
/*=========================================================================*/
/*   Function :  GetLog_SetHardKeyFeature                                  */
/*                                    QƃOꗗʂ̃n[hL[@\ݒ */
/*=========================================================================*/
void GetLog_SetHardKeyFeature(void)
{
    // Xg̃NA
    clearFeatureList();
      
    // QƃOꗗʋ@\Xg̐ݒ
    createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREGETLOG_STRINGS);

    // n[hL[ڍאݒ
    (void) SetTitleHardKey(NNSH_TITLE_GETLOGLIST_TITLE, GETLOGBTN_FEATURE, 
                            GETLOGBTN_FEATURE_MASK, &((NNshGlobal->NNsiParam)->getLogFeature));

    //  ꕔn[hL[̐́ANNsiݒ̃n[hL[ݒ肪Kv
    // ƂxB
    NNsh_WarningMessage(ALTID_WARN, MSG_WARN_SETTING_HARDKEY, "", 0);

    // Xg̃NA
    clearFeatureList();

    return;
}
#endif // #ifdef USE_LOGCHARGE
