/*============================================================================*
 *  FILE: 
 *     httpMgr.c
 *
 *  Description: 
 *     HTTPR~jP[V}l[W
 *===========================================================================*/
#define  HTTPMGR_C
#include "local.h"

/*-------------------------------------------------------------------------*/
/*   Function :   http_divideHostName                                      */
/*                                               URLzXg𒊏o */
/*-------------------------------------------------------------------------*/
static void NNshHttp_divideHostName(Char *url, Char *host, Char **loc, UInt16 *portNo)
{
    Char   *start;

    // zXg̍ŏƍŌ̏ꏊ߂("://"  "/" Ɉ͂܂Ă钆g)
    start = StrStr(url, "://");
    if (start != NULL)
    {
        start = start + StrLen("://");
    }
    else
    {
        // w肪Ȃꍇ͐擪AAA肦Ȃ񂾂ǁAAA
        start = url;
    }
#ifdef USE_STRSTR
    *loc  = StrStr(start, "/");
    // "/" Ȃꍇɂ́As̍ŌォRs[
    if (*loc == NULL)
#else
    *loc = start;
    while ((*(*loc) != '/')&&(*(*loc) != '\0'))
    {
        (*loc)++;
    }
    if (*(*loc) == '\0')
#endif
    {
        *loc = start + StrLen(url);
        StrNCopy(host, start, StrLen(url));
    }
    else
    {
        // zXg𒊏o
        StrNCopy(host, start, (*loc - start));
    }
    
    if (portNo != NULL)
    {
        start = StrStr(host, ":");
        if (start != NULL)
        {
            *start = '\0';
            start++;
            *portNo = StrAToI(start);
        }
   }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   http_createPostMsg                                       */
/*                                            HTTPMbZ[W쐬 */
/*-------------------------------------------------------------------------*/
static Err NNshHttp_createPostMsg(UInt16 type, Char *url, Char *host,
                                   Char *extendUserAgent, Char *cookie, 
                                   Char *appendData, UInt16 *portNo,
                                   Char *buffer, UInt32 bufSize)
{
    NNshFileRef sendRef;
    UInt32      dataSize, readSize;
    Char       *loc, *buf;
    Err         ret;

    // t@C瑗M郁bZ[WǂݏoB
    dataSize = 0;
    readSize = 0;
    buf      = NULL;

    // Mt@Cf[^擾
    ret = OpenFile_NNsh(FILE_SENDMSG, 
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &sendRef);
    if (ret != errNone)
    {
        return (ret);
    }
    (void) GetFileSize_NNsh(&sendRef, &readSize);
    buf = (Char *) MEMALLOC_PTR(readSize + 8);
    if (buf == NULL)
    {
        return (~errNone);
    }
    MemSet(buf, (readSize + 8), 0x00);
    (void) ReadFile_NNsh (&sendRef, 0, readSize, buf, &dataSize);
    (void) CloseFile_NNsh(&sendRef);

    // URLzXgƃt@Cɕ
    loc = NULL;
    NNshHttp_divideHostName(url, host, &loc, portNo);

    // tf[^TCYmF
    if (appendData != NULL)
    {
        readSize = StrLen(appendData);
    }
    else
    {
        readSize = 0;
    }

    // HTTP̃wb_쐬(܂BBSΉ)
    switch (type)
    {
      case HTTP_SENDTYPE_POST_SHITARABAJBBS:
        StrCopy(buffer, "POST ");

        // t@炻̂܂CGIt@C𐶐
        StrCat (buffer, loc);
        StrCat (buffer, " HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST_MACHIBBS:
        StrCopy(buffer, "POST /bbs/write.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST_SHITARABA:
        StrCopy(buffer, "POST /cgi-bin/bbs.cgi HTTP/1.0\r\nHost: cgi.shitaraba.com");
        StrCopy(host, "cgi.shitaraba.com");
        break;

      case HTTP_SENDTYPE_POST_OTHERBBS:
        StrCopy(buffer, "POST ");
        StrCat (buffer, loc);
        StrCat (buffer, "../test/bbs.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST:
        StrCopy(buffer, "POST /test/bbs.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST_2chLOGIN:
        extendUserAgent = "DOLIB/1.00";
        // not break!!

      default:
        StrCopy(buffer, "POST ");
        StrCat (buffer, loc);
        StrCat (buffer, " HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;
    }
    NNsh_DebugMessage(ALTID_INFO, " ", buffer, 0);

    StrCat (buffer,  "\r\nAccept: text/html, */*\r\nReferer: ");
    StrCat (buffer,  url);
    StrCat (buffer, "\r\nContent-Length: ");
    if ((type == HTTP_SENDTYPE_POST_2chLOGIN)||(extendUserAgent != NULL))
    {
        // OCɂ́AŌ \r\n ȂB
        StrIToA(&buffer[StrLen(buffer)], (dataSize + readSize));
    }
    else
    {
        StrIToA(&buffer[StrLen(buffer)], (dataSize + readSize + 2));
    }
    StrCat (buffer, "\r\nPragma: no-cache\r\n");
    StrCat (buffer,  "User-Agent: ");
    if (extendUserAgent == NULL)
    {
        StrCat(buffer, "Monazilla/1.00  NNsi/1.3(" SOFT_REVISION ")\r\n");
        if (cookie != NULL)
        {
            StrCat (buffer, cookie);
            StrCat (buffer, "; NAME=NNsi(PalmOS); Mail=");
        }
        else
        {
            StrCat(buffer, "Cookie: NAME=; Mail=");
        }
    }
    else
    {
        StrCat(buffer, extendUserAgent);
        StrCat(buffer, "\r\nX-2ch-UA: NNsi/1.03");
        if (cookie != NULL)
        {
            StrCat (buffer, "\r\n");
            StrCat (buffer, cookie);
            StrCat (buffer, "; NAME=NNsi(PalmOS); Mail=");
        }
    }
    StrCat (buffer, "\r\n\r\n");

    // f[^obt@ɃRs[邩mF
    if (bufSize >= (StrLen(buffer) + dataSize + readSize + 2))
    {
        // f[^̃Rs[
        StrCat (buffer, buf);
        if (appendData != NULL)
        {
            StrCat (buffer, appendData);
        }
        StrCat (buffer, "\r\n");
        ret = errNone;
    }
    else
    {
        // obt@TCYI[ot[
        ret = (~errNone - 1);
    }
    MEMFREE_PTR(buf);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   http_createGetMsg                                        */
/*                                            HTTPMbZ[W쐬 */
/*-------------------------------------------------------------------------*/
static void NNshHttp_createGetMsg(UInt16 type, Char *url, Char *host,
                                   Char *extendUserAgent, UInt16 *portNo,
                                   UInt32 getRange, UInt32 endRange, 
                                   Char *buffer, Char *proxy, Char *appendData)
{
    Char *loc;

    // URLzXgƃt@Cɕ
    loc = NULL;
    NNshHttp_divideHostName(url, host, &loc, portNo);
    if ((loc == NULL)||(*loc == '\0'))
    {
        loc = "/";
    }

    // f[^Mpobt@ɃbZ[WLڂ
    StrCopy(buffer, "GET ");
    if ((proxy != NULL)&&(*proxy != '\0'))
    {
        StrCat (buffer,  url);
    }
    else
    {
        StrCat (buffer,  loc);
    }
#if 0
    if (type == HTTP_SENDTYPE_GET_NOTMONA)
    {
        StrCat (buffer,  " HTTP/1.0\r\nHOST: ");
    }
    else
    {
        StrCat (buffer,  " HTTP/1.1\r\nHOST: ");
    }
#else
    // "chunked" 𔭐Ȃ...
    StrCat (buffer,  " HTTP/1.0\r\nHOST: ");
#endif
    StrCat (buffer,  host);
    StrCat (buffer,  "\r\nACCEPT: text/html, */*\r\nUser-Agent: ");
    if (extendUserAgent == NULL)
    {
        if (type !=  HTTP_SENDTYPE_GET_NOTMONA)
        {
            StrCat (buffer, "Monazilla/1.00  ");
        }
        StrCat (buffer,  "NNsi/1.50 for PalmOS (" SOFT_VERSION ")\r\n");
    }
    else
    {
        StrCat(buffer, extendUserAgent);
        StrCat(buffer, "\r\nX-2ch-UA: NNsi/1.4\r\n");
    }

#ifdef USE_ZLIB
    // gzipΉ by Nickle
    // RFC2616: Field names are case-insensitive. 炵Ba񂾂
    if ((NNshGlobal->useGzip != 0)&&
         ((getRange == HTTP_RANGE_OMIT)||(getRange == 0)))
    {
        //  GZIP gp\ȏꍇA擪擾\ȂƂA͔͈͎wȂ
        // ꍇɂ gzipLɂ
        StrCat(buffer, "ACCEPT-ENCODING: gzip");
    }
    else
#endif
    {
        StrCat(buffer, "ACCEPT-ENCODING: identity");
    }
    StrCat(buffer, "\r\nACCEPT-LANGUAGE: ja, en");

    if (getRange != HTTP_RANGE_OMIT)
    {
        StrCat(buffer, "\r\nRANGE: bytes=");
        StrIToA(&buffer[StrLen(buffer)], getRange);
        StrCat(buffer, "-");
    }
    if (endRange != HTTP_RANGE_OMIT)
    {
        StrIToA(&buffer[StrLen(buffer)], endRange);
    }
    if ((appendData != NULL)&&(*appendData != '\0'))
    {
        StrCat(buffer, "\r\n");
        StrCat(buffer, appendData);
    }
    StrCat(buffer, "\r\nConnection: close");
    StrCat(buffer, "\r\nPRAGMA: no-cache\r\n\r\n");

    return;
}

/*=========================================================================*/
/*   Function :   NNshHttp_commMain                                        */
/*                                                 HTTPf[^](GET)v */
/*                                            (Mf[^recv.txtɋL^) */
/*=========================================================================*/
Err NNshHttp_commMain(UInt16 type, Char *url, Char *cookie, Char *appendData,
                      UInt32 range, UInt32 endRange, UInt16 port, Char *proxy,
                      Char   *message, UInt16 sslMode)
{
#ifdef OFFLINE_DEBUG

    Char logMes[BUFSIZE];

    // Oo͂āAʐMӂB
    MemSet (logMes, sizeof(logMes), 0x00);
    StrCopy(logMes, "\n<< This is OFFLINE DEBUG, NOT CONNECT >>\n");
    if (range != HTTP_RANGE_OMIT)
    {
        StrCat (logMes, "Range:");
        NUMCATI(logMes, range);
        StrCat (logMes, "-");
    }
    if (endRange != HTTP_RANGE_OMIT)
    {
        NUMCATI(logMes, endRange);
    }
    StrCat (logMes, " PORT:");
    NUMCATI(logMes, port);

    if ((proxy != NULL)&&(*proxy != '\0'))
    {
       StrCat (logMes, " (proxy:");
       StrCat (logMes, proxy);
       StrCat (logMes, ")");
    }
    if ((message != NULL)&&(*message != '\0'))
    {
       StrCat (logMes, "[");
       StrCat (logMes, message);
       StrCat (logMes, "]");
    }
    StrCat (logMes, " ssl:");
    NUMCATI(logMes, sslMode);
    NNsh_InformMessage(ALTID_INFO, url, logMes, 0);

    return (errNone);
#else   // #ifdef OFFLINE_DEBUG

    Err             ret, err;
    Char           *bufPtr, host[MAX_URL], logBuf[MINIBUF + MARGIN], *userAgent;
    UInt16          dataSize, autoOffTime;
    UInt32          writeSize, totalSize;
#ifdef USE_CONTENT_LENGTH_INFO
    UInt32          contentSize, progress;
    Char           *tmpPtr;
#else  // #ifdef USE_CONTENT_LENGTH_INFO
#ifdef USE_ZLIB
    Char           *tmpPtr;
#endif // #ifdef USE_ZLIB
#endif // #ifdef USE_CONTENT_LENGTH_INFO
    NetSocketRef    socketRef;
    NNshFileRef     fileRef;
    FormType       *frm;

#ifdef USE_SSL
    UInt16          sslRef;
    SslLib         *sslTemplate;
    SslContext     *sslContext;
#endif

#ifdef USE_ZLIB // by Nickle
    Boolean compressed = false; // 󂯎contentgzip`ǂ
    Boolean firstBlock = false; // ݂̃f[^content̍ŏ̕ǂ
#endif

#ifdef USE_CONTENT_LENGTH_INFO
    // content-length̏
    contentSize = 0;
#endif

    // [UG[WFg̐ݒ
    userAgent = NNshGlobal->customizedUserAgent;

    // (ꎞ)Mobt@̊m
    bufPtr = MEMALLOC_PTR((NNshGlobal->NNsiParam)->bufferSize + MARGIN);
    if (bufPtr == NULL)
    {
        // ̈̊mێsI
        NNsh_DebugMessage(ALTID_ERROR, "HTTP(temp)", "MEMALLOC_PTR(), size:",
                          (NNshGlobal->NNsiParam)->bufferSize + MARGIN);
        return (~errNone);
    }
    MemSet(bufPtr, ((NNshGlobal->NNsiParam)->bufferSize + MARGIN), 0x00);

    // MpbZ[W̍쐬ƂtqkzXg擾
    MemSet(host, sizeof(host), 0x00);
    switch (type)
    {
      case HTTP_SENDTYPE_POST_2chLOGIN:
#ifdef USE_SSL_V2
        // SSL v2gpăOC(tiger2.he.net́ASSL v2ΉȂ̂...)
        if (NNshGlobal->palmOSVersion < 0x05200000)
        {
            // PalmOS V5.2Ő@́AƎSSLlSVG[Vgp
            sslMode = NNSH_SSLMODE_SSL_V2SPECIAL;
        }
        else
#endif  // #ifdef USE_SSL_V2
        {
            // PalmOS 5.2ȍ~T|[gSslLibgp
            sslMode = NNSH_SSLMODE_SSLV3;
        }
        // not break!!!;

      case HTTP_SENDTYPE_POST:
      case HTTP_SENDTYPE_POST_MACHIBBS:
      case HTTP_SENDTYPE_POST_SHITARABA:
      case HTTP_SENDTYPE_POST_SHITARABAJBBS:
      case HTTP_SENDTYPE_POST_OTHERBBS:
        ret = NNshHttp_createPostMsg(type, url, host, userAgent, cookie, 
                                     appendData, &port,
                                     bufPtr, (NNshGlobal->NNsiParam)->bufferSize);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "createPostMsg()", "", ret);
            MEMFREE_PTR(bufPtr);
            return (ret);
        }
        break;

      default:
        // HTTP_SENDTYPE_GET
        NNshHttp_createGetMsg(type, url, host, userAgent, &port,
                              range, endRange, bufPtr, proxy, appendData);
        break;
    }

    // Proxyݒ肳Ă΁A擾zXgoverride
    if ((proxy != NULL)&&(*proxy != '\0'))
    {
        MemSet(host, sizeof(host), 0x00);
        StrNCopy(host, proxy, (MAX_URL - 1));
    }

    // ʐM\...
    NNsh_DebugMessage(ALTID_INFO, host, ":", port);

    // lbgCuI[vĂȂƂ̓I[vB
#ifdef USE_SSL
    ret = NNshSSL_open(sslMode, &(NNshGlobal->netRef), &sslRef, &sslTemplate, &sslContext);
#else
    ret = NNshNet_open(&(NNshGlobal->netRef));
#endif
    if (ret != errNone)
    {
        // I[vs
        NNsh_DebugMessage(ALTID_ERROR, "failure ", "net_open()", ret);
        NNshGlobal->netRef = 0;
        MEMFREE_PTR(bufPtr);
        return (ret);
    }

    // p[^ݒ肳ĂƂ́Aʂĕ`悷
    if ((NNshGlobal->NNsiParam)->redrawAfterConnect != 0)
    {
        frm  = FrmGetActiveForm();
        FrmEraseForm(frm);
        NNsi_FrmDrawForm(frm, true);
    }

    // dnee^C}𖳌ɂ
    autoOffTime = SysSetAutoOffTime(0);
    (void) EvtResetAutoOffTimer();

    // BUSY\
    MemSet (logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, MSG_CONNECTING_TO);
    StrCat (logBuf, host);
    if ((message != NULL)&&(*message != '\0'))
    {
        // \bZ[WɎw肳ĂꍇA𖖔ɕt
        // (̕\bZ[ẂAƂ肠zXg֐ڑƂ̂ݕt)
        StrCat(logBuf, message);
    }
    Show_BusyForm(logBuf);

    // (HTTP)zXg֐ڑ
#ifdef USE_SSL
    ret = NNshSSL_connect(sslMode, sslRef, sslContext, &socketRef, NNshGlobal->netRef, host, port);
#else
    ret = NNshNet_connect(&socketRef, NNshGlobal->netRef, host, port);
#endif
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR,"connection failure HOST:", host, ret);

        // ڑɎs
        Hide_BusyForm(false);
        MEMFREE_PTR(bufPtr);
#ifdef USE_SSL
        NNshSSL_close(sslMode, NNshGlobal->netRef, sslRef, sslTemplate, sslContext);
#else
        NNshNet_close(NNshGlobal->netRef);
#endif

        // dOFF^C}𕜋
        (void) SysSetAutoOffTime(autoOffTime);
        (void) EvtResetAutoOffTimer();

        return (NNSH_ERRORCODE_FAILURECONNECT);
    }

    // HTTPvbZ[W̑M
    SetMsg_BusyForm(MSG_BUSY_SENDING);
#ifdef USE_SSL
    NNshSSL_write(sslMode, NNshGlobal->netRef, socketRef, sslRef, sslContext, StrLen(bufPtr), bufPtr);
#else
    NNshNet_write(NNshGlobal->netRef, socketRef, StrLen(bufPtr), bufPtr);
#endif

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, ")))SEND : %s ", bufPtr);
#endif // #ifdef USE_REPORTER

    // HTTPf[^̎M(Mf[^FILE_RECVMSGɏo)
    SetMsg_BusyForm(MSG_BUSY_WAITREPLY);
    MemSet(&fileRef, sizeof(fileRef), 0x00);
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
    }

    dataSize  = 0;
    totalSize = 0;
    ret       = errNone;
    while (ret == errNone)
    {
        dataSize = 0;
        // (ꎞ)Mobt@̃NA
        MemSet(bufPtr, (NNshGlobal->NNsiParam)->bufferSize, 0x00);
#ifdef USE_SSL
        ret = NNshSSL_read(sslMode, NNshGlobal->netRef, socketRef,
                           sslRef, sslContext,
                           (NNshGlobal->NNsiParam)->bufferSize, bufPtr, &dataSize);
#else
        ret = NNshNet_read(NNshGlobal->netRef, socketRef,
                           (NNshGlobal->NNsiParam)->bufferSize, bufPtr, &dataSize);
#endif
        if (ret != errNone)
        {
            break;
        }
        if (dataSize == 0)
        {
            break;
        }
#ifdef USE_CONTENT_LENGTH_INFO
        // Mf[^̐擪̂ƂAMf[^̑oCg߂
        if (totalSize == 0)
        {
            tmpPtr = StrStr(bufPtr, NNSH_HTTP_CONTENT_LENGTH);
            if (tmpPtr != NULL)
            {
                // ̐擪߂
                tmpPtr = tmpPtr + StrLen(NNSH_HTTP_CONTENT_LENGTH);
                while ((*tmpPtr != '\x0d')&&((*tmpPtr < '0')||(*tmpPtr > '9')))
                {
                    tmpPtr++;
                }

                // oCǧvZ
                while ((*tmpPtr >= '0')&&(*tmpPtr <= '9'))
                {
                    contentSize = (contentSize * 10) + (*tmpPtr - '0');
                    tmpPtr++;
                }
            }
        }
#endif
#ifdef USE_ZLIB // by Nickle
        // Mf[^̐擪̂Ƃ(httpwb_ĂƂ)
        // gzipkĂ邩ׂ
        if ((NNshGlobal->useGzip != 0)&&(totalSize == 0))
        {
            firstBlock = true; // Mf[^̐擪

            // Mwb_ "Content-Encoding: gzip" ܂܂Ă邩H
            tmpPtr = StrStr(bufPtr, NNSH_HTTP_CONTENT_GZIPED);
            if (tmpPtr == NULL)
            {
                tmpPtr = StrStr(bufPtr, NNSH_HTTP_CONTENT_XGZIPED);
            }
            if (tmpPtr != NULL)
            {
                // kĂ...
                compressed = true;
                if (OpenZLib() == false)
                {
                    // Zlib̃I[vɎsAڑsƂĈ
                    Hide_BusyForm(false);
                    MEMFREE_PTR(bufPtr);
#ifdef USE_SSL
                    NNshSSL_close(sslMode, NNshGlobal->netRef, sslRef, sslTemplate, sslContext);
#else
                    NNshNet_close(NNshGlobal->netRef);
#endif
                    // dOFF^C}𕜋
                    (void) SysSetAutoOffTime(autoOffTime);
                    (void) EvtResetAutoOffTimer();
                    return (NNSH_ERRORCODE_FAILURECONNECT);
                }
            }
        }
        else
        {
            // Mf[^擪ł͂Ȃ...
            firstBlock = false;
        }
#endif  // #ifdef USE_ZLIB 

        totalSize = totalSize + dataSize;
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, MSG_BUSY_RECV_WAIT);
        NUMCATI(logBuf, totalSize);

#ifdef USE_CONTENT_LENGTH_INFO
        // MoCg\悤ɂĂ݂
        if (contentSize != 0)
        {
            StrCat(logBuf, "/");
            NUMCATI(&logBuf[StrLen(logBuf)], contentSize);
            StrCat (logBuf, MSG_BUSY_RECV_BYTES);
            StrCat (logBuf, " (");
            progress = ((totalSize * 100) / contentSize);
            NUMCATI(&logBuf[StrLen(logBuf)], progress);
            StrCat (logBuf, "%)");
        }
        else
#endif
        {
            StrCat (logBuf, MSG_BUSY_RECV_BYTES);
        }
        SetMsg_BusyForm(logBuf);

#ifdef USE_ZLIB // by Nickle
        if (compressed != false)
        {
            // gzipedȂ̂ŁAfR[hȂt@Cɏ
            int headerSize = 0;

            // fR[hΏۂ̐擪BƂ肠f[^̐擪w
            // httpwb_΁Acontent{̂w
            Char* decodePtr = bufPtr;
 
            // httpwb_΁A͈kĂȂ̂ł̂܂܏
            if (firstBlock != false)
            {
                tmpPtr = StrStr(bufPtr, "\r\n\r\n");
                if (tmpPtr != NULL)
                {
                    // wb_
                    tmpPtr = tmpPtr + 4; // +4 : \r\n\r\n̂Ԃ
                    decodePtr = tmpPtr;

                    // (wb_)kȂ̂ł̂܂܏
                    headerSize = tmpPtr - bufPtr;
                    err = AppendFile_NNsh(&fileRef, headerSize, bufPtr, &writeSize);
                    if (err != errNone)
                    {
                        NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", err);
                    }
                    if (writeSize == 0)
                    {
                        NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", 
                                          " write size == 0", writeSize);
                    }
                }
            }
            
            // NNsh_DebugMessage(ALTID_INFO, "info", " dataSize:", dataSize);
            // NNsh_DebugMessage(ALTID_INFO, "info", " headerSize:", headerSize);
            // NNsh_DebugMessage(ALTID_INFO, "bodyPtr:", decodePtr, 0);
          
            // gzip𓀁t@Cɏ
            // ToDo: HTTP/1.1 applications MUST be able to receive and decode the "chunked" transfer-coding
            //       RFC 2616 - Hypertext Transfer Protocol -- HTTP/1.1
            ParseGZip(&fileRef, decodePtr, (dataSize - headerSize), firstBlock);
        }
        else // if(compressed)
#endif
        {
            // 񈳏kf[^͒ڃt@Cɏo͂
            err = AppendFile_NNsh(&fileRef,dataSize, bufPtr, &writeSize);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", err);
            }
            if (writeSize == 0)
            {
                NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", 
                                  " write size == 0", writeSize);
            }
        }
#ifdef USE_SSL
        // SSLʐMf[^obt@̃NAw(͕svȁH)
        // NNshSSL_flush(sslMode, sslRef, sslContext);
#endif
    }

    // cf[^̏o
#ifdef USE_ZLIB // by Nickle
    if (compressed != false)
    {
        // gzipedȂ̂ŁAfR[hȂt@Cɏ
        // gzip𓀁t@Cɏ
        // ToDo: HTTP/1.1 applications MUST be able to receive and decode the "chunked" transfer-coding
        //       RFC 2616 - Hypertext Transfer Protocol -- HTTP/1.1
        ParseGZip(&fileRef, bufPtr, dataSize, false);
    }
    else
#endif // #ifdef USE_ZLIB
    {
        err = AppendFile_NNsh(&fileRef,dataSize, bufPtr, &writeSize);
        if (err != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "AppendFile(end) ", " ret:", err);
        }
    }

    err = CloseFile_NNsh (&fileRef);
    if (err != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CloseFile() ", " ret:", err);
    }
    MEMFREE_PTR(bufPtr);

#ifdef USE_ZLIB // by Nickle
    if (compressed != false)
    {
        CloseZLib(); // ZLIBĝŃN[Y
    }
#endif

    // Mf[^TCY̕\
    MemSet (logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, MSG_BUSY_RECV_END);
    NUMCATI(logBuf, totalSize);
    StrCat (logBuf, MSG_BUSY_RECV_BYTES);
    SetMsg_BusyForm(logBuf);

    // zXgڑ؂ABUSYEBhE폜B
#ifdef USE_SSL
    NNshSSL_disconnect(sslMode, sslRef, sslContext, socketRef, NNshGlobal->netRef);
    NNshSSL_close(sslMode, NNshGlobal->netRef, sslRef, sslTemplate, sslContext);
#else
    NNshNet_disconnect(NNshGlobal->netRef, socketRef);
    NNshNet_close(NNshGlobal->netRef);
#endif
    Hide_BusyForm(false);

    // dOFF^C}𕜋
    (void) SysSetAutoOffTime(autoOffTime);
    (void) EvtResetAutoOffTimer();

    return (ret);

#endif     // #ifdef OFFLINE_DEBUG
}
