//////////////////////////////////////////////////////////////////////////////
//  $Id: nnda.c,v 1.24 2004/11/09 14:43:58 mrsa Exp $
//
// nnda.c   --- nnDA main
//
// (C) NNsi project, 2004, all rights reserved.
//
//////////////////////////////////////////////////////////////////////////////
#include <PalmOS.h>
#include "nnda-rsc-defines.h"
#include "nnda-defines.h"

static void setnnDA_DAData       (FormType *frm, nnDADataType *adtP);
static void setDisp_nnDA_DAData  (FormType *frm, nnDADataType *adtP);
static void resetDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP);
static void endnnDA_DAData       (FormType *frm, nnDADataType *adtP);
static void displayJPEGscreen    (FormType *frm, nnDADataType *adtP);
#ifdef USE_CLIE
static void startClieDisp_DAData(FormType *frm, nnDADataType *adtP);
static void endClieDisp_DAData  (FormType *frm, nnDADataType *adtP);
#endif // #ifdef USE_CLIE


// \f[^̎擾֐Q
static Char *getFileStreamData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getVfsFileData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getFileStreamBinData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getFileStreamUtf8Data(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getFileStreamHtmlData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getMemoryHandleData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *getStringListData(nnDADataType *adtP);
static Char *getStringData    (UInt16 rscID, nnDADataType *adtP);
static Char *outputHexString(Char *data, UInt16 len, nnDADataType *adtP);
static Char *getJpegFileData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static Char *openFileStreamForJPEG(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP);
static void postProcessJpegDisplay(nnDADataType *adtP);

// UTF8 -> Shift JISϊe[u (AMsoft̂cagp)
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId);

static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr);
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte);
static UInt16  Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L);

static void ParseMessage(Char *buf, Char *src, UInt32 size, UInt16 kanjiCode);

Boolean textCallBack(PrgCallbackDataPtr cbP);
static Boolean checkVFSdevice(UInt32 aMediaType, nnDADataType *adtP);

#if 0
/*=========================================================================*/
/*   Function : MemPtrNew_NNsh                                             */
/*                                    mۊ֐(IɎg...)  */
/*=========================================================================*/
MemPtr MemPtrNew_NNsh(UInt32 size, nnDADataType *adtP)
{
    if (adtP->palmOSVersion > 0x04000000)
    {
        // over 64kB̗̈mۂ(OS4.xȏ)
        return (MemGluePtrNew(size));
    }
    // ʏ̃m
    return (MemPtrNew(size));
}
#endif

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamBinData                                      */
/*                                  fileStreamoCif[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamBinData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    UInt32     creator, dataSize;
    UInt16     len;
    Char      *fileName, *ptr, *ptr2;
    Err        err;
    FileHand   filRef;
    
    // creatorID̒o
    ptr = (Char *) &creator;
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂
    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MEMALLOC_PTR(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MEMALLOC_PTR", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &dataSize, &err) != -1)
    {
        len = dataSize;
        if (dataSize > (DISP_LIMIT / 3))
        {
            len = (DISP_LIMIT / 3);
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MEMALLOC_PTR(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MEMALLOC_PTR()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        FileRead(filRef, ptr, 1, len, &err);
        ptr2 = outputHexString(ptr, len, adtP);
        if (ptr2 != NULL)
        {
            // oCi\f[^쐬łÄJ
            MEMFREE_PTR(ptr);
            ptr = ptr2;
        }
        MEMFREE_PTR(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "FileTell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamData                                         */
/*                                          fileStreamf[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    UInt32     creator, dataSize;
    UInt16     len;
    Char      *fileName, *ptr;
    Err        err;
    FileHand   filRef;
    
    // creatorID̒o
    ptr = (Char *) &creator;
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂
    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MEMALLOC_PTR(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MEMALLOC_PTR", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAG[R[h\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &dataSize, &err) != -1)
    {
        len = dataSize;
        if (dataSize > DISP_LIMIT)
        {
            len = DISP_LIMIT;
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MEMALLOC_PTR(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MEMALLOC_PTR()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        StrCopy(ptr, "size:");
        StrIToA(&ptr[StrLen(ptr)], len);
        StrCat (ptr, "/");
        StrIToA(&ptr[StrLen(ptr)], dataSize);
        StrCat (ptr, "\n=====\n");
        FileRead(filRef, &ptr[StrLen(ptr)], 1, len, &err);
        MEMFREE_PTR(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "FileTell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}


/*-------------------------------------------------------------------------*/
/*   Function :  getVfsFileData                                            */
/*                                            VFS filef[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getVfsFileData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    Err     ret;
    Char   *fileName, *ptr, *ptr2;
    Boolean result;
    UInt32  dataSize, len;

    // xRRRR:/...(fileName)...
    //   x: ǂݍ݃t@Ĉ肩(t@CXg[ or VFS̎w)
    //       v : VFS (wȂ)
    //       c : VFS (CF)
    //       m : VFS (MS)
    //       s : VFS (SD)
    //       t : VFS (SmartMedia ... ToshibaT)
    //       r : VFS (RD  : ramdisk)
    //       d : VFS (DoC : foCX)
    //   RRRR: \̈
    //   /...(fileName)...  t@C
    adtP->vfsFileRef = 0;
    switch (infoName[0])
    {
      case 'c': 
        // VFS(CF)
        result = checkVFSdevice(ExpMediaType_CompactFlash, adtP);
        break;

      case 'm': 
        // VFS(MS)
        result = checkVFSdevice(ExpMediaType_MemoryStick, adtP);
        break;

      case 's': 
        // VFS(SD)
        result = checkVFSdevice(ExpMediaType_SecureDigital, adtP);
        if (result == false)
        {
            result = checkVFSdevice(ExpMediaType_MultiMediaCard, adtP);
        }
        break;

      case 't': 
        // VFS(SmartMedia)
        result = checkVFSdevice(ExpMediaType_SmartMedia, adtP);
        break;

      case 'r': 
        // VFS(RamDisk)
        result = checkVFSdevice(ExpMediaType_RAMDisk, adtP);
        break;

      case 'd': 
        // VFS(DoC)
        result = checkVFSdevice('Tffs', adtP);
        break;

      default:
        // VFS(any)
        result = checkVFSdevice(0, adtP);
        break;
    }
    if (result == false)
    {
        //  VFSoAI
        return (NULL);
    }
    fileName = MEMALLOC_PTR((nnDA_FILENAMESIZE + MARGIN));
    if (fileName == NULL)
    {
        // ̈mۂɎsAI
        return (NULL);
    }
    MemSet(fileName, (nnDA_FILENAMESIZE + MARGIN), 0x00);

    // t@C ϐt@CɃRs[
    ptr  = fileName;
    ptr2 = &(infoName[6]);
    while ((*ptr2 != '<')&&(*ptr2 != '\0'))
    {
        *ptr = *ptr2;
        ptr++;
        ptr2++;
    }

    // t@CI[v(VFS)
    ret = VFSFileOpen(adtP->vfsVol,fileName,vfsModeRead,&(adtP->vfsFileRef));
    if (ret != errNone)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], ret);
        adtP->vfsFileRef = 0;
        return (fileName);
    }

    // t@CTCY擾
    ret = VFSFileSize(adtP->vfsFileRef, &(dataSize));
    if (ret == errNone)
    {
        len = dataSize;
        if (dataSize > DISP_LIMIT)
        {
            len = DISP_LIMIT;
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MEMALLOC_PTR(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MEMALLOC_PTR()", titleSize);
            VFSFileClose(adtP->vfsFileRef);
            adtP->vfsFileRef = 0;
            return (fileName);
        }

        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        StrCopy(ptr, "size:");
        StrIToA(&ptr[StrLen(ptr)], len);
        StrCat (ptr, "/");
        StrIToA(&ptr[StrLen(ptr)], dataSize);
        StrCat (ptr, "\n=====\n");
        VFSFileSeek(adtP->vfsFileRef, vfsOriginBeginning, 0);
        VFSFileRead(adtP->vfsFileRef, len, &ptr[StrLen(ptr)], &(dataSize));
        MEMFREE_PTR(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "VfsFileSize()", titleSize);
        ptr = fileName;
    }
    VFSFileClose(adtP->vfsFileRef);

    adtP->vfsFileRef = 0;
    return (ptr);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamUtf8Data                                     */
/*                                      fileStreamUTF8f[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamUtf8Data(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    UInt32     creator, dataSize;
    UInt16     len;
    Char      *fileName, *ptr, *ptr2;
    Err        err;
    FileHand   filRef;
    LocalID    dbId;

    dbId = DmFindDatabase(0, "UnicodeToJis0208");
    if (dbId == 0)
    {
        StrNCopy(title, "Not exist:UTF8-DB", titleSize);
        return (NULL);
    }
    
    // creatorID̒o
    ptr = (Char *) &creator;
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂
    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MEMALLOC_PTR(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MEMALLOC_PTR", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &dataSize, &err) != -1)
    {
        len = dataSize;
        if (dataSize > (DISP_LIMIT / 3))
        {
            len = (DISP_LIMIT / 3);
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MEMALLOC_PTR(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MEMALLOC_PTR()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        FileRead(filRef, ptr, 1, len, &err);
        
        ptr2 = MEMALLOC_PTR(len + BUF_MARGIN);
        if (ptr2 == NULL)
        {
            StrNCopy(title, "MEMALLOC_PTR()", titleSize);
            FileClose(filRef);
            MEMFREE_PTR(ptr);
            return (fileName);            
        }
        MemSet(ptr2, (len + BUF_MARGIN), 0x00);
        StrNCopyUTF8toSJ(ptr2, ptr, len, dbId);

        // ϊ̕񂪍쐬łÄJ
        MEMFREE_PTR(ptr);
        ptr = ptr2;
        MEMFREE_PTR(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "FileTell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}

/*--------------------------------------------------------------------------*/
/*  Function : outputHexString                                              */
/*                                             fobOpɐlփf[^ϊ */
/*--------------------------------------------------------------------------*/
static Char *outputHexString(Char *data, UInt16 len, nnDADataType *adtP)
{
    UInt16   loop;
    UInt8   *dat;
    Char     buff[12], *buffer;

    buffer = MEMALLOC_PTR(len * 3 + MARGIN);
    if (buffer == NULL)
    {
         // ̈mێsA\I
         return (NULL);
    }
    MemSet(buffer, (len * 3 + MARGIN), 0x00);

    // lf[^ʕ\
    dat = data;
    for (loop = 0; loop < len; loop++)
    {
        if ((loop % 8) == 0)
        {
            // f[^WÂ؂
            StrCat(buffer, "\n");            
        } 
        MemSet (buff, sizeof(buff), 0x00);
        StrIToH(buff, *dat);
        StrCat(buffer, &buff[6]);
        dat++;
    }
    return (buffer);
}


/*-------------------------------------------------------------------------*/
/*   Function :  getStringListData                                         */
/*                        ꗗʂ̑wvf[^(XgO)擾 */
/*-------------------------------------------------------------------------*/
static Char *getStringListData(nnDADataType *adtP)
{
    MemHandle  memH, memH2;
    UInt16     len;
    Char      *ptr, *ptr2, *data;

    // XgO\[X擾
    memH = DmGetResource('tSTR', HELPSTRING_LIST);
    if (memH == 0)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    len = StrLen(ptr);
    
    // XgO\[X擾
    ptr2  = NULL;
    memH2 = DmGetResource('tSTR', HELPSTRING_LIST2);
    if (memH2 != 0)
    {
        ptr2 = MemHandleLock(memH2);
        if (ptr2 != NULL)
        {
            len = len + StrLen(ptr2);
        }
    }

    // f[^̊i[̈mۂA\[Xf[^Rs[
    // iŊmۂ̈́AnnDAIɉj
    data = MEMALLOC_PTR(len + MARGIN);
    if (data == NULL)
    {
        return (NULL);
    }
    MemSet (data, (len + MARGIN), 0x00);
    StrCopy(data, ptr);
    if (ptr2 != NULL)
    {
        StrCat(data, ptr2);
    }
    MemHandleUnlock(memH2);
    MemHandleUnlock(memH);

    return (data);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getStringData                                             */
/*                                  wvf[^(XgO)擾 */
/*-------------------------------------------------------------------------*/
static Char *getStringData(UInt16 rscID, nnDADataType *adtP)
{
    MemHandle  memH;
    UInt16     len;
    Char      *ptr, *data;

    // XgO\[X擾
    memH = DmGetResource('tSTR', rscID);
    if (memH == 0)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    len = StrLen(ptr);

    // f[^̊i[̈mۂA\[Xf[^Rs[
    // iŊmۂ̈́AnnDAIɉj
    data = MEMALLOC_PTR(len + 4);
    if (data == NULL)
    {
        return (NULL);
    }
    MemSet (data, (len + 4), 0x00);
    StrCopy(data, ptr);

    MemHandleUnlock(memH);

    return (data);
}

/*-------------------------------------------------------------------------*/
/*   Function :  checkDisplayMode                                          */
/*                           ʃ[h(PalmOS5𑜓xT|[g)̃`FbN */
/*-------------------------------------------------------------------------*/
static void checkDisplayMode(nnDADataType *adtP)
{
    UInt32 version;
#ifdef USE_CLIE
    Err     ret;
    Boolean isColor;
    UInt32  width, height, depth;
#endif

    adtP->os5density = (UInt32) kDensityLow;

    // 𑜓xtB[`[̎擾
    if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &(version)) != 0)
    {
        // 𑜓xtB[`[̃T|[gȂ
        return;
    }
    if (version < 4)
    {
        //@𑜓x̃T|[gȂꍇ̏
        //  (Ő񂾂낤...}jAɂ͂Ă...)
#ifdef USE_CLIE
        // CLIEp𑜓xT|[gĂ邩`FbN    
        // HRLIB̎QƔԍ擾
        ret = SysLibFind(sonySysLibNameHR, &(adtP->hrRef));
        if (ret == sysErrLibNotFound)
        {
            // HRLIB[h̏ꍇA[hł邩TryĂ݂B
            ret = SysLibLoad('libr', sonySysFileCHRLib, &(adtP->hrRef));
        }
        if (ret != errNone)
        {
            // HRLIB͎gpłȂAW𑜓xg
            adtP->hrRef = 0;
            return;
        }

        // HRLIB̎gp錾HRLIB̃o[Wԍ擾
        HROpen(adtP->hrRef);
        HRGetAPIVersion(adtP->hrRef, &(adtP->hrVer));
        if (adtP->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
        {
            // o[W̃nC]...ʃ[hmF...
            ret = HRWinScreenMode(adtP->hrRef, winScreenModeGet, 
                                  &width, &height, &depth, &isColor);
            if ((ret != errNone)||(width != hrWidth))
            {
                // nC][hł͂Ȃ̂ŁAHRLIB͎gpȂ
                HRClose(adtP->hrRef);
                adtP->hrRef = 0;
                return;
            }
        }
#endif // #ifdef USE_CLIE
        return;
    }

    // Window̉𑜓x擾
    WinScreenGetAttribute(winScreenDensity, &(adtP->os5density));

    // Ƃ肠AW𑜓xɂĂ
    WinSetCoordinateSystem(kCoordinatesStandard);

    return;
}

/*=========================================================================*/
/*   Function :  getInformation                                            */
/*                          ^ꂽ񂩂A\ׂ̐ݒs */
/*=========================================================================*/
Char *getInformation(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    // ^ꂽ񂪈ُH
    if (infoName == NULL)
    {
        // B
        return (NULL);
    }

    ////////////////////// \^Cgƕ\̐ //////////////////

    // t@Cf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_FILE, (sizeof(nnDA_NNSIEXT_FILE) - 1)) == 0)
    {
        return (getFileStreamData((infoName + sizeof(nnDA_NNSIEXT_FILE) - 1), title, titleSize, adtP));
    }

    // t@Cf[^擾(܂ԂΉ)
    if (StrNCompare(infoName, nnDA_NNSIEXT_FILE_FOLD, (sizeof(nnDA_NNSIEXT_FILE_FOLD) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_FOLD;  // ܂肽ݑΉw
        return (getFileStreamData((infoName + sizeof(nnDA_NNSIEXT_FILE_FOLD) - 1), title, titleSize, adtP));
    }

    // ꗗʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPLIST, (sizeof(nnDA_NNSIEXT_HELPLIST) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_LIST, titleSize);
        return (getStringListData(adtP));
    }

    // QƉʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPVIEW, (sizeof(nnDA_NNSIEXT_HELPVIEW) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_VIEW, titleSize);
        return (getStringData(HELPSTRING_VIEW, adtP));
    }

    // [Uݒ^uʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPUSERTAB, (sizeof(nnDA_NNSIEXT_HELPUSERTAB) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_USERTAB, titleSize);
        return (getStringData(HELPSTRING_USERTAB, adtP));
    }

    // NNsiݒʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPNNSISET, (sizeof(nnDA_NNSIEXT_HELPNNSISET) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_NNSISET, titleSize);
        return (getStringData(HELPSTRING_NNSISET, adtP));
    }

    // QƃOꗗʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPGETLOG, (sizeof(nnDA_NNSIEXT_HELPGETLOG) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_GETLOG, titleSize);
        return (getStringData(HELPSTRING_GETLOG, adtP));
    }

    // t@C̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_FILE, (sizeof(nnDA_NNSIEXT_FILE) - 1)) == 0)
    {
        return (getFileStreamData(infoName + (sizeof(nnDA_NNSIEXT_FILE) - 1), title, titleSize, adtP));
    }

    // oCit@C̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_BINFILE, (sizeof(nnDA_NNSIEXT_BINFILE) - 1)) == 0)
    {
        return (getFileStreamBinData(infoName + (sizeof(nnDA_NNSIEXT_BINFILE) - 1), title, titleSize, adtP));
    }

    // nh̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_VIEWMEM, (sizeof(nnDA_NNSIEXT_VIEWMEM) - 1)) == 0)
    {
        return (getMemoryHandleData(infoName + (sizeof(nnDA_NNSIEXT_VIEWMEM) - 1), title, titleSize, adtP));
    }

    // nh̃f[^ǂݏo...(܂肽ݎwΉ)
    if (StrNCompare(infoName, nnDA_NNSIEXT_VIEWMEM_FOLD, (sizeof(nnDA_NNSIEXT_VIEWMEM_FOLD) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_FOLD;  // ܂肽ݑΉw
        return (getMemoryHandleData(infoName + (sizeof(nnDA_NNSIEXT_VIEWMEM_FOLD) - 1), title, titleSize, adtP));
    }

    // HTMLt@C̃f[^ǂݏo...(܂肽ݎwΉ)
    if (StrNCompare(infoName, nnDA_NNSIEXT_HTML_FOLD, (sizeof(nnDA_NNSIEXT_HTML_FOLD) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_FOLD;  // ܂肽ݑΉw
        return (getFileStreamHtmlData(infoName + (sizeof(nnDA_NNSIEXT_HTML_FOLD) - 1), title, titleSize, adtP));
    }

    // HTMLt@C̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_HTMLFILE, (sizeof(nnDA_NNSIEXT_HTMLFILE) - 1)) == 0)
    {
        return (getFileStreamHtmlData(infoName + (sizeof(nnDA_NNSIEXT_HTMLFILE) - 1), title, titleSize, adtP));
    }

    // UTF8t@C̃f[^ǂݏo
    if (StrNCompare(infoName, nnDA_NNSIEXT_UTF8FILE, (sizeof(nnDA_NNSIEXT_UTF8FILE) - 1)) == 0)
    {
        if (DmFindDatabase(0, "UnicodeToJis0208") != 0)
        {
            return (getFileStreamUtf8Data(infoName + (sizeof(nnDA_NNSIEXT_UTF8FILE) - 1), title, titleSize, adtP));
        }
        return (getFileStreamData((infoName + sizeof(nnDA_NNSIEXT_FILE_FOLD) - 1), title, titleSize, adtP));
    }

    // UTF8t@C̃f[^ǂݏo(܂肽ݎwΉ)
    if (StrNCompare(infoName, nnDA_NNSIEXT_UTF8FILEFOLD, (sizeof(nnDA_NNSIEXT_UTF8FILEFOLD) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_FOLD;  // ܂肽ݑΉw
        if (DmFindDatabase(0, "UnicodeToJis0208") != 0)
        {
            return (getFileStreamUtf8Data(infoName + (sizeof(nnDA_NNSIEXT_UTF8FILEFOLD) - 1), title, titleSize, adtP));
        }
        return (getFileStreamData((infoName + sizeof(nnDA_NNSIEXT_FILE_FOLD) - 1), title, titleSize, adtP));
    }

    // VFSt@C̃f[^ǂݏo
    if (StrNCompare(infoName, nnDA_NNSIEXT_VFSFILE, (sizeof(nnDA_NNSIEXT_VFSFILE) - 1)) == 0)
    {
        return (getVfsFileData(infoName + (sizeof(nnDA_NNSIEXT_VFSFILE) - 1), title, titleSize, adtP));
    }

    // VFSt@C̃f[^ǂݏo(܂肽ݎwΉ)
    if (StrNCompare(infoName, nnDA_NNSIEXT_VFSFILE_FOLD, (sizeof(nnDA_NNSIEXT_VFSFILE_FOLD) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_FOLD;  // ܂肽ݑΉw
        return (getVfsFileData(infoName + (sizeof(nnDA_NNSIEXT_VFSFILE_FOLD) - 1), title, titleSize, adtP));
    }

    // JPEGt@C̕\s...
    if (StrNCompare(infoName, nnDA_NNSIEXT_SHOWJPEG, (sizeof(nnDA_NNSIEXT_SHOWJPEG) - 1)) == 0)
    {
        adtP->displayCommand = nnDA_DISPCOMMAND_JPEGDISP;
        return (getJpegFileData((infoName + sizeof(nnDA_NNSIEXT_SHOWJPEG) - 1), title, titleSize, adtP));
    }

    // nnDAT|[gBBB
    return (NULL);
}

/*-------------------------------------------------------------------------*/
/*   Function :  nnDA_EventHandler                                         */
/*                                                   nnDA  event     */
/*-------------------------------------------------------------------------*/
static Boolean nnDA_EventHandler(EventPtr evP)
{
    UInt16        btnId = 0;
    Boolean       mov;
    nnDADataType *adtP = NULL;
    FormType     *frm;
    ControlType  *obj;

    // global pointer擾
    if (FtrGet(nnDA_Creator, ADT_FTRID, (UInt32 *) &adtP) != 0)
    {
        // O[o|C^擾s
        return (false);
    }

    // VtgCWP[^mF
    frm = FrmGetActiveForm();
    obj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));
    mov = CtlEnabled(obj);

    switch (evP->eType)
    {
      case keyDownEvent:
        switch (evP->data.keyDown.chr)
        {
          // JOG PUSH/ZL[Ƃ̏
          case vchrJogRelease:
          case vchrThumbWheelPush:
          case chrCapital_Z:
          case chrSmall_Z:
            // ㉺ړ[hEEړ[h̐؂ւs
            btnId = BTNID_SHIFT;
            break;

          case vchrPageDown:
          case chrDownArrow:
          case vchrJogDown:
          case chrCapital_J:
          case chrSmall_J:
            // XN[
            if (mov == true)
            {
                // Eړ[h(EXN[)
                btnId = BTNID_NEXT;
            }
            else
            {
                // ㉺ړ[h(XN[)
                btnId = BTNID_DOWN;
            }
            break;

          case vchrPageUp:
          case chrUpArrow:
          case vchrJogUp:
          case chrCapital_K:
          case chrSmall_K:
            if (mov == true)
            {
                // Eړ[h(EXN[)
                btnId = BTNID_PREV;
            }
            else
            {
                // ㉺ړ[h(XN[)
                btnId = BTNID_UP;
            }
            break;

          case vchrJogLeft:
          case chrLeftArrow:
          case vchrJogPushedUp:
          case chrCapital_H:
          case chrSmall_H:
            // XN[
            btnId = BTNID_PREV;
            break;

          case vchrJogRight:
          case chrRightArrow:
          case vchrJogPushedDown:
          case chrCapital_L:
          case chrSmall_L:
            // EXN[
            btnId = BTNID_NEXT;
            break;

          case vchrHard2:
          case vchrHard3:
          case chrCapital_Q:
          case chrSmall_Q:
            // njƂɂ
            CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                          FrmGetObjectIndex(FrmGetActiveForm(),
                                          BTNID_DA_OK)));
            return (true);
            break;
            
          case chrBackspace:
          case chrEscape:
            // About\
            btnId = BTNID_DA_ABOUT;
            break;

          case vchrNavChange:
            // 5way navigatorΉ
            if ((evP->data.keyDown.keyCode) & navBitLeft)
            {
                // J[\L[Ɠ(XN[)
                btnId = BTNID_PREV;
                break;
            }
            if ((evP->data.keyDown.keyCode) & navBitRight)
            {
                // J[\L[EƓ(EXN[)
                btnId = BTNID_NEXT;
                break;
            }
            break;
          case chrCapital_F:
          case chrSmall_F:
            // tHgTCY̕ύX...
            adtP->fontId = FontSelect(adtP->fontId);
            FntSetFont(adtP->fontId);
            btnId = GADID_DA_VIEW;
            break;
           
          case chrSpace:
          case chrCarriageReturn:
          case chrLineFeed:
          default:
            // Ȃ
            return (false);
            break;
        }
        break;

      case ctlSelectEvent:
        // Ƃŏ
        btnId = evP->data.ctlSelect.controlID;
        break;
        
      case ctlRepeatEvent:
        // Ƃŏ
        btnId = evP->data.ctlRepeat.controlID;

      default:
        // Ȃ
        return (false);
        break;
    }

    // {^ꂽƂ̏
    switch (btnId)
    {
      case BTNID_DA_ABOUT:
        // About\
        FrmAlert(ALERTID_DA_ABOUT);
        break;

      case BTNID_UP:
        // ړ
        if (adtP->startY > 0)
        {
            adtP->startY = adtP->startY - (adtP->area.extent.y / 2);
        }
        break;      

      case BTNID_DOWN:
        // ړ
        if (adtP->startY < adtP->maxY)
        {
            adtP->startY = adtP->startY + (adtP->area.extent.y / 2);
        }
        break;

      case BTNID_PREV:
        // O(ړ)
        if (adtP->startX > 0)
        {
            adtP->startX = adtP->startX - (adtP->area.extent.x / 2);
        }
        break;

      case BTNID_NEXT:
        // (Eړ)
        if (adtP->startX < adtP->maxX)
        {
            adtP->startX = adtP->startX + (adtP->area.extent.x / 2);
        }
        break;

      case BTNID_SHIFT:
        // VtgԐ؂ւ
        // ON/OFF؂ւA"!"̕\؂ւ
        if (mov == true)
        {
            // Eړ[h㉺ړ[h(!)
            CtlSetEnabled(obj, false);
            CtlSetUsable (obj, false);
            FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));                
        }
        else
        {
            // ㉺ړ[hEړ[h(!\)
            CtlSetEnabled(obj, true);
            CtlSetUsable (obj, true);
            FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));   
        }
        break;

      case GADID_DA_VIEW:
        // ʂĕ`悷
        break;

      default:
        // Ȃ
        return (false);
        break;
    }

    // JPEG\̏ꍇɂ́AȂɂȂ
    if (adtP->displayCommand == nnDA_DISPCOMMAND_JPEGDISP)
    {
        return (false);
    }

    // ʂĕ`(eLXg\̂Ƃ)
    setDisp_nnDA_DAData  (FrmGetActiveForm(), adtP);
    setnnDA_DAData       (FrmGetActiveForm(), adtP);
    resetDisp_nnDA_DAData(FrmGetActiveForm(), adtP);

    return (true);
}

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  startClieDisp_DAData                                      */
/*                                              `惂[hݒ菈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void startClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{

    // drawȂƁAWindowɗ̈悪\ȂAAA
    FrmDrawForm(frm);

    // KWFbg̗̈TCY擾
    FrmGetObjectBounds(frm,
                       FrmGetObjectIndex(frm, GADID_DA_VIEW),
                       &(adtP->dimF));

    // CLIE𑜓xpɕ`GAg傷
    adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2;
    adtP->area.extent.x   = adtP->dimF.extent.x  * 2;
    adtP->area.extent.y   = adtP->dimF.extent.y  * 2;
    adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2;

    // `̈̃NA
    HRWinEraseRectangle(adtP->hrRef, &(adtP->area), 0);

    return;
}
#endif  // #ifdef USE_CLIE


#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  endClieDisp_DAData                                        */
/*                                                  ʕ`㏈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void endClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{

    return;
}
#endif // #ifdef USE_CLIE


/*-------------------------------------------------------------------------*/
/*   Function :  WinDrawChar_NNsh                                          */
/*                                                            \ */
/*-------------------------------------------------------------------------*/
static void WinDrawChar_NNsh(nnDADataType *adtP, WChar theChar, 
                               Coord x, Coord y)
{
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        HRWinDrawChar(adtP->hrRef, theChar, x, y);
    }
    else
#endif
    {
        WinDrawChar(theChar, x, y);
    }
    return;    
}

/*-------------------------------------------------------------------------*/
/*   Function :  setDisp_nnDA_DAData                                       */
/*                                            ʂɕ\t鏈 */
/*-------------------------------------------------------------------------*/
static void setDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP)
{
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        startClieDisp_DAData(frm, adtP);  //  ʕ\
        return;
    }
#endif

    // drawȂƁAWindowɗ̈悪\ȂAAA
    FrmDrawForm(frm);

    // KWFbg̗̈TCY擾
    FrmGetObjectBounds(frm,FrmGetObjectIndex(frm, GADID_DA_VIEW),
                                                               &(adtP->dimF));

    // 𑜓x[hmFÄNA(areaɎ𑜓xi[)
    switch (adtP->os5density)
    {
      case kDensityDouble:
        // 320x320
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 2;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 2;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityTriple:
        // 480x480
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 3;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 3;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 3;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 3;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityQuadruple:
        // 640x640
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 4;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 4;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 4;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 4;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityOneAndAHalf:
        // 240x240
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2 / 3;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 2 / 3;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 2 / 3;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2 / 3;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityLow:
      default:
        // 160x160
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x;
        adtP->area.extent.x   = adtP->dimF.extent.x;
        adtP->area.extent.y   = adtP->dimF.extent.y;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y;
        break;
    }
    // `̈̃NA
    WinEraseRectangle(&(adtP->area), 0);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  resetDisp_nnDA_DAData                                     */
/*                                    ʂɕ\t鏈̌㏈ */
/*-------------------------------------------------------------------------*/
static void resetDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP)
{

    // 𑜓x̐ݒ
    switch (adtP->os5density)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()), adtP->os5density);
        WinSetCoordinateSystem(kCoordinatesStandard);
        break;

      case kDensityLow:
      default:
        break;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  endnnDA_DAData                                            */
/*                                    ʂɕ\t鏈̌㏈ */
/*-------------------------------------------------------------------------*/
static void endnnDA_DAData(FormType *frm, nnDADataType *adtP)
{
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        endClieDisp_DAData(frm, adtP);  //  ʕ\
        return;
    }
#endif

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  setnnDA_DAData                                            */
/*                                            ʂɕ\t鏈 */
/*-------------------------------------------------------------------------*/
static void setnnDA_DAData(FormType *frm, nnDADataType *adtP)
{
    UInt16  letter;
    UInt8  *ptr, upper, lower;
    Coord   x, y, topX, marginX;

    ptr  = adtP->areaP;
    topX = 0;
    x    = 0;
    y    = 0;
    marginX = FntCharWidth('\x01');   // missing character symbol̕
    while ((UInt8 *) ptr < adtP->areaP + adtP->length)
    {
        // w肳ꂽR[h\
        if ((*ptr == 0x0a)||(*ptr == 0x0d))
        {
            if ((*ptr == 0x0d)&&(*(ptr + 1) == 0x0a))
            {
                // sR[hbq{keꍇ
                ptr++;
            }

            // sR[ĥƂ
            y = y + FntCharHeight();
            adtP->maxY = y;
            x = topX;
            ptr++;
            if (y >= adtP->startY + adtP->area.extent.y)
            {
                // `̈敝𒴂AI
                break;
            }
            continue;
        }

        // ܂Ԃ\sꍇ̃`FbNAAA(\͈͂𒴂Ă邩H)
        if ((adtP->displayCommand == nnDA_DISPCOMMAND_FOLD)&&
            (x >= adtP->startX + adtP->area.extent.x))
        {
            // s{
            y = y + FntCharHeight();
            adtP->maxY = y;
            x = topX;
            if (y >= adtP->startY + adtP->area.extent.y)
            {
                // `̈敝𒴂AI
                break;
            }
            continue;
        }

        //  or ANK ?
        if ((*ptr <= 0x80)||((*ptr >= 0xa1)&&(*ptr <= 0xdf)))
        {            
            // VOoCg̏ꍇ
            letter = *ptr;
            ptr++;
            if ((letter >= 0x20)&&(x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                WinDrawChar_NNsh(adtP, letter, 
                                 (x - adtP->startX + adtP->area.topLeft.x),
                                 (y - adtP->startY + adtP->area.topLeft.y));
            }
#ifdef USE_REAL_WIDTH
            // vZlɂ...
            x = x + FntCharWidth(letter);
#else
            x = x + marginX;
#endif
           adtP->maxX = x;
        }
        else
        {            
            // _uoCg̏ꍇAJISR[hɕϊĂ
            // 8rbg/8rbgϐɃRs[
            upper   = *ptr;
            letter  = *ptr << 8;
            ptr++;
            lower   = *ptr;
            letter  = letter + *ptr;
            ptr++;
            if (upper <= 0x9f)
            {
                if (lower < 0x9f)
                {
                    upper = (upper << 1) - 0xe1;
                }
                else
                {
                    upper = (upper << 1) - 0xe0;
                }
            }
            else
            {
                if (lower < 0x9f)
                {
                    upper = ((upper - 0xb0) << 1) - 1;
                }
                else
                {
                    upper = ((upper - 0xb0) << 1);
                }
            }
            if (lower < 0x7f)
            {
                lower = lower - 0x1f;
            }
            else
            {
                if (lower < 0x9f)
                {
                    lower = lower - 0x20;
                }
                else
                {
                    lower = lower - 0x7e;
                }
            }

            if ((x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                WinDrawChar_NNsh(adtP, letter, 
                                 (x - adtP->startX + adtP->area.topLeft.x),
                                 (y - adtP->startY + adtP->area.topLeft.y));
            }            
            letter = upper << 8;
            letter = lower + letter;
            x = x + (marginX + marginX);
            adtP->maxX = x;
        }
    }

    return;
}

/*=========================================================================*/
/*   Function :  nnDAMain                                                  */
/*                                                        DAf[^\ */
/*=========================================================================*/
void nnDAMain(void)
{
    FontID        fontId;
    UInt16        result, size, len;
    MemHandle     memH;
    Char         *areaP, *ptr, *infoName, *infoData;
    FormType     *diagFrm, *prevFrm;
    nnDADataType *adtP;
    UInt32        osVersion;
#ifdef USE_DIA
    UInt32        diaVar;
#endif
    UInt16        objIndex;
    Coord         x, y, diffX, diffY;
    RectangleType r;

    // ݂̃tH[擾
    prevFrm = FrmGetActiveForm();

    // Lf[^̊m
    size = sizeof(nnDADataType) + MARGIN;
    adtP = MEMALLOC_PTR(size);
    if (adtP == NULL)
    {
        // ̈mێsAI
        return;
    }
    MemSet(adtP, size, 0x00);
    StrNCopy(adtP->title, nnDA_DEFTITLE, nnDA_TITLESIZE);
    infoData  = NULL;
    areaP     = NULL;
    ptr       = NULL;

    // global pointerfeatureƂăZbg
    FtrSet(nnDA_Creator, ADT_FTRID, (UInt32) adtP);

    // OSo[W̊mF
    if (FtrGet(sysFtrCreator, sysFtrNumROMVersion, &osVersion) == errNone)
    {
        adtP->palmOSVersion = osVersion;
    }

    // tHgTCYꎞIɕύX
    fontId = FntGetFont();
    adtP->fontId = stdFont;
    FntSetFont(adtP->fontId);

    //  ʃ[h̃`FbN
    checkDisplayMode(adtP);

#ifdef USE_DIA
    // DIAT|[g邩ǂmF
    result = FtrGet(pinCreator, pinFtrAPIVersion, &diaVar);
    if (result != errNone)
    {
        // DIA T|[gfoCXA_CAOTCY̊g͂Ȃ
        diagFrm = FrmInitForm(FRMID_DA_VIEWER);
        FrmSetActiveForm(diagFrm);
        goto RESIZE_WINDOW;
    }

    // DIAT|[gfoCX AVNIɓ\mF
    result = FtrGet(sysFtrCreator, sysFtrNumInputAreaFlags, &diaVar);
    if ((result != errNone)|
        ((diaVar & grfFtrInputAreaFlagDynamic) == 0)||
        ((diaVar & grfFtrInputAreaFlagCollapsible) == 0))
    {
        // G[ɂȂꍇA͓IVNT|[g̏ꍇA
        diagFrm = FrmInitForm(FRMID_DA_VIEWER);
        FrmSetActiveForm(diagFrm);
        goto RESIZE_WINDOW;
    }

    // ݂̃VNԂL
    objIndex = PINGetInputAreaState();

    // _CAÕI[v
    diagFrm = FrmInitForm(FRMID_DA_VIEWER);
    FrmSetActiveForm(diagFrm);

    // VNLɂ
    FrmSetDIAPolicyAttr(diagFrm, frmDIAPolicyCustom);
    PINSetInputTriggerState(pinInputTriggerEnabled);

    // 炢x^AAAEBhETCY̍őlŏlݒ
    WinSetConstraintsSize(FrmGetWindowHandle(diagFrm),
                          160, 225, 225, 160, 225, 225);

    // VN̈ۑĂ̂ɂ
    PINSetInputAreaState(objIndex);

RESIZE_WINDOW:
#else  // #ifdef USE_DIA
    // Viewer Form̏
    diagFrm = FrmInitForm(FRMID_DA_VIEWER);
    FrmSetActiveForm(diagFrm);
#endif  // #ifdef USE_DIA

    /* ŜWindowTCY擾 */
    WinGetDisplayExtent(&x, &y);

    /* dialog̃TCY */
    FrmGetFormBounds(diagFrm, &r);

    /* dialog̊g */
    r.topLeft.x = 2;
    r.topLeft.y = 3;
    diffX = r.extent.x;
    diffY = r.extent.y;
    r.extent.y = y - 6;
    r.extent.x = x - 4;
    
    diffX = r.extent.x - diffX;
    diffY = r.extent.y - diffY;
    WinSetWindowBounds(FrmGetWindowHandle(diagFrm), &r);

    /* OK {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DA_OK);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_UP);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_PREV);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* E {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_NEXT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DOWN);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* SHIFT {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_SHIFT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    // ĺA㉺ړ[hɐݒ
    CtlSetEnabled(FrmGetObjectPtr(diagFrm, objIndex), false);
    CtlSetUsable (FrmGetObjectPtr(diagFrm, objIndex), false);
    FrmHideObject(diagFrm, objIndex);                

    /* About {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DA_ABOUT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* gadget̊g */
    objIndex = FrmGetObjectIndex(diagFrm, GADID_DA_VIEW);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    r.extent.x = r.extent.x + diffX;
    r.extent.y = r.extent.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    // Viewer Form̃Cxgnho^
    FrmSetEventHandler(diagFrm, nnDA_EventHandler);

    ////////////////////////////////////////////////////////////
    //  f[^̉ʐݒ菈
    //   (Nbv{[hɂf[^擾\)
    memH = ClipboardGetItem(clipboardText, &len);
    if ((len != 0)&&(memH != 0))
    {
        areaP = MemHandleLock(memH);
        if (areaP != NULL)
        {
            ///////////////////// NNsiƂ̘Ag 
            if (StrNCompare(areaP, nnDA_NNSIEXT_VIEWSTART, StrLen(nnDA_NNSIEXT_VIEWSTART)) == 0)
            {
                // f[^tH[𒊏o
                ptr = StrStr(areaP, nnDA_NNSIEXT_INFONAME);
                if (ptr != NULL)
                {
                    // f[^񖼂؂o
                    ptr = ptr + StrLen(nnDA_NNSIEXT_INFONAME);
                    infoName = MEMALLOC_PTR(BUFSIZE);
                    if (infoName != NULL)
                    {
                        MemSet(infoName, BUFSIZE, 0x00);
                        infoData = infoName;
                        while ((*ptr != '<')&&(ptr < areaP + len))
                        {
                            *infoData = *ptr;
                            ptr++;
                            infoData++;
                        }
                        // \ׂ̎擾
                        infoData = getInformation(infoName, adtP->title, nnDA_TITLESIZE, adtP);
                        if (infoData != NULL)
                        {
                            // \f[^̐ݒ
                            areaP = infoData;          // 
                            len   = StrLen(infoData);  // 
                        }
                        // 񖼗̈̉
                        MEMFREE_PTR(infoName);
                        infoName = NULL;
                    }
                }
            }
            ///////////////////// NNsiƂ̘Ag ܂

            // `f[^̃|C^L
            adtP->areaP  = areaP;
            adtP->length = len;

            setDisp_nnDA_DAData  (diagFrm, adtP);  //  ʕ\
            if (adtP->displayCommand == nnDA_DISPCOMMAND_JPEGDISP)
            {
                // JPEGʕ\
                adtP->bitmapPP = NULL;
                displayJPEGscreen(FrmGetActiveForm(), adtP);

                // ㉺E{^Ȃ悤ɂ...
                CtlSetUsable(FrmGetObjectPtr(FrmGetActiveForm(),
                              FrmGetObjectIndex(FrmGetActiveForm(), 
                              BTNID_NEXT)), false);

                CtlSetUsable(FrmGetObjectPtr(FrmGetActiveForm(),
                              FrmGetObjectIndex(FrmGetActiveForm(), 
                              BTNID_PREV)), false);

                CtlSetUsable(FrmGetObjectPtr(FrmGetActiveForm(),
                              FrmGetObjectIndex(FrmGetActiveForm(), 
                              BTNID_UP)), false);

                CtlSetUsable(FrmGetObjectPtr(FrmGetActiveForm(),
                              FrmGetObjectIndex(FrmGetActiveForm(), 
                              BTNID_DOWN)), false);
            }
            else
            {
                // ʏ̕\
                setnnDA_DAData       (FrmGetActiveForm(), adtP);
            }
            resetDisp_nnDA_DAData(diagFrm, adtP);  //  ʕ\㏈
        }
    }
    ////////////////////////////////////////////////////////////

    // tH[̃^CgRs[
    FrmCopyTitle(diagFrm, adtP->title);

    // Dialog\
    result = FrmDoDialog(diagFrm);
    if (result == BTNID_DA_OK)
    {
        // OK{^ꂽAAAǁA͕KOKŔ͂
    }
    
    ////////////////////////////////////////////////////////////
    //  f[^̉ʐݒ̌㏈
    //
    endnnDA_DAData(diagFrm, adtP);
    //
    ////////////////////////////////////////////////////////////

    // JPEG\̌㏈(Kvł)
    postProcessJpegDisplay(adtP);

    // tHgTCYɖ߂
    FntSetFont(fontId);            

    // Nbv{[ḧJ
    if (memH != 0)
    {
        MemHandleUnlock(memH);
    }

    // e|f[^obt@
    if (infoData != NULL)
    {
        MEMFREE_PTR(infoData);
    }

    // tH[global pointeřn
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    FtrUnregister(nnDA_Creator, ADT_FTRID);
    MEMFREE_PTR(adtP);
}

/* --------------------------------------------------------------------------
 *   AMsoftUTF8ϊe[u𗘗pĎ
 *       (http://amsoft.minidns.net/palm/gfmsg_chcode.html)
 * --------------------------------------------------------------------------*/

/*=========================================================================*/
/*   Function : StrNCopyUTF8toSJ                                           */
/*                     ̃Rs[(UTF8SHIFT JISR[hւ̕ϊ{) */
/*=========================================================================*/
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId)
{
    UInt8     buffer[2];
    UInt16    cnt, codes, ucode;
    Boolean   kanji;
    DmOpenRef dbRef;   

    // ϊe[u邩mF
    // dbId  = DmFindDatabase(0, "UnicodeToJis0208");
    if (dbId == 0)
    {
        return;
    }
    dbRef = DmOpenDatabase(0 , dbId, dmModeReadOnly);

    kanji = false; 
    cnt = 0;
    while ((*src != '\0')&&(cnt <size))
    {
        if (*src < 0x80)
        {
            // p[h...
            *dst = *src;
            dst++;
            cnt++;
            src++;
            continue;
        }

        ucode = ((*src & 0x0f) << 12);
        ucode = ucode | ((*(src + 1) & 0x3f) << 6);
        ucode = ucode | ((*(src + 2) & 0x3f));

        buffer[0] = ((ucode & 0xff00) >> 8);
        buffer[1] = ((ucode & 0x00ff));

        // R[h̕ϊ
        codes = Unicode11ToJisx0208(dbRef, buffer[0], buffer[1]);
        buffer[0] = ((codes & 0xff00) >> 8);
        buffer[1] = (codes & 0x00ff);
        ConvertJIStoSJ(dst, buffer);

        dst = dst + 2;
        src = src + 3;
        cnt = cnt + 2;
    }
    *dst = '\0';

    DmCloseDatabase(dbRef);
    return;
}

/* --------------------------------------------------------------------------
 *  Unicode11ToJisx0208()
 *                                                       (Unicode > JIS0208)
 * --------------------------------------------------------------------------*/
static UInt16 Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L)
{
    MemHandle            recH;
    UInt16               num, col, code = 0x0000;
    UnicodeToJis0208Rec *rec;

    // f[^x[X̃R[hȂƂ...
    if (dbRef == 0)
    {
        // G[...
        return (0x2121);
    }
    num  = utf8H;

    // 킹
    if (utf8L < 0x80)
    {
        num = (utf8H * 2);
        col = utf8L;
    }
    else
    {
        num = (utf8H * 2) + 1;
        col = utf8L - 0x80;
    }
    
    recH = DmQueryRecord(dbRef, num);
    if (recH == 0)
    {
        // G[...
        return (0x2122);
    }
    rec = (UnicodeToJis0208Rec *) MemHandleLock(recH);
    if (rec->size > 0)
    {
        // f[^L
        code  = rec->table[col];
    }
    else
    {
        // f[^Ȃ
        code = 0x2121;
    }
    MemHandleUnlock(recH);
    return (code);
}

/*=========================================================================*/
/*   Function : ConvertJIStoSJ                                             */
/*                            JISR[hSHIFT JISR[hɕϊ */
/*=========================================================================*/
static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr)
{
    UInt8 upper, lower;

    // 8rbg/8rbgϐɃRs[
    upper = *ptr;
    lower = *(ptr + 1);

    // CɂASYT(p.110)̃R[hg킹Ă
    if ((upper & 1) != 0)
    {
        if (lower < 0x60)
        {
            lower = lower + 0x1f;
        }
        else
        {
            lower = lower + 0x20;
        }
    }
    else
    {
        lower = lower + 0x7e;
    }   
    if (upper < 0x5f)
    {
        upper = (upper + 0xe1) >> 1;
    }
    else
    {
        upper = (((upper + 0x61) >> 1)|(0x80));
    }
    *dst = upper;
    dst++;
    *dst = lower;

    return (true);
}

/*=========================================================================*/
/*   Function : ConvertEUCtoSJ                                             */
/*                                  R[hEUCSHIFT JISɕϊ */
/*=========================================================================*/
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte)
{
    UInt8 temp[2];

    *copyByte = 0;
    if (*ptr == 0x8e)
    {
        // pJiR[h
        ptr++;
        *dst = *ptr;
        *copyByte = 1;
        return (true); 
    }
    if ((*ptr >= ((0x80)|(0x21)))&&(*ptr <= ((0x80)|(0x7e))))
    {
        // EUCR[hƔAJISR[hɈxϊĂSHIFT JISɕϊ
        temp[0] = ((*ptr)&(0x7f));
        ptr++;
        temp[1] = ((*ptr)&(0x7f));
        (void) ConvertJIStoSJ(dst, temp);
        *copyByte = 2;
        return (true);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : ParseMessage                                               */
/*                                                  (bZ[W̐`) */
/*-------------------------------------------------------------------------*/
static void ParseMessage(Char *buf, Char *src, UInt32 size, UInt16 kanjiCode)
{
    Boolean kanjiMode;
    UInt16  len;
    Char   *ptr, *dst, dataStatus;

    dataStatus = MSGSTATUS_NAME;
    kanjiMode = false;

    // x߃[`... (PÂp[X)
    dst  = buf;
    ptr  = src;

    while (ptr < (src + size))
    {
        // JISR[h̕ϊWbN
        if (kanjiCode == NNSH_KANJICODE_JIS)
        {
            // JISSHIFT JIS̃R[hϊ
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x24')&&(*(ptr + 2) == '\x42'))
            {
                // [hɐ؂ւ
                kanjiMode = true;
                ptr = ptr + 3;
                continue;
            }
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x28')&&(*(ptr + 2) == '\x42'))
            {
                // ANK[hɐ؂ւ
                kanjiMode = false;
                ptr = ptr + 3;
                continue;
            }
            if (kanjiMode == true)
            {
                // JIS > SJIS ϊ
                ConvertJIStoSJ(dst, ptr);
                ptr = ptr + 2;
                dst = dst + 2;
                continue;
            }
        }
        if (*ptr == '&')
        {
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
                (*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&(*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
                (*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&(*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
                (*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }
        if (*ptr == '<')
        {
            //  "<>" ́AZp[^(Ԃɂĕς)
            if (*(ptr + 1) == '>')
            {
                ptr = ptr + 2;   // StrLen(DATA_SEPARATOR);
                switch (dataStatus)
                {
                  case MSGSTATUS_NAME:
                    // Ő؂
                    *dst++ = ' ';
                    *dst++ = ' ';
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_EMAIL;
                    break;

                  case MSGSTATUS_EMAIL:
                    // e-mail̋؂
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_DATE;
                    *dst++ = '\n';
                    break;

                  case MSGSTATUS_DATE:
                    // NEԂтhc̋؂
                    *dst++ = '\n';
                    *dst++ = '\n';
                    dataStatus = MSGSTATUS_NORMAL;
                    if (*ptr == ' ')
                    {
                        // Xy[X͓ǂݔ΂
                        ptr++;
                    }
                    break;

                  case MSGSTATUS_NORMAL:
                  default:
                    // bZ[W̏I[
                    *dst++ = ' ';
                    *dst++ = '\0';
                    return;
                    break;
                }
                continue;
            }
            //  "<br>" ́Asɒu
            if (((*(ptr + 1) == 'b')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'B')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                // sƍs̃Xy[XĂ݂ꍇ
                if ((ptr > src)&&(*(ptr - 1) == ' '))
                {
                    dst--;
                }
                if (*(ptr + 4) == ' ')
                {
                    *dst++ = '\n';
                    ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                    continue;
                }
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<p*>" ́As2ɒu
            if ((*(ptr + 1) == 'p')||(*(ptr + 1) == 'P'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 2;
                while ((*ptr != '>')&&(ptr < (src + size)))
                {
                    ptr++;
                }
                ptr++;
                continue;
            }

            // <li>^OsR[h:ɒu
            if (((*(ptr + 1) == 'l')&&(*(ptr + 2) == 'i')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'L')&&(*(ptr + 2) == 'I')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '';
                ptr = ptr + 4;
                continue;
            }   

            //  "<hr>" ́As === s ɒu
            if (((*(ptr + 1) == 'h')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'H')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dt>"́Asɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "</tr>"  "</td>" ́Asɒu
            if (((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'r')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'R')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'd')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'D')&&(*(ptr + 4) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dd>" ́AsƋ󔒂Qɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 'd')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'D')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<h?" ́As + s ɒu
            if ((*(ptr + 1) == 'h')&&(*(ptr + 1) == 'H'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            //  "</h?>" ́As + s ɒu
            if (((*(ptr + 2) == 'h')||(*(ptr + 2) == 'H'))&&(*(ptr + 1) == '/'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            // <tr>, <td> ̓Xy[XPɕϊ
            if (((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                ((*(ptr + 2) == 'r')||(*(ptr + 2) == 'R')||
                 (*(ptr + 2) == 'd')||(*(ptr + 2) == 'D')))
            {
                *dst++ = ' ';
                // continue͂ȂBB (^O͓ǂݔ΂)
            }
SKIP_TAG:
            // ̑̃^O͓ǂݔ΂
#ifdef USE_STRSTR
            ptr = StrStr(ptr, ">");
#else
            while ((*ptr != '>')&&(*ptr != '\0'))
            {
                ptr++;
            }
#endif
            ptr++;
            // *dst++ = ' ';   // ^O͊SƂB
            continue;
        }
        // R[hEUCꍇ...
        if (kanjiCode == NNSH_KANJICODE_EUC)
        {
            if (ConvertEUCtoSJ((UInt8 *) dst, (UInt8 *) ptr, &len) == true)
            {
                // EUC > SHIFT JISϊs
                dst = dst + len;
                ptr = ptr + 2;
                continue;
            }
            if (*ptr != '\0')
            {
                // ʂ̈ꕶ]
                *dst++ = *ptr;
            }
            ptr++;
            continue;
        }

        // Xy[XAĂꍇAPɌ炷
        if ((*ptr == ' ')&&(*(ptr + 1) == ' '))
        {
            ptr++;
            while ((*ptr == ' ')&&(ptr < (src + size)))
            {
                ptr++;
            }
            ptr--;
        }

        // NULL  0x0a, 0x0d, 0x09(^u) ͖
        if ((*ptr != '\0')&&(*ptr != 0x0a)&&(*ptr != 0x0d)&&(*ptr != 0x09))
        {
            // ʂ̈ꕶ]
            *dst++ = *ptr;
        }
        ptr++;
    }
    *dst++ = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  getMemoryHandleData                                       */
/*                                      nhf[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getMemoryHandleData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    MemHandle  memH;
    Char      *ptr, *buf;
    Int16      times;
	Int32      size;

    // nh擾
	ptr  = infoName;
	size  = 0;
    times = 1;
    if (*ptr == '-')
    {
        // ̐...
        times = -1;
        ptr++;
    }    
	while ((*ptr >= '0')&&(*ptr <= '9'))
	{
		size = (size * 10) + (*ptr - '0');
		ptr++;
	}
	if (size == 0)
	{
        StrNCopy(title, "memH == 0", titleSize);
	    return (NULL);
	}
    size = size * times;
	memH = (MemHandle) size;

	// R[ȟ
    switch (*ptr)
    {
      case 'e':
        // R[hEUC
        adtP->kanjiCode = NNSH_KANJICODE_EUC;
        adtP->times = 2;
        adtP->fontId = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'E':
        // R[hEUC
        adtP->kanjiCode = NNSH_KANJICODE_EUC;
        adtP->times = 2;
        break;

      case 'r':
        // f[^\
        adtP->kanjiCode = nnDA_KANJICODE_RAW;
        adtP->times = 1;
        adtP->fontId = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'R':
        // f[^\
        adtP->kanjiCode = nnDA_KANJICODE_RAW;
        adtP->times = 1;
        break;

      case 'j':
        // R[hJIS
        adtP->kanjiCode = NNSH_KANJICODE_JIS;
        adtP->times     = 3;
        adtP->fontId    = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'J':
        // R[hJIS
        adtP->kanjiCode = NNSH_KANJICODE_JIS;
        adtP->times     = 3;
        break;

      case 's':
        // R[hSHIFT JIS
        adtP->kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        adtP->times     = 2;
        adtP->fontId    = largeFont;
		FntSetFont(adtP->fontId);
        break;

      default:
        // ̑SHIFT JIS
        adtP->kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        adtP->times     = 2;
        break;
    }
    ptr++;
    ptr++;

    // Titlef[^̃Rs[
    StrNCopy(title, ptr, titleSize);
    ptr = StrStr(title, "<");
    if (ptr != NULL)
    {
        *ptr = '\0';
    }

    // \f[^̎擾
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        StrNCopy(title, "MemHandleLock()", titleSize);
        return (NULL);
    }
    size = StrLen(ptr);
    
    // \̈̊m
    buf = MEMALLOC_PTR((size * times) + BUF_MARGIN);
    if (buf == NULL)
    {
        StrNCopy(title, "MEMALLOC_PTR()", titleSize);
        MemHandleUnlock(memH);
        return (NULL);
    }
    MemSet (buf, ((size * times) + BUF_MARGIN), 0x00);

	// f[^̕\R[h̊mF...
	if (adtP->kanjiCode != nnDA_KANJICODE_RAW)
	{
        // \f[^̐`
        ParseMessage(buf, ptr, size, adtP->kanjiCode);
	}
	else
	{
		// f[^\
		StrNCopy(buf, ptr, size);
	}
	MemHandleUnlock(memH);
    return (buf);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamHtmlData                                     */
/*                                fileStreamf[^擾(HTMLH) */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamHtmlData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    UInt16     len;
    Char      *fileName, *ptr, *buf;
    Err        err;
    FileHand   filRef;
    
    // creatorID̒o
    ptr = (Char *) &(adtP->creator);
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂

    // R[h̎擾
    switch (*ptr)
    {
      case 'e':
        // R[hEUC
        adtP->kanjiCode = NNSH_KANJICODE_EUC;
        adtP->times = 2;
        adtP->fontId = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'E':
        // R[hEUC
        adtP->kanjiCode = NNSH_KANJICODE_EUC;
        adtP->times = 2;
        break;

      case 'r':
        // f[^\
        adtP->kanjiCode = nnDA_KANJICODE_RAW;
        adtP->times = 1;
        adtP->fontId = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'R':
        // f[^\
        adtP->kanjiCode = nnDA_KANJICODE_RAW;
        adtP->times = 1;
        break;

      case 'j':
        // R[hJIS
        adtP->kanjiCode = NNSH_KANJICODE_JIS;
        adtP->times     = 3;
        adtP->fontId    = largeFont;
		FntSetFont(adtP->fontId);
        break;

      case 'J':
        // R[hJIS
        adtP->kanjiCode = NNSH_KANJICODE_JIS;
        adtP->times     = 3;
        break;

      case 's':
        // R[hSHIFT JIS
        adtP->kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        adtP->times     = 2;
        adtP->fontId    = largeFont;
		FntSetFont(adtP->fontId);
        break;

      default:
        // ̑SHIFT JIS
        adtP->kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        adtP->times     = 2;
        break;
    }
    ptr++;
    ptr++;

    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MEMALLOC_PTR(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MEMALLOC_ptr", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5 + 2), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, adtP->creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAG[R[h\
        StrCopy(title, "err:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &(adtP->dataSize), &err) != -1)
    {
        // ^Cg͋󔒂
        StrNCopy(title, " ", titleSize);

        ptr = MEMALLOC_PTR(adtP->dataSize + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MEMALLOC_ptr()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (adtP->dataSize + BUF_MARGIN), 0x00);

        FileRead(filRef, ptr, 1, adtP->dataSize, &err);
 
        if (adtP->kanjiCode != nnDA_KANJICODE_RAW)
        {
            len = (adtP->dataSize * adtP->times);
            if (len > DISP_LIMIT)
            {
                // \f[^TCYۂ߂...
                len = DISP_LIMIT;
                adtP->dataSize = (adtP->dataSize * 2 / 3);
            }
            buf = MEMALLOC_PTR(len + BUF_MARGIN);
            if (buf != NULL)
            {
                MemSet(buf, (len + BUF_MARGIN), 0x00);

                // \f[^̐`
                ParseMessage(buf, ptr, adtP->dataSize, adtP->kanjiCode);

                // ǂݍ񂾃f[^obt@͊J
                MEMFREE_PTR(ptr);
                ptr = buf;
            }
        }
        MEMFREE_PTR(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "filetell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}

/*!
 *   Progress Dialogp̃R[obN֐
 */
Boolean textCallBack(PrgCallbackDataPtr cbP)
{
    // ip[Zg\
    StrPrintF(cbP->textP, "%d%%...", cbP->stage);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :  displayJPEGscreen                                         */
/*                                                        JPEGt@C\ */
/*-------------------------------------------------------------------------*/
static void displayJPEGscreen    (FormType *frm, nnDADataType *adtP)
{
    Err          err;
    UInt32       apiVer;
    UInt16       jpegRef, nc;
    Coord        width, height;
    Char         textBuffer[16];

    // JpegLibgp\mF
    err = SysLibFind(jpegLibName, &jpegRef);
    if (err != errNone) // not already loaded; do it now
    {
        err = SysLibLoad(sysResTLibrary, jpegLibCreator, &jpegRef);
    }
    if (err == errNone)
    {
        // JpegLibgp\Agpĉ摜\
        goto START_JPEGLIB;
    }

    // SONY JPEGCu̎gpۊmF
    err = SysLibFind(sonySysLibNameJpegUtil, &jpegRef);
    if (err != errNone)
    {
        err = SysLibLoad(sonySysFileTJpegUtilLib,
                         sonySysFileCJpegUtilLib, &jpegRef);
    }
    if (err != errNone)
    {
        // SONY JPEGCugpłȂ...(G[I)...
        FrmCustomAlert(ALTID_ERROR, "Could not find ", "JPEG library", ".");
        return;
    }

    // SONY JPEGCũI[v
#ifdef USE_CLIE
#ifdef USE_SONY_JPEG
    err = jpegUtilLibOpen(jpegRef);
    if (err != errNone)
    {
        // SONY JPEGCũI[vɎsAI
        FrmCustomAlert(ALTID_ERROR,
                       "Could not open",
                       "Sony JPEG library",
                       ".");
        return;
    }

    // SONY JPEGCũo[WmF (2ȏȂ΁AFileStreamǂݏo)
    adtP->bitmapPP = 0;
    apiVer = jpegUtilLibGetLibAPIVersion(jpegRef);
    if ((apiVer < 2)&&(adtP->sourceLocation == nnDA_JPEGSOURCE_FILESTREAM))
    {
        // jpeg APIΉASONY JPEGCuN[YI
        jpegUtilLibClose(jpegRef);
        FrmCustomAlert(ALTID_ERROR,
                       "Do not support a stream JPEG file",
                       "at Sony JPEG library",
                       ".");
        return;
    }

    // SONY JPEGCugpJPEGt@Cʕ`悷
    // (`A\[XN[Y)
    switch (adtP->sourceLocation)
    {
      case nnDA_JPEGSOURCE_FILESTREAM:
        if (adtP->streamRef != 0)
        {
            // 摜ʂɕ`悷(t@CXg[)
            err = jpegUtilLibDecodeImageToWindowForFS(jpegRef,
                                                      adtP->streamRef,
                                                      jpegDecModeNormal,
                                                      &(adtP->area),
                                                      NULL);
            FileClose(adtP->streamRef);
            adtP->streamRef = 0;
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "File open failure", " > ");
        }
        break;

      case nnDA_JPEGSOURCE_VFS:
        if (adtP->vfsFileRef != 0)
        {
            // 摜ʂɕ`悷(VFSt@C)
            err = jpegUtilLibDecodeImageToWindow(jpegRef,
                                                 adtP->vfsFileRef,
                                                 0,
                                                 jpegDecModeNormal,
                                                 &(adtP->area),
                                                 NULL);
            VFSFileClose(adtP->vfsFileRef);
            adtP->vfsFileRef = 0;
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "File open failure", " > ");
        }
        break;

      case nnDA_JPEGSOURCE_MEMORY:
      default:
        // ɂJPEGf[^ʂɕ\
        if (adtP->jpegData != 0)
        {
            err = jpegUtilLibDecodeImageToWindow(jpegRef,
                                                 0,
                                                 adtP->jpegData,
                                                 jpegDecModeNormal,
                                                 &(adtP->area),
                                                 NULL);
            MEMFREE_PTR(adtP->jpegData);
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "memory alloc. failure", " > ");
        }
        break;
    }

    // SONY JPEGCũN[Y
    jpegUtilLibClose(jpegRef);

    // `OKȂA\
    if ((err == errNone)&&(adtP->bitmapPP != 0))
    {
        HRWinDrawBitmap(adtP->hrRef,
                        adtP->bitmapPP, 
                        adtP->area.topLeft.x,
                        adtP->area.topLeft.y);
    }
    return;
#endif // #ifdef USE_SONY_JPEG
#endif // #ifdef USE_CLIE
START_JPEGLIB:
    err = JpegLibOpen(jpegRef, jpegLibCurrentVersion);
    if (err != errNone)
    {
        // JPEGCugpłȂ...(G[I)...
        FrmCustomAlert(ALTID_ERROR, "Could not OPEN ", "JPEG library", ".");
        return;
    }

    // u҂āv\...
    MemSet (textBuffer, sizeof(textBuffer), 0x00);
    StrCopy(textBuffer, "Please Wait...");
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        HRWinDrawChars(adtP->hrRef, textBuffer, StrLen(textBuffer), adtP->area.topLeft.x, adtP->area.topLeft.y);
    }
    else
#endif
    {
        WinDrawChars(textBuffer, StrLen(textBuffer), adtP->area.topLeft.x, adtP->area.topLeft.y);
    }

    adtP->bitmapPP = 0;
    switch (adtP->sourceLocation)
    {
      case nnDA_JPEGSOURCE_FILESTREAM:
        if (adtP->streamRef != 0)
        {
            // 摜ʂɕ`悷(FileStream)
            JpegLibCreateDataFileStreaming(jpegRef, &(adtP->data), adtP->streamRef);
            JpegLibCreateDecOptions(jpegRef, &(adtP->dopt));
            JpegLibSetDecOptDestBitmap(jpegRef, &(adtP->dopt));
            JpegLibSetDecOptScale(jpegRef, &(adtP->dopt), 2);
            err = JpegLibRead(jpegRef, &(adtP->data), &(adtP->dopt), &width, &height, &nc, (void **)&(adtP->bitmapPP));
            FileClose(adtP->streamRef);
            adtP->streamRef = 0;
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "File open failure", " > ");
        }
        break;

      case nnDA_JPEGSOURCE_VFS:
        if (adtP->vfsFileRef != 0)
        {
            // 摜ʂɕ`悷(VFSt@C)
            JpegLibCreateDataVFS(jpegRef, &(adtP->data), adtP->vfsFileRef);
            JpegLibCreateDecOptions(jpegRef, &(adtP->dopt));
            JpegLibSetDecOptDestBitmap(jpegRef, &(adtP->dopt));
            JpegLibSetDecOptScale(jpegRef, &(adtP->dopt), 2);
            err = JpegLibRead(jpegRef, &(adtP->data), &(adtP->dopt), &width, &height, &nc, (void **)&(adtP->bitmapPP));
            VFSFileClose(adtP->vfsFileRef);
            adtP->vfsFileRef = 0;
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "File open failure", " > ");
        }
        break;

      case nnDA_JPEGSOURCE_MEMORY:
      default:
        // ɂJPEGf[^ʂɕ\
        if (adtP->jpegData != 0)
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "not support memory-data", " > ");
            MEMFREE_PTR(adtP->jpegData);
            adtP->jpegData = 0;
        }
        else
        {
            FrmCustomAlert(ALTID_ERROR, " < ", "memory alloc. failure", " > ");
        }
        break;
    }

    // `OKȂABitmap\
    if ((err == errNone)&&(adtP->bitmapPP != 0))
    {
        //FrmCustomAlert(ALTID_ERROR, "READY ", " TO BITMAP...", ".");
        BmpGetDimensions(adtP->bitmapPP, &width, &height, NULL);

#ifdef USE_CLIE
        if (adtP->hrRef != 0)
        {
            HRWinDrawBitmap(adtP->hrRef,
                            adtP->bitmapPP, 
                            adtP->area.topLeft.x,
                            adtP->area.topLeft.y);
        }
        else
#endif  // #ifdef USE_CLIE
        {
            WinDrawBitmap(adtP->bitmapPP, 
                          adtP->area.topLeft.x,
                          adtP->area.topLeft.y);
        }
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  getJpegFileData                                           */
/*                                  JPEGt@Cf[^̃I[v{ */
/*-------------------------------------------------------------------------*/
static Char *getJpegFileData(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    Err   ret;
    Char *fileName, *ptr, *ptr2;
    Boolean result;

    // SHOWJPEG:xRRRR:/...(fileName)...
    //   x: ǂݍ݃t@Ĉ肩(t@CXg[ or VFS̎w)
    //       f : t@CXg[
    //       v : VFS (wȂ)
    //       c : VFS (CF)
    //       m : VFS (MS)
    //       s : VFS (SD)
    //       t : VFS (SmartMedia ... ToshibaT)
    //       r : VFS (RD  : ramdisk)
    //       d : VFS (DoC : foCX)
    //   RRRR: \̈
    //   /...(fileName)...  t@C
    adtP->streamRef  = 0;
    adtP->vfsFileRef = 0;
    switch (infoName[0])
    {
      case 'f': 
        // file stream
        return (openFileStreamForJPEG(infoName, title, titleSize, adtP));
        break;

      case 'v': 
        // VFS(any)
        result = checkVFSdevice(0, adtP);
        break;

      case 'c': 
        // VFS(CF)
        result = checkVFSdevice(ExpMediaType_CompactFlash, adtP);
        break;

      case 'm': 
        // VFS(MS)
        result = checkVFSdevice(ExpMediaType_MemoryStick, adtP);
        break;

      case 's': 
        // VFS(SD)
        result = checkVFSdevice(ExpMediaType_SecureDigital, adtP);
        if (result == false)
        {
            result = checkVFSdevice(ExpMediaType_MultiMediaCard, adtP);
        }
        break;

      case 't': 
        // VFS(SmartMedia)
        result = checkVFSdevice(ExpMediaType_SmartMedia, adtP);
        break;

      case 'r': 
        // VFS(RamDisk)
        result = checkVFSdevice(ExpMediaType_RAMDisk, adtP);
        break;

      case 'd': 
        // VFS(DoC)
        result = checkVFSdevice('Tffs', adtP);
        break;

      default:
        return (NULL);
        break;
    }
    if (result == false)
    {
        //  VFSoAI
        return (NULL);
    }
    fileName = MEMALLOC_PTR((nnDA_FILENAMESIZE + MARGIN));
    if (fileName == NULL)
    {
        // ̈mۂɎsAI
        return (NULL);
    }

    // t@C ϐt@CɃRs[
    MemSet(fileName, (nnDA_FILENAMESIZE + MARGIN), 0x00);
    ptr  = fileName;
    ptr2 = &(infoName[6]);
    while ((*ptr2 != '<')&&(*ptr2 != '\0'))
    {
        *ptr = *ptr2;
        ptr++;
        ptr2++;
    }

    // t@CI[v(VFS)
    ret = VFSFileOpen(adtP->vfsVol,fileName,vfsModeRead,&(adtP->vfsFileRef));
    if (ret != errNone)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], ret);
        adtP->vfsFileRef = 0;
        return (fileName);
    }

    // t@C̃I[vIiQƔԍ\̂ɃRs[)
    adtP->sourceLocation = nnDA_JPEGSOURCE_VFS;

    MEMFREE_PTR(fileName);
    return (NULL);
}

/*-------------------------------------------------------------------------*/
/*   Function :  postProcessJpegDisplay                                    */
/*                                          JPEGt@Cf[^̕\㏈ */
/*-------------------------------------------------------------------------*/
static void postProcessJpegDisplay(nnDADataType *adtP)
{
    if (adtP->vfsFileRef != 0)
    {
        VFSFileClose(adtP->vfsFileRef);
        adtP->vfsFileRef = 0;
    }    
    if (adtP->streamRef != 0)
    {
        FileClose(adtP->streamRef);
        adtP->streamRef = 0;
    }    
    if (adtP->bitmapPP != 0)
    {
        BmpDelete(adtP->bitmapPP);
        adtP->bitmapPP = 0;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkVFSdevice                                           */
/*                 VFS̃T|[gmF(adtP->vfsVolVFS volumei[) */
/*-------------------------------------------------------------------------*/
static Boolean checkVFSdevice(UInt32 aMediaType, nnDADataType *adtP)
{
    Err err;

    // VFS̃T|[gLmFB
    adtP->vfsVolumeIterator = 0;
    err = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &(adtP->vfsVolumeIterator));
    if (err != errNone)
    {
        adtP->vfsVol = 0;
        return (false);
    }

    //  VFSgp\mFB
    adtP->vfsVolumeIterator = vfsIteratorStart;
    while (adtP->vfsVolumeIterator != vfsIteratorStop)
    {
        err = VFSVolumeEnumerate(&(adtP->vfsVol), &(adtP->vfsVolumeIterator));
        if (err != errNone)
        {
            adtP->vfsVol = 0;
	    return (false);
        }
        err = VFSVolumeInfo(adtP->vfsVol, &(adtP->volInfo));
        if (err != errNone)
        {
            adtP->vfsVol = 0;
            return (false);
        }
        if ((aMediaType == 0)||(aMediaType == adtP->volInfo.mediaType))
        {
            // t@CVXe̊mF
            if (adtP->volInfo.fsType == vfsFilesystemType_VFAT)
            {                    
                // VFSfoCX𔭌I
                return (true);                
            }
        }
    }
    // VFSfoCXȂ...
    adtP->vfsVol = 0;
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :  openFileStreamForJPEG                                     */
/*                      JPEGt@Cf[^̃I[v{(FileStream) */
/*-------------------------------------------------------------------------*/
static Char *openFileStreamForJPEG(Char *infoName, Char *title, UInt16 titleSize, nnDADataType *adtP)
{
    UInt32  creator;
    Char   *fileName, *ptr, *ptr2;
    Err     err;

    ptr = (Char *) &creator;
    *ptr       = infoName[1];
    *(ptr + 1) = infoName[2];
    *(ptr + 2) = infoName[3];
    *(ptr + 3) = infoName[4];

    // t@Cp̈mۂ
    fileName = MEMALLOC_PTR(nnDA_FILENAMESIZE);
    if (fileName == NULL)
    {
        return (NULL);
    }
    MemSet(fileName, nnDA_FILENAMESIZE, 0x00);
    ptr  = fileName;
    ptr2 = &(infoName[6]);
    while ((*ptr2 != '<')&&(*ptr2 != '\0'))
    {
        *ptr = *ptr2;
        ptr++;
        ptr2++;
    }

    // t@CI[v(fileStream)
    adtP->streamRef = FileOpen(0,fileName, 0, creator, fileModeReadOnly, &err);
    if (adtP->streamRef == 0)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }
    adtP->sourceLocation = nnDA_JPEGSOURCE_FILESTREAM;

    // [NŊmۂ̈J
    MEMFREE_PTR(fileName);
    return (NULL);
}
