/*============================================================================*
 *  $Id: damain.c,v 1.7 2004/09/11 10:59:35 mrsa Exp $
 *
 *  FILE: 
 *     damain.c
 *
 *  Description: 
 *     DAAvP[V
 *
 *===========================================================================*/
/********** Include Files **********/
#include "local.h"

void DAmain(void);
Err  SendToLocalMemopad(Char *title, Char *data);

static void ParseMessage(Char *buf, Char *src, UInt32 dstSize, UInt32 size, UInt16 kanjiCode);

// UTF8 -> Shift JISϊe[u (AMsoft̂cagp)
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId);

static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr);
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte);
static UInt16  Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L);

static Boolean analysis_URL(NNshWorkingInfo *NNshGlobal);
static void    get_html_contents(NNshWorkingInfo *NNshGlobal);

static void NNsh_checkRefreshConnectionRequest(NNshWorkingInfo *NNshGlobal);

#ifdef DEBUG_LOCALHOST_ADDRESS
#define  DEBUG_ADDRESS  "localhost"
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS
 
/*=========================================================================*/
/*   Function : startDA  (DAX^[gAbv)                                */
/*                                                                         */
/*=========================================================================*/
void startDA(void)
{
    FormType *frm;

    frm = FrmGetActiveForm();
    DAmain();
    FrmSetActiveForm(frm);

    return;
}

/*=========================================================================*/
/*   Function : DAmain  (DAC)                                     */
/*                                                                         */
/*=========================================================================*/
void DAmain(void)
{
    Boolean           isURL;
    UInt16            size, autoOffTime, btnId, ref;
    NNshWorkingInfo  *NNshGlobal;

    // URL̎w肪sꂽǂ
    isURL = false;

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NȂ)
        FrmCustomAlert(ALTID_INFO, "Cannot Launch ",  "(DA)", " global");
        return;
    }        
    MemSet(NNshGlobal, size, 0x00);

    // ʐM^CAEglݒ
    NNshGlobal->timeout = SysTicksPerSecond() * NNSH_GETMAIL_TIMEOUT;

    // Parameter pointerfeatureɃZbg
    FtrSet(SOFT_CREATOR_ID, SOFT_DB_ID, (UInt32) NNshGlobal);

    // OSo[W̎擾
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &(NNshGlobal->palmOSVersion));

    // URL̎擾(I𒆃tB[hNbv{[hɃRs[)
    // IIIӁIII
    //    Cɂ߁Aϐ𗬗pĂI (悭ȂI)
    //      fldId  NNshGlobal->isChecking
    //      start  NNshGlobal->portNum
    //      end    NNshGlobal->kanjiCode
    NNshGlobal->isChecking = FrmGetFocus(FrmGetActiveForm());
    if (NNshGlobal->isChecking != noFocus)
    {
        if (FrmGetObjectType(FrmGetActiveForm(), NNshGlobal->isChecking) == frmFieldObj)
        {
            FldGetSelection(FrmGetObjectPtr(FrmGetActiveForm(), 
                                            NNshGlobal->isChecking),
                            &(NNshGlobal->portNum),
                            &(NNshGlobal->kanjiCode));
            if (NNshGlobal->portNum != NNshGlobal->kanjiCode)
            {
                // I𕶎Rs[
                FldCopy(FrmGetObjectPtr(FrmGetActiveForm(),
                                        NNshGlobal->isChecking));
	    }
        }
    }
    NNshGlobal->isChecking = 0;
    NNshGlobal->portNum    = 0;
    NNshGlobal->kanjiCode  = 0;

    // URL̎擾(Nbv{[h)
    if (isURL == false)
    {
        NNshGlobal->memH = ClipboardGetItem(clipboardText,
                                            &(NNshGlobal->fieldLen));
        if ((NNshGlobal->memH != 0)&&(NNshGlobal->fieldLen != 0))
        {
            if (NNshGlobal->fieldLen > (BUFSIZE * 2))
            {
                NNshGlobal->fieldLen = (BUFSIZE * 2) - 1;
            }
            MemMove(NNshGlobal->reqURL, 
                    MemHandleLock(NNshGlobal->memH),
                    NNshGlobal->fieldLen);
            MemHandleUnlock(NNshGlobal->memH);
        }
    }
    isURL = analysis_URL(NNshGlobal);

    // URLw肳ĂȂꍇɂ́A_CAO\
    if (isURL == false)
    {
        MemSet(NNshGlobal->reqURL, (BUFSIZE * 2), 0x00);
        isURL = InputDialog("Input URL", NNshGlobal->reqURL, (BUFSIZE * 2));
    }
    if (isURL != false)
    {
        // ͂ꂽf[^URL܂܂Ă邩͂
        isURL = analysis_URL(NNshGlobal);
    }

    if (isURL == false)
    {
        // 擾URLw肳ȂAI
        goto FUNC_END;
    }

    //////////////////////////////////////////////////////////////////////////
    // HTTP擾
    //////////////////////////////////////////////////////////////////////////
    // Mobt@̊m
    NNshGlobal->sendBuf = MemPtrNew(SENDBUFFER_DEFAULT);
    if (NNshGlobal->sendBuf == NULL)
    {
        // ̈mێsAI
        goto FUNC_END;
    }
    MemSet(NNshGlobal->sendBuf, (SENDBUFFER_DEFAULT), 0x00);

    // Mobt@̊m
    NNshGlobal->recvBuf = MemPtrNew(RECEIVEBUFFER_DEFAULT + MARGIN);
    if (NNshGlobal->recvBuf == NULL)
    {
        // ̈mێsAI
        MEMFREE_PTR(NNshGlobal->sendBuf);
        goto FUNC_END;
    }
    MemSet(NNshGlobal->recvBuf, (RECEIVEBUFFER_DEFAULT + MARGIN), 0x00);

    NNshGlobal->workBuf = MemPtrNew(WORKBUFFER_DEFAULT);
    if (NNshGlobal->workBuf == NULL)
    {
        // ̈mێsAI
        MEMFREE_PTR(NNshGlobal->sendBuf);
        MEMFREE_PTR(NNshGlobal->recvBuf);
        goto FUNC_END;
    }
    MemSet(NNshGlobal->workBuf, (WORKBUFFER_DEFAULT), 0x00);

    // BUSYEBhE\
    Show_BusyForm(NNshGlobal->hostName, NNshGlobal);    

    // dOFF^C}~
    autoOffTime = SysSetAutoOffTime(0);
    (void) EvtResetAutoOffTimer();

    // gslkf[^M
    get_html_contents(NNshGlobal);

    // dOFF^C}𕜋
    (void) SysSetAutoOffTime(autoOffTime);
    (void) EvtResetAutoOffTimer();

    SetMsg_BusyForm("Parsing...");

    // obt@NA
    MemSet(NNshGlobal->workBuf, (WORKBUFFER_DEFAULT), 0x00);

    // ^CgɗvURL\悤ɃRs[
    MemSet(NNshGlobal->showBuf, (MINIBUF + MARGIN), 0x00);
    NNshGlobal->tempPtr = StrStr(NNshGlobal->reqURL, "://");
    if (NNshGlobal->tempPtr == NULL)
    {
        NNshGlobal->tempPtr = NNshGlobal->reqURL;
    }
    else
    {
        NNshGlobal->tempPtr = NNshGlobal->tempPtr + sizeof("://") - 1; 
    }
    MemMove(NNshGlobal->showBuf, NNshGlobal->tempPtr, DIALOGTITLE_LENGTH);

    // HTTPwb_̖T
    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "\r\n\r\n");
    if (NNshGlobal->tempPtr == NULL)
    {
        // Mobt@̐擪\
        NNshGlobal->tempPtr = NNshGlobal->recvBuf;
    }
    else
    {
        // sR[h("\r\n\r\n")|C^i߂
        NNshGlobal->tempPtr = NNshGlobal->tempPtr + 4;
    }

    // tB[hɎMʂ\

    // \TCYtB[h\pobt@Ɏ܂邩H
    if (StrLen(NNshGlobal->tempPtr) < (WORKBUFFER_DEFAULT - 1))
        
    {
        NNshGlobal->fieldLen = StrLen(NNshGlobal->tempPtr);
    }
    else
    {
        NNshGlobal->fieldLen = (WORKBUFFER_DEFAULT - 2);
    }

    // gpR[h̉(ԂႯ\...)
    NNshGlobal->kanjiCode = NNSH_KANJICODE_SHIFTJIS;
    if (StrStr(NNshGlobal->tempPtr, "iso-2022-jp") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_JIS;
        goto HTML_PARSE;
    }
    if (StrStr(NNshGlobal->tempPtr, "ISO-2022-JP") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_JIS;
        goto HTML_PARSE;
    }
    if (StrStr(NNshGlobal->tempPtr, "euc-jp") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_EUC;
        goto HTML_PARSE;
    }
    if (StrStr(NNshGlobal->tempPtr, "EUC-JP") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_EUC;
        goto HTML_PARSE;
    }
    if (StrStr(NNshGlobal->tempPtr, "utf-8") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_UTF8;
        goto HTML_PARSE;
    }
    if (StrStr(NNshGlobal->tempPtr, "UTF-8") != NULL)
    {
        NNshGlobal->kanjiCode = NNSH_KANJICODE_UTF8;
        goto HTML_PARSE;
    }

HTML_PARSE:

    if (NNshGlobal->kanjiCode == nnDA_KANJICODE_RAW)
    {
        // Mf[^܂͂ɕ\
        MemMove(NNshGlobal->workBuf,NNshGlobal->tempPtr,NNshGlobal->fieldLen);
    }
    else
    {
        // Mf[^HTMLf[^t@CƂ(ȒPɉ͂)\
        ParseMessage(NNshGlobal->workBuf,NNshGlobal->tempPtr,
                WORKBUFFER_DEFAULT,NNshGlobal->fieldLen,NNshGlobal->kanjiCode);
    }

    // BUSYEBhEB
    Hide_BusyForm(NNshGlobal);


    // ʃ_CAO\
    if (FrmGetActiveFormID() != 0)
    {
        NNshGlobal->previousForm = FrmGetActiveForm();
    }
    else
    {
        NNshGlobal->previousForm = NULL;
    }
    NNshGlobal->currentForm  = FrmInitForm(FRMID_RESULT);
    FrmSetActiveForm   (NNshGlobal->currentForm);
    FrmCopyTitle(NNshGlobal->currentForm, NNshGlobal->showBuf);

#ifdef USE_WIDEWINDOW
    NNshGlobal->ret = FtrGet(pinCreator, pinFtrAPIVersion, &(NNshGlobal->silkVer));
    if (NNshGlobal->ret != errNone)
    {
        // DIA T|[gfoCXA_CAOTCY̊g͂Ȃ
        goto RESIZE_WINDOW;
    }

    // DIAT|[gfoCX    
    NNshGlobal->ret = FtrGet(sysFtrCreator, sysFtrNumInputAreaFlags, &(NNshGlobal->silkVer));
   if ((NNshGlobal->ret != errNone)|
       ((NNshGlobal->silkVer & grfFtrInputAreaFlagDynamic) == 0)||
       ((NNshGlobal->silkVer & grfFtrInputAreaFlagCollapsible) == 0))
   {
       // G[ɂȂꍇADIAT|[g̏ꍇA
        goto RESIZE_WINDOW;
   }

#ifdef HIDE_SILK
   // VNLɂ
   FrmSetDIAPolicyAttr(NNshGlobal->currentForm, frmDIAPolicyCustom);
   PINSetInputTriggerState(pinInputTriggerEnabled);

   // 炢x^AAAEBhETCY̍őlŏlݒ
   WinSetConstraintsSize(FrmGetWindowHandle(NNshGlobal->currentForm),
                         160, 225, 225, 160, 225, 225);

   // VN̈g傷...
   NNshGlobal->ret = PINSetInputAreaState(pinInputAreaClosed);
#endif  // #ifdef HIDE_SILK

RESIZE_WINDOW:
    /* ŜWindowTCY擾 */
    WinGetDisplayExtent(&(NNshGlobal->x), &(NNshGlobal->y));

    /* dialog̃TCY擾 */
    FrmGetFormBounds(NNshGlobal->currentForm, &(NNshGlobal->r));

    /* dialog(EChE)̊g */
    NNshGlobal->r.topLeft.x = 2;
    NNshGlobal->r.topLeft.y = 4;

    NNshGlobal->diffX       = NNshGlobal->r.extent.x;
    NNshGlobal->diffY       = NNshGlobal->r.extent.y;

    NNshGlobal->r.extent.y  = NNshGlobal->y - 6;
    NNshGlobal->r.extent.x  = NNshGlobal->x - 4;

    NNshGlobal->diffX       = NNshGlobal->r.extent.x - NNshGlobal->diffX;
    NNshGlobal->diffY       = NNshGlobal->r.extent.y - NNshGlobal->diffY;

    WinSetWindowBounds(FrmGetWindowHandle(NNshGlobal->currentForm),
                       &NNshGlobal->r);

    /* OK {^̈ړ */
    ref = FrmGetObjectIndex(NNshGlobal->currentForm, BTNID_DIALOG_OK);
    FrmGetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);
    // NNshGlobal->r.topLeft.x = NNshGlobal->r.topLeft.x + NNshGlobal->diffX;
    NNshGlobal->r.topLeft.y = NNshGlobal->r.topLeft.y + NNshGlobal->diffY;
    FrmSetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);

    /* REDRAW {^̈ړ */
    ref = FrmGetObjectIndex(NNshGlobal->currentForm, BTNID_DIALOG_REDRAW);
    FrmGetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);
    // NNshGlobal->r.topLeft.x = NNshGlobal->r.topLeft.x + NNshGlobal->diffX;
    NNshGlobal->r.topLeft.y = NNshGlobal->r.topLeft.y + NNshGlobal->diffY;
    FrmSetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);
    // FrmHideObject(NNshGlobal->currentForm, ref);                

    /* Field̈ړ(g) */
    ref = FrmGetObjectIndex(NNshGlobal->currentForm, FLDID_INFOFIELD);
    FrmGetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);
    NNshGlobal->r.extent.x = NNshGlobal->r.extent.x + NNshGlobal->diffX;
    NNshGlobal->r.extent.y = NNshGlobal->r.extent.y + NNshGlobal->diffY;
    FrmSetObjectBounds(NNshGlobal->currentForm, ref, &NNshGlobal->r);

#endif // #ifdef USE_WIDEWINDOW

    // Mf[^tB[hɃZbg
    NNshWinSetFieldText(NNshGlobal->currentForm, FLDID_INFOFIELD,
                        NNshGlobal->workBuf, StrLen(NNshGlobal->workBuf));

    // 擾ʃ_CAO\
    FrmSetEventHandler(NNshGlobal->currentForm, Handler_MainForm);
    btnId = FrmDoDialog(NNshGlobal->currentForm);

    // tH[̍폜
    if (NNshGlobal->previousForm != NULL)
    {
        FrmSetActiveForm(NNshGlobal->previousForm);
    }
    FrmDeleteForm(NNshGlobal->currentForm);

    if (btnId == BTNID_DIALOG_REDRAW)
    {
        // "ʍĕ\"̏ꍇ...
        NNshGlobal->currentForm  = FrmInitForm(FRMID_RESULT);
        FrmCopyTitle(NNshGlobal->currentForm, NNshGlobal->showBuf);

        goto HTML_PARSE;
    }

    // Mobt@̉
    MEMFREE_PTR(NNshGlobal->recvBuf);
    MEMFREE_PTR(NNshGlobal->sendBuf);
    MEMFREE_PTR(NNshGlobal->workBuf);

FUNC_END:
    //////////////////////////////////////////////////////////////////////////
    /////     Iiݒ̕ۑj
    //////////////////////////////////////////////////////////////////////////
    // Global̓o^
    FtrUnregister(SOFT_CREATOR_ID, SOFT_DB_ID);

    // mۂ̈J
    MEMFREE_PTR(NNshGlobal);

    return;
}

/*=========================================================================*/
/*   Function : Handler_EditAction                                         */
/*                                        ҏWj[Iꂽ̏ */
/*=========================================================================*/
Boolean Handler_EditAction(EventType *event)
{
    FormType  *frm;
    FieldType *fldP;
    UInt16     frmId;
    
    // IĂtB[hǂ`FbN
    frm   = FrmGetActiveForm();
    frmId = FrmGetFocus(frm);
    if (frmId == noFocus)
    { 
        // tH[JXIĂȂ̂ŁAԂ
        return (false);
    }
    if (FrmGetObjectType(frm, frmId) != frmFieldObj)
    {
        // ItB[hł͂Ȃ̂ŁAԂ
        return (false);
    }
    fldP = FrmGetObjectPtr(frm, frmId);

    if (event->eType != menuEvent)
    {
        // L[͂̃`FbN
        if (event->eType == keyDownEvent)
        {
            switch (event->data.keyDown.chr)
            {
              case vchrJogRelease:
              case vchrThumbWheelPush:
                // OK{^Ƃɂ
                CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                       FrmGetObjectIndex(FrmGetActiveForm(),
                                                         BTNID_DIALOG_OK)));
                return (true);
                break;

              default:
                // Ȃ 
                break;
            }
        }
        return (false);
    }

    // ҏWj[{
    switch (event->data.menu.itemID)
    {
      case MNUID_EDIT_UNDO:
        FldUndo(fldP);
        break;
      case MNUID_EDIT_CUT:
        FldCut(fldP);
        break;
      case MNUID_EDIT_COPY:
        FldCopy(fldP);
        break;
      case MNUID_EDIT_PASTE:
        FldPaste(fldP);
        break;
      case MNUID_SELECT_ALL:
        FldSetSelection(fldP, 0, FldGetTextLength(fldP));
        break;
      default:
        // ȂɂȂAƂRRɂ͗Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Hander_MainForm                                          */
/*                                       Cxgnh(ݒtH[p)  */
/*=========================================================================*/
Boolean Handler_MainForm(EventType *event)
{
    FieldType *fldP;
    UInt16    itemId;

    // p[^̎擾
    NNshWorkingInfo *NNshGlobal;
    FtrGet(SOFT_CREATOR_ID, SOFT_DB_ID, (UInt32 *)&NNshGlobal);

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        itemId = event->data.menu.itemID;
        break;

      // L[
      case keyDownEvent:
        itemId = event->data.keyDown.chr;
        break;

      // ʃ^bv
      case ctlSelectEvent:
        itemId = event->data.ctlSelect.controlID;
        break;

      // ISPύX
      case popSelectEvent:
        itemId = event->data.popSelect.listID;
        break;

      case penDownEvent:
      default: 
        return (false);
        break;
    }
    switch (itemId)
    {
      case MNUID_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case vchrPageDown:
      case chrDownArrow:
      case vchrJogDown:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winDown);
        }
        break;

      case vchrPageUp:
      case chrUpArrow:
      case vchrJogUp:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winUp);
        }
        break;

      case MNUID_CODE_RAW:
      case chrCapital_R:
      case chrSmall_R:
        // "x^\"[h
        NNshGlobal->kanjiCode = nnDA_KANJICODE_RAW;

        // REDRAW{^Ƃɂ
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        BTNID_DIALOG_REDRAW)));
        break;

      case MNUID_CODE_SHIFTJIS:
      case chrCapital_S:
      case chrSmall_S:
        // SHIFT JIS\[h
        NNshGlobal->kanjiCode = NNSH_KANJICODE_SHIFTJIS;

        // REDRAW{^Ƃɂ
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        BTNID_DIALOG_REDRAW)));
        break;

      case MNUID_CODE_EUC:
      case chrCapital_E:
      case chrSmall_E:
        // EUC\[h
        NNshGlobal->kanjiCode = NNSH_KANJICODE_EUC;

        // REDRAW{^Ƃɂ
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        BTNID_DIALOG_REDRAW)));
        break;

      case MNUID_CODE_JIS:
      case chrCapital_J:
      case chrSmall_J:
        // JIS\[h
        NNshGlobal->kanjiCode = NNSH_KANJICODE_JIS;

        // REDRAW{^Ƃɂ
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        BTNID_DIALOG_REDRAW)));
        break;

      case MNUID_CODE_UTF8:
      case chrCapital_U:
      case chrSmall_U:
        // UTF8\[h
        NNshGlobal->kanjiCode = NNSH_KANJICODE_UTF8;

        // REDRAW{^Ƃɂ
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        BTNID_DIALOG_REDRAW)));
        break;

      case MNUID_DISCONNECT:
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf...
        NNshNet_LineHangup();
        break;

      case MNUID_SENDMEMO:
      case chrCapital_M:
      case chrSmall_M:
        // ֏o
        SendToLocalMemopad("html contents", NNshGlobal->workBuf);
        break;

      case BTNID_DIALOG_OK:
      case BTNID_DIALOG_CANCEL:
      case BTNID_DIALOG_REDRAW:
      default:
        return (false);
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF                                                */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuŁvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_Char(void *rec1, void *rec2, Int16 other,
                              SortRecordInfoPtr       rec1SortInfo,
                              SortRecordInfoPtr       rec2SortInfo, 
                              MemHandle               appInfoH)
{
    Char *str1, *str2;

    str1 = ((Char *) rec1) + other;
    str2 = ((Char *) rec2) + other;
    return (StrCompare(str1, str2));
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt32                                         */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuUInt32Łvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt32(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt32 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt32 *) loc1;
    data2 = (UInt32 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt16                                         */
/*                                                (\[eBOpr֐) */
/*                     key擪otheroCgڂuUInt16Łv  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt16(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt16 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt16 *) loc1;
    data2 = (UInt16 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : searchRecordSub                                            */
/*                                                        (R[h) */
/*-------------------------------------------------------------------------*/
static Err searchRecordSub(DmOpenRef dbRef, void *target, UInt16 keyType, 
                           UInt16   offset, UInt16 *idx,  MemHandle *hnd)
{
    UInt16     nofData, start, end, mid;
    Int16      chk;
    MemHandle  dataH;
    Char      *data;

    // 镶LXg
    data = (Char *)target;
    data = data + offset;

    // f[^[猟s
    nofData = DmNumRecords(dbRef);
    if (nofData == 0)
    {
        return (~errNone - 5);
    }

    // QŎw肳ꂽf[^o^Ă邩`FbN
    mid   = 0;
    start = 0;
    end   = nofData;
    while (start <= end)
    {
        mid = start + (end - start) / 2;
        dataH = DmQueryRecord(dbRef, mid);
        if (dataH == 0)
        {
            // ȂI (Ŕ͗l)
            return (~errNone);
        }

        // w肳ꂽL[ɂāA`FbN@ς
        data = (Char *) MemHandleLock(dataH);
        switch (keyType)
        {
          case NNSH_KEYTYPE_UINT32:
            chk  = *((UInt32 *) data) - *((UInt32 *) target);
            break;

          case NNSH_KEYTYPE_UINT16:
            chk  = *((UInt16 *) data) - *((UInt16 *) target);
            break;

          case NNSH_KEYTYPE_CHAR:
          default:
            chk  = StrCompare(data, (Char *) target);
            break;
        }
        if (chk == 0)
        {
            // I(f[^܂邲ƃRs[)
            MemHandleUnlock(dataH);
            *idx  = mid;
            *hnd  = dataH;
            return (errNone);
        }
        MemHandleUnlock(dataH);
        if (chk < 0)
        {
            start = mid + 1;
        }
        else
        {
            end   = mid - 1;
        }
    }
    return (~errNone - 4);
}

/*==========================================================================*/
/*  OpenDatabase_NNsh : f[^x[XANZX̏                        */
/*                                                                          */
/*==========================================================================*/
void OpenDatabase_NNsh(Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef)
{
    LocalID dbId;
    UInt16  dbVersion;

    // f[^x[X݂邩mFB
    *dbRef    = 0;
    dbVersion = 0;
    dbId      = DmFindDatabase(0, dbName);
    if (dbId != 0)
    {
        // f[^x[X̃o[Wԍ擾
        (void) DmDatabaseInfo(0, dbId, NULL, NULL, &dbVersion, NULL, 
                              NULL, NULL, NULL, NULL, NULL, NULL, NULL);
        if (dbVersion < chkVersion)
        {
            // f[^x[X̃o[WÂƂ́Af[^x[X폜
            (void) DmDeleteDatabase(0, dbId);
            dbId = 0;
        }
    }

    // f[^x[X݂ȂƂ
    if (dbId == 0)
    {
        // f[^x[XVK쐬
        (void) DmCreateDatabase(0, dbName, 
                                SOFT_CREATOR_ID, SOFT_DBTYPE_ID, false);

        dbId      = DmFindDatabase(0, dbName);
        if (dbId != 0)
        {
            // DBɃo[Wԍݒ
            dbVersion = chkVersion;
            (void) DmSetDatabaseInfo(0, dbId, NULL,NULL, &dbVersion, NULL,
                                     NULL,NULL,NULL,NULL,NULL,NULL,NULL);
        }
    }

    // f[^x[X̃I[v
    *dbRef = DmOpenDatabase(0 , dbId, dmModeReadWrite);

    return;
}

/*==========================================================================*/
/*  closeDatabase_NNsh() : f[^x[XN[Y                       */
/*                                                                          */
/*==========================================================================*/
void CloseDatabase_NNsh(DmOpenRef dbRef)
{
    // DBI[vłĂCLOSEB
    if (dbRef != 0)
    {
        (void) DmCloseDatabase(dbRef);
        dbRef = 0;
    }
    return;
}

/*=========================================================================*/
/*   Function : QsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void QsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // NCbN\[gd|
    switch (keyType)
    {

      case NNSH_KEYTYPE_UINT32:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : IsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void IsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // }\[gd|
    switch (keyType)
    {
      case NNSH_KEYTYPE_UINT32:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : EntryRecord_NNsh                                           */
/*                                               (ca̐擪Ƀf[^o^)  */
/*=========================================================================*/
Err EntryRecord_NNsh(DmOpenRef dbRef, UInt16 size, void *recordData)
{
    MemHandle  newRecH;
    UInt16     index;
    void      *dbP;

    // R[h̐VKǉ
    index   = 0;
    newRecH = DmNewRecord(dbRef, &index, size + sizeof(UInt32));
    if (newRecH == 0)
    {
        // R[hǉG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(newRecH);
    DmWrite(dbP, 0, recordData, size);
    MemHandleUnlock(newRecH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*=========================================================================*/
/*   Function : IsExistRecord_NNsh                                         */
/*                                                (R[h̑݃`FbN) */
/*=========================================================================*/
Err IsExistRecord_NNsh(DmOpenRef dbRef, void   *target,  UInt16 keyType,
                       UInt16 offset,   UInt16 *index)
{
    MemHandle  dataH;

    *index  = 0;
    dataH   = 0;
    return (searchRecordSub(dbRef, target, keyType, offset, index, &dataH));
}

/*=========================================================================*/
/*   Function : SearchRecord_NNsh                                          */
/*                                                        (R[h) */
/*=========================================================================*/
Err SearchRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType,
                      UInt16 offset, UInt16 size, void *matchedData,
                      UInt16 *index)
{
    Err        ret;
    UInt16     start;
    MemHandle  dataH;
    Char      *sc,  *ds;
    UInt32    *src, *dest;

    *index = 0;
    dataH  = 0;

    ret    = searchRecordSub(dbRef, target, keyType, offset, index, &dataH);
    if (ret != errNone)
    {
        // f[^炸
        return (ret);
    }
    if (dataH == 0)
    {
        // nhُ
        return ((~errNone) - 2);
    }

    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }

    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : DeleteRecord_NNsh                                          */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecord_NNsh(DmOpenRef dbRef, void  *target,
                      UInt16 keyType,  UInt16 offset)
{
    Err       ret;
    UInt16    index;
    MemHandle dataH;

    index = 0;
    dataH = 0;
    ret = searchRecordSub(dbRef, target, keyType, offset, &index, &dataH);
    if (ret != errNone)
    {
        return (errNone + 1);
    }

    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : DeleteRecordIDX_NNsh                                       */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone);
    }
    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : GetRecord_NNsh                                             */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecord_NNsh(DmOpenRef dbRef, UInt16 index,
                   UInt16 size, void *matchedData)
{
    MemHandle  dataH;
    UInt16     start;
    UInt32    *src, *dest;
    Char      *sc,  *ds;

    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    dataH = DmQueryRecord(dbRef, index);
    if (dataH == 0)
    {
        // ȂI
        return (~errNone);
    }
    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }
    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : GetRecordReadOnly_NNsh                                     */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    *dataH = DmQueryRecord(dbRef, index);
    if (*dataH == 0)
    {
        // ȂI
        return (~errNone);
    }

    // ̈bN
    *record = MemHandleLock(*dataH);
    if (record == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : ReleaseRecordReadOnly_NNsh                                 */
/*                                                (R[hǂݏoI) */
/*=========================================================================*/
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH)
{
    if (dataH != 0)
    {
        MemHandleUnlock(dataH);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : UpdateRecord_NNsh                                          */
/*                                          (R[hCfbNXōXV) */
/*=========================================================================*/
Err UpdateRecord_NNsh(DmOpenRef dbRef, UInt16 index, 
                      UInt16 size, void *updateData)
{
    MemHandle recH;
    void     *dbP;

    recH = DmGetRecord(dbRef, index);
    if (recH == 0)
    {
        // R[hQƃG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(recH);
    DmWrite(dbP, 0, updateData, size);
    MemHandleUnlock(recH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*==========================================================================*/
/*  GetDBCount_NNsh : f[^x[Xɓo^Ăf[^      */
/*                                                                          */
/*==========================================================================*/
void GetDBCount_NNsh(DmOpenRef dbRef, UInt16 *count)
{
    *count = DmNumRecords(dbRef);
    return;
}

/*==========================================================================*/
/*  GetDBInfo_NNsh : f[^x[X̏̎擾                               */
/*                                                                          */
/*==========================================================================*/
Err GetDBInfo_NNsh(Char *dbName, NNshDBInfo *info)
{
    LocalID dbId;
    
    dbId = DmFindDatabase(0, dbName);

    // f[^x[X݂ȂƂ
    if (dbId == 0)
        return(~errNone);

    return(DmDatabaseInfo(0, dbId,
                          info->nameP, info->attributesP,
                          info->versionP, info->crDateP,
                          info->modDateP, info->bckUpDateP,
                          info->modNumP, info->appInfoIDP,
                          info->sortInfoIDP, info->typeP,
                          info->creatorP));
}


/*==========================================================================*/
/*  net_open() : lbg̃I[v                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_open(UInt16 *netRef)
{
    UInt16 ifErr;
    Err    ret;

    // ϐ̏
    ifErr = 0;

    // lbgCũI[v
    (void) SysLibFind("Net.lib", netRef);

    // lbg[Nnodm
    ret   = NetLibOpen(*netRef, &ifErr);
    if ((ret == errNone)||(ret == netErrAlreadyOpen))
    {
        if (ifErr == 0)
        {
            // open
            return (errNone);
        }
        (void) NetLibClose(*netRef, false);
        *netRef = 0;
        ret = ~errNone;
    }
    return (ret);
}

/*==========================================================================*/
/*  net_close() : lbg̃N[Y                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_close(UInt16 netRef)
{
    return (NetLibClose(netRef, false));
}

/*==========================================================================*/
/*  net_write() : f[^𑗐M                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_write(NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->ret = NetLibSend(NNshGlobal->netRef, 
                                 NNshGlobal->socketRef,
                                 NNshGlobal->sendBuf, 
                                 StrLen(NNshGlobal->sendBuf),
                                 0,
                                 NULL,
                                 0,
                                 NNshGlobal->timeout,
                                 &(NNshGlobal->err));
    if (NNshGlobal->ret != -1)
    {
        NNshGlobal->err = errNone;
    }
    return (NNshGlobal->err);
}

/*==========================================================================*/
/*  net_read() : f[^M                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_read(NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->ret = 0;
    NNshGlobal->fieldLen = 0;
    while (NNshGlobal->ret < RECEIVEBUFFER_DEFAULT)
    {
        NNshGlobal->fieldLen = NetLibReceive(NNshGlobal->netRef, 
                                      NNshGlobal->socketRef,
                                      &(NNshGlobal->recvBuf[NNshGlobal->ret]),
                                      (RECEIVEBUFFER_DEFAULT
                                               - MARGIN - NNshGlobal->ret),
                                      0, NULL, 0, 
                                      NNshGlobal->timeout,
                                      &(NNshGlobal->err));
        if (NNshGlobal->fieldLen != -1)
        {
            NNshGlobal->err = errNone;
        }
        if (NNshGlobal->fieldLen == 0)
        {
            break;
        }

        NNshGlobal->ret = NNshGlobal->ret + NNshGlobal->fieldLen;

        // BUSYEBhEXV
        MemSet (NNshGlobal->showBuf, MINIBUF, 0x00);
        StrIToA(NNshGlobal->showBuf, NNshGlobal->ret);
        StrCat (NNshGlobal->showBuf, " bytes...");
        SetMsg_BusyForm(NNshGlobal->showBuf);
    }
    return (NNshGlobal->err);
}

/*==========================================================================*/
/*  net_disconnect() : zXg؂藣                                   */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_disconnect(UInt16 netRef, NetSocketRef socketRef, Int32 timeout)
{
    Err    err;

    (void) NetLibSocketShutdown(netRef, socketRef, netSocketDirBoth, timeout, &err);
    (void) NetLibSocketClose(netRef, socketRef, timeout, &err);
    if (err == errNone)
    {
        socketRef = 0;
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_connect() : zXgɐڑ                                            */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_connect(NNshWorkingInfo *NNshGlobal)
{
    UInt8                openFlag;
    Int16                addrLen;
    NetHostInfoPtr       hostIP;
    NetSocketAddrINType *addrType;
    NetSocketAddrType    addrBuf;
    NetHostInfoBufType  *infoBuff;

    // ڑXV(ǉ...)
    NetLibConnectionRefresh(NNshGlobal->netRef,
                            true,
                            &openFlag,
                            &(NNshGlobal->ret));

    // obt@̈m
    infoBuff = MemPtrNew(sizeof(NetHostInfoBufType));
    if (infoBuff == NULL)
    {
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "MemPtrNew", "");
        return (~errNone);
    }
    MemSet(infoBuff, sizeof(NetHostInfoBufType), 0x00);

    // zXgIPAhX擾
    hostIP = NetLibGetHostByName(NNshGlobal->netRef,
                                 NNshGlobal->hostName,
                                 infoBuff,
                                 NNshGlobal->timeout, 
                                 &(NNshGlobal->err));
    if (hostIP == 0)
    {
        // zXgIP̎擾s
        NNshGlobal->err = NNSH_ERRORCODE_FAILURECONNECT;
        FrmCustomAlert(ALTID_INFO,
                       "NNshNet_connect",  
                       "NetLibGetHostByName :",
                       NNshGlobal->hostName);
        goto FUNC_END;
    }

    // \PbgOPEN
    NNshGlobal->socketRef = NetLibSocketOpen(NNshGlobal->netRef,
                                             netSocketAddrINET, 
                                             netSocketTypeStream,
                                             netSocketProtoIPTCP,
                                             NNshGlobal->timeout,
                                             &(NNshGlobal->err));
    if (NNshGlobal->socketRef == -1)
    {
        // \PbgOPENُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketOpen", "");
        NNshGlobal->socketRef = 0;
        NNshGlobal->err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }

    // \PbgRlNg
    MemSet(&addrBuf, sizeof(NetSocketAddrType), 0x00);
    addrType = (NetSocketAddrINType *) &addrBuf;
    addrType->family = netSocketAddrINET;
    addrType->port   = NetHToNS(NNshGlobal->portNum);
    //addrType->addr   = infoBuff->address[0];
    MemMove(&(addrType->addr), *(hostIP->addrListP), hostIP->addrLen); 
    addrLen         = sizeof(NetSocketAddrType);
    NNshGlobal->err = errNone;
    NNshGlobal->ret = NetLibSocketConnect(NNshGlobal->netRef, 
                                          NNshGlobal->socketRef,
                                          (NetSocketAddrType *) &addrBuf,
                                          addrLen,
                                          NNshGlobal->timeout,
                                          &(NNshGlobal->err));
    if (NNshGlobal->ret == -1)
    {
        // \PbgRlNgُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketConnect", "");
        (void) NetLibSocketClose(NNshGlobal->netRef,
                                 NNshGlobal->socketRef,
                                 NNshGlobal->timeout,
                                 &(NNshGlobal->err));
        NNshGlobal->err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }
    NNshGlobal->err = errNone;

FUNC_END:
    // obt@̈J
    (void) MemPtrFree(infoBuff);

    return (NNshGlobal->err);
}

/*==========================================================================*/
/*  NNshNet_LineHangup() : ؒf                                         */
/*                                                                          */
/*==========================================================================*/
void NNshNet_LineHangup(void)
{
   UInt16 netRef;

   (void) SysLibFind("Net.lib", &(netRef));

    // ؒf̊mF
    if (netRef != 0)
    {
        (void) NetLibClose(netRef, true);
        (void) NetLibFinishCloseWait(netRef);
    }
    return;
}

/*==========================================================================*/
/*  NNshSSL_callbackFunc() : SSL̃R[obN֐                          */
/*                                                                          */
/*==========================================================================*/
Int32 NNshSSL_callbackFunc(SslCallback *callbackStruct, Int32 command,
                           Int32 flavor, void *info)
{
  //  Ƃ肠AȂBBB
#if 0
    SslVerify *verifyData;

    switch (command)
    {
      case sslCmdVerify:
        // 'verify callback'
        verifyData = (SslVerify *) info;
        // ̊֐̌ŋᖡ
        break;

      case sslCmdInfo:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Info:","sslCmdInfo");
        return (errNone);
        break;
      case sslCmdNew:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," New:","sslCmdNew");
        return (errNone);
        break;
      case sslCmdReset:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Reset:","sslCmdReset");
        return (errNone);
        break;

      case sslCmdFree:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Free:","sslCmdFree");
        return (errNone);
        break;

      default:
        // FrmCustomAlert(ALTID_INFO, "SSL_callback", " cmd:", "???");
        return (errNone);
        break;
    }

    // Verify(certificate)
    // FrmCustomAlert(ALTID_INFO, "SSL_callback", " code:", "flavor");
    switch (flavor)
    {
      case sslErrBadDecode:
        // ܂ؖfR[hłȂ
      case sslErrCert:
        // ʓIȏؖG[
      case sslErrCertDecodeError:
        // ؖ̃fR[hɎs
      case sslErrUnsupportedCertType:
        // T[o킯̂킩iT|[gĂȂjؖ𑗂Ă
      case sslErrUnsupportedSignatureType:
        // T[o킯̂킩VOl`𑗂Ă
      case sslErrVerifyBadSignature:
        // ؖ̃VOl`
      case sslErrVerifyNoTrustedRoot:
        // ؖȂ
      case sslErrVerifyNotAfter:
        // ̗ؖL؂Ă
      case sslErrVerifyNotBefore:
        // ؖ̓tɂȂĂ
      case sslErrVerifyConstraintViolation:
        // ؖX509̊gɈᔽĂ
      case sslErrVerifyUnknownCriticalExtension:
        // X509gؖ`FbN[`ŉ߂łȂ
      case sslErrOk:
      default:
        // NULL
        break;
    }
#endif
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_open() : SSLCũI[v                                */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_open(UInt16 sslMode, UInt16 *netRef,
                 UInt16 *sslRef, SslLib **template, SslContext **context)
{
    Err ret;

    // ϐ̏
    *netRef   = 0;
    *sslRef   = 0;
    *template = NULL;
    *context  = NULL;

    // NetCũI[v
    ret = NNshNet_open(netRef);
    if (ret != errNone)
    {
        *netRef = 0;
        return (ret);
    }

    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        // SSL[hłȂA܂Ԃ
        return (ret);
    }

    // SSLCũI[v
    if (SysLibFind(kSslDBName, sslRef) != 0)
    {
        if (SysLibLoad(kSslLibType, kSslLibCreator, sslRef) != 0)
        {
            // [hsAG[
            *sslRef = 0;
            return (~errNone);
        }
    }
    ret = SslLibOpen(*sslRef);
    if (ret != errNone)
    {
        // SSLCuI[vsAAA
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // generic SSL context̍쐬
    ret = SslLibCreate (*sslRef, template);
    if (ret != errNone)
    {
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // Rp`tÕZbg
    // SslLibSet_Compat(*sslRef, *template, sslCompatAll);

    // SSL context̍쐬
    ret = SslContextCreate(*sslRef, *template, context);
    if (ret != errNone)
    {
        // generic SSL context̔p
        (void) SslLibDestroy(*sslRef, *template);
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        *template = NULL;
        return (ret);
    }
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_close() : SSLCũN[Y                               */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_close(UInt16 sslMode, UInt16 netRef,
                         UInt16 sslRef, SslLib *template, SslContext *context)
{
    if ((sslRef == 0)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
        NNshNet_close(netRef);
        return (errNone);
    }

    if (context != NULL)
    {
        (void) SslContextDestroy(sslRef, context);
    }

    if (template != NULL)
    {
        (void) SslLibDestroy(sslRef, template);
    }
    (void) SslLibClose(sslRef);

    (void) NNshNet_close(netRef);
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_connect() : SSLڑ                                             */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_connect(UInt16 sslMode, NNshWorkingInfo *NNshGlobal)
{
    Err ret;
    SslCallback verifyCallback;

    // TCP/IPŃzXgɐڑ
    ret = NNshNet_connect(NNshGlobal);
    if ((ret != errNone)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
        return (ret);
    }

    // VerifyR[obN֐ݒ肷
    MemSet(&verifyCallback, sizeof(SslCallback), 0x00);
    verifyCallback.callback = NNshSSL_callbackFunc;
    SslContextSet_VerifyCallback(NNshGlobal->sslRef,
                                 NNshGlobal->sslContext,
                                 &verifyCallback);

    // \PbgContextɐݒAzXgɐڑ
    //SslContextSet_Compat(sslRef, context, sslCompatAll);
    SslContextSet_Socket(NNshGlobal->sslRef,
                         NNshGlobal->sslContext,
                         NNshGlobal->socketRef);
    ret = SslOpen(NNshGlobal->sslRef, NNshGlobal->sslContext,
                  ((sslOpenModeSsl)|(sslOpenUseDefaultTimeout)), 0);
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_disconnect() : SSLؒf                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_disconnect(UInt16 sslMode, UInt16 sslRef, SslContext *context,
                       NetSocketRef socketRef, UInt16 netRef, Int32 timeout)
{
    Err ret;
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        ret = SslClose(sslRef, context, sslCloseUseDefaultTimeout, timeout);
    }
    ret = NNshNet_disconnect(netRef, socketRef, timeout);

    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_write() : f[^M(SSL)                                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_write(UInt16 sslMode, NNshWorkingInfo *NNshGlobal)
{
    // SSL[hłȂ΁Aʏ̏ݏs
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_write(NNshGlobal));
    }

    // f[^
    NNshGlobal->ret = SslWrite(NNshGlobal->sslRef,
                               NNshGlobal->sslContext,
                               NNshGlobal->sendBuf,
                               StrLen(NNshGlobal->sendBuf),
                               &(NNshGlobal->err));
    if (NNshGlobal->ret  != -1)
    {
        NNshGlobal->err = errNone;
    }
    return (NNshGlobal->err);
}

/*==========================================================================*/
/*  NNshSSL_read() : f[^M(SSL)                                        */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_read(UInt16 sslMode, NNshWorkingInfo *NNshGlobal)
{
    // SSL[hłȂ΁Aʏ̓ǂݏos
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_read(NNshGlobal));
    }
    
    // f[^ǂݍ
    NNshGlobal->ret = SslRead(NNshGlobal->sslRef,
                              NNshGlobal->sslContext,
                              NNshGlobal->recvBuf, 
                              NNshGlobal->ret,
                              &(NNshGlobal->err));
    if (NNshGlobal->ret != -1)
    {
        NNshGlobal->err = errNone;
    }
    return (NNshGlobal->err);
}

/*==========================================================================*/
/*  NNshSSL_flush() : f[^obt@̃NA(SSL)                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_flush(UInt16 sslMode, UInt16  sslRef, SslContext *context)
{
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        // f[^obt@̃NAw
        SslContextSet_Mode(sslRef, context, (sslModeFlush));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : SendToLocalMemopad                                         */
/*                    Exchange}l[WgpăɃf[^] */
/*                    (http://www.palmos.com/dev/support/docs/recipes/     */
/*                                    recipe_exg_mgr_send_local.html ) */
/*=========================================================================*/
Err SendToLocalMemopad(Char *title, Char *data)
{
    ExgSocketType *exgSocket;
    UInt32        size;
    Err           err;

    // f[^̏
    exgSocket = MemPtrNew(sizeof(ExgSocketType));
    if (exgSocket == NULL)
    {
        // ̈mێs
        return (~errNone);
    }
    MemSet(exgSocket, sizeof(ExgSocketType), 0x00);
    err  = errNone;
    size = StrLen(data) + 1;

    // X]ANȂ悤ɂ
    exgSocket->noGoTo      = 1;

    // X]\sȂ
    exgSocket->noStatus    = true;

    // will comm. with memopad app
    exgSocket->description = title;
    exgSocket->name        = "Message.txt";

    // set to comm. with local machine (PIM) only
    exgSocket->localMode = 1;

    err = ExgPut(exgSocket);
    if (err == errNone)
    {
        ExgSend(exgSocket, data, size, &err);
        ExgDisconnect(exgSocket, err);
    }

    // mۗ̈̉
    MEMFREE_PTR(exgSocket);

    return (err);
}

/*=========================================================================*/
/*   Function : ShowVersion_NNsh                                           */
/*                                                    o[W̕\ */
/*=========================================================================*/
void ShowVersion_NNsh(void)
{
    Char *buffer;
    
    buffer = MemPtrNew(BUFSIZE * 2);
    if (buffer == NULL)
    {
        // ̈mێs
        return;
    }
    MemSet (buffer, (BUFSIZE * 2), 0x00);
    StrCopy(buffer, SOFT_NAME);
    StrCat (buffer, "\n");
    StrCat (buffer, SOFT_VERSION);
    StrCat (buffer, SOFT_REVISION);
    StrCat (buffer, "\n(");
    StrCat (buffer, SOFT_DATE);
    StrCat (buffer, ")\n    ");
    StrCat (buffer, SOFT_INFO);
    FrmCustomAlert(ALTID_INFO, buffer, "", "");

    MEMFREE_PTR(buffer);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinSetFieldText                                       */
/*                                                tB[heLXg̍XV */
/*=========================================================================*/
void NNshWinSetFieldText(FormType *frm, UInt16 fldID, Char *msg, UInt32 size)
{
    MemHandle  txtH, oldTxtH;
    Char      *txtP;
    FieldType *fldP;

    // bZ[W\̈ɃRs[
    txtH = MemHandleNew(size + MARGIN);
    if (txtH == 0)
    {
        // ̈̊mۂɎs
        return;
    }
    txtP = (Char *) MemHandleLock(txtH);
    if (txtP == NULL)
    {
        // ̈̊mۂɎs
        MemHandleFree(txtH);
        return;
    }
    (void) MemSet(txtP,  size + MARGIN, 0x00);
    if (size != 0)
    {
        (void) StrNCopy(txtP, msg, size);
    }
    MemHandleUnlock(txtH);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnhւAÂ̂폜
    oldTxtH = FldGetTextHandle(fldP);
    FldSetTextHandle(fldP, NULL);
    FldSetTextHandle(fldP, txtH);
    if (oldTxtH != 0)
    {
        (void) MemHandleFree(oldTxtH);
    }

    // tH[̍ĕ`
    FrmDrawForm(frm);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinGetFieldText                                       */
/*                                                tB[heLXg̎擾 */
/*=========================================================================*/
void NNshWinGetFieldText(FormType *frm, UInt16 fldID, Char *area, UInt32 len)
{
    MemHandle  txtH;
    Char      *txtP;
    FieldType *fldP;

    // tB[hi[̈
    MemSet(area, len, 0x00);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnh擾
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        if (txtP != NULL)
        {
            StrNCopy(area, txtP, (len - 1));
            MemHandleUnlock(txtH);
        }
    }
    return;
}

/*=========================================================================*/
/*   Function : NNshWinSetPopItems                                         */
/*                                          |bvAbvgK̃xݒ */
/*=========================================================================*/
void NNshWinSetPopItems(FormType *frm, UInt16 popId, UInt16 lstId, UInt16 item)
{
    ListType    *lstP;
    ControlType *ctlP;

    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, popId));
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));
                          
    LstSetTopItem  (lstP, item);
    LstSetSelection(lstP, item);
    CtlSetLabel    (ctlP, LstGetSelectionText(lstP, item));

    return;
}

/*=========================================================================*/
/*   Function : DataInputDialog                                            */
/*                                                NNsiʂ̓̓_CAO */
/*=========================================================================*/
Boolean InputDialog(Char *title, Char *area, UInt16 size)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    FieldType    *fldP;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAOtH[ANeBuɂ
    diagFrm  = FrmInitForm(FRMID_INPUTDIALOG);
    if (diagFrm == NULL)
    {
        return (false);
    }
    FrmSetActiveForm(diagFrm);

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    // w肳ꂽEBhEɔf
    NNshWinSetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
    FrmSetFocus(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    fldP = FrmGetObjectPtr(diagFrm,
                           FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    // IĂ
    FldSetSelection(fldP, 0, FldGetTextLength(fldP));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_EditAction);

    if (FrmDoDialog(diagFrm) == BTNID_DIALOG_OK)
    {
        // OK{^ꂽƂɂ́A擾
        NNshWinGetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
        ret = true;
    }
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    return (ret);
}

/*=========================================================================*/
/*   Function : SetMsg_BusyForm                                            */
/*                                                     BUSYeLXg̐ݒ  */
/*=========================================================================*/
void SetMsg_BusyForm(Char *msg)
{
    FormType *busyFrm;
    UInt16    length;

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    busyFrm = FrmGetActiveForm();
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Show_BusyForm                                              */
/*                                                      BUSYtH[̕\ */
/*=========================================================================*/
void Show_BusyForm(Char *msg, NNshWorkingInfo *NNshGlobal)
{
    FormType  *busyFrm;
    UInt16    length;

    switch (FrmGetActiveFormID())
    {
      case FRMID_BUSY:
        // łBUSYEBhE\Ăꍇ
        return (SetMsg_BusyForm(msg));
        break;

      case 0:
        // EBhEJĂȂ
        NNshGlobal->prevBusyForm = NULL;
        break;

      default:
        // ݂̃EBhEL
        NNshGlobal->prevBusyForm = FrmGetActiveForm();
        break;
    }

    // tH[݂̌̏ԂL
    // MemSet(&(NNshGlobal->formState), sizeof(FormActiveStateType), 0x00);
    // FrmSaveActiveState(&(NNshGlobal->formState));
    // NNshGlobal->prevBusyForm = FrmGetActiveForm();

    // BUSY_CAOtH[𐶐AANeBuɂ
    busyFrm = FrmInitForm(FRMID_BUSY);
    FrmSetActiveForm(busyFrm);

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    // tB[hɕݒ
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Hide_BusyForm                                              */
/*                                                      BUSYtH[̍폜 */
/*=========================================================================*/
void Hide_BusyForm(NNshWorkingInfo *NNshGlobal)
{
    FormType *frm;

    if (FrmGetActiveFormID() != FRMID_BUSY)
    {
        // Ȃ
        return;
    }

    // BUSYtH[폜
    frm = FrmGetActiveForm();
    if (NNshGlobal->prevBusyForm != NULL)
    {
        // Ȃł̂...
        FrmEraseForm (frm);
        FrmSetActiveForm(NNshGlobal->prevBusyForm);
    }
    FrmDeleteForm(frm);

    // FrmRestoreActiveState(&(NNshGlobal->formState));

    return;
}

/**----------------------------------------------------------------------**
 **   get_html_contents   : HTMLf[^M
 **
 **----------------------------------------------------------------------**/
static void get_html_contents(NNshWorkingInfo *NNshGlobal)
{
    // Mobt@f[^߂
    StrCopy(NNshGlobal->workBuf, " ");

    // bZ[W쐬
    NNsh_MakeHTTPmsg(NNshGlobal);

    // iMvgRɍ킹ājHTMLvbZ[W𑗂
    if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
    {
        // httpsʐMv
        NNshHTTPS_comm(NNshGlobal);
    }
    else
    {
        // httpʐMv
        NNshHTTP_comm(NNshGlobal);
    }
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", " ");
#endif
        return;
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n---\n\n1st RECEIVE CONTENT\n\n");
    SendToLocalMemopad("RECEIVED DATA(1)", NNshGlobal->recvBuf);
#endif

    // MbZ[WɃ_CNg̎w邩A`FbNs
    NNshGlobal->err = ~errNone - 9;
    if ((NNshGlobal->recvBuf[0]  == 'H')&&
        (NNshGlobal->recvBuf[1]  == 'T')&&
        (NNshGlobal->recvBuf[2]  == 'T')&&
        (NNshGlobal->recvBuf[3]  == 'P')&&
        (NNshGlobal->recvBuf[9]  == '3')&&
        (NNshGlobal->recvBuf[10] == '0')&&
        (NNshGlobal->recvBuf[11] == '2'))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNsh_check302URL(NNshGlobal);
    }

    // _CNg̃AhX擾łƂ...
REDIRECT_AGAIN:
    if (NNshGlobal->err == errNone)
    {
        // bZ[W쐬
        NNsh_MakeHTTPmsg(NNshGlobal);
        // _CNgɁiMvgRɍ킹āj
        if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
        {
            // httpsʐMv
            NNshHTTPS_comm(NNshGlobal);
        }
        else
        {
            // httpʐMv
            NNshHTTP_comm(NNshGlobal);
        }
        if (NNshGlobal->err != errNone)
        {
#ifdef DEBUG
            // ʐMsAG[
            FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", "(redirect)");
#endif
            return;
        }
    }

    // ēxy[WJȂĂ͂ȂȂꍇ...
    NNsh_checkRefreshConnectionRequest(NNshGlobal);
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG
        // ēx_CNg邱Ƃ𑗐M
        FrmCustomAlert(ALTID_INFO, 
                       "REDIRECT AGAIN...(", NNshGlobal->reqAddress, ")");
#endif
        goto REDIRECT_AGAIN;
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n---\n\nRECEIVE CONTENT\n\n");
    SendToLocalMemopad("RECEIVED DATA", NNshGlobal->recvBuf);
#endif

}

/**----------------------------------------------------------------------**
 **    MbZ[W̃_CNg(OCy[W)͂
 ** 
 **                    NNshGlobal->recvBuf F M{fB
 **
 **
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_check302URL(NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "http");
    if (NNshGlobal->tempPtr == NULL)
    {
        // RedirectzXg̓ǂݏos
        NNshGlobal->err = ~errNone;
        return;
    }

#ifdef USE_REFERER
    // _CNgꂽAhXRefererɐݒ肷
    MemSet(NNshGlobal->referer, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (NNshGlobal->tempPtr[(NNshGlobal->loopCount)] <= ' ')
        {
            // URL̖ɓB(ԂA{ \r Ŕ...)
            break;
        }
        NNshGlobal->referer[(NNshGlobal->loopCount)] =
                                  NNshGlobal->tempPtr[(NNshGlobal->loopCount)];
    }
#endif

    // vgR̃`FbN
    NNshGlobal->sendMethod = 0;
    if (NNshGlobal->tempPtr[4] == 's')
    {
        // https (SSL)
        NNshGlobal->sendMethod = NNSHLOGIN_SSL_PROTOCOL;
    }
    NNshGlobal->tempPtr = StrStr(NNshGlobal->tempPtr, "://");
    if (NNshGlobal->tempPtr == NULL)
    {
        // zXgoɎs
        NNshGlobal->err = ~errNone + 100;
        return;
    }
    NNshGlobal->tempPtr = NNshGlobal->tempPtr + 3;  // 3́AStrLen("://");

    // zXg̃Rs[
    MemSet(NNshGlobal->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (*(NNshGlobal->tempPtr) == '/')
        {
            // zXg̏I[
            // (NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        if (*(NNshGlobal->tempPtr) == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            (NNshGlobal->tempPtr)++;

            // |[gԍ̓
            NNshGlobal->portNum = 0;
            while ((*(NNshGlobal->tempPtr) >= '0')&&
                   (*(NNshGlobal->tempPtr) <= '9'))
            {
                NNshGlobal->portNum = NNshGlobal->portNum * 10 + 
                                         (*(NNshGlobal->tempPtr) - '0');
                (NNshGlobal->tempPtr)++;
            }
            //(NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        NNshGlobal->hostName[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
    }

    // ʐMt@C擾
    NNshGlobal->loopCount = 0; 
    if (*(NNshGlobal->tempPtr) != '/')
    {
        // ΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
        NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
        while (NNshGlobal->loopCount != 0)
        {
            (NNshGlobal->loopCount)--;
            if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
            {
                break;
            }
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
        (NNshGlobal->loopCount)++;
    }
    else
    {
        MemSet(NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    }
    while (NNshGlobal->loopCount < (BUFSIZE - 1))
    {
        if (*(NNshGlobal->tempPtr) <= ' ')
        {
            break;
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
        (NNshGlobal->loopCount)++;
    }

    // AhXȂ / ɂ
    if (StrLen(NNshGlobal->reqAddress) == 0)
    {
        StrCopy(NNshGlobal->reqAddress, "/");
    }
#ifdef DEBUG
    // ͌ʂ̃Oo͂
    FrmCustomAlert(ALTID_INFO, NNshGlobal->hostName, ":", NNshGlobal->reqAddress);
#endif

    // I
    NNshGlobal->err = errNone;
    return;
}

/**----------------------------------------------------------------------**
 **    MbZ[W̃_CNg(OCy[W)ēx͂
 ** 
 **                    NNshGlobal->recvBuf F M{fB
 **
 **
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **                    (NnshGlobal->errerrNonêƂ͍ēxURL擾)
 **----------------------------------------------------------------------**/
static void NNsh_checkRefreshConnectionRequest(NNshWorkingInfo *NNshGlobal)
{
    Char   *ptr;

    ///////////// tbVwH //////////
    NNshGlobal->err = ~errNone;
    ptr = StrStr(NNshGlobal->recvBuf, "http-equiv=\"Refresh\"");
    if (ptr == NULL)
    {
        // Ȃꍇɂ́AȂɂȂ
        NNshGlobal->err = ~errNone;
        return;
    }

    if (NNshGlobal->isChecking != 0)
    {
        // x`FbNς݁AQxڂ͂ȂɂȂ
        NNshGlobal->err = ~errNone;
        return;
    }

    ptr = StrStr(NNshGlobal->recvBuf, "URL=");
    if (ptr == NULL)
    {
        ptr = StrStr(NNshGlobal->recvBuf, "url=");
    }
    if (ptr == NULL)
    {
        // URLEȂAI
        NNshGlobal->err = ~errNone;
        return;
    }
    ptr = ptr + sizeof("url");


    // vAhX̐擪T
    while ((*ptr != '/')&&(*ptr != '\0')&&(*ptr != '"'))
    {
        ptr++;
    }
    // XbV͐摗...
    while (*ptr == '/')
    {
        ptr++;
    }

    // URLwŃtZbgw肩ǂ`FbN
    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "://");
    if ((NNshGlobal->tempPtr == NULL)||(NNshGlobal->tempPtr > ptr))
    {
        //  tZbgwł͂ȂAzXg(ƃ|[gԍ)̐؂o
        // sȂ...
        goto GET_CONTENT_NAME;
    }

    // zXĝ肾s(zXg̃Rs[)
    MemSet(NNshGlobal->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->isChecking = 0; 
         NNshGlobal->isChecking < (BUFSIZE - 1); 
         (NNshGlobal->isChecking)++)
    {
        if (*ptr == '/')
        {
            // zXg̏I[
            break;
        }
        if (*ptr == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            ptr++;

            // |[gԍ̓
            NNshGlobal->portNum = 0;
            while ((*ptr >= '0')&&(*ptr <= '9'))
            {
                NNshGlobal->portNum = NNshGlobal->portNum * 10 + (*ptr - '0');
                ptr++;
            }
            break;
        }
        NNshGlobal->hostName[NNshGlobal->isChecking] = *ptr;
        ptr++;
    }
GET_CONTENT_NAME:
    NNshGlobal->isChecking = 0;
    while ((*ptr != '\0')&&(*ptr != '>')&&(*ptr != '"'))
    {
        NNshGlobal->reqAddress[NNshGlobal->isChecking] = *ptr;
        (NNshGlobal->isChecking)++;
        ptr++;
    }
    NNshGlobal->reqAddress[NNshGlobal->isChecking] = '\0';

    // łxOCtH[擾Ȃ
    NNshGlobal->err = errNone;
    return;
}

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                    NNshGlobal->workBuf F Mf[^
 **                    NNshGlobal->sendBuf F M{fB(HTTPwb_)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_MakeHTTPmsg(NNshWorkingInfo *NNshGlobal)
{
#ifdef USE_RESOURCE
    MemHandle  strH;
#endif

    MemSet(NNshGlobal->sendBuf, (SENDBUFFER_DEFAULT), 0x00);
    switch (NNshGlobal->sendMethod)
    {
      case NNSILOGIN_POST_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshGlobal->portNum = 443;
        break;

      case NNSILOGIN_POST_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshGlobal->portNum = 80;
        break;

      case NNSILOGIN_GET_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshGlobal->portNum = 443;
        break;

      case NNSILOGIN_GET_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshGlobal->portNum = 80;
        break;

      case NNSILOGIN_POST_METHOD_OTHER:
      case NNSILOGIN_POST_METHOD_OTHERSSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        break;

      case NNSILOGIN_GET_METHOD_OTHER:
      case NNSILOGIN_GET_METHOD_OTHERSSL:
      default:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        break;
    }

    if (NNshGlobal->reqAddress[0] != '/')
    {
        // ΃pXŎw΂Ȃꍇ̕⑫...
        StrCat(NNshGlobal->sendBuf, "/");
    }
    StrCat(NNshGlobal->sendBuf, NNshGlobal->reqAddress);
    StrCat(NNshGlobal->sendBuf, " HTTP/1.0\r\nHost: ");
    StrCat(NNshGlobal->sendBuf, NNshGlobal->hostName);

    // refererݒ肳Ăꍇɂ͕t
#ifdef USE_REFERER
    if (StrLen(NNshGlobal->referer) != 0)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nReferer: ");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->referer);
    }
#endif

    // {fBȂꍇɂ́AContent-Length, Content-TypeȂ
    if (StrLen(NNshGlobal->workBuf) > 1)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Length: ");
        StrIToA(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)], 
                                      StrLen(NNshGlobal->workBuf));
#ifdef USE_FORM_SEND
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Type: application/x-www-form-urlencoded");
#endif
    }

    // Mf[^TCY肳
    StrCat(NNshGlobal->sendBuf, "\r\nRange: bytes=0-");
    StrIToA(&(NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)]),
            (RECEIVEBUFFER_DEFAULT - HEADER_BUFFER));

    // Cookieǉ
    if (NNshGlobal->cookie[0] != '\0')
    {
        StrCat(NNshGlobal->sendBuf, "\r\n");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->cookie);
    }

    // wb_̎c蕔t
    StrCat(NNshGlobal->sendBuf, "\r\nAccept: text/html, */*\r\nUser-Agent: webDA/1.00 (PDA; PalmOS/NNsi family)\r\nAccept-Encoding: identity\r\nAccept-Language: ja, en\r\nConnection: close\r\nPragma: no-cache\r\n\r\n");

    StrCat(NNshGlobal->sendBuf, NNshGlobal->workBuf);

    return;
}

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTPS_comm(NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, RECEIVEBUFFER_DEFAULT, 0x00);

    // PalmOS v5.20ꍇɂ͋NȂ
    if (NNshGlobal->palmOSVersion < 0x05200000)
    {
        FrmCustomAlert(ALTID_INFO, "a https-request is need a SslLib."
                       "(You should USE a PalmOS 5.2 or later).","","[webDA]");
        return;
    }

    // SSL̃I[v
    NNshGlobal->err = 
          NNshSSL_open(NNSH_SSLMODE_DOSSL,    &(NNshGlobal->netRef), 
                       &(NNshGlobal->sslRef), &(NNshGlobal->sslTemplate),
                       &(NNshGlobal->sslContext));
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_open", " ", NNshGlobal->hostName);
#endif
        return;
    }

    // SSL̃RlNg
    NNshGlobal->err = NNshSSL_connect(NNSH_SSLMODE_DOSSL, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_connect", " ", NNshGlobal->hostName);
#endif
        goto HTTPS_CLOSE;
    }

    // v̑M
    NNshGlobal->err = NNshSSL_write(NNSH_SSLMODE_DOSSL, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_write", " ", NNshGlobal->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

    // ǂݍ
    NNshGlobal->err = NNshSSL_read(NNSH_SSLMODE_DOSSL, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_read", " ", NNshGlobal->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

HTTPS_DISCONNECT:
    // ڑ؂
    NNshSSL_disconnect(NNSH_SSLMODE_DOSSL, NNshGlobal->sslRef,
                       NNshGlobal->sslContext,  NNshGlobal->socketRef,
                       NNshGlobal->netRef,      NNshGlobal->timeout);
HTTPS_CLOSE:
    // N[Y
    NNshSSL_close(NNSH_SSLMODE_DOSSL, NNshGlobal->netRef,
                  NNshGlobal->sslRef, NNshGlobal->sslTemplate,
                  NNshGlobal->sslContext);

    return;
}

/**----------------------------------------------------------------------**
 **    HTTPʐM{
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTP_comm(NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, RECEIVEBUFFER_DEFAULT, 0x00);

    // lbgCuOPEN
    NNshGlobal->err = NNshNet_open(&(NNshGlobal->netRef));
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_open", " ", NNshGlobal->hostName);
#endif
        return;
    }
    // RlNg
    NNshGlobal->err = NNshNet_connect(NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_connect", " ", NNshGlobal->hostName);
#endif
        goto HTTP_CLOSE;
    }
    SetMsg_BusyForm("Sending a request...");

    // 
    NNshGlobal->err = NNshNet_write(NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_write",  "", "");
#endif
        goto HTTP_CLOSE;
    }
    SetMsg_BusyForm("Receiving a message...");

    // ǂݏo
    NNshGlobal->err = NNshNet_read(NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
        // ǂݏos
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_read",  "", "");
#endif
        goto HTTP_DISCONNECT;
    }

    SetMsg_BusyForm("Disconnecting...");

HTTP_DISCONNECT:
    // \Pbgؒf
    NNshNet_disconnect(NNshGlobal->netRef, NNshGlobal->socketRef, 
                                                        NNshGlobal->timeout);
HTTP_CLOSE:
    NNshNet_close(NNshGlobal->netRef);

    return;
}

/**************************************************************************/
/*   CookieE                                                         */
/*                                                                        */
/*                                                                        */
/**************************************************************************/
void pickup_cookie(NNshWorkingInfo *NNshGlobal)
{
    Char *ptr;

    MemSet(NNshGlobal->cookie, (BUFSIZE + MARGIN), 0x00);
    ptr = StrStr(NNshGlobal->recvBuf, "Set-Cookie");
    if (ptr == NULL)
    {
        // cookie̎w肪ȂAI
        return;
    }

    // Cookief[^Rs[
    ptr = ptr + StrLen("Set-");
    MemMove(NNshGlobal->cookie, ptr, BUFSIZE);
    ptr = NNshGlobal->cookie;
    while ((*ptr != ';')&&(*ptr != '\0'))
    {
        ptr++;
    }
    *ptr = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : ParseMessage                                               */
/*                                                  (bZ[W̐`) */
/*                    buf : Rs[̈                                   */
/*                    src : Rs[̈                                   */
/*                   size : Rs[obt@TCY                         */
/*              kanjiCode : gp銿R[h                             */
/*-------------------------------------------------------------------------*/
static void ParseMessage(Char *buf, Char *src, UInt32 dstSize, UInt32 size, UInt16 kanjiCode)
{
    Boolean kanjiMode;
    UInt16  len;
    Char   *ptr, *dst, dataStatus;

    dataStatus = MSGSTATUS_NAME;
    kanjiMode = false;

    // x߃[`... (PÂp[X)
    dst  = buf;
    ptr  = src;

    while (ptr < (src + size))
    {
        // Rs[obt@sI
        if ((dst + MARGIN) > (buf + dstSize))
        {
            break;
	}

        // JISR[h̕ϊWbN
        if (kanjiCode == NNSH_KANJICODE_JIS)
        {
            // JISSHIFT JIS̃R[hϊ
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x24')&&(*(ptr + 2) == '\x42'))
            {
                // [hɐ؂ւ
                kanjiMode = true;
                ptr = ptr + 3;
                continue;
            }
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x28')&&(*(ptr + 2) == '\x42'))
            {
                // ANK[hɐ؂ւ
                kanjiMode = false;
                ptr = ptr + 3;
                continue;
            }
            if (kanjiMode == true)
            {
                // JIS > SJIS ϊ
                ConvertJIStoSJ(dst, ptr);
                ptr = ptr + 2;
                dst = dst + 2;
                continue;
            }
        }
        if (*ptr == '&')
        {
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
                (*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&(*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
                (*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&(*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
                (*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }
        if (*ptr == '<')
        {
            //  "<>" ́AZp[^(Ԃɂĕς)
            if (*(ptr + 1) == '>')
            {
                ptr = ptr + 2;   // StrLen(DATA_SEPARATOR);
                switch (dataStatus)
                {
                  case MSGSTATUS_NAME:
                    // Ő؂
                    *dst++ = ' ';
                    *dst++ = ' ';
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_EMAIL;
                    break;

                  case MSGSTATUS_EMAIL:
                    // e-mail̋؂
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_DATE;
                    *dst++ = '\n';
                    break;

                  case MSGSTATUS_DATE:
                    // NEԂтhc̋؂
                    *dst++ = '\n';
                    *dst++ = '\n';
                    dataStatus = MSGSTATUS_NORMAL;
                    if (*ptr == ' ')
                    {
                        // Xy[X͓ǂݔ΂
                        ptr++;
                    }
                    break;

                  case MSGSTATUS_NORMAL:
                  default:
                    // bZ[W̏I[
                    *dst++ = ' ';
                    *dst++ = '\0';
                    return;
                    break;
                }
                continue;
            }
            //  "<br>" ́Asɒu
            if (((*(ptr + 1) == 'b')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'B')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                // sƍs̃Xy[XĂ݂ꍇ
                if ((ptr > src)&&(*(ptr - 1) == ' '))
                {
                    dst--;
                }
                if (*(ptr + 4) == ' ')
                {
                    *dst++ = '\n';
                    ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                    continue;
                }
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<p*>" ́As2ɒu
            if ((*(ptr + 1) == 'p')||(*(ptr + 1) == 'P'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 2;
                while ((*ptr != '>')&&(ptr < (src + size)))
                {
                    ptr++;
                }
                ptr++;
                continue;
            }

            // <li>^OsR[h:ɒu
            if (((*(ptr + 1) == 'l')&&(*(ptr + 2) == 'i')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'L')&&(*(ptr + 2) == 'I')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '';
                ptr = ptr + 4;
                continue;
            }   

            //  "<hr>" ́As === s ɒu
            if (((*(ptr + 1) == 'h')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'H')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dt>"́Asɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "</tr>"  "</td>" ́Asɒu
            if (((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'r')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'R')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'd')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'D')&&(*(ptr + 4) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dd>" ́AsƋ󔒂Qɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 'd')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'D')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<h?" ́As + s ɒu
            if ((*(ptr + 1) == 'h')&&(*(ptr + 1) == 'H'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            //  "</h?>" ́As + s ɒu
            if (((*(ptr + 2) == 'h')||(*(ptr + 2) == 'H'))&&(*(ptr + 1) == '/'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 3;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            //  "</title>" ́As + s ɒu
            if ((*(ptr + 1) == '/')&&
                ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
                ((*(ptr + 3) == 'i')||(*(ptr + 3) == 'I'))&&
                ((*(ptr + 4) == 't')||(*(ptr + 4) == 'T'))&&
                ((*(ptr + 5) == 'l')||(*(ptr + 5) == 'L'))&&
                ((*(ptr + 6) == 'e')||(*(ptr + 6) == 'E')))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 7;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            // <tr>, <td> ̓Xy[XPɕϊ
            if (((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                ((*(ptr + 2) == 'r')||(*(ptr + 2) == 'R')||
                 (*(ptr + 2) == 'd')||(*(ptr + 2) == 'D')))
            {
                *dst++ = ' ';
                // continue͂ȂBB (^O͓ǂݔ΂)
            }
SKIP_TAG:
            // ̑̃^O͓ǂݔ΂
#ifdef USE_STRSTR
            ptr = StrStr(ptr, ">");
#else
            while ((*ptr != '>')&&(*ptr != '\0'))
            {
                ptr++;
            }
#endif
            ptr++;
            // *dst++ = ' ';   // ^O͊SƂB
            continue;
        }
        // R[hEUCꍇ...
        if (kanjiCode == NNSH_KANJICODE_EUC)
        {
            if (ConvertEUCtoSJ((UInt8 *) dst, (UInt8 *) ptr, &len) == true)
            {
                // EUC > SHIFT JISϊs
                dst = dst + len;
                ptr = ptr + 2;
                continue;
            }
            if (*ptr != '\0')
            {
                // ʂ̈ꕶ]
                *dst++ = *ptr;
            }
            ptr++;
            continue;
        }

        // Xy[XAĂꍇAPɌ炷
        if ((*ptr == ' ')&&(*(ptr + 1) == ' '))
        {
            ptr++;
            while ((*ptr == ' ')&&(ptr < (src + size)))
            {
                ptr++;
            }
            ptr--;
        }

        // NULL  0x0a, 0x0d, 0x09(^u) ͖
        if ((*ptr != '\0')&&(*ptr != 0x0a)&&(*ptr != 0x0d)&&(*ptr != 0x09))
        {
            // ʂ̈ꕶ]
            *dst++ = *ptr;
        }
        ptr++;
    }
    *dst++ = '\0';
    return;
}

/* --------------------------------------------------------------------------
 *   AMsoftUTF8ϊe[u𗘗pĎ
 *       (http://amsoft.minidns.net/palm/gfmsg_chcode.html)
 * --------------------------------------------------------------------------*/

/*=========================================================================*/
/*   Function : StrNCopyUTF8toSJ                                           */
/*                     ̃Rs[(UTF8SHIFT JISR[hւ̕ϊ{) */
/*=========================================================================*/
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId)
{
    UInt8     buffer[2];
    UInt16    cnt, codes, ucode;
    Boolean   kanji;
    DmOpenRef dbRef;   

    // ϊe[u邩mF
    // dbId  = DmFindDatabase(0, "UnicodeToJis0208");
    if (dbId == 0)
    {
        return;
    }
    dbRef = DmOpenDatabase(0 , dbId, dmModeReadOnly);

    kanji = false; 
    cnt = 0;
    while ((*src != '\0')&&(cnt <size))
    {
        if (*src < 0x80)
        {
            // p[h...
            *dst = *src;
            dst++;
            cnt++;
            src++;
            continue;
        }

        ucode = ((*src & 0x0f) << 12);
        ucode = ucode | ((*(src + 1) & 0x3f) << 6);
        ucode = ucode | ((*(src + 2) & 0x3f));

        buffer[0] = ((ucode & 0xff00) >> 8);
        buffer[1] = ((ucode & 0x00ff));

        // R[h̕ϊ
        codes = Unicode11ToJisx0208(dbRef, buffer[0], buffer[1]);
        buffer[0] = ((codes & 0xff00) >> 8);
        buffer[1] = (codes & 0x00ff);
        ConvertJIStoSJ(dst, buffer);

        dst = dst + 2;
        src = src + 3;
        cnt = cnt + 2;
    }
    *dst = '\0';

    DmCloseDatabase(dbRef);
    return;
}

/* --------------------------------------------------------------------------
 *  Unicode11ToJisx0208()
 *                                                       (Unicode > JIS0208)
 * --------------------------------------------------------------------------*/
static UInt16 Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L)
{
    MemHandle            recH;
    UInt16               num, col, code = 0x0000;
    UnicodeToJis0208Rec *rec;

    // f[^x[X̃R[hȂƂ...
    if (dbRef == 0)
    {
        // G[...
        return (0x2121);
    }
    num  = utf8H;

    // 킹
    if (utf8L < 0x80)
    {
        num = (utf8H * 2);
        col = utf8L;
    }
    else
    {
        num = (utf8H * 2) + 1;
        col = utf8L - 0x80;
    }
    
    recH = DmQueryRecord(dbRef, num);
    if (recH == 0)
    {
        // G[...
        return (0x2122);
    }
    rec = (UnicodeToJis0208Rec *) MemHandleLock(recH);
    if (rec->size > 0)
    {
        // f[^L
        code  = rec->table[col];
    }
    else
    {
        // f[^Ȃ
        code = 0x2121;
    }
    MemHandleUnlock(recH);
    return (code);
}

/*=========================================================================*/
/*   Function : ConvertJIStoSJ                                             */
/*                            JISR[hSHIFT JISR[hɕϊ */
/*=========================================================================*/
static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr)
{
    UInt8 upper, lower;

    // 8rbg/8rbgϐɃRs[
    upper = *ptr;
    lower = *(ptr + 1);

    // CɂASYT(p.110)̃R[hg킹Ă
    if ((upper & 1) != 0)
    {
        if (lower < 0x60)
        {
            lower = lower + 0x1f;
        }
        else
        {
            lower = lower + 0x20;
        }
    }
    else
    {
        lower = lower + 0x7e;
    }   
    if (upper < 0x5f)
    {
        upper = (upper + 0xe1) >> 1;
    }
    else
    {
        upper = (((upper + 0x61) >> 1)|(0x80));
    }
    *dst = upper;
    dst++;
    *dst = lower;

    return (true);
}

/*=========================================================================*/
/*   Function : ConvertEUCtoSJ                                             */
/*                                  R[hEUCSHIFT JISɕϊ */
/*=========================================================================*/
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte)
{
    UInt8 temp[2];

    *copyByte = 0;
    if (*ptr == 0x8e)
    {
        // pJiR[h
        ptr++;
        *dst = *ptr;
        *copyByte = 1;
        return (true); 
    }
    if ((*ptr >= ((0x80)|(0x21)))&&(*ptr <= ((0x80)|(0x7e))))
    {
        // EUCR[hƔAJISR[hɈxϊĂSHIFT JISɕϊ
        temp[0] = ((*ptr)&(0x7f));
        ptr++;
        temp[1] = ((*ptr)&(0x7f));
        (void) ConvertJIStoSJ(dst, temp);
        *copyByte = 2;
        return (true);
    }
    return (false);
}

/*#------------------------------------------------------------------------#*/
/*#   analysis_URL (URL̉)                                             #*/
/*#                                      true: ͐  false: ͎s   #*/
/*#------------------------------------------------------------------------#*/
static Boolean analysis_URL(NNshWorkingInfo *NNshGlobal)
{
    UInt16  len;
    UInt8  *ptr;

    NNshGlobal->sendMethod = NNSILOGIN_GET_METHOD_HTTP;
    NNshGlobal->portNum = 80;
    len = sizeof("ttp://") - 1;
    ptr = StrStr(NNshGlobal->reqURL, "ttp://");
    if (ptr == NULL)
    {
        ptr = StrStr(NNshGlobal->reqURL, "ttps://");
        if (ptr == NULL)
        {
            return (false);
	}
        // SSLvgR...
        len = sizeof("ttps://") - 1;
        NNshGlobal->portNum = 443;
        NNshGlobal->sendMethod = NNSHLOGIN_SSL_PROTOCOL;

        // PalmOS v5.20ꍇɂNG(SslLibKvȂ̂)
        if (NNshGlobal->palmOSVersion < 0x05200000)
        {
            FrmCustomAlert(ALTID_INFO, "a https-request is need a SslLib."
                           "(You should USE a PalmOS 5.2 or later).","",
                           "[webDA]");
            return (false);
        }
    }
    ptr = ptr + len;

    // HOSTo
    len = 0;
    MemSet(NNshGlobal->hostName, BUFSIZE, 0x00);
    while ((*ptr != '/')&&(*ptr != ':')&&(*ptr != '\0'))
    {
        NNshGlobal->hostName[len] = *ptr;
        len++;
        ptr++;
    }
    NNshGlobal->hostName[len] = '\0';

    // portԍo
    if (*ptr == ':')
    {
        NNshGlobal->portNum = 0;
        while ((*ptr >= '0')&&
               (*ptr <= '9'))
        {
            NNshGlobal->portNum = NNshGlobal->portNum * 10 + (*ptr - '0');
            ptr++;
        }
        NNshGlobal->sendMethod
                        = (NNshGlobal->sendMethod) | (NNSHLOGIN_CONNECT_PORT);
    }

    // vAhXo
    if ((*ptr == '/')&&(*ptr == '/'))
    {
        ptr++;
    }

    len = 0;
    while ((*ptr != '>')&&(*ptr > ' ')&&(*ptr < 0x80))
    {
        NNshGlobal->reqAddress[len] = *ptr;
        len++;
        ptr++;
    }
    NNshGlobal->reqAddress[len] = '\0';
    if (len == 0)
    {
        NNshGlobal->reqAddress[len] = '/';
        len++;
        NNshGlobal->reqAddress[len] = '\0';
    }
    return (true);
}
