//------------------------------------------------
// Vector.c xNg
//------------------------------------------------
#include <math.h>
#include <stdlib.h>
#include "funcs.h"


#ifndef __Vector__
#define __Vector__

// `
#ifndef EPS
#define EPS      1e-10		// ̌덷el
#endif
#ifndef sinf
#define sinf sin
#endif
#ifndef cosf
#define cosf cos
#endif

//-----------------------------------------------------------------
// xNg
// ֐͕K Vector n܂D
//
// lɁuȕϊ/ZvƂ̂́C
// ʊi[AhXƕϊAhX/ZAhX
// ɂ邱Ƃŕϊ/Z\
//   FVectorAdd(v1, v1, v2)  v1 Ɍʂi[
//
// xNg̃AhXԂĂ邽߁CZq邱Ƃ\
// ǐ͑Ȃ
// ܂ꎞϐ̎舵ɂӂKv
//   FxNgZɂ  v = a + b - c
//       VectorAdd(v, a, VectorSub(tmp, b, c));
//-----------------------------------------------------------------

//-----------------------------------------------------------------
// VectorFromXY
// @\Fʏ̍WlxNg𐶐
// FVector *v0, float x, float y
//	 *v0  : ʂi[AhX
//       x, y : ϊW
// ԒlFʂ̃AhX
Vector* VectorFromXY(Vector *v0, float x, float y)
{
	v0->x = x - CenterX;
	v0->y = CenterY-y;
	return v0;
}

//-----------------------------------------------------------------
// VectorToXY
// @\FxNgʏW
// Fint *x, int *y, Vector *vector
//       *x, *y  : ϊWAhX
//       *vector : ϊxNgAhX
// ԒlFȂ
void VectorToXY(int *x, int *y, Vector *vector)
{
	*x = CenterX + (int)vector->x;
	*y = CenterY - (int)vector->y;
	//return vector;
}

//-----------------------------------------------------------------
// VectorFromUV
// @\FxNgWn̍WxNg𐶐
// FVector *v0, float u, float v
//	 *v0  : ʂi[AhX
//       u, v : ϊW
// ԒlFʂ̃AhX
Vector* VectorFromUV(Vector *v0, float u, float v)
{
	v0->x = u;
	v0->y = v;
	return v0;
}

//-----------------------------------------------------------------
// VectorAdd
// @\FxNg̉Z
// FVector *v0, Vector *v1, Vector *v2
//       *v0 : ʂi[AhX
//       *v1 : ZxNg̃AhX
//       *v2 : ZxNg̃AhX
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorAdd(Vector *v0, Vector *v1, Vector *v2)
{
	v0->x = v1->x + v2->x;
	v0->y = v1->y + v2->y;
	return v0;
}

//-----------------------------------------------------------------
// VectorAddNum
// @\FxNg̉Z𐔒ls
// FVector *v0, Vector *v1, float x, float y
//	 *v0  : ʂi[AhX
//       *v1  : ZxNg̃AhX
//       x, y : ZW
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorAddNum(Vector *v0, Vector *v1, float x, float y)
{
	v0->x = v1->x + x;
	v0->y = v1->y + y;
	return v0;
}

//-----------------------------------------------------------------
// VectorSub
// @\FxNǧZ
// FVector *v0, Vector *v1, Vector *v2
//       *v0 : ʂi[AhX
//       *v1 : ZxNg̃AhX
//       *v2 : ZxNg̃AhX
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorSub(Vector *v0, Vector *v1, Vector *v2)
{
	v0->x = v1->x - v2->x;
	v0->y = v1->y - v2->y;
	return v0;
}

//-----------------------------------------------------------------
// VectorMult
// @\FxNg̃XJ[{
// FVector *v0, Vector *v1, float n
//       *v0 : ʂi[AhX
//       *v1 : ZxNg̃AhX
//       n   : {
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorMult(Vector *v0, Vector *v1, float n)
{
	v0->x = v1->x * n;
	v0->y = v1->y * n;
	return v0;
}

//-----------------------------------------------------------------
// VectorInvert
// @\FxNg̔]
// FVector *v0, Vector *v1
//       *v0 : ʂi[AhX
//       *v1 : ]xNg̃AhX
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorInvert(Vector *v0, Vector *v1)
{
	v0->x = -v1->x;
	v0->y = -v1->y;
	return v0;
}

//-----------------------------------------------------------------
// VectorLength
// @\FxNg̒Ԃ
// FVector *v1
//       *v1 : ߂xNg̃AhX
// ԒlF
float VectorLength(Vector *v1)
{
	if(v1->x==0 && v1->y==0)	return 0;
	return sqrt(v1->x*v1->x + v1->y*v1->y);
}

//-----------------------------------------------------------------
// VectorLengthNoSquare
// @\FxNg̒̂QԂ
//       ̂߂Ɏgp
// FVector *v1
//       *v1 : ̂Q߂xNg̃AhX
// ԒlF̂Q
float VectorLengthNoSquare(Vector *v1)
{
	return v1->x*v1->x + v1->y*v1->y;
}

//-----------------------------------------------------------------
// VectorNormalize
// @\FxNgPʃxNgɕϊ
// FVector *v0, Vector *v1
//       *v0 ; ʂi[AhX
//       *v1 : PʃxNgxNg̃AhX
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorNormalize(Vector *v0, Vector *v1)
{
	float len = VectorLength(v1);
	if(len == 0){	// 0xNĝƂ0
		v0->x = v0->y = 0;
		return v0;
	}
	len = 1/len;					// tƂ
	v0->x = v1->x * len;
	v0->y = v1->y * len;
	return v0;
}

//-----------------------------------------------------------------
// VectorRotate
// @\Fw肳ꂽpxxNg]
// FVector *v0, Vector *v1, float rad
//       *v0 : ʂi[AhX
//       *v1 : ]xNg̃AhX
//       rad : ]pxiWAj
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorRotate(Vector *v0, Vector *v1, float rad)
{
	float sinx = sinf(rad),
	      cosx = cosf(rad),
	         x = v1->x*cosx - v1->y*sinx;	// x ϊĕۊ
	     v0->y = v1->x*sinx + v1->y*cosx;	// y ϊĊi[
	     v0->x = x;				// x i[
	return v0;
}

//-----------------------------------------------------------------
// VectorArrayRotate
// @\Fw肳ꂽxNgz]
//       VectorRotateJԂ荂
//       num=1ƂVectorRotateƓ@\
// FVector *vs, int num, float rad
//       *vs : ]xNgz̃AhX
//       num : z̗vf
//       rad : ]pxiWAj
// ԒlFʂ̃AhX	//void?
Vector* VectorArrayRotate(Vector *vs, int num, float rad)
{
	int i;
	float sinx = sinf(rad),		// Op֐͏d߈ōς܂
	      cosx = cosf(rad),
	      x;
	if(rad == 0)	return vs;
	for(i=0; i<num; i++){
		      x = vs[i].x*cosx - vs[i].y*sinx;
		vs[i].y = vs[i].x*sinx + vs[i].y*cosx;
		vs[i].x = x;
	}
	return vs;
}

//-----------------------------------------------------------------
// VectorRotate90
// @\F@xNg߂D
// FVector *v0, Vector *v1, float type
//       *v0  : ʂi[AhX
//       *v1  : ϊxNg
//	 type : xNǧ
//              type =  1 :  pi/2]
//                   = -1 : -pi/2]
// ԒlFʂ̃AhX
// lFȕϊ/Z
Vector* VectorRotate90(Vector *v0, Vector *v1, float type)
{
	float x = v1->x;
	v0->x   = -v1->y * type;
	v0->y   = x * type;
	return v0;
}

//-----------------------------------------------------------------
// VectorDotProduct
// @\FQ̃xNg̓ς߂
// FVector *v1, Vector *v2
//       *v1 : xNgP
//       *v2 : xNgQ
// ԒlFς̒l
float VectorDotProduct(Vector *v1, Vector *v2)
{
	return v1->x*v2->x + v1->y*v2->y;
}

//-----------------------------------------------------------------
// VectorCrossProduct
// @\FQ̃xNg̊Oς߂
// FVector *v1, Vector *v2
//       *v1 : xNgP
//       *v2 : xNgQ
// ԒlFOς̒l
// ӁF{̊Oςz=0ɂĉĂ邽߁CXJ[Ԃ
// QlFhttp://www.deqnotes.net/acmicpc/2d_geometry/products
float VectorCrossProduct(Vector *v1, Vector *v2)
{
	return v1->x*v2->y - v1->y*v2->x;
}

#endif
