//------------------------------------------------
// Screen.c XN[XV
//------------------------------------------------

#include "Screen.h"
#include "SDL_gfxPrimitives.h"

//xNgf[^`
void DrawVector( SDL_Surface *gBgSurf, MyObject *Ball, Line *line, int size)
{
	int i, x1, y1, x2, y2;
	// xNg]\
	for(i=0; i<size; i++){
		LineToXY(&x1, &y1, &x2, &y2, &line[i]);
		lineColor( gBgSurf, x1, y1, x2, y2, 0x00FF00FF);
	}
	
	//{[̕`
	VectorToXY(&x1, &y1, &Ball->xy);
	circleColor( gBgSurf, (Sint16)x1, (Sint16)y1, Ball->r, 0x00FF00FF);
	
	SDL_Flip( gBgSurf );	// ʂXV
}

//rbg}bvf[^̕`
void RenewScreen( Surface *Scr, int Degree, int BallX, int BallY)
{
	SDL_Rect DestBackGround, DestFrame;
	int DegreeToNum = Degree/ROTATE_DEG;	//xz̓YɑΉ

	//ʂ𔒂œhԂ
	DestBackGround.x = DestBackGround.y = 0;
	DestBackGround.w = DISP_WIDTH, DestBackGround.h = DISP_HEIGHT;
	SDL_FillRect( Scr->gBgSurf, &DestBackGround, 0xFFFFFFFF );
	
	//Ht[̕`
	//512,384𒆐SƂĉ]
	DestFrame.x = CenterX-( Scr->gStage[DegreeToNum]->w/2);
	DestFrame.y = CenterY-( Scr->gStage[DegreeToNum]->h/2);
	SDL_BlitSurface( Scr->gStage[DegreeToNum], NULL, Scr->gBgSurf, &DestFrame );
	
	//{[̕`
	DestFrame.x = CenterX + (int)BallX - BALL_SIZE;
	DestFrame.y = CenterY - (int)BallY - BALL_SIZE;
	//DestFrame.x = BallX, DestFrame.y = BallY;
	SDL_BlitSurface( Scr->gBall, NULL, Scr->gBgSurf, &DestFrame );
	
	SDL_Flip( Scr->gBgSurf );	// ʂXV
}
