//------------------------------------------------
// InitEnd.c ƏI
//------------------------------------------------

#include "Screen.h"
#include "SDL_rotozoom.h"	//摜]֐

//SDL̏֐
bool InitializeSDL( Surface *Scr, FPSmanager *FrManage, const char *BallName)
{
	if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) return false;	// SDL̏
	SDL_WM_SetCaption( GAME_TITLE, NULL );	// LvV̐ݒ
	
	//EBhȄ, TCY
	Scr->gBgSurf = SDL_SetVideoMode(
		DISP_WIDTH, DISP_HEIGHT, DISP_DEPTH, SDL_SWSURFACE//|SDL_FULLSCREEN //tXN[
		);
	if( !Scr->gBgSurf ){
		fprintf(stderr, "Failed to initialize video mode : %s\n", SDL_GetError());
		return false;
	}
	//SDL_ShowCursor( SDL_DISABLE );	//}EXJ[\

//--------------------{[--------------------
	//摜̓ǂݍ
	Scr->gBall = IMG_Load(BallName);
	if( !Scr->gBall ) {
		printf("IMG_Load: %s\n", IMG_GetError());	//handle error
		SDL_Quit(); return false;
	}
	
	//t[[g̏
	SDL_initFramerate( FrManage );
	SDL_setFramerate( FrManage, FRAME_RATE );
	return true;
}

//Xe[W摜ƃ{[摜쐬
bool InitStage( Surface *Scr, const char *StageName, MyObject *Ball)
{
	int i;
	
	Scr->gStage[0] = IMG_Load(StageName);	//摜̓ǂݍ
	if( !Scr->gStage[0] ) {
		printf("IMG_Load: %s\n", IMG_GetError());	//handle error
		SDL_Quit(); return false;
	}
	//]摜̍쐬(炩ߍ쐬ĂƂōɕ`ł)
	for( i=1; i<360/ROTATE_DEG; ++i)
		Scr->gStage[i] = rotozoomSurface( Scr->gStage[0], i*ROTATE_DEG, 1, 1);

	//{[̏p[^(ʒuȂǃXe[Wɂĕς)
	Ball->r = BALL_SIZE;
	VectorFromUV(&Ball->velocity, 0.0f, 0.0f);
	//VectorFromXY(&Ball->xy, CenterX-STAGE_HH+BALL_SIZE+4, CenterY-STAGE_HW+BALL_SIZE+4);
	VectorFromUV(&Ball->xy, 0, 0);

	return true;
}

//Xe[W̃(Xe[Wςۂɂ͕Ks)
void RleaseStage( SDL_Surface *gStage[] )
{
	int i;
	for( i=0; i<360/ROTATE_DEG; ++i)
		SDL_FreeSurface( gStage[i] );
}

//SDL̏I
void EndSDL( Surface *Scr )
{
	SDL_FreeSurface( Scr->gBall );
	SDL_Quit();		// SDL̏I
}
