//------------------------------------------------
// InitEnd.c ƏI
//------------------------------------------------

#include "funcs.h"
#include "SDL_rotozoom.h"

//SDL̏֐
bool InitializeSDL(void)
{
	if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) return false;	// SDL̏
	SDL_WM_SetCaption( "Test", NULL );	// LvV̐ݒ

	//EBhȄ,TCY
	gScreenSurface = SDL_SetVideoMode(
 		DISP_WIDTH, DISP_HEIGHT, DESP_DEPTH, SDL_SWSURFACE//|SDL_FULLSCREEN //tXN[
		);
	if( !gScreenSurface ){
		fprintf(stderr, "Failed to initialize video mode : %s\n", SDL_GetError());
		return false;
	}
	//SDL_ShowCursor(SDL_DISABLE );	//}EXJ[\
	return true;
}

//Xe[W摜쐬D̓Xe[W0`3Dt@C͓KXςĂ
bool InitStage(short StageNum)
{
	short i;
	static char *StageName[3]={"frame1.png","frame2.png","frame3.png"};

	if( StageNum<0 || StageNum>=3 ) return false;
	//摜̓ǂݍ
	gStage[0] = IMG_Load(StageName[StageNum]);	//libpng12-0.dll,SDL_image.dll,zlib.dllKv
	if( !gStage[0] ) {
		printf("IMG_Load: %s\n", IMG_GetError());	//handle error
		SDL_Quit(); return false;
	}
	//]摜̍쐬
	for( i=1; i<360/ROTATE_DEG; ++i)
		gStage[i] = rotozoomSurface( gStage[0], i*ROTATE_DEG, 1, 1);

	return true;
}

//Xe[W̃iXe[Wςۂɂ͕KsĂj
void RleaseStage(void)
{
	short i;
	for( i=0; i<360/ROTATE_DEG; ++i)
		SDL_FreeSurface( gStage[i] );
}

//SDL̏I
void EndSDL(void)
{
	SDL_Quit();		// SDL̏I
}