#! /bin/jsh
#
# Copyright 2013-2014 Yuichiro Moriguchi
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
if [ -z "$2" ]
then
  putlicense_cstyle.sh
  [ -z "$PACKAGE" ] || echo "namespace $PACKAGE"
  [ -z "$PACKAGE" ] || echo "{"
  [ -z "$EXTENDS" ] || [ -z "$EXTENDS" ] || cln=':'
  class_nm="${CLASSNAME}"
  print_imports
  cat definition
else
  class_nm="$2"
fi

if [ -z "$TYPE" ]
then
  nullsym='-1'
  [ -z "$NEWLINEMODE" ] && streamsym='System.IO.TextReader'
  [ -z "$NEWLINEMODE" ] || streamsym='System.IO.Stream'
  [ -z "$NEWLINEMODE" ] && readfn='Read'
  [ -z "$NEWLINEMODE" ] || readfn='ReadByte'
  rdt='System.IO.TextReader'
else
  nullsym='null'
  rdt="Iterable<$CTYPE>"
  streamsym='java.util.Iterator'
fi

[ -z "$2" ] && awk '{ printf("/// %s\n", $0) }' description
[ -z "$2" ] && cat << EOF

public $ABSTRACT class ${class_nm}${TEMPLATE} $cln $EXTENDS $IMPLEMENTS
{
	/* @@@-PARSER-CODE-START-@@@ */
	public static readonly object ENDMARKER = new {};
	const int INITIAL = 0;

	readonly ${class_nm}${TEMPLATE} __this__;

	int STATE;
	private object iseof = null;
	private $CTYPE unread = $nullsym;

	public ${class_nm}()
	{
		__this__ = this;
	}
EOF

if [ -n "$2" ]
then
  echo
elif [ -z "$TYPE" ]
then
  cat << EOF
	private int _Read($streamsym rd)
	{
		int c;

		if(unread >= 0)
		{
			c = unread;
			unread = -1;
		}
		else if((c = rd.${readfn}()) < 0)
		{
			iseof = ENDMARKER;
		}
		return c;
	}

EOF
else
  cat << EOF
	private $CTYPE _Read(System.Collections.IEnumerator itr)
	{
		$CTYPE c;

		if(unread != null)
		{
			c = unread;
			unread = null;
			return c;
		}
		else if(itr.MoveNext())
		{
			return ($CTYPE)itr.Current;
		}
		else
		{
			return null;
		}
	}

EOF
fi

nina_template.nfa.cs.sub2.sh "$1" "$CTYPE" "$TYPE" ""

if [ -n "$2" ]
then
  echo
elif [ -z "$TYPE" ]
then
  cat << EOF
	public void Reset() {
		STATE = 0;
		iseof = null;
		unread = -1;
	}

	public object SearchToken($streamsym rd)
	{
		System.Text.StringBuilder b = new System.Text.StringBuilder();
		bool f = false;
		object o = null;
		int c;

		if(iseof != null)  return iseof;
		while((c = _Read(rd)) >= 0) {
			b.Append((char)c);
			if(_Step(c) == 0)
			{
				if(f)
				{
					unread = c;
					STATE = 0;
					return o;
				}
				else
				{
					return null;
				}
			}
			else if(f = _Accepted())
			{
				o = _Gettoken(b);
				if(_Isdead())
				{
					STATE = 0;
					return o;
				}
			}
			else if(_Isdead())
			{
				return null;
			}
		}
		return f ? o : null;
	}
EOF
else
  cat << EOF
	public void Reset() {
		STATE = 0;
		iseof = null;
		unread = null;
	}

	public object SearchToken(System.Collections.IEnumerator itr)
	{
		$CTYPE[] b = new $CTYPE[0];
		bool f = false;
		object o = null;
		$CTYPE c;

		if(iseof != null)  return iseof;
		while((c = _Read(itr)) != null)
		{
			Array.Resize(ref b, b.Length + 1);
			b[b.Length - 1] = c;
			if(_Step(c) == 0)
			{
				if(f)
				{
					unread = c;
					STATE = 0;
					return o;
				}
				else
				{
					return null;
				}
			}
			else if(f = _Accepted())
			{
				o = _Gettoken(b);
				if(_Isdead())
				{
					STATE = 0;
					return o;
				}
			}
			else if(_Isdead())
			{
				return null;
			}
		}
		return f ? o : null;
	}
EOF
fi
[ -z "$2" ] && echo '	/* @@@-PARSER-CODE-END-@@@ */'

[ -z "$2" ] && cat fragment
[ -z "$2" ] && echo '}'
[ -n "$2" ] || [ -z "$PACKAGE" ] || echo "}"
