package net.morilib.range;

import net.morilib.range.integer.IntCharSets;
import net.morilib.range.integer.IntRange;
import net.morilib.regex.dfa.CharSet;
import junit.framework.TestCase;

public class IntCharSetsTest extends TestCase {

	static IntRange getci(String s) {
		IntRange r;

		r = CharSet.parse(s);
		return IntCharSets.toCaseInsensitive(r);
	}

	public void testToCaseInsensitive0001() {
		IntRange r;

		r = getci("b-x");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('h'));
		assertTrue(r.contains('x'));
		assertTrue(r.contains('B'));
		assertTrue(r.contains('H'));
		assertTrue(r.contains('X'));
		assertFalse(r.contains('a'));
		assertFalse(r.contains('z'));
		assertFalse(r.contains('A'));
		assertFalse(r.contains('Z'));
		assertFalse(r.contains(0));
		assertFalse(r.contains(65535));
	}

	public void testToCaseInsensitive0002() {
		IntRange r;

		r = getci("^b-xC-W");
		assertTrue(r.contains('a'));
		assertTrue(r.contains('z'));
		assertTrue(r.contains('A'));
		assertTrue(r.contains('Z'));
		assertTrue(r.contains(0));
		assertTrue(r.contains(65535));
		assertTrue(r.contains('b'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('h'));
		assertFalse(r.contains('w'));
		assertFalse(r.contains('C'));
		assertFalse(r.contains('H'));
		assertFalse(r.contains('W'));
	}

}
