/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.math.stochastic;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/16
 */
public final class GenerateRandomSequence {

	private GenerateRandomSequence() {
		// do nothing
	}

	/**
	 * 
	 * @param p
	 * @param dlm
	 * @return
	 */
	public static String generate(StochasticProcess p, String dlm) {
		StringBuilder b = new StringBuilder();
		StochasticProcess s = p;
		String d = "";

		for(; !s.isAccepted(); s = s.go(Math.random())) {
			b.append(d).append(s.getOutput());
			d = dlm;
		}
		return b.toString();
	}

	/**
	 * 
	 * @param p
	 * @param dlm
	 * @return
	 */
	public static String generate(MarkovProcess p, String dlm) {
		StringBuffer b = new StringBuffer();
		MarkovProcess s = p;
		String d = "";

		for(; !s.isAccepted(); s = s.go(Math.random(), b)) {
			b.append(d);
			d = dlm;
		}
		return b.toString();
	}

}
