/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class LispVector extends Datum
implements java.io.Serializable {

	//
	private static final long serialVersionUID = 3364203058083838114L;

	//
	private List<Datum> vec;

	/**
	 * 
	 * @param vec
	 */
	public LispVector(Collection<Datum> vec) {
		if(vec == null) {
			throw new NullPointerException();
		}
		this.vec = new ArrayList<Datum>(vec);
	}

	/**
	 * 
	 * @param data
	 */
	public LispVector(Datum... data) {
		this(Arrays.asList(data));
	}

	/**
	 * 
	 */
	public LispVector() {
		this(new ArrayList<Datum>());
	}

	/**
	 * 
	 * @param vec
	 */
	public LispVector(LispVector vec) {
		if(vec == null) {
			throw new NullPointerException();
		}
		this.vec = new ArrayList<Datum>(vec.vec);
	}

	/**
	 * 
	 */
	public LispVector(int size) {
		this(new ArrayList<Datum>(size));
	}

	/**
	 * 
	 * @param index
	 * @return
	 */
	public Datum get(int index) {
		return vec.get(index);
	}

	//
	/*package*/ void setS(int index, Datum d) {
		vec.set(index, d);
	}

	/**
	 * 
	 * @return
	 */
	public int size() {
		return vec.size();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#isTypeVector()
	 */
	public boolean isTypeVector() {
		return true;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getList()
	 */
	public List<Datum> getList() {
		return Collections.unmodifiableList(vec);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.nano.Datum#toDisplay()
	 */
	@Override
	public String toDisplay() {
		return LispUtils.toDisplay(this);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.nano.Datum#toDisplay()
	 */
	@Override
	public String toWrite() {
		return LispUtils.toWrite(this);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#toString()
	 */
	public String toString() {
		return LispUtils.toWrite(this);
	}

}
