/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/10
 */
public class NinaLanguageOptionJavaScript implements NinaLanguageOption {

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookahead()
	 */
	@Override
	public String getLookahead() {
		return "LOOKAHEAD($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadCommit()
	 */
	@Override
	public String getLookaheadCommit() {
		return "LOOKAHEAD_COMMIT();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadMark()
	 */
	@Override
	public String getLookaheadMark() {
		return "LOOKAHEAD_MARK();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadMark()
	 */
	@Override
	public String getLookaheadMarkInit() {
		return "LOOKAHEAD_MARK_INIT();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getUnget()
	 */
	@Override
	public String getUnget() {
		return "UNGET($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAssignArray(java.lang.String, int)
	 */
	@Override
	public String getAssignArray(String s, int k) {
		return String.format("%s[%d] = $c;", s, k);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getInitBuffer(java.lang.String)
	 */
	@Override
	public String getInitBuffer(String s) {
		return s + " = '';";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAppendBuffer(java.lang.String)
	 */
	@Override
	public String getAppendBuffer(String s) {
		return s + " += String.fromCharCode($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getInitList()
	 */
	@Override
	public String getInitList() {
		return "$this._initlist();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAddList()
	 */
	@Override
	public String getAddList() {
		return "$this._addlist($this._);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getSeparator()
	 */
	@Override
	public String getSeparator() {
		return ";";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getSequenceBufferName()
	 */
	@Override
	public String getSequenceBufferName() {
		return "$this.$buffer";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToInteger()
	 */
	@Override
	public String getBufferToInteger(int radix) {
		return String.format("$this.$int=parseInt($this.$buffer, %d);",
				radix);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToBigInteger(int)
	 */
	@Override
	public String getBufferToBigInteger(int radix) {
		throw new NinaException("bigintegernotsupported", radix);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToNumberInteger()
	 */
	@Override
	public String getBufferToNumberInteger() {
		return "$this.$num=parseFloat($this.$buffer);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getBufferToNumberDouble()
	 */
	@Override
	public String getBufferToNumberDouble() {
		return "$this.$num=parseFloat($this.$buffer);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getIndent(java.lang.String, int)
	 */
	@Override
	public String getIndent(String cmp, int off) {
		return String.format(
				"$c == INDENT && $this.$indent %s $this.$indentBefore + (%d)",
				cmp, off);
	}

}
