/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.line;

import net.morilib.sed.SedLineMatcher;
import net.morilib.sed.SedPatternEngine;

/**
 * 相対的な行番号にマッチするマッチ器です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class SedRelativeLineMatcher implements SedLineMatcher {

	long lineno;

	/**
	 * マッチ器を生成します。
	 * 
	 * @param lineno 行番号
	 */
	public SedRelativeLineMatcher(long lineno) {
		this.lineno = lineno;
	}

	public boolean matches(SedPatternEngine pa, String s, long lno,
			long relno, boolean lastno) {
		return relno >= 0 && relno == lineno;
	}

	public String toString() {
		return "+" + lineno;
	}

}
