/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.strftime;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class StrftimeSimpleDateUpperAction implements StrftimeAction {

	/**
	 * 
	 */
	public static final StrftimeAction ACTION_v =
		new StrftimeSimpleDateUpperAction("dd-MMM-yyyy");

	private SimpleDateFormat fmt;

	public StrftimeSimpleDateUpperAction(String format) {
		fmt = new SimpleDateFormat(format, Locale.US);
	}

	public void action(Writer writer,
			Date date) throws IOException {
		writer.append(fmt.format(date.getTime()).toUpperCase());
	}

}
