/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

public final class ShStat {

	/**
	 * 
	 */
	public static final int DIRECTORY = 8;

	/**
	 * 
	 */
	public static final int EXECUTABLE = 4;

	/**
	 * 
	 */
	public static final int WRITABLE = 2;

	/**
	 * 
	 */
	public static final int READABLE = 1;

	//
	private String filename;
	private long mtime, size;
	private int flags;

	/**
	 * 
	 */
	public ShStat() {}

	/**
	 * 
	 * @param filename
	 * @param mtime
	 * @param size
	 * @param flags
	 */
	public ShStat(String filename, long mtime, long size, int flags) {
		this.filename = filename;
		this.mtime    = mtime;
		this.size     = size;
		this.flags    = flags;
	}

	/**
	 * 
	 * @return
	 */
	public String getFilename() {
		return filename;
	}

	/**
	 * 
	 * @return
	 */
	public long getMtime() {
		return mtime;
	}

	/**
	 * 
	 * @return
	 */
	public long getSize() {
		return size;
	}

	/**
	 * 
	 * @return
	 */
	public int getFlags() {
		return flags;
	}

	/**
	 * 
	 * @param filename
	 */
	public void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * 
	 * @param mtime
	 */
	public void setMtime(long mtime) {
		this.mtime = mtime;
	}

	/**
	 * 
	 * @param size
	 */
	public void setSize(long size) {
		this.size = size;
	}

	/**
	 * 
	 * @param flags
	 */
	public void setFlags(int flags) {
		this.flags = flags;
	}

}
