/*
 * Translated by Nina
 * This source code is under public domain
 */

package net.morilib.nina.translate;

public  class ReplaceActionCSharp   {

	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(java.io.Reader __rd, int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	private static final int NINA_ACCEPT = -1;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_STACKLEN = 72;
	static final int INITIAL = 0;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;

	Throwable exception;

	private int unread = -1;

private StringBuffer b1, ot;

ReplaceActionCSharp() {}

private void _init() {
	if(b1.length() > 0)  b1 = new StringBuffer();
}

private void _apc(int c) {
	if(c >= 0)  ot.appendCodePoint(c);
}

private void _apb(int c) {
	b1.appendCodePoint(c);
}

public static String replace(String s) {
	ReplaceActionCSharp c = new ReplaceActionCSharp();

	c.b1 = new StringBuffer();
	c.ot = new StringBuffer();
	try {
		c.parse(new java.io.StringReader(s));
	} catch(java.io.IOException e) {
		throw new RuntimeException(e);
	}
	c.ot.append(c.b1);
	return c.ot.toString();
}


	int _read1(java.io.Reader stream) throws java.io.IOException {
		int c;

		c = stream.read();
		return c < 0 ? -1 : c;
	}
	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread >= 0) {
			c = unread;
			unread = -1;
			__logprint("Read unread: ", c);
		} else if((c = _read1(rd)) != -1) {
			__logprint("Read: ", c);
		} else {
			__logprint("Read end-of-file");
		}
		return c;
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}


	private int replaceActionCSharp_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c == '"') {
				STATE = 1;
				return 1;
			} else if($c == '$') {
				STATE = 2;
				return 1;
			} else {
				STATE = 0;
				return 1;
			}
		case 2:
			if($c >= '0' && $c <= '9') {
				STATE = 3;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 3;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 3;
				return 1;
			} else {
				UNGET($c);
				STATE = 4;
				return 1;
			}
		case 4:
			return 0;
		case 3:
			if($c >= '0' && $c <= '9') {
				STATE = 3;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 3;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 3;
				return 1;
			} else {
				UNGET($c);
				STATE = 5;
				return 1;
			}
		case 5:
			return 0;
		case 1:
			if($c == '"') {
				STATE = 0;
				return 1;
			} else {
				STATE = 1;
				return 1;
			}
		}
		return 0;
	}

	private boolean replaceActionCSharp_accepted() {
		return (STATE == 0 ||
				STATE == 1 ||
				STATE == 2 ||
				STATE == 3 ||
				STATE == 4 ||
				STATE == 5);
	}

	int replaceActionCSharp_execaction(int  $c) {
		switch(STATE) {
		case 2:
			break;
		case 3:
			_apb($c);
			break;
		case 0:
			_apc($c);  _init();
			break;
		case 5:
			ot.append("__").append(b1).append("__");
b1 = new StringBuffer();                
STATE = INITIAL;
			break;
		case 1:
			{ _apc($c); }
			break;
		case 4:
			ot.append('$'); 
STATE = INITIAL;
			break;
		}
		return 1;
	}

	boolean replaceActionCSharp_isend() {
		return false;
	}

	private final Engine ENGINE_replaceActionCSharp = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return replaceActionCSharp_step(__rd, c);
		}

		boolean accepted() {
			return replaceActionCSharp_accepted();
		}

		int execaction(int c) {
			return replaceActionCSharp_execaction(c);
		}

		boolean isend() {
			return replaceActionCSharp_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 6;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "replaceActionCSharp";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(java.io.Reader rd, int x) throws java.io.IOException {
		boolean b = false;
		int c = x, a;
		Engine en;

		b = __stk[__slen - 1].accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				return NINA_ACCEPT;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				return NINA_FAIL;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				return NINA_HALT_ACCEPT;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				return NINA_HALT_REJECT;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(c < 0) {
					// do nothing
				} else if((a = en.step(rd, c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						return NINA_ACCEPT;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						return NINA_FAIL;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						return NINA_HALT_ACCEPT;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						return NINA_HALT_REJECT;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					return NINA_ACCEPT;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					return NINA_FAIL;
				}
			} while((c = _read(rd)) >= 0);
			if(!b)  throw new TokenException();
			return NINA_ACCEPT;
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	 boolean parse(java.io.Reader rd, Engine entry) throws java.io.IOException {
		int c = -1;
		Boolean b;

		__logopen();
		try {
			__stkpush(0, entry);
			while(true) {
				try {
					if((c = _parse(rd, c)) >= 0) {
						// do nothing
					} else if(c == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  return b;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
					} else if(c == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  return b;
						__slen = 0;
						return true;
					} else if(c == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  return b;
						__slen = 0;
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  return b;
						STATE = __sts[--__slen];
					} else {
						if((b = execfinally()) != null)  return b;
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
			}
			return __stk[__slen - 1].accepted();
		} finally {
			__logclose();
		}
	}

	 boolean parse(java.io.Reader rd) throws java.io.IOException {
		return parse(rd, ENGINE_replaceActionCSharp);
	}

	 static boolean parseAll(java.io.Reader rd) throws java.io.IOException {
		ReplaceActionCSharp o = new ReplaceActionCSharp();

		return o.parse(rd);
	}

	 boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	 static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

}
