package net.morilib.nina;

import junit.framework.TestCase;

public class VersionNumberTest extends TestCase {

	static void up(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertTrue(f.isUpperThan(g));
	}

	static void dn(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertTrue(f.isLowerThan(g));
	}

	static void in(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertTrue(f.isIncluded(g));
	}

	static void nu(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertFalse(f.isUpperThan(g));
	}

	static void nd(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertFalse(f.isLowerThan(g));
	}

	static void ni(String a, String b) {
		VersionNumber f, g;

		f = new VersionNumber(a);
		g = new VersionNumber(b);
		assertFalse(f.isIncluded(g));
	}

	public void test0001() {
		up("1.2", "1.2");
		up("1.2.1", "1.2");
		up("1.2", "1.1");
		up("2", "1.1.1");
		nu("1.2", "1.2.1");
		nu("1.1", "1.2");
		nu("1", "2.1");
		up("1.1.1.3",     "1.1.1.2");
		up("1.1.1.1.3",   "1.1.1.1.2");
		up("1.1.1.1.1.3", "1.1.1.1.1.2");
	}

	public void test0002() {
		dn("1.2", "1.2");
		dn("1.2", "1.2.1");
		dn("1.1", "1.2");
		dn("1", "2.1");
		nd("1.2.1", "1.2");
		nd("1.2", "1.1");
		nd("2", "1.1");
		dn("1.1.1.1",     "1.1.1.2");
		dn("1.1.1.1.1",   "1.1.1.1.2");
		dn("1.1.1.1.1.1", "1.1.1.1.1.2");
	}

	public void test0003() {
		in("1.2", "1.2");
		in("1.2", "1.2.1");
		ni("1.1", "1.2");
		ni("1", "2.1");
		ni("1.2.1", "1.2");
		ni("1.2", "1.1");
		ni("2", "1.1");
		in("1.1.1.1",     "1.1.1.1");
		in("1.1.1.1.1",   "1.1.1.1.1");
		in("1.1.1.1.1.1", "1.1.1.1.1.1");
	}

}
