/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import net.morilib.automata.DFA;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/05/22
 */
public final class NinaDFAPattern implements NinaPattern {

	//
	DFA<Object, Object, Void> dfa;

	/**
	 * 
	 * @param dfa
	 */
	public NinaDFAPattern(DFA<Object, Object, Void> dfa) {
		this.dfa = dfa;
	}

	//
	DFABuilder.DBS getInitialState() {
		return (DFABuilder.DBS)dfa.getInitialState();
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public NinaDFAMatcher matcher(String s) {
		return new NinaDFAMatcher(this, s);
	}

}
