/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.lr;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/11
 */
public class LRUtils {

	/**
	 *  A initial hash code for the EJ method.
	 * <p>EJ生成法におけるハッシュコードの初期値である.
	 */
	public static final int INIT = 17;

	/**
	 *  A multiplication coefficient for the EJ method.
	 * <p>EJ生成法におけるハッシュコードの乗数である.
	 */
	public static final int A = 37;

	/**
	 * Returns true if the given objects are equal.<br>
	 * <p>与えられた引数が等しいときにtrueを得る.
	 * 
	 * @return  true if obj1 equals obj2, otherwise false
	 */
	public static /*inline*/ boolean equals(Object obj1, Object obj2) {
		return (obj1 == null) ? obj2 == null : obj1.equals(obj2);
	}

	/**
	 * Transform an object to its string representation:
	 * If the object is null, returns an empty string.<br>
	 * <p>与えられたオブジェクトの文字列表現を返す.オブジェクトがnullの
	 * ときは空文字列を返す.
	 * 
	 * @param attr  an object to transform
	 * @return  string representation
	 * @see  java.lang.Object
	 */
	public static /*inline*/ String toString(Object attr) {
		return (attr == null) ? "" : attr.toString();
	}

	/**
	 * calculates the hash code of the given argument.
	 * <p>引数に対応するhashCodeを返す.
	 * 
	 * @param b the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(boolean b) {
		return b ? 0 : 1;
	}

	/**
	 * calculates the hash code of the given argument.
	 * <p>引数に対応するhashCodeを返す.
	 * 
	 * @param l the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(long l) {
		return (int)(l ^ (l >>> 32));
	}

	/**
	 * calculates the hash code of the given argument.
	 * <p>引数に対応するhashCodeを返す.
	 * 
	 * @param d the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(double d) {
		long l;
		l = Double.doubleToLongBits(d);
		return (int)(l ^ (l >>> 32));
	}

	/**
	 * calculates the hash code of the given argument.
	 * <p>引数に対応するhashCodeを返す.
	 * 
	 * @param f the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(float f) {
		return Float.floatToIntBits(f);
	}

	/**
	 * calculates the hash code of the given argument.
	 * <p>引数に対応するhashCodeを返す.
	 * 
	 * @param o the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(Object o) {
		return (o == null) ? 0 : o.hashCode();
	}

}
