/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import java.util.List;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Subr;

public class StringAppend extends Subr {

	@Override
	public Datum eval(
			Datum body, Environment env, LispMessage mesg) {
		List<Datum> lst = LispUtils.consToList(body, mesg);
		StringBuilder bld = new StringBuilder();
		
		for(int i = 0; i < lst.size(); i++) {
			if(lst.get(i) instanceof LispString) {
				bld.append(((LispString)lst.get(i)).getString());
			} else if(lst.get(i) instanceof LispCharacter) {
				bld.append(((LispCharacter)lst.get(i)).getCharacter());
			} else {
				//throw new LispException("string required");
				throw mesg.getError("err.require.string", lst.get(i));
			}
		}
		
		return new LispString(bld.toString());
	}

}
