/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

public class CpreRelop1 extends CpreOperator {

	public static enum Operator { EQ, NE, LT, LE, GT, GE }

	public static final CpreRelop1 LT =
		new CpreRelop1(CpreOperatorType.LT, "<");
	public static final CpreRelop1 LE =
		new CpreRelop1(CpreOperatorType.LE, "<=");
	public static final CpreRelop1 GT =
		new CpreRelop1(CpreOperatorType.GT, ">");
	public static final CpreRelop1 GE =
		new CpreRelop1(CpreOperatorType.GE, ">=");

	private CpreOperatorType operator;

	private CpreRelop1(CpreOperatorType op, String desc) {
		super(desc);
		operator = op;
	}

	public CpreOperatorType getRelation() {
		return operator;
	}

}
