/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.builtin;

import java.util.List;
import java.util.Random;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkFunction;
import net.morilib.awk.nano.value.AwkValue;

/**
 * 組み込み関数randの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkRand extends AwkFunction {

	//
	private static long seed = System.currentTimeMillis();
	private static Random random = new Random(seed);

	/**
	 * 
	 */
	public AwkRand() {
		super("rand", null);
	}

	//
	static synchronized void setSeed(long s) {
		random.setSeed(s = seed);
	}

	//
	static synchronized long getSeed() {
		return seed;
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		return AwkFloat.valueOf(random.nextDouble());
	}

}
