/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/17
 */
public final class JsNFACpp implements ShProcess {

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShProcess#main(net.morilib.sh.ShEnvironment, net.morilib.sh.ShFileSystem, java.io.InputStream, java.io.PrintStream, java.io.PrintStream, java.lang.String[])
	 */
	@Override
	public int main(ShEnvironment env, ShFileSystem fs,
			InputStream stdin, PrintStream stdout, PrintStream stderr,
			String... args) throws IOException {
		CPreprocessorReader rd = null;
		String s;

		try {
			rd = new CPreprocessorReader("<stdin>",
					new InputStreamReader(stdin));
			rd.define("STATE",            "this.__state");
			rd.define("INITIAL",          "0");
			rd.define("CONSOLE",          "java.lang.System['out']");
			while((s = rd.readLine()) != null) {
				stdout.println(s);
			}
			return 0;
		} finally {
			if(rd != null)  rd.close();
		}
	}

}
