#! /bin/jsh
#
# Copyright 2013-2014 Yuichiro Moriguchi
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
sed "s/@@YEAR@@/$YEAR/g
s/@@OWNER@@/$OWNER/g
s/@@ORGANIZATION@@/$ORGANIZATION/g" /license/$LICENSE

print_imports
cat definition

c='$c'
cat << EOF

function ${CLASSNAME}() {
	this.__state = 0;
	this.iseof = null;
	this.unread = null;
}

${CLASSNAME}.ENDMARKER = {};

${CLASSNAME}.prototype._read = function(itr) {
	var c;

	if(this.unread != null) {
		c = this.unread;
		this.unread = null;
	} else if((c = itr()) == null) {
		this.iseof = ${CLASSNAME}.ENDMARKER;
	}
	return c;
}

${CLASSNAME}.prototype._step = function($c) {
	switch(this.__state) {
EOF
print_states
cat << EOF
	}
	return 0;
}

${CLASSNAME}.prototype._accepted = function() {
EOF
print_accepts
echo '}'
echo
echo "${CLASSNAME}.prototype._gettoken = function(__b__) {"
echo '		var $$ = __b__;'
echo
echo '		switch(this.__state) {'
print_token
echo '		default:  return null;'
echo '		}'
echo '	}'
echo
echo "${CLASSNAME}.prototype._isdead = function() {"
print_nfadead
echo '	}'

cat << EOF

${CLASSNAME}.prototype.reset = function() {
	this.__state = 0;
	this.iseof = null;
	this.unread = null;
}

${CLASSNAME}.prototype.searchToken = function(itr) {
	var b = '';
	var f = false;
	var o = null;
	var c;

	if(this.iseof != null)  return this.iseof;
	while((c = this._read(itr)) != null) {
		b += String.fromCharCode(c);
		if(this._step(c) == 0) {
			if(f) {
				this.unread = c;
				this.__state = 0;
				return o;
			} else {
				return null;
			}
		} else if(f = this._accepted()) {
			o = this._gettoken(b);
			if(this._isdead()) {
				this.__state = 0;
				return o;
			}
		} else if(this._isdead()) {
			return null;
		}
	}
	return f ? o : null;
}

${CLASSNAME}.newStream = function(stream) {
	return function() {
		var c;

		c = stream.read();
		return c < 0 ? null : c;
	};
}

${CLASSNAME}.newString = function(s) {
	var p = 0;

	return function() {
		return p < s.length ? s.charCodeAt(p++) : null;
	};
}

${CLASSNAME}.newJavaString = function(s) {
	var p = 0;

	return function() {
		return p < s.length() ? s.charAt(p++) : null;
	};
}

${CLASSNAME}.newStdin = function() {
	return ${CLASSNAME}.newStream(
			new java.io.InputStreamReader(java.lang.System['in']));
}
EOF
cat fragment
