/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/12/19
 */
public class NinatTask {

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2013/12/19
	 */
	public static class Param {

		private String name, value;

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(String value) {
			this.value = value;
		}

	}

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2013/12/19
	 */
	public static class Library {

		private String path;

		/**
		 * @param path the path to set
		 */
		public void setPath(String path) {
			this.path = path;
		}

	}

	//
	private String src, outfile, lang;
	private List<Param> params = new ArrayList<Param>();
	private List<Library> libs = new ArrayList<Library>();

	/**
	 * 
	 * @return
	 */
	public Param createParameter() {
		Param p = new Param();

		params.add(p);
		return p;
	}

	/**
	 * 
	 * @return
	 */
	public Library createLibrary() {
		Library p = new Library();

		libs.add(p);
		return p;
	}

	/**
	 * @param src the src to set
	 */
	public void setSrc(String src) {
		this.src = src;
	}

	/**
	 * @param outfile the outfile to set
	 */
	public void setOutfile(String outfile) {
		this.outfile = outfile;
	}

	/**
	 * @param lang the lang to set
	 */
	public void setLang(String lang) {
		this.lang = lang;
	}

	/**
	 * 
	 */
	public void execute() {
		Map<String, String> z;
		Ninac a = new Ninac();
		NinaTranslator t;

		a.opts = new NinatOptions();
		z = new HashMap<String, String>();
		for(Param p : params)  z.put(p.name, p.value);
		for(Library p : libs)  a.opts.libs.add(p.path);

		if(outfile != null)  a.opts.opts.put("outfile", outfile);
		if(lang != null) {
			t = AbstractNinaTranslator.getTranslator(lang);
			a.opts.setTranslator(t);
		}
		a.process(src, z, false, null);
		a.opts.print("anttranslated", src);
	}

}
