/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.arith;

public class ShExprOp extends ShExprToken {

	public static final ShExprOp ADD    = new ShExprOp("+");
	public static final ShExprOp SUB    = new ShExprOp("-");
	public static final ShExprOp MUL    = new ShExprOp("*");
	public static final ShExprOp DIV    = new ShExprOp("/");
	public static final ShExprOp MOD    = new ShExprOp("%");
	public static final ShExprOp POW    = new ShExprOp("**");
	public static final ShExprOp B_XOR  = new ShExprOp("^");
	public static final ShExprOp B_AND  = new ShExprOp("&");
	public static final ShExprOp B_OR   = new ShExprOp("|");
	public static final ShExprOp L_AND  = new ShExprOp("&&");
	public static final ShExprOp L_OR   = new ShExprOp("||");
	public static final ShExprOp L_NOT  = new ShExprOp("!");
	public static final ShExprOp TRI1   = new ShExprOp("?");
	public static final ShExprOp TRI2   = new ShExprOp(":");
	public static final ShExprOp LPAREN = new ShExprOp("(");
	public static final ShExprOp RPAREN = new ShExprOp(")");
	public static final ShExprOp B_NOT  = new ShExprOp("~");
	public static final ShExprOp COMMA  = new ShExprOp(",");
	public static final ShExprOp SHIFTL = new ShExprOp("<<");
	public static final ShExprOp SHIFTR = new ShExprOp(">>");
	public static final ShExprOp INC    = new ShExprOp("++");
	public static final ShExprOp DEC    = new ShExprOp("--");

	public static final ShExprOp ASSIGN = new ShExprOp("=");
	public static final ShExprOp A_ADD  = new ShExprOp("+=");
	public static final ShExprOp A_SUB  = new ShExprOp("-=");
	public static final ShExprOp A_MUL  = new ShExprOp("*=");
	public static final ShExprOp A_DIV  = new ShExprOp("/=");
	public static final ShExprOp A_MOD  = new ShExprOp("%=");
	public static final ShExprOp A_SFL  = new ShExprOp(">>=");
	public static final ShExprOp A_SFR  = new ShExprOp("<<=");
	public static final ShExprOp A_BAND = new ShExprOp("&=");
	public static final ShExprOp A_BXOR = new ShExprOp("^=");
	public static final ShExprOp A_BOR  = new ShExprOp("|=");

	ShExprOp(String desc) {
		super(desc);
	}

}
