echo '// Translated by Nina'
echo '// This source code is under public domain'
[ -z "$PACKAGE" ] || echo "package $PACKAGE;"

cat << EOF

public class $CLASSNAME {

	private int state;
	private int unread = -1;
	private String matched;

EOF
cat fragment
cat << EOF

	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread < 0) {
			return rd.read();
		} else {
			c = unread;
			unread = -1;
			return c;
		}
	}

	private boolean _step(int c) {
		switch(state) {
EOF

print_states
cat << EOF
		}
		return false;
	}

	private boolean _accepted() {
EOF

print_accepts
echo '	}'
echo
echo '	private void _execaction(int $c) {'
echo '		switch(state) {'

print_actions
cat << EOF
		}
	}

	public boolean matches(String s) {
		int n;

		for(n = 0; n < s.length(); n++) {
			if(!_step(s.charAt(n))) {
				return false;
			}
		}
		return _accepted();
	}

	public boolean lookingAt(String s) {
		StringBuffer b = new StringBuffer();
		int n;

		matched = null;
		for(n = 0; n < s.length(); n++) {
			if(_accepted()) {
				matched = b.toString();
			}

			if(_step(s.charAt(n))) {
				// do nothing
			} else {
				return matched != null;
			}
			b.append(s.charAt(n));
		}

		if(_accepted()) {
			matched = b.toString();
			return true;
		} else {
			return matched != null;
		}
	}

	public boolean find(String s) {
		StringBuffer b = new StringBuffer();
		int n, k;

		matched = null;
		for(k = 0; k < s.length(); k++) {
			for(n = k; n < s.length(); n++) {
				if(_accepted()) {
					matched = b.toString();
				}

				if(_step(s.charAt(n))) {
					// do noting
				} else if(matched == null) {
					state = 0;
					break;
				} else {
					return true;
				}
				b.append(s.charAt(n));
			}

			if(_accepted()) {
				matched = b.toString();
				return true;
			} else if(matched != null) {
				return true;
			} else {
				b = new StringBuffer();
			}
		}
		return false;
	}

	public String group() {
		return matched;
	}

	public boolean parse(
			java.io.Reader rd) throws java.io.IOException {
		int p, c;

		for(p = -2; (c = _read(rd)) >= 0; p = c) {
			_execaction(p);
			if(!_step(c)) {
				state = 0;
			}
		}
		_execaction(p);
		return _accepted();
	}

}
EOF
