// Serial 
// by takuya matsubara 

#include <avr/io.h>
#include <avr/interrupt.h> 
#include "sio.h"

#ifndef F_CPU
#define   F_CPU   8000000    //CPUNbNg 8MHz
#endif

//123456789
//rt,12,12r

#define BAUD 9600 // 9600bps
#define MYUBRR ((F_CPU/16/BAUD)-1) // UART

#define BUFSIZE	9	//obt@TCYi2n-1j
unsigned char recv_dat[BUFSIZE];
unsigned char recv_cnta=0;
unsigned char recv_cntb=0;

/* USARTݒ */
void sio_init(void)
{
	UBRRH = (MYUBRR >> 8); // {[[g
	UBRRL = MYUBRR & 0xff; // {[[g

	UCSRB = (1<<RXEN) | (1<<TXEN)|(1<<RXCIE);

	//set frame format data8, stop1, nonparity
	UCSRC=(1<<UCSZ1) | (1<<UCSZ0);
}


SIGNAL(SIG_USART0_RECV	)            //M荞
{
    recv_dat[recv_cnta++] = UDR;
	if(recv_cnta >= BUFSIZE) recv_cnta = 0;	//rotation ringbuff
}

//extern char debugflag;

int sio_rx(void)
{
	unsigned char ch;

	if(recv_cnta == recv_cntb)
		return(-1);

	ch = recv_dat[recv_cntb++];
	if(recv_cntb >= BUFSIZE) recv_cntb=0;	//rotation ringbuff

//	if(debugflag)
//		sio_tx(ch);//debug

	return((int)ch);
}

void sio_tx(char dat)
{
	while(!(UCSRA & (1<<UDRE)));

	UDR=dat;

	while(!(UCSRA & (1<<UDRE)));//

}

void sio_txstr(char *str)
{
    while(*str != 0)
    {
        sio_tx(*str++);
    }
}

void sio_txdec(int x)
{
#define SETUYAKU 1
    unsigned char temp;
	int ketaval=100;

	if(x<0) {
		x = -x;
		sio_tx('-');
	}
    while (ketaval != 0) {
#if SETUYAKU
		temp=0;
		while(x >= ketaval){
			x -= ketaval;
			temp++;
		}
		sio_tx('0'+temp);
#else
        temp = x / ketaval;
		sio_tx('0'+temp);
		x -= (ketaval*temp);
#endif
		ketaval /= 10;
    }
}


