//---------------------------------------------------------------------
// text
//by takuya matsubara
//http://nicotak.com
// ̕͏C֎~(Please do not delete a document from here.)
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "text.h"
#include "sfont.h"	//4x6X[tHg


char text_x=0;  // printfpJ[\ʒu
char text_y=0;


extern unsigned int vram[VRAMHEIGHT];	 // LED Bitmap Buffer


//---------------------------------------------------------------------
//sNZ`
//xFXWB0`15
//xFYWB0`15
//colorFJ[R[hB0=A1=_iԐFjA2=XOR1
void vram_pset(char x,char y,char color)
{
	unsigned int mask;

	if(x<0)return;
	if(y<0)return;
	if(x>=VRAMWIDTH)return;
	if(y>=VRAMHEIGHT)return;

	mask=0x8000 >> x;

	if(color==1)
		vram[(int)y] |= mask;
	else if(color==0)
		vram[(int)y] &= ~mask;
	else if(color==2)
		vram[(int)y] ^= mask;

}

//--------------------------------------------------------------------------------
//C`
//x1FX1W
//y1FY1W
//x2FX2W
//y2FY2W
//colorFJ[R[hB0=A1=_iԐFjA2=XOR1
void vram_line(char x1 ,char y1 ,char x2 ,char y2 ,char color)
{
	char xd;	// X2-X1W̋
	char yd;	// Y2-Y1W̋
	char xs=1;  // X1pixelړ
	char ys=1;  // Y1pixelړ
	char e;

	xd = x2 - x1;	 // X2-X1W̋
	if(xd < 0){
		xd = -xd;	 // X2-X1W̐Βl
		xs = -1;	  // X1pixelړ
	}
	yd = y2 - y1;	 // Y2-Y1W̋
	if(yd < 0){
		yd = -yd;	 // Y2-Y1W̐Βl
		ys = -1;	  // Y1pixelړ
	}
	vram_pset (x1, y1 ,color); //hbg`
	e = 0;
	if( yd < xd ) {
		while( x1 != x2) {
			x1 += xs;
			e += (2 * yd);
			if(e >= xd) {
				y1 += ys;
				e -= (2 * xd);
			}
			vram_pset (x1, y1 ,color); //hbg`
		}
	}else{
		while( y1 != y2) {
			y1 += ys;
			e += (2 * xd);
			if(e >= yd) {
				x1 += xs;
				e -= (2 * yd);
			}
			vram_pset (x1, y1 ,color); //hbg`
		}
	}
}

//--------------------------------------------------------------------------------
// ʃXN[
// EVRAM̒gIɃVtg܂B
// x1: XړʁB+ƍVtg(_E)A-ƉEVtg(_)
// y1: YړʁB+ƏVtg(_)A-ƉVtg(_)
void vram_scroll(char x1,char y1)
{
	int i;
	if(x1!=0){
		if(x1>0){
			for(i=0; i<VRAMWIDTH; i++){
				vram[i] <<= x1;
			}
		}else{
			for(i=0; i<VRAMWIDTH; i++){
				vram[i] >>= (-x1);
			}
		}
	}

	if(y1!=0){
		if(y1>0){
			for(i=0; i<VRAMHEIGHT; i++){
				if((i+y1)>15)
					vram[i] = 0;
				else
					vram[i] = vram[i+y1];
			}
		}else{
			for(i=VRAMHEIGHT-1; i>=0; i--){
				if((i+y1)<0)
					vram[i] = 0;
				else
					vram[i] = vram[i+y1];
			}
		}
	}
}


//---------------------------------------------------------------------
// J[\ʒuݒ
// xFXW0`15B13ȏゾƎsB
// yFYW0`15B11ȏゾƉ։ʃXN[܂B
void vram_locate(char tx,char ty)
{
	text_x = tx;
	text_y = ty;
}

//---------------------------------------------------------------------
// 1LN^VRAM]
// E4x6X[tHgp
// chFLN^[R[hi0x00-0xffj
// ߂lF0Ԃ܂B
int vram_putch(char ch)
{
	char tx,ty;
	unsigned char i;
	unsigned char bitdata;
	PGM_P p;

	if((ch==10)||(text_x > (VRAMWIDTH-4))){
		text_x = 0;
		text_y += 6;
	}
	if(text_y > (VRAMHEIGHT-6)){
		vram_scroll(0,text_y-(VRAMHEIGHT-6));
		text_y = VRAMHEIGHT-6;
	}
	if((unsigned char)ch < 0x20)return 0;

	ty= text_y;
	tx = (VRAMWIDTH-4)-text_x;
	p = (PGM_P)smallfont;
	p += ((int)((unsigned char)ch - 0x20) * 3);

	for(i=0 ;i<6 ;i++) {
		bitdata = pgm_read_byte(p);
		if((i % 2)==0){
			bitdata >>= 4;
		}else{
			p++;
		}
		bitdata &= 0xf;
//		vram[ty] &= ~(0xf << tx);
		vram[ty] |= ((unsigned int)bitdata << tx);
		ty++;
	}
	text_x += 4;    // J[\ړ
//	if(((unsigned char)ch>=0xB0)&&((unsigned char)ch<=0xDC))
//		text_x += 1;    // J[\ړ(J^Jip)

	return 0;
}


